'use strict';
define(function() {
  var kisProcess = function(
    $rootScope,
    gaDomUtils,
    $timeout,
    $filter,
    ngDialog,
    $interval,
    processFactory,
    ngTableParams,
    $location,
    gaUrlUtils
  ) {
    return {
      templateUrl: 'js/XG/containers/views/kis_process.html',
      restrict: 'EA',
      scope: {
        map: '=?',
      },
      controller: [
        '$scope',
        function($scope) {
          // $scope.eventSources = [{
          //     events: []
          // }];
        },
      ],
      link: function(scope) {
        scope.processtabs = [
          {
            title: 'process.mbtiles.main',
          },
          {
            title: 'process.geopackage.main',
          },
          {
            title: 'process.docxprocess.main',
          },
        ];
        scope.processtabs.activeTab = 0;
        scope.processtabs.autorefresh = true;

        scope.currentFormData = {
          mbtiles: undefined,
          gpkg: undefined,
          docx: undefined,
        };

        var TYPES = ['mbtiles', 'gpkg', 'docx'];
        scope.refreshallLists = function(b) {
          if (b && b === 'frombtn') gaDomUtils.showGlobalLoader();
          processFactory.getProcessByUserSpecial(TYPES.join(',')).then(
            function(res) {
              try {
                scope.currentFormData = res.data;
                scope.tableParamsProcess.reload();
              } catch (e) {
                console.error(e.stack);
              }
              if (b && b === 'frombtn') gaDomUtils.hideGlobalLoader();
            },
            function() {
              if (b && b === 'frombtn') gaDomUtils.hideGlobalLoader();
            }
          );
        };
        scope.refreshallLists('first');

        /**
         * Paramètres du tableau listant les règles associées au currentfeaturetype passé à cette directive
         */
        scope.tableParamsProcess = new ngTableParams(
          {
            page: 1, //ng-table show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              try {
                switch (scope.processtabs.activeTab) {
                  case 0:
                    if (scope.currentFormData.mbtiles) {
                      var displayedTab = scope.currentFormData.mbtiles.slice(
                        (params.page() - 1) * params.count(),
                        params.page() * params.count()
                      );

                      params.total(scope.currentFormData.mbtiles.length); // set total for recalc pagination
                      $defer.resolve(displayedTab);
                    } else {
                      $defer.resolve([]);
                    }
                    break;
                  case 1:
                    if (scope.currentFormData.gpkg) {
                      displayedTab = scope.currentFormData.gpkg.slice(
                        (params.page() - 1) * params.count(),
                        params.page() * params.count()
                      );

                      params.total(scope.currentFormData.gpkg.length); // set total for recalc pagination
                      $defer.resolve(displayedTab);
                    } else {
                      $defer.resolve([]);
                    }
                    break;
                  case 2:
                    if (scope.currentFormData.docx) {
                      displayedTab = scope.currentFormData.docx.slice(
                        (params.page() - 1) * params.count(),
                        params.page() * params.count()
                      );

                      params.total(scope.currentFormData.docx.length); // set total for recalc pagination
                      $defer.resolve(displayedTab);
                    } else {
                      $defer.resolve([]);
                    }
                    break;
                }
              } catch (e) {
                console.error(e.stack);
                $defer.resolve([]);
              }
            },
          }
        );

        scope.$watch('processtabs.activeTab', function(newval) {
          if (angular.isDefined(newval)) scope.tableParamsProcess.reload();
        });

        var stop;
        scope.changedRefresh = function() {
          if (scope.processtabs.autorefresh) {
            scope.refreshallLists();
            stop = $interval(function() {
              scope.refreshallLists();
            }, 5000);
          } else {
            if (stop) $interval.cancel(stop);
          }
        };

        var btnstop;
        var stopnewclign = function() {
          angular
            .element(document.querySelector('.ProcessNav'))
            .removeClass('modified-options-true');
          if (stopnewclign) $interval.cancel(btnstop);
        };

        scope.$on('newProcessCreated', function(evt, arg) {
          scope.refreshallLists();
          if (angular.isDefined(arg)) scope.processtabs.activeTab = arg;
          if (!$rootScope.process.visible) {
            angular
              .element(document.querySelector('.ProcessNav'))
              .addClass('modified-options-true');
            btnstop = $interval(function() {
              stopnewclign();
            }, 10000);
          }
        });

        scope.$on('newProcessStop', function() {
          stopnewclign();
        });

        scope.removeProcess = function(idx) {
          try {
            idx =
              (scope.tableParamsProcess.page() - 1) *
                scope.tableParamsProcess.count() +
              idx;
            var callback = function(isConfirm) {
              if (isConfirm) {
                switch (scope.processtabs.activeTab) {
                  case 0:
                    processFactory
                      .deleteProcess(scope.currentFormData.mbtiles[idx])
                      .then(
                        function(res) {
                          $timeout(function() {
                            scope.currentFormData.mbtiles.splice(idx, 1);
                            scope.tableParamsProcess.reload();
                            swal(
                              $filter('translate')('portals.process.title'),
                              $filter('translate')(
                                'portals.process.object_removed'
                              ),
                              'success'
                            );
                          }, 500);
                        },
                        function() {
                          require('toastr').error(
                            $filter('translate')(
                              'process.process.processnotavailabe'
                            )
                          );
                        }
                      );
                    break;
                  case 1:
                    processFactory
                      .deleteProcess(scope.currentFormData.gpkg[idx])
                      .then(
                        function(res) {
                          $timeout(function() {
                            scope.currentFormData.gpkg.splice(idx, 1);
                            scope.tableParamsProcess.reload();
                            swal(
                              $filter('translate')('portals.process.title'),
                              $filter('translate')(
                                'portals.process.object_removed'
                              ),
                              'success'
                            );
                          }, 500);
                        },
                        function() {
                          require('toastr').error(
                            $filter('translate')(
                              'process.process.processnotavailabe'
                            )
                          );
                        }
                      );
                    break;
                  case 2:
                    processFactory
                      .deleteProcess(scope.currentFormData.docx[idx])
                      .then(
                        function(res) {
                          $timeout(function() {
                            scope.currentFormData.docx.splice(idx, 1);
                            scope.tableParamsProcess.reload();
                            swal(
                              $filter('translate')('portals.process.title'),
                              $filter('translate')(
                                'portals.process.object_removed'
                              ),
                              'success'
                            );
                          }, 500);
                        },
                        function() {
                          require('toastr').error(
                            $filter('translate')(
                              'process.process.processnotavailabe'
                            )
                          );
                        }
                      );
                    break;
                }
              }
            };
            swal(
              {
                title: $filter('translate')('portals.process.title'),
                text: $filter('translate')('portals.process.confirm_delete'),
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d9534f',
                confirmButtonText: $filter('translate')('common.yes'),
                cancelButtonText: $filter('translate')('common.no'),
                closeOnConfirm: true,
                closeOnCancel: true,
              },
              callback
            );
          } catch (e) {
            console.error(e.stack);
          }
        };

        scope.showQrProcess = function(idx) {
          try {
            idx =
              (scope.tableParamsProcess.page() - 1) *
                scope.tableParamsProcess.count() +
              idx;
            switch (scope.processtabs.activeTab) {
              case 0:
                var mobhost =
                  $location.protocol() +
                  '://' +
                  $location.host() +
                  ':' +
                  $location.port();
                var appname = localStorage.getItem('app');
                if ($location.search().app) {
                  appname = $location.search().app;
                }
                scope.mobqrcode =
                  '/services/' +
                  $rootScope.xgos.portal.uid +
                  '/process/qrcode?name=' +
                  appname +
                  '&token=' +
                  gaUrlUtils.encodeUriQuery(
                    localStorage.getItem('auth_token')
                  ) +
                  '&url=' +
                  mobhost +
                  '&uid=' +
                  scope.currentFormData.mbtiles[idx].uid;
                scope.titleqrcode =
                  $filter('translate')('process.process.qrmbtiles') +
                  ' ' +
                  scope.currentFormData.mbtiles[idx].file;
                ngDialog.open({
                  template: 'js/XG/widgets/mapapp/main/views/barecode.html',
                  className: 'ngdialog-theme-plain width300 miniclose',
                  closeByDocument: false,
                  scope: scope,
                });
                break;
              case 1:
                mobhost =
                  $location.protocol() +
                  '://' +
                  $location.host() +
                  ':' +
                  $location.port();
                var appname = localStorage.getItem('app');
                if ($location.search().app) {
                  appname = $location.search().app;
                }
                scope.mobqrcode =
                  '/services/' +
                  $rootScope.xgos.portal.uid +
                  '/process/qrcode?name=' +
                  appname +
                  '&token=' +
                  gaUrlUtils.encodeUriQuery(
                    localStorage.getItem('auth_token')
                  ) +
                  '&url=' +
                  mobhost +
                  '&uid=' +
                  scope.currentFormData.gpkg[idx].uid;
                scope.titleqrcode =
                  $filter('translate')('process.process.qrmbtiles') +
                  ' ' +
                  scope.currentFormData.gpkg[idx].file;
                ngDialog.open({
                  template: 'js/XG/widgets/mapapp/main/views/barecode.html',
                  className: 'ngdialog-theme-plain width300 miniclose',
                  closeByDocument: false,
                  scope: scope,
                });
                break;
            }
          } catch (e) {
            console.error(e.stack);
          }
        };

        scope.downloadProcess = function(idx) {
          try {
            idx =
              (scope.tableParamsProcess.page() - 1) *
                scope.tableParamsProcess.count() +
              idx;
            switch (scope.processtabs.activeTab) {
              case 0:
                if (
                  scope.currentFormData.mbtiles[idx].type.split('/').length ===
                  1
                )
                  window.open(
                    '/services/' +
                      $rootScope.xgos.portal.uid +
                      '/mbtiles/getFile?f=json&uid=' +
                      scope.currentFormData.mbtiles[idx].uid +
                      '&etat=' +
                      scope.currentFormData.mbtiles[idx].etat +
                      '&file=' +
                      scope.currentFormData.mbtiles[idx].file +
                      '&type=' +
                      scope.currentFormData.mbtiles[idx].type +
                      '&token=' +
                      encodeURIComponent(localStorage.getItem('auth_token'))
                  );
                else {
                  window.open(
                    '/services/' +
                      $rootScope.xgos.portal.uid +
                      '/geopackage/getZipFile?f=json&uid=' +
                      scope.currentFormData.mbtiles[idx].uid +
                      '&etat=' +
                      scope.currentFormData.mbtiles[idx].etat +
                      '&file=' +
                      scope.currentFormData.mbtiles[idx].file +
                      '&type=mbtiles&token=' +
                      encodeURIComponent(localStorage.getItem('auth_token'))
                  );
                }
                break;
              case 1:
                if (
                  scope.currentFormData.gpkg[idx].type.split('/').length === 1
                )
                  window.open(
                    '/services/' +
                      $rootScope.xgos.portal.uid +
                      '/geopackage/getFile?f=json&uid=' +
                      scope.currentFormData.gpkg[idx].uid +
                      '&etat=' +
                      scope.currentFormData.gpkg[idx].etat +
                      '&file=' +
                      scope.currentFormData.gpkg[idx].file +
                      '&type=' +
                      scope.currentFormData.gpkg[idx].type +
                      '&token=' +
                      encodeURIComponent(localStorage.getItem('auth_token'))
                  );
                else {
                  window.open(
                    '/services/' +
                      $rootScope.xgos.portal.uid +
                      '/geopackage/getZipFile?f=json&uid=' +
                      scope.currentFormData.gpkg[idx].uid +
                      '&etat=' +
                      scope.currentFormData.gpkg[idx].etat +
                      '&file=' +
                      scope.currentFormData.gpkg[idx].file +
                      '&type=mbtiles&token=' +
                      encodeURIComponent(localStorage.getItem('auth_token'))
                  );
                }
                break;
              case 2:
                if (
                  scope.currentFormData.docx[idx].type.split('/').length === 1
                )
                  window.open(
                    '/services/' +
                      $rootScope.xgos.portal.uid +
                      '/documents/getFileProcess?f=json&uid=' +
                      scope.currentFormData.docx[idx].uid +
                      '&token=' +
                      encodeURIComponent(localStorage.getItem('auth_token'))
                  );
                break;
            }
          } catch (e) {
            console.error(e.stack);
          }
        };
      },
    };
  };

  kisProcess.$inject = [
    '$rootScope',
    'gaDomUtils',
    '$timeout',
    '$filter',
    'ngDialog',
    '$interval',
    'processFactory',
    'ngTableParams',
    '$location',
    'gaUrlUtils',
  ];
  return kisProcess;
});
