'use strict';
define(function() {
  /**
   *
   * @returns {{restrict: string, templateUrl: string}}
   */
  var kisSocialShare = function() {
    return {
      restrict: 'EA',
      templateUrl:
        'js/XG/modules/common/views/directives/kis_social_share.html',
      scope: {
        text: '=?', // preset text
        url: '=?', // preset url
        tags: '=?', // preset comma separated tags (ie : kis, sig, altereo)
        services: '=?', // array of services names (ie ['twitter','facebook','linkedin'])
        disabled: '=?', // disabled buttons
      },
      link: function(scope) {
        if (!angular.isDefined(scope.text)) {
          scope.text = 'KIS, le SIG qui vous simplifie la ville';
        }
        if (!angular.isDefined(scope.url)) {
          scope.url = 'KIS, le SIG qui vous simplifie la ville';
        }
        if (!angular.isDefined(scope.tags)) {
          scope.tags = 'kis, sig';
        }
        if (!angular.isDefined(scope.disabled)) {
          scope.disabled = false;
        }
      },
    };
  };

  kisSocialShare.$inject = [];
  return kisSocialShare;
});
