'use strict';
define(function() {
  /**
   * Class : modalFactory
   * Factory WebServices
   * Inspired from http://fundoo-solutions.github.io/angularjs-modal-service/
   */
  var modalFactory = function(
    $document,
    $compile,
    $rootScope,
    $controller,
    $timeout
  ) {
    /*
         Default values
         */
    var defaults = {
      id: null,
      templateUrl: null,
      title: 'Default Title',
      successFn: null,
      successLabel: 'common.save',
      cancelFn: null,
      cancelLabel: 'common.close',
      controller: null,
      backdropClass: 'modal-backdrop',
      backdropCancel: true,
      footerTemplate: null,
      modalClass: 'modal xgos_modal',
      css: {
        top: '100px',
        left: '30%',
        margin: '0 auto',
      },
    };

    var body = $document.find('body');

    var open = function(options, passedInLocals) {
      /*
             Merging passedIn options with defaults
             */
      options = angular.extend({}, defaults, options);

      /*
             Footer Template
             */
      var defaultFooter =
        '<button class="btn" ng-click="$modalCancel()">{{$modalCancelLabel|translate}}</button>' +
        '<button class="btn btn-primary" ng-click="$modalSuccess()">{{$modalSuccessLabel|translate}}</button>';

      /*
             Body Template
             */
      var modalEl = angular.element(
        '<div class="' +
          options.modalClass +
          ' fade"' +
          (options.id ? ' id="' + options.id + '" ' : '') +
          ' style="display: block;">' +
          '  <div class="modal-dialog">' +
          '    <div class="modal-content">' +
          '      <div class="modal-header">' +
          '        <button type="button" class="close" ng-click="$modalCancel()">&times;</button>' +
          '        <h4>{{$title|translate}}</h4>' +
          '      </div>' +
          '<div class="modal-body" ng-include="\'' +
          options.templateUrl +
          '\'"></div>' +
          '<div class="modal-footer">' +
          defaultFooter +
          '</div>' +
          '    </div>' +
          '  </div>' +
          '</div>'
      );

      /*
             Backdrop template
             */
      var backdropEl = angular
        .element('<div/>')
        .addClass(options.backdropClass)
        .addClass('fade in');

      /*
             Styling
             */
      for (var key in options.css) {
        modalEl.css(key, options.css[key]);
      }

      /*
                Passing the controller to the modal
             */

      var ctrl,
        locals,
        scope = $rootScope.$new();

      if (options.controller) {
        locals = angular.extend({ $scope: scope }, passedInLocals);
        ctrl = $controller(options.controller, locals);

        // Yes, ngControllerController is not a typo
        modalEl.contents().data('$ngControllerController', ctrl);
      }

      /*
             Modal Title
             */
      scope.$title = options.title;

      /*
             Default Close modal function
             */

      var closeFn = function() {
        modalEl.remove();
        backdropEl.remove();
      };

      /*
             Extended close modal function
             */
      scope.$modalClose = closeFn;
      scope.$modalCancel = function() {
        var callFn = options.cancelFn || closeFn;
        callFn.call(this);
        scope.$modalClose();
      };

      /*
             Submit modal function
             */
      scope.$modalSuccess = function() {
        // if nothing is passed, closeFn is called
        var callFn = options.successFn || closeFn;

        scope[callFn].apply(this);
        scope.$modalClose();
      };

      /*
             Close and Submit Labels
             */
      scope.$modalSuccessLabel = options.successLabel;
      scope.$modalCancelLabel = options.cancelLabel;

      /*
             Compile and display modal + backdrop
             */
      $compile(modalEl)(scope);
      $compile(backdropEl)(scope);
      body.append(modalEl).append(backdropEl);

      $timeout(function() {
        modalEl.addClass('in');
      }, 200);
    };

    return {
      modalFactory: modalFactory,
      open: open,
    };
  };

  modalFactory.$inject = [
    '$document',
    '$compile',
    '$rootScope',
    '$controller',
    '$timeout',
  ];
  return modalFactory;
});
