'use strict';
define(function() {
  var adminParamWidget = function(
    ParametersFactory,
    ngTableParams,
    ngDialog,
    UsersFactory
  ) {
    return {
      templateUrl: 'js/XG/modules/dbparameters/views/adminParamWidget.html',
      restrict: 'A',
      scope: {},
      //scope propre à cette directive
      //methode executée au chargement de la page
      link: function(scope, element, attrs, ctrl) {
        var parameters = [];

        scope.iswait = false;

        //                scope.users = [];//Contient la liste des utilisateurs
        //
        //                /**
        //                 *
        //                 * Méthode de récupération des utilisateurs stockés dans le repository du portail.
        //                 */
        //                UsersFactory.get().then(
        //                    function(res){
        //                        scope.users.splice(0);
        //                        var resultObject = res.data ;
        //
        //                        for (var i=0;i<resultObject.length; i++){
        //                            var l = resultObject[i];
        //                             scope.users.push(l);
        //                        }
        //                    },
        //                    function(reason){
        //                        var resultObject = reason ;
        //                        console.log("Get Users echec : "+resultObject);
        //                        require('toastr').error("Get Users echec :"+resultObject);
        //                    }
        //                );

        /**
         * Méthode de récupération de l'ensemble des paramètres stockés.
         */
        scope.refreshParams = function() {
          scope.iswait = true;
          ParametersFactory.get().then(
            function(res) {
              parameters.splice(0);
              var resultObject = res.data;

              for (var i = 0; i < resultObject.length; i++) {
                parameters.push(resultObject[i]);
              }
              //Rafraichissement du tableau ng-table
              scope.tableParams.reload();
              scope.iswait = false;
            },
            function(reason) {
              scope.iswait = false;
              var resultObject = reason;
              console.log('Get parameters echec : ' + resultObject);
              require('toastr').error('Get parameters echec :' + resultObject);
            }
          );
        };
        scope.refreshParams();

        /**
         * Gestion du tableau des paramètres par la directive angular ngTable.
         */
        scope.tableParams = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: parameters.length, // length of data
            getData: function($defer, params) {
              $defer.resolve(
                parameters.slice(
                  (params.page() - 1) * params.count(),
                  params.page() * params.count()
                )
              );
            },
          }
        );

        /**
         * Réécrit dans le paramètre les valeurs de date en millisecondes si les valeurs sont un objet Date.
         * @param {type} param
         * @returns {undefined}
         */
        function transformDateValues(param) {
          if (param.datecreation instanceof Object) {
            param.datecreation = param.datecreation.getTime();
          }
          if (param.datemodification instanceof Object) {
            param.datemodification = param.datemodification.getTime();
          }
        }

        /**
         * Handler de clic sur le bouton de sauvegarde des modifications du paramètre.
         * @param {type} param
         * @returns {undefined}
         */
        scope.editEndParam = function(param) {
          //Retransformation eventuelle des valeurs de type date en milliseconde si le composant de date à écrit un objet Date au lieu d'un nombre de millisecondes.
          transformDateValues(param);

          //Confirmation de sauvegarde des modifications
          scope.confirmMsg = 'Voulez-vous sauvegarder les modifications ?';
          var ngDialogPromise = ngDialog.openConfirm({
            template: 'js/XG/modules/dbparameters/views/confirmPopup.html',
            scope: scope,
            showClose: false,
          });

          ngDialogPromise.then(
            function(data) {
              saveParam(param);
              require('toastr').info(data);
            },
            function(data) {
              getParamById(param);
              require('toastr').info(data);
            }
          );
        };

        //Modification des date des paramètres: coté serveur:
        // la date de creation n'est pas écrite
        // et la date de modificaton est affecté à la date du jour.
        function saveParam(param) {
          ParametersFactory.update(param, param.id).then(
            function(res) {
              require('toastr').info('Parametre ' + param.id + ' sauvegardé !');
            },
            function(reason) {
              //En cas d'erreur de la mise à jour
              getParamById(param);
              var resultObject = reason;
              console.log('saveParam echec : ' + resultObject);
              require('toastr').error('saveParam echec :' + resultObject);
            }
          );
        }

        /**
         * Récupére les valeurs initiales du paramètre 'param'.
         * @param {type} param
         * @returns {undefined}
         */
        function getParamById(param) {
          ParametersFactory.getbyid(param.id).then(
            function(result) {
              var key;
              var resultParam = result.data;
              for (key in resultParam) {
                param[key] = resultParam[key];
              }
            },
            function(reason) {
              console.log(
                'Impossible de Récupérer les valeurs initiales du paramètre : ' +
                  id
              );
              require('toastr').error(
                'Impossible de Récupérer les valeurs initiales du paramètre : ' +
                  id
              );
            }
          );
        }

        /**
         * Gestion des sélections
         */
        scope.selectedParams = [];
        scope.changeParamsSelection = function(object) {
          if (object.$selected) {
            scope.selectedParams.push(object);
          } else {
            scope.selectedParams.splice(
              scope.selectedParams.indexOf(object),
              1
            );
          }
        };

        /**
         * Méthode de suppression d'un paramètre.
         */

        function deleteParam(param) {
          ParametersFactory.remove(param.id).then(
            function(res) {
              var resultObject = res.data;
              parameters.splice(parameters.indexOf(param), 1);
              //Rafraichissement du tableau ng-table
              scope.tableParams.reload();
            },
            function(reason) {
              var resultObject = reason;
              console.log(
                'deleteParam id:' + param.id + ' en echec . ' + resultObject
              );
              require('toastr').error(
                'Suppression du paramètre id:' +
                  param.id +
                  ': en echec .' +
                  resultObject
              );
            }
          );
        }

        /** show parameter data in a popup **/
        scope.showData = function(param) {
          scope.displayData = param.data;
          ngDialog.open({
            template:
              'js/XG/modules/dbparameters/views/modal/modal.print_data.html',
            className: 'ngdialog-theme-plain',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.removeParams = function() {
          scope.confirmMsg =
            'Voulez-vous supprimer les paramètres sélectionnés ?';
          //Confirmation de sauvegarde des modifications
          var ngDialogPromise = ngDialog.openConfirm({
            template: 'js/XG/modules/dbparameters/views/confirmPopup.html',
            scope: scope,
            showClose: false,
          });
          ngDialogPromise.then(
            function(data) {
              for (var i = 0; i < scope.selectedParams.length; i++) {
                deleteParam(scope.selectedParams[i]);
              }
              require('toastr').info(data);
            },
            function(data) {}
          );
        };

        scope.openPublishInfos = function(param) {
          ngDialog.open({
            template: 'js/XG/modules/dbparameters/views/publishInfosPopup.html',
            scope: scope,
            controller: 'publishController',
            closeByDocument: false,
            data: param,
          });
        };
      },
    };
  };
  adminParamWidget.$inject = [
    'ParametersFactory',
    'ngTableParams',
    'ngDialog',
    'UsersFactory',
  ];
  return adminParamWidget;
});
