'use strict';
define(function () {
  let homepageNewsEventConfig = function (
      extendedNgDialog,
      $filter,
      $rootScope,
      homeFactory,
      $compile,
      $timeout
  ) {
    return {
      templateUrl: 'js/XG/modules/home/views/directives/homepageNewsEvents.html',
      restrict: 'EA',
      scope: {
        currentResources: '=',  // (OBLIGATOIRE) liste des actualités
        homepageName: '='       // (OBLIGATOIRE) nom de la page d'accueil
      },
      link: function (scope){

        /**
         * Au clic sur le bouton "Ajouter une actualité".<br><ul><li>
         * Initialise une nouvelle actualité</li><li>
         * Créé la propriété temporaire "time" nécessaire au timepicker</li><li>
         * Lance l'ouverture de la popup de création d'une actualité</li></ul>
         */
        scope.openAddNewEvent = () => {
          scope.edit_resource = {
            date: new Date(),
            text: '',
            published: false,
            homepage: scope.homepageName
          };
          openEditResourcePopup(true);
        };

        /**
         * Au clic sur le bouton "Editer" (crayon) d'une ligne de la table d'actualité,
         * lance l'ouverture de la popup de création d'une actualité
         */
        scope.openEditNewsEvent = () => {
          openEditResourcePopup(false);
        };

        /**
         * Ouvre la popup de création/édition d'une actualité. <br>
         * Le titre de la popup est différent suivant la valeur du boolean <code>isNew</code>
         * @param {boolean} isNew est <code>true</code> au clic sur le bouton "Ajouter une actualité",
         * <code>false</code> au clic sur le bouton "Editer" (crayon) d'une ligne de la table
         */
        const openEditResourcePopup = (isNew) => {
          extendedNgDialog.open({
            template: 'js/XG/modules/home/views/modals/modal.home.news.event.add.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose edit-event',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('portals.homepage.v2.news.config.add.'+ (isNew ? 'add' : 'edit') + 'Title'),
            draggable: true,
            scrollable: true,
            minimizeMaximize: true,
            resizable: true,
            minWidth: '570px',
            minHeight: '685px'
          });
          scope.edit_resource.time =  homeFactory.getTimeFromTimestamp(scope.edit_resource.date);
          $timeout(() => {
            // masque word-counter et char-counter
            homeFactory.hideEditEventCcWcToolbar();
          },400);
        };

        /**
         * Au clic sur le bouton "Annuler" dans la popup de création d'une actualité
         */
        scope.cancelNewsEvent = () => {
          if (scope.edit_resource) {
            scope.edit_resource = null;
          }
        };

        /**
         * Ajoute l'actualité dans la liste d'actualités du front
         * Combine la date et le temps dans la propriété "date"
         * Effectue l'enregistrement/mise à jour de l'actualité dans la base de données
         * Ré-initialise le tableau des actualités de la popup de configuration des actualités
         */
        scope.saveNewsEvent = () => {
          if (scope.edit_resource) {
            if (scope.edit_resource.date && scope.edit_resource.time) {
              // combine la date et l'heure dans la propriété 'date'
              homeFactory.combineDateTime(scope.edit_resource);
              delete scope.edit_resource.time;
            }
            if (scope.edit_resource.datestring) {
              delete scope.edit_resource.datestring;
            }
            homeFactory.saveHomepageNewsEvent(scope.edit_resource).then(
                res => {
                  if (Array.isArray(res.data)) {
                    const events = res.data;
                    // ajoute les propriétés "datestring" et "time" aux actualités:
                    homeFactory.addNewsEventsDatestring(events);
                    homeFactory.addNewsEventsTime(events);
                    scope.currentResources = events;
                    require('toastr').success($filter('translate')('portals.homepage.v2.saveEventSuccess'));
                  }
                }
            ).finally(
                () => {
                  scope.edit_resource = null;
                }
            );
          }
        };

        /**
         * Au clic sur le bouton "Supprimer",
         * supprime l'actualité dont la ligne est en surbrillance dans la liste d'actualités
         * dans le tableau du front.<br>
         * Effectue également la suppression dans la base de données.<br>
         * Ré-initialise le tableau des actualités de la popup de configuration des actualités
         */
        scope.deleteNewsEvent = () => {
          if (scope.edit_resource && Number.isInteger(scope.edit_resource.fid)) {
            homeFactory.deleteHomepageNewsEvent(scope.edit_resource.fid, scope.homepageName).then(
                res => {
                  if (Array.isArray(res.data)) {
                    const events = res.data;
                    // ajoute les propriétés "datestring" et "time" aux actualités:
                    homeFactory.addNewsEventsDatestring(events);
                    homeFactory.addNewsEventsTime(events);
                    scope.currentResources = events;
                    require('toastr').success($filter('translate')('portals.homepage.v2.delEventSuccess'));
                  }
                }
            ).finally(
                () => {
                  scope.edit_resource = null;
                }
            );
          }
        };

        /**
         * Ordonne les actualités de la plus récente à la plus ancienne
         * L'ordre ne peut être modifié (il n'y a pas de tri de date dans editList)
         */
        const sortNewsEventsDesc = () => {
          if (scope.currentResources) {
            scope.currentResources = scope.currentResources.sort(
                (objA, objB) => Number(objB.date) - Number(objA.date)
            );
          }
        };

        /****************************************
         *   INITIALISATION LISTE D'ACTUALITES  *
         ****************************************/

        sortNewsEventsDesc();

        scope.editListCfg = {
          dataModule: 'portals',
          resource_type: 'homepage.v2.news.config',
          cols: ['datestring', 'text', 'published', 'fid'],
          addResourceButton: false,
          addFunction: scope.openAddNewEvent,
          editFunction: scope.openEditNewsEvent,
          removeFunction: scope.deleteNewsEvent,
          newResourceAppname: '',
          newResourceType: '',
          sort: false,
          extraActions: [],
          extraGlobalActions: [
            {
              label: 'portals.homepage.v2.news.config.addButton',
              fn: scope.openAddNewEvent,
            }
          ]
        };
      },
    };
  };

  homepageNewsEventConfig.$inject = [
      'extendedNgDialog',
      '$filter',
      '$rootScope',
      'homeFactory',
      '$compile',
      '$timeout'
  ];
  return homepageNewsEventConfig;
});