'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    gaJsUtils,
    gaDomUtils,
    EditFactory,
    $filter,
    $timeout
  ) {
    return {
      templateUrl:
        'js/XG/modules/model/views/directives/featuretypeactionsIsDetailRender.html',
      restrict: 'E',
      link: function(scope) {
        // jointure parent
        let baseId = scope.actionData.currentFeature.properties.id;
        scope.baseWhereClause = `${scope.actionData.properties.is_detail_cfg.di_fk} = ${baseId}`;

        // @TODO should be using  getFeatureByNameAndDatastore or getByUid
        let fti = FeatureTypeFactory.getFeatureByName(
          scope.actionData.currentFeature.id.split('.')[0]
        );
        scope.diFti = FeatureTypeFactory.getFeatureByUid(
          scope.actionData.properties.is_detail_cfg.di_fti
        );

        // n'affiche que les attributs choisis
        scope.diAttrs = [];
        scope.actionData.properties.is_detail_cfg.self.fields.forEach(x => {
          let attrDef = false;
          for (let attr of scope.diFti.attributes) {
            if (x.attr === attr.name) {
              attrDef = attr;
            }
          }
          if (attrDef) {
            scope.diAttrs.push({
              type: attrDef.type,
              name: x.attr,
            });
          }
        });

        // actions datatable

        scope.diTableACtions = [
          {
            label: 'btn',
            btnclass: 'default',
            cfg: {
              icon: {
                name: 'times',
              },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-danger',
            },
            config: { click: ['deleteDi'] },
          },
        ];

        scope.actionFromListeDi = function(args) {
          const item = scope.selectedDi.x[0];
          const action = args[0];
          scope.resetEditMode();
          scope.selectedDi = { x: [] };

          $timeout(() => {
            if (action == 'deleteDi') {
              var ans = confirm(
                "Etes-vous certain de vouloir supprimer l'objet " +
                  item.id +
                  ' ?'
              );
              if (ans) {
                gaDomUtils.showGlobalLoader();

                EditFactory.remove(scope.diFti.uid, item.id).then(
                  () => {
                    gaDomUtils.hideGlobalLoader();
                    require('toastr').success('Objet supprimé');
                    scope.diFti = angular.copy(scope.diFti);
                  },
                  () => {
                    gaDomUtils.hideGlobalLoader();
                    require('toastr').error(
                      "Erreur lors de la suppression de l'objet"
                    );
                  }
                );
              }
            }
          });
        };

        // add a new detail d'intervention
        scope.addDi = () => {
          let tmp = angular.copy(scope.currentEditDi);
          let promise = null;

          // tous les attributs sont obligatoires
          for (let field of scope.actionData.properties.is_detail_cfg.self
            .fields) {
            if (
              !angular.isDefined(tmp[field.attr]) ||
              tmp[field.attr] == null
            ) {
              require('toastr').error('Champ ' + field.attr + ' obligatoire');
              return;
            }
          }

          // AJOUT
          if (scope.curreEditDi_id == -1) {
            // ajout de la reference au parent
            tmp[scope.actionData.properties.is_detail_cfg.di_fk] = baseId;
            promise = EditFactory.add(
              scope.diFti.uid,
              gaJsUtils.setNewFeatureCollection(tmp)
            );
            // EDITION
          } else {
            if (tmp.id == null) delete tmp.id;
            tmp = {
              id: scope.curreEditDi_id,
              type: 'Feature',
              properties: tmp,
            };
            promise = EditFactory.update(
              scope.diFti.uid,
              gaJsUtils.setNewFeatureCollection(tmp)
            );
          }

          gaDomUtils.showGlobalLoader();

          promise.then(
            res => {
              gaDomUtils.hideGlobalLoader();
              require('toastr').success($filter('translate')('common.updated'));

              // refresh datatable
              scope.diFti = angular.copy(scope.diFti);
              scope.resetEditMode();
            },
            () => {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                "Erreur lors de l'enregistrement des informations"
              );
            }
          );
        };

        scope.resetCurrentEditDiValues = () => {
          scope.currentEditDi = {};
        };

        scope.resetEditMode = () => {
          scope.currentDiEditMode = 'ajout';
          scope.curreEditDi_id = -1;
          scope.resetCurrentEditDiValues();
        };

        scope.$watch(
          'selectedDi',
          selectedDi => {
            if (selectedDi && selectedDi.x.length) {
              scope.currentDiEditMode = 'edit';
              let x = angular.copy(selectedDi.x[0]);
              scope.curreEditDi_id = x.id;
              scope.currentEditDi = x.properties;
            } else {
              scope.resetEditMode();
            }
          },
          1
        );

        scope.translateAlias = (attr, type) => {
          let _tmp = type === 'parent' ? fti.name : scope.diFti.name;
          return gaJsUtils.translateAttributeAlias(attr, { name: _tmp });
        };

        scope.displayAttrValue = ref => {
          let attrDef = false;
          let val = scope.actionData.currentFeature.properties[ref];

          if (val == null) {
            return '-';
          }

          for (let attr of fti.attributes) {
            if (ref === attr.name) {
              attrDef = attr;
            }
          }

          if (attrDef) {
            switch (attrDef.type) {
              case 'java.util.Date':
              case 'java.sql.Date':
                var dDate = new Date(val);
                val = dDate.toLocaleDateString();
                break;
              case 'java.sql.Boolean':
                val = val === true ? 'Vrai' : 'Faux';
                break;
            }
          }
          return val;
        };
      },
    };
  };
  gcelement.$inject = [
    'FeatureTypeFactory',
    'gaJsUtils',
    'gaDomUtils',
    'EditFactory',
    '$filter',
    '$timeout',
  ];
  return gcelement;
});
