'use strict';
define([
  'angular',
  'ol3js',

  'modules/model/services/DataStoreFactory',
  'modules/model/services/FeatureTypeFactory',
  'modules/model/services/FeatureHistoryFactory',
  'modules/model/services/UnitFactory',
  'modules/model/services/mUnitFactory',
  'modules/model/services/CalculFactory',
  'modules/model/services/BaseMapFactory',
  'modules/model/services/AssociationFactory',
  'modules/model/services/ObjectFilesFactory',
  'modules/model/services/DataDictionaryFactory',
  'modules/model/services/NetworkFactory',
  'modules/model/services/ThumbnailFactory',
  'modules/model/services/StyleConverterFactory',

  'modules/model/controllers/DataStoreCtrl',
  'modules/model/controllers/FeatureTypeCtrl',
  'modules/model/controllers/UnitCtrl',
  'modules/model/controllers/StyleCtrl',
  'modules/model/controllers/BaseMapCtrl',
  'modules/model/controllers/AssociationCtrl',
  'modules/model/controllers/ObjectFilesCtrl',
  'modules/model/controllers/NetworksCtrl',

  'modules/model/directives/attributeInput',
  'modules/model/directives/featuretypeActions',
  'modules/model/directives/featuretypeactionsForm',
  'modules/model/directives/featuretypeactionsJasper',
  'modules/model/directives/featuretypeactionsJasperGlobal',
  'modules/model/directives/featuretypeactionsUrl',
  'modules/model/directives/featuretypeactionsEsrigeoprocess',
  'modules/model/directives/featuretypeactionsHtml',
  'modules/model/directives/featuretypeactionsAnomalie',
  'modules/model/directives/featuretypeactionsIsDetail',
  'modules/model/directives/featuretypeactionsIsDetailRender',
  'modules/model/directives/featuretypeactionsWidget',
  'modules/model/directives/featuretypeRule',
  'modules/model/directives/featuretypeTriggers',
  'modules/model/directives/featuretypePreview',
  'modules/model/directives/wfsMonitor',
  'modules/model/directives/styleconverter',

  'angular-strap',
  'angular-strap.tpl',

  'angular-route',

  'ng-table',
  'cb.x2js',
  'colorpicker.module',
  'ui-rangeSlider',
], function(
  angular,
  ol3js,
  DataStoreFactory,
  FeatureTypeFactory,
  FeatureHistoryFactory,
  UnitFactory,
  mUnitFactory,
  CalculFactory,
  BaseMapFactory,
  AssociationFactory,
  ObjectFilesFactory,
  DataDictionaryFactory,
  NetworkFactory,
  ThumbnailFactory,
  StyleConverterFactory,
  DataStoreCtrl,
  FeatureTypeCtrl,
  UnitCtrl,
  StyleCtrl,
  BaseMapCtrl,
  AssociationCtrl,
  ObjectFilesCtrl,
  NetworksCtrl,
  attributeInput,
  featuretypeActions,
  featuretypeactionsForm,
  featuretypeactionsJasper,
  featuretypeactionsJasperGlobal,
  featuretypeactionsUrl,
  featuretypeactionsEsrigeoprocess,
  featuretypeactionsHtml,
  featuretypeactionsAnomalie,
  featuretypeactionsIsDetail,
  featuretypeactionsIsDetailRender,
  featuretypeactionsWidget,
  featuretypeRule,
  featuretypeTriggers,
  featuretypePreview,
  wfsMonitor,
  styleconverter
) {
  // CHARGER GLOBALEMENT cb.x2js','colorpicker.module','ui-rangeSlider ? dans configuration.js ?

  // Module
  var model = angular.module('model', [
    'mgcrea.ngStrap',
    'cb.x2js',
    'colorpicker.module',
    'ui-rangeSlider',
  ]);

  // Services
  model.factory('DataStoreFactory', DataStoreFactory);
  model.factory('FeatureTypeFactory', FeatureTypeFactory);
  model.factory('FeatureHistoryFactory', FeatureHistoryFactory);
  model.factory('UnitFactory', UnitFactory);
  model.factory('mUnitFactory', mUnitFactory);
  model.factory('CalculFactory', CalculFactory);
  model.factory('BaseMapFactory', BaseMapFactory);
  model.factory('AssociationFactory', AssociationFactory);
  model.factory('ObjectFilesFactory', ObjectFilesFactory);
  model.factory('DataDictionaryFactory', DataDictionaryFactory);
  model.factory('NetworkFactory', NetworkFactory);
  model.factory('ThumbnailFactory', ThumbnailFactory);
  model.factory('StyleConverterFactory', StyleConverterFactory);
  // Controllers
  model.controller('DataStoreCtrl', DataStoreCtrl);
  model.controller('FeatureTypeCtrl', FeatureTypeCtrl);
  model.controller('UnitCtrl', UnitCtrl);
  model.controller('StyleCtrl', StyleCtrl);
  model.controller('BaseMapCtrl', BaseMapCtrl);
  model.controller('AssociationCtrl', AssociationCtrl);
  model.controller('ObjectFilesCtrl', ObjectFilesCtrl);
  model.controller('NetworksCtrl', NetworksCtrl);

  model.directive('attributeInput', attributeInput);
  model.directive('featuretypeActions', featuretypeActions);
  model.directive('featuretypeactionsForm', featuretypeactionsForm);
  model.directive('featuretypeactionsJasper', featuretypeactionsJasper);
  model.directive(
    'featuretypeactionsJasperGlobal',
    featuretypeactionsJasperGlobal
  );
  model.directive('featuretypeactionsUrl', featuretypeactionsUrl);
  model.directive('featuretypeactionsEsrigeoprocess', featuretypeactionsEsrigeoprocess);
  model.directive('featuretypeactionsHtml', featuretypeactionsHtml);
  model.directive('featuretypeactionsAnomalie', featuretypeactionsAnomalie);
  model.directive('featuretypeactionsIsDetail', featuretypeactionsIsDetail);
  model.directive(
    'featuretypeactionsIsDetailRender',
    featuretypeactionsIsDetailRender
  );

  model.directive('featuretypeactionsWidget', featuretypeactionsWidget);

  model.directive('featuretypeRule', featuretypeRule);
  model.directive('featuretypeTriggers', featuretypeTriggers);
  model.directive('featuretypePreview', featuretypePreview);
  model.directive('wfsMonitor', wfsMonitor);
  model.directive('styleconverter', styleconverter);

  // Configuration
  model.config([
    '$routeProvider',
    function($routeProvider) {
      $routeProvider.when('/datasources/', {
        templateUrl: 'js/XG/modules/' + 'model/views/datasources.html',
        controller: DataStoreCtrl,
      });
      $routeProvider.when('/features/', {
        templateUrl: 'js/XG/modules/' + 'model/views/features.html',
        controller: FeatureTypeCtrl,
      });
      $routeProvider.when('/units/', {
        templateUrl: 'js/XG/modules/' + 'model/views/units.html',
        controller: UnitCtrl,
      });
      $routeProvider.when('/style/', {
        templateUrl: 'js/XG/modules/' + 'model/views/style.html',
        controller: StyleCtrl,
      });
      $routeProvider.when('/association/', {
        templateUrl: 'js/XG/modules/' + 'model/views/association.html',
        controller: AssociationCtrl,
      });
      $routeProvider.when('/objectFiles/', {
        templateUrl: 'js/XG/modules/' + 'model/views/objectFiles.html',
        controller: ObjectFilesCtrl,
      });
      $routeProvider.when('/basemap/', {
        templateUrl: 'js/XG/modules/' + 'model/views/basemap.html',
        controller: BaseMapCtrl,
      });
      $routeProvider.when('/networks/', {
        templateUrl: 'js/XG/modules/' + 'model/views/networks.html',
        controller: NetworksCtrl,
      });
    },
  ]);
  return model;
});
