'use strict';
define(function() {
  const StyleConverterFactory = ($http) => {

    const apiCapabilities = {
      SLD: {
        export: ['QML', 'Mapbox'],
        extension: '.sld'
      },
      QML: {
        export: ['SLD', 'Mapbox'],
        extension: '.qml'
      },
      Mapbox: {
        export: ['SLD', 'QML'],
        extension: '.json'
      },
      Mapserver: {
        export: ['SLD', 'QML', 'Mapbox'],
        extension: '.map'
      },
    };

    /**
     * Vérifie la validité d'un fichier SLD
     * @param file fichier SLD à vérifier
     * @return {*} true ou false
     */
    const checkSldFile = (file) => {
      const formData = new FormData();
      formData.append('file', file);
      return $http.post('/services/{portalid}/styleConverter/checkSldFile?f=json', formData, {
        headers: {'Content-Type': undefined},
        transformRequest: angular.identity
      });
    };

    /**
     * Lance la conversion d'un fichier de style
     * @param conversionData objet contenant les caractéristiques de la conversion
     * @return {*} fichier de style dans le format de sortie
     */
    const convert = (conversionData) => {
      const formData = new FormData();
      formData.append('file', conversionData.file);
      formData.append('inputFormat', conversionData.inputFormat);
      formData.append('outputFormat', conversionData.outputFormat);
      formData.append('sldName', conversionData.sldName || '');

      return $http.post('/services/{portalid}/styleConverter/convert?f=json', formData, {
        headers: {'Content-Type': undefined},
        transformRequest: angular.identity,
        responseType: 'blob'
      });
    };
    
    return  {
      checkSldFile: checkSldFile,
      convert: convert,
      apiCapabilities: apiCapabilities
    };
  };
  StyleConverterFactory.$inject = ['$http'];
    return StyleConverterFactory;
});