'use strict';
define(function() {
  var imgAttr = function(
      $http,
      $location,
      PortalsFactory
  ) {
    return {
      restrict: 'AE',
      templateUrl:
        'js/XG/modules/print/views/directives/blocks/blocksConf/imgAttr.html',
      scope: {
        res: '=res',
      },
      link: function(scope) {
        scope.isRotation = scope.res.data.rotation == '${rotation}';

        scope.$watch('res.render.h', function(newval, oldval) {
          if (newval != oldval) scope.res.data.maxHeight = newval;
        });

        scope.$watch('res.render.w', function(newval, oldval) {
          if (newval != oldval) scope.res.data.maxWidth = newval;
        });

        var fileToUpload = null;

        var portalid = angular.module('gcMain').portalid;

        if (portalid == undefined || portalid == '') {
          portalid = PortalsFactory.getPortalId();
        }

        var uploadUrl = '../services/{portalid}/files/uploadfileForPrint';

        if (uploadUrl.indexOf('{portalid}') > -1) {
          uploadUrl = uploadUrl.replace('{portalid}', portalid);
        }

        console.log('Upload url : ' + uploadUrl);

        scope.fileNameChanged = function(a) {
          fileToUpload = a.files[0];
        };

        scope.uploadFile = function() {
          var fd = new FormData();
          fd.append('file', fileToUpload);
          fd.append('print', 'true');

          $http
            .post(uploadUrl, fd, {
              transformRequest: angular.identity,
              headers: { 'Content-Type': undefined },
            })
            .then(function(res) {
              scope.res.data.url =
                $location.protocol() +
                '://' +
                $location.host() +
                ':' +
                $location.port() +
                res.data;
            })
            .catch(function() {});
        };

        scope.rotationChange = function() {
          if (scope.isRotation) {
            scope.res.data.rotation = '${rotation}';
          } else {
            scope.res.data.rotation = 0;
          }
        };
      },
    };
  };

  imgAttr.$inject = [
    '$http',
    '$location',
    'PortalsFactory'
  ];
  return imgAttr;
});
