'use strict';
define(function() {
  var legendAttr = function(PrintModelFactory, $timeout) {
    return {
      restrict: 'AE',
      templateUrl:
        'js/XG/modules/print/views/directives/blocks/blocksConf/legendAttr.html',
      scope: {
        res: '=res',
      },
      link: function(scope) {
        scope.columnNumbersArray = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];

        scope.$watch('res.data.maxHeight', function(newval, oldval) {
          if (newval != oldval) scope.res.render.h = newval;
        });

        scope.$watch('res.data.maxWidth', function(newval, oldval) {
          if (newval != oldval) scope.res.render.w = newval;
        });

        scope.$watch('res.render.h', function(newval, oldval) {
          if (newval != oldval) scope.res.data.maxHeight = newval;
        });

        scope.$watch('res.render.w', function(newval, oldval) {
          if (newval != oldval) scope.res.data.maxWidth = newval;
        });

        scope.setLegIconSize = function() {
          scope.legStyles.layerNameStyle['font-size'] =
            '' + scope.res.data.layerFontSize + 'px';
        };

        scope.setLegIconSize = function() {
          var fntSize = 20,
            factor = 1.0;

          if (scope.legStyles.categoryTextStyle == undefined) return;

          if (scope.res.data.classFontSize != undefined)
            fntSize = scope.res.data.classFontSize;
          if (scope.res.data.scaleForAllIcons != undefined)
            factor = scope.res.data.scaleForAllIcons;

          scope.legStyles.categoryTextStyle['font-size'] = '' + fntSize + 'px';
          scope.legStyles.category1RepStyle.width = scope.legStyles.category1RepStyle.height = scope.legStyles.category2RepStyle.width = scope.legStyles.category2RepStyle.height =
            '' + parseInt('' + fntSize * factor) + 'px';
        };

        scope.setTextPadding = function() {
          var padding = scope.res.data.textPadding.split(' ');
          scope.legStyles.legSketchLblPadding['padding-top'] =
            '' + padding[0] + 'px';
          scope.legStyles.legSketchLblPadding['padding-bottom'] =
            '' + padding[2] + 'px';
          scope.legStyles.legSketchLblPadding['padding-left'] =
            '' + padding[3] + 'px';
          scope.legStyles.legSketchLblPadding['padding-right'] =
            '' + padding[1] + 'px';
        };

        scope.initTextPadding = function() {
          scope.legStyles.legSketchLblPadding = {};
          scope.$watch('res.data.textPadding', scope.setTextPadding);
        };

        scope.setLayerTextFont = function() {
          scope.legStyles.layerNameStyle['font-family'] =
            scope.res.data.layerFont;
        };

        scope.setLayerTextSize = function() {
          var fntSize = 21;

          if (scope.res.data.layerFontSize != undefined)
            fntSize = scope.res.data.layerFontSize;

          scope.legStyles.layerNameStyle['font-size'] = '' + fntSize + 'px';
        };

        scope.setlayerNameStyle = function() {
          return {
            'font-family': 'Arial',
            'font-size': '21px',
          };
        };

        scope.setCategoryRepStyle = function() {
          scope.legStyles.category1RepStyle = {};
          scope.legStyles.category2RepStyle = {};
          scope.$watch('res.data.classFontSize', scope.setLegIconSize);
          scope.$watch('res.data.scaleForAllIcons', scope.setLegIconSize);

          scope.setLegIconSize();
          scope.legStyles.category1RepStyle['background-color'] = 'blue';
          scope.legStyles.category2RepStyle['background-color'] = 'red';
        };

        scope.setFontList = function() {
          scope.legStyles.fontList = [
            {
              fontname: 'Courrier',
              fontweights: ['Normal', 'Bold', 'Oblique'],
            },
            {
              fontname: 'Helvetica',
              fontweights: ['Normal', 'Bold', 'Oblique'],
            },
            {
              fontname: 'Times',
              fontweights: ['Normal', 'Bold', 'Oblique'],
            },
            { fontname: 'Symbol' },
            { fontname: 'ZapfDingbats' },
          ];
          PrintModelFactory.getFontsNames().then(function(res) {
            var iFnt;
            for (iFnt = 0; iFnt < PrintModelFactory.fontsNames.length; iFnt++) {
              scope.legStyles.fontList.push({
                fontname: PrintModelFactory.fontsNames[iFnt],
                fontweights: ['Normal', 'Bold', 'Oblique'],
              });
            }
          });
        };

        scope.checkNumberIsCorrect = function(params) {
          if (params.min != undefined) {
            $timeout(function() {
              if (scope.res.data[params.val] < params.min)
                scope.res.data[params.val] = params.min;
            }, 1500);
          }
        };

        var theScope = scope;
        while (theScope.$parent != undefined && theScope.legStyles == undefined)
          theScope = theScope.$parent;
        if (theScope.legStyles != undefined)
          scope.legStyles = theScope.legStyles;

        scope.initTextPadding();
        scope.setFontList();
        scope.legStyles.categoryTextStyle = {};
        scope.legStyles.layerNameStyle = scope.setlayerNameStyle();
        scope.$watch('res.data.layerFontSize', scope.setLayerTextSize);
        scope.$watch('res.data.layerFont', scope.setLayerTextFont);
        scope.setCategoryRepStyle();
        scope.borderSizeArray = ['0', '1', '2', '3', '4'];
      },
    };
  };

  legendAttr.$inject = ['PrintModelFactory', '$timeout'];
  return legendAttr;
});
