'use strict';
define(function() {
  /**
   * Class : RootFactory
   * Factory WebServices
   */
  var RootFactory = function(
    $http,
    $q,
    gaUrlUtils,
    $rootScope,
    CalendarFactory
  ) {
    /**
     * Function: get
     */
    function get() {
      var promise = $http.get('/services/rootdebug/get?f=json');
      promise.then(function(res) {});
      return promise;
    }

    /**
     * Function: getFileContent
     */
    function getFileContent(file, total, page) {
      var sendata = {
        file: file,
        total: total,
        page: page,
      };
      var promise = $http.post(
        '/services/rootdebug/getFileContent?f=json',
        sendata
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * Function: getConfiguration
     */
    function getConfiguration(bool) {
      var promise = $http.get(
        '/services/rootdebug/get/configuration?f=json' + '&reload=' + bool
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * Function: saveConfiguration
     */
    function saveConfiguration(sendata) {
      var promise = $http.post(
        '/services/rootdebug/save/configuration?f=json',
        sendata
      );
      promise.then(function(res) {});
      return promise;
    }

    return {
      get: get,
      getFileContent: getFileContent,
      getConfiguration: getConfiguration,
      saveConfiguration: saveConfiguration,
    };
  };
  RootFactory.$inject = [
    '$http',
    '$q',
    'gaUrlUtils',
    '$rootScope',
    'CalendarFactory',
  ];
  return RootFactory;
});
