'use strict';
define(function() {
  var StyleFactory = function($http, gaJsUtils, x2js) {
    var StyleFactory = {};
    /**
     * Class : StyleFactory
     * Factory WebServices
     */
    var resources = {
      styles: [],
    };
    /**
     * Function: add
     */
    function add(senddata, name) {
      var promise = $http.post(
        '/services/{portalid}/style/add?f=json' + '&name=' + name,
        senddata
      );
      promise.then(function(res) {
        // todo : server should send back the object in res.data
        resources.styles.push({ name: name });
      });
      return promise;
    }
    /**
     * Function: get
     */
    function get(name) {
      var promise = $http.get(
        '/services/{portalid}/style/get?f=xml' + '&name=' + name
      );
      promise.then(function(res) {});
      return promise;
    }
    /**
     * Function: delete
     */
    function remove(name) {
      var promise = $http.get(
        '/services/{portalid}/style/delete?f=json' + '&name=' + name
      );
      promise.then(function(res) {
        var deleteIndex = resources.styles
          .map(function(s) {
            return s.name;
          })
          .indexOf(name);
        resources.styles.splice(deleteIndex, 1);
      });
      return promise;
    }
    /**
     * Function: update
     */
    function update(senddata, name) {
      var promise = $http.post(
        '/services/{portalid}/style/update?f=json' + '&name=' + name,
        senddata
      );

      return promise;
    }

    /**
     * Function: gettffile
     */
    function gettffile(name) {
      var promise = $http.get(
        '/services/{portalid}/style/ttf/file?f=json' + '&name=' + name
      );

      return promise;
    }
    /**
     * Function: getfont
     */
    function getfont() {
      var promise = $http.get('/services/{portalid}/style/fonts?f=json');

      return promise;
    }
    /**
     * Function: gettf
     */
    function gettf() {
      var promise = $http.get('/services/{portalid}/style/ttf/css?f=json');

      return promise;
    }

    /**
     * Function: getlist
     * @returns {HttpPromise}
     */
    function getlist() {
      var promise = $http.get('/services/{portalid}/style/getlist?f=json');
      promise.then(function(res) {
        if (res.data && res.data.length > 0) {
          resources.styles = [];
          res.data.forEach(function(d) {
            // todo we get the ttf files and we shouldnt
            // move it to another folder or modify the webservice

            if (d.indexOf('.ttf') == -1)
              resources.styles.push({
                name: d,
              });
          });
        }
      });

      return promise;
    }
    /**
     * Function: publish
     */
    function publish(name) {
      var promise = $http.get(
        '/services/{portalid}/style/publish?f=json' + '&name=' + name
      );

      return promise;
    }
    /**
     * Function: publishall
     */
    function publishall() {
      var promise = $http.get('/services/{portalid}/style/publishall?f=json');

      return promise;
    }

    /**
     * Function: getsymbolsimages
     */
    function getsymbolsimages() {
      var promise = $http.get(
        '/services/{portalid}/style/getSymbolsImages?f=json'
      );

      return promise;
    }
    /**
     * Function: getgeoserverresturl
     */
    function getgeoserverresturl() {
      var promise = $http.get(
        '/services/{portalid}/style/getGeoserverRestUrl?f=json'
      );

      return promise;
    }

    /**
     * Function: uploadnewimage
     */
    function uploadnewimage(senddata, path) {
      var promise = $http.post(
        '/services/{portalid}/style/uploadNewImage?f=json' + '&path=' + path,
        senddata,
        {
          transformRequest: angular.identity,
          headers: { 'Content-Type': undefined },
        }
      );

      return promise;
    }

    /**
     * Function: getsymbolbase64
     */
    function getsymbolbase64(symbol) {
      var promise = $http.get(
        '/services/{portalid}/style/getSymbolBase64?f=json' +
          '&symbol=' +
          symbol
      );

      return promise;
    }

    /**
     * Function: forceresetimagelibrary
     */
    function forceresetimagelibrary() {
      var promise = $http.get(
        '/services/{portalid}/style/forceResetImageLibrary?f=json'
      );

      return promise;
    }

    /**
     *  TODO: WEBSERVICE
     * @returns {HttpPromise}
     */
    function getAvailableImages() {
      var promise = $http.get('api_geoserver/getfoldercontents.php');

      return promise;
    }

    function getPaletteFunction(id) {
      switch (id) {
        case 'lemon':
          return function(x) {
            return palette.rgbColor(x, 20, 0);
          };
          break;
        case 'red':
          return function(x) {
            return palette.linearRgbColor(x, 0, 0);
          };
          break;
        case 'sky':
          return function(x) {
            return palette.rgbColor(0, x, 20);
          };
          break;
        case 'orange':
          return function(x) {
            return palette.linearRgbColor(20, x, 0);
          };
          break;
        case 'lagoon':
          return function(x) {
            return palette.linearRgbColor(0, 60, x);
          };
          break;
      }
    }

    /**
     *
     * @param p
     * @returns {*}
     */
    function paletteGenerator(p) {
      if (p.scheme) {
        var scheme = palette.listSchemes(p.scheme)[0];
        var data = p.extra;
        if (!Array.isArray(data) && typeof data === 'string') {
          data = [data];
        }
        data.unshift(p.nb);
        return scheme.apply(scheme, data);
      }

      if (p.func) {
        return palette.generate(getPaletteFunction(p.func), p.nb);
      }

      return palette(p.id, p.nb);
    }

    /**
     * Return if the sld passed is valid or not
     * valid = !null + StyledLayerDescriptor.NamedLayer.UserStyle.FeatureTypeStyle
     * @param sld
     * @returns {boolean}
     */
    function isValidSld(sld) {
      var valid = false,
        jsonSLD = x2js.xml_str2json(sld);

      if (jsonSLD != null) {
        if (
          gaJsUtils.checkNestedProperty(
            'StyledLayerDescriptor.NamedLayer.UserStyle.FeatureTypeStyle',
            jsonSLD
          ) !== false
        ) {
          valid = true;
        }
      }
      return valid;
    }

    /**
     * Updates the JSON mainConfig with the newly published canalisations colors
     */
    function updateJSONCanalColors(canalColoursSld) {
      return $http.post(
          '/services/{portalid}/geoserver/updateJSONCanalColors?f=json',
          canalColoursSld);
    }

    /**
     * Supprime des images parmi les images de portail disponibles dans l'éditeur de styles.<br>
     * Les images utilisées dans des styles ne seront pas supprimées.
     * @param {string} imageNames nom complet des images à supprimer (avec extension) séparés par une virgule
     * @return {Promise} contenant la liste des images supprimées et la liste des images non supprimées
     */
    const deletePortalImageFiles = (imageNames) => {
      return $http.get('/services/{portalid}/style/deletePortalImageFiles?f=json&imagenames=' + imageNames);
    };

    return {
      StyleFactory: StyleFactory,
      resources: resources,
      add: add,
      get: get,
      remove: remove,
      update: update,
      getfont: getfont,
      gettf: gettf,
      gettffile: gettffile,
      getlist: getlist,
      publish: publish,
      publishall: publishall,
      getAvailableImages: getAvailableImages,
      paletteGenerator: paletteGenerator,
      isValidSld: isValidSld,
      getsymbolsimages: getsymbolsimages,
      getgeoserverresturl: getgeoserverresturl,
      uploadnewimage: uploadnewimage,
      forceresetimagelibrary: forceresetimagelibrary,
      updateJSONCanalColors: updateJSONCanalColors,
      deletePortalImageFiles: deletePortalImageFiles
    };
  };
  StyleFactory.$inject = ['$http', 'gaJsUtils', 'x2js'];
  return StyleFactory;
});
