/**
 *
 */
'use strict';
define(function() {
  /**
   * Document Ctrl
   * @param $scope
   * @constructor
   */
  var DocumentCtrl = function(
    $scope,
    DocumentFactory,
    ngDialog,
    $rootScope,
    $filter
  ) {
    $scope.builderForm = function(loadTemplate) {
      ngDialog.open({
        template: 'js/XG/modules/tools/views/modals/modal.add.document.html',
        className: 'ngdialog-theme-plain    miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };
    $scope.removeForm = function() {
      DocumentFactory.removeuploaded($scope.edit_resource.name).then(function(
        res
      ) {
        refreshList();
      });
    };
    $scope.refreshDocumentsList = function() {
      //alert("coco");
      refreshList();
    };
    $scope.getFile = function() {
      window.open(
        '/services/' +
          $rootScope.xgos.portal.uid +
          '/documents/getFile?f=json&name=' +
          $scope.edit_resource.name
      );
    };

    $scope.editListCfg = {
      dataModule: 'tools',
      resource_type: 'documents',
      cols: ['name', 'creationdate'],
      addFunction: $scope.builderForm,
      editFunction: $scope.builderForm,
      removeFunction: $scope.removeForm,
      extraActions: [
        {
          icon: "<i class='fa fa-download'></i>",
          label: 'common.featuretypes.refresh',
          fn: $scope.getFile,
          disableCondition: 'download',
        },
      ],
    };
    /**
     * [refreshList description]
     * @return {[type]} [description]
     */
    var refreshList = function() {
      $scope.currentResources = [];

      DocumentFactory.getlisttemplate().then(function(res) {
        /* $scope.testfeature = FeatureTypeFactory.getFeatureByUid('69506c75-9575-4a71-88e1-cb09a48ea263');*/
        $scope.currentResources = res.data;

        //refreshList();
      });
    };

    DocumentFactory.getlisttemplate().then(function(res) {
      /* $scope.testfeature = FeatureTypeFactory.getFeatureByUid('69506c75-9575-4a71-88e1-cb09a48ea263');*/
      $scope.currentResources = res.data;

      //refreshList();
    });
    setTimeout(function() {
      // dev
      // $scope.builderForm({application_name: "mapapp", type: "forms", name: "simple.form"})
    }, 500);
  };

  DocumentCtrl.$inject = [
    '$scope',
    'DocumentFactory',
    'ngDialog',
    '$rootScope',
    '$filter',
  ];
  return DocumentCtrl;
});
