'use strict';
define(function() {
  var ancAvisControle = function(
    AncAppFactory,
    $timeout,
    $rootScope,
    ancBacTools
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_avis_controle.html',
      restrict: 'EA',
      scope: {
        typeControle: '=',
        cdata: '=',
        ctrlClos: '=',
        labelKey: '=?',
        controleCommentConfig: '=?',
        agent: '=?', // used to render agent on user picker
      },
      link: function(scope, elt, attrs, ctrl) {
        // gestion du cas ou pas de responsable, juste un agent
        scope.validationMode = AncAppFactory.appCfg.main.properties
          .cfgFormulaires.agent_valideur
          ? 'agent_valideur'
          : 'classique';
        scope.rolesValideurPicker =
          scope.validationMode == 'classique'
            ? ['ANC_responsable']
            : ['ANC_agent'];
        scope.avisCtrl = AncAppFactory.appCfg.main.dossierCfg.avisControles;
        scope.fromDialog = false;
        scope.$on('userFromDialog', function(event, status) {
          if (!event.defaultPrevented) {
            event.defaultPrevented = true;
            scope.fromDialog = status;
          }
        });

        // pick agent et resp
        var agentPickerValue = scope.$watch(
          'agentPicker.value',
          function(a) {
            if (a && angular.isDefined(a)) {
              if (!angular.isDefined(scope.cdata.conformite)) {
                scope.cdata.conformite = {};
              }
              scope.cdata.conformite.agent = a.vorname + ' ' + a.name;

              if (!scope.fromDialog) {
                $rootScope.$broadcast(
                  'updateCleanData',
                  scope.cdata.conformite.agent,
                  'checkDiffCdata.conformite.agent'
                );
              }
              scope.fromDialog = false;
            }
          },
          1
        );
        var respPickerValue = scope.$watch(
          'respPicker.value',
          function(r) {
            if (r && angular.isDefined(r)) {
              if (!angular.isDefined(scope.cdata.conformite)) {
                scope.cdata.conformite = {};
              }
              scope.cdata.conformite.responsable = r.vorname + ' ' + r.name;

              if (!scope.fromDialog) {
                $rootScope.$broadcast(
                  'updateCleanData',
                  scope.cdata.conformite.responsable,
                  'checkDiffCdata.conformite.responsable'
                );
              }
              scope.fromDialog = false;
            }
          },
          1
        );

        // cleanup
        scope.$on('$destroy', function() {
          agentPickerValue();
          respPickerValue();
        });

        scope.resetAvis = function(type) {
          if (type == 'agent') delete scope.cdata.conformite.valeur_agent;
          if (type == 'responsable') delete scope.cdata.conformite.valeur;
        };

        scope.checkAvisActif = function(label, typeCtrl, fonction) {
          console.log(typeCtrl);
          for (var i = 0; i < scope.avisCtrl.length; i++) {
            if (
              scope.avisCtrl[i].label === label &&
              scope.avisCtrl[i].type_controle === typeCtrl
            ) {
              if (
                angular.isDefined(scope.avisCtrl[i].actif) &&
                scope.avisCtrl[i].actif === false
              ) {
                if (fonction === 'responsable')
                  scope.avisInactifResponsable = true;
                scope.valeur_inactive = scope.cdata.conformite.valeur;
                if (fonction === 'agent') scope.avisInactifAgent = true;
                scope.valeur_inactive_agent =
                  scope.cdata.conformite.valeur_agent;
              }
            }
          }
        };

        scope.copyAvisAgent = function() {
          ancBacTools.copyAvisAgent(scope.cdata);
        };
      },
    };
  };

  ancAvisControle.$inject = [
    'AncAppFactory',
    '$timeout',
    '$rootScope',
    'ancBacTools',
  ];
  return ancAvisControle;
});
