'use strict';
define(function() {
  var ancbacLiaisonTables = function(
    AncAppFactory,
    BacAppFactory,
    FeatureTypeFactory,
    gaDomUtils,
    $rootScope
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_liaison_tables.html',
      restrict: 'EA',
      scope: {
        apptype: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;

        scope.entreprisesCfg = CurrentAppFactory.appCfg.main.entreprisesCfg;
        scope.parcellesCfg = CurrentAppFactory.appCfg.main.parcellesCfg;

        var defaultEntrepriseFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          'kis_anc_entreprise'
        );
        var defaultParcelleFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          'kis_anc_parcelle'
        );
        scope.defaultDatastoreName = CurrentAppFactory.appCfg.main.datastore;

        /**
         *  showEntreprisesCfg
         */
        scope.selectFtiForEntreprise = {
          fti: angular.copy(defaultEntrepriseFti),
        };
        scope.newEntreprisesCfg = {
          type_emplacement: 'defaut',
          emplacement: 'kis_anc_entreprise',
        };

        var setDefaultEntrepriseAttributes = function() {
          if (scope.newEntreprisesCfg.type_emplacement != 'defaut') {
            scope.newEntreprisesCfg.fields = {};
          } else {
            scope.selectFtiForEntreprise.fti = angular.copy(
              defaultEntrepriseFti
            );
            scope.newEntreprisesCfg.fields = {
              nom: 'nom',
              type: 'type',
              siret: 'siret',
              num_tel: 'num_tel',
              num_port: 'num_port',
              email: 'email',
              fax: 'fax',
              adresse_num_rue: 'adresse_num_rue',
              adresse_num_rue_extra: 'adresse_num_rue_extra',
              adresse_rue: 'adresse_rue',
              adresse_ville: 'adresse_ville',
              adresse_cp: 'adresse_cp',
              adresse_bp: 'adresse_bp',
              adresse_pays: 'adresse_pays',
              adresse_batiment: 'adresse_batiment',
              adresse_appt: 'adresse_appt',
              adresse_etage: 'adresse_etage',
              adresse_escalier: 'adresse_escalier',
              adresse_complement: 'adresse_complement',
              actif: 'actif',
              agree: 'agree',
            };
          }
        };

        // if the fti is changed
        var watch1 = scope.$watch(
          'newEntreprisesCfg.type_emplacement',
          function(v) {
            if (angular.isDefined(v)) {
              if (v == 'defaut')
                scope.newEntreprisesCfg.emplacement = 'kis_anc_entreprise';
            }
            setDefaultEntrepriseAttributes();
          },
          1
        );
        var watch2 = scope.$watch(
          'selectFtiForEntreprise',
          function(xd) {
            setDefaultEntrepriseAttributes();
            scope.newEntreprisesCfg.emplacement =
              scope.selectFtiForEntreprise.fti.name;
          },
          1
        );

        var interdictionsEntreprise = {
          nom: [
            'java.lang.Double',
            'java.lang.Float',
            'java.util.Date',
            'java.lang.Boolean',
            'java.lang.Integer',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          type: [
            'java.lang.Double',
            'java.lang.Float',
            'java.util.Date',
            'java.lang.Boolean',
            'java.lang.Integer',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          siret: [
            'java.util.Date',
            'java.lang.Boolean',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          telephone: [
            'java.lang.Integer',
            'java.util.Date',
            'java.lang.Boolean',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          adresse_num_rue: [
            'java.lang.Double',
            'java.lang.Float',
            'java.util.Date',
            'java.lang.Boolean',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          adresse_num_rue_extra: [
            'java.lang.Double',
            'java.util.Date',
            'java.lang.Float',
            'java.lang.Boolean',
            'java.lang.Integer',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          adresse_rue: [
            'java.lang.Double',
            'java.lang.Float',
            'java.util.Date',
            'java.lang.Boolean',
            'java.lang.Integer',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          adresse_ville: [
            'java.lang.Double',
            'java.lang.Float',
            'java.util.Date',
            'java.lang.Boolean',
            'java.lang.Integer',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          adresse_cp: [
            'java.lang.Double',
            'java.lang.Float',
            'java.util.Date',
            'java.lang.Boolean',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          adresse_bp: [
            'java.lang.Double',
            'java.lang.Float',
            'java.util.Date',
            'java.lang.Boolean',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          adresse_pays: [
            'java.lang.Double',
            'java.lang.Float',
            'java.util.Date',
            'java.lang.Boolean',
            'java.lang.Integer',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          fax: [
            'java.lang.Double',
            'java.lang.Float',
            'java.util.Date',
            'java.lang.Boolean',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
        };

        scope.problemesLiaisonEntreprise = [];
        var watch3 = scope.$watch(
          'newEntreprisesCfg.fields',
          function(fields) {
            scope.problemesLiaisonEntreprise = [];
            if (
              angular.isDefined(fields) &&
              scope.newEntreprisesCfg.type_emplacement == 'autre' &&
              Object.keys(fields).length
            ) {
              for (var i in fields) {
                var field = fields[i];
                for (var j in scope.selectFtiForEntreprise.fti.attributes) {
                  if (
                    scope.selectFtiForEntreprise.fti.attributes[j].name == field
                  ) {
                    /*                            console.log('attribut '+i);
                                     console.log('type '+scope.selectFtiForEntreprise.fti.attributes[j].type);*/
                    if (
                      ~interdictionsEntreprise[i].indexOf(
                        scope.selectFtiForEntreprise.fti.attributes[j].type
                      )
                    ) {
                      scope.problemesLiaisonEntreprise.push(
                        "L'attribut " +
                          i +
                          ' me peut pas être de type ' +
                          scope.selectFtiForEntreprise.fti.attributes[j].type
                      );
                    }
                  }
                }
              }
            }
          },
          1
        );

        /**
         * return whether the current entreprise cfg is valid
         */
        scope.isValidEntrepriseCfg = function() {
          var valid = true;

          [
            'nom',
            'type',
            'siret',
            'num_tel',
            'num_port',
            'email',
            'fax',
            'adresse_num_rue',
            'adresse_num_rue_extra',
            'adresse_rue',
            'adresse_ville',
            'adresse_cp',
            'adresse_bp',
            'adresse_pays',
          ].forEach(function(x) {
            if (!scope.newEntreprisesCfg.fields[x]) valid = false;
          });
          if (scope.problemesLiaisonEntreprise.length) valid = false;
          return valid;
        };

        /**
         * save saveEntrepriseCfg in ancAppCfg
         */
        scope.saveEntrepriseCfg = function() {
          CurrentAppFactory.appCfg.main.entreprisesCfg =
            scope.newEntreprisesCfg;
          gaDomUtils.showGlobalLoader();
          CurrentAppFactory.updateAppCfg().then(function() {
            scope.entreprisesCfg = CurrentAppFactory.appCfg.main.entreprisesCfg;
            scope.entreprisesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
              CurrentAppFactory.appCfg.main.datastore,
              scope.entreprisesCfg.emplacement
            );
            $rootScope.$broadcast('refreshDatatable', {
              uid: scope.entreprisesFti.uid,
            });
            gaDomUtils.hideGlobalLoader();
            //$window.location.reload();
          });
        };

        /*----------------------------------------------
         * PARCELLES
         *---------------------------------------------*/

        /**
         *  showParcelleCfg
         */
        scope.selectFtiForParcelle = {
          fti: angular.copy(defaultParcelleFti),
        };

        scope.newParcelleCfg = {
          type_emplacement: 'defaut',
          emplacement: 'kis_anc_parcelle',
          api_cadastre: {
            url: 'https://api-cadastre.sig.rennesmetropole.fr/v1',
          },
        };

        var setDefaultParcelleAttributes = function() {
          if (scope.newParcelleCfg.type_emplacement != 'defaut') {
            scope.newParcelleCfg.fields = {};
          } else {
            scope.selectFtiForParcelle.fti = angular.copy(defaultParcelleFti);
            scope.newParcelleCfg.fields = {
              section: 'section',
              surface: 'surface',
              numero: 'numero',
              commune: 'commune',
            };
          }
        };

        // check validite des chamnps choisis
        var interdictionsParcelle = {
          section: [
            'java.util.Date',
            'java.lang.Boolean',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          numero: [
            'java.util.Date',
            'java.lang.Boolean',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          surface: [
            'java.util.Date',
            'java.lang.Boolean',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
          commune: [
            'java.lang.Double',
            'java.lang.Float',
            'java.util.Date',
            'java.lang.Boolean',
            'java.lang.Integer',
            'java.sql.Timestamp',
            'g2c.attachment',
            'g2c.attachments',
          ],
        };

        scope.problemesLiaisonParcelle = [];
        var watch4 = scope.$watch(
          'newParcelleCfg.fields',
          function(fields) {
            scope.problemesLiaisonParcelle = [];
            if (
              angular.isDefined(fields) &&
              scope.newParcelleCfg.type_emplacement == 'autre' &&
              Object.keys(fields).length
            ) {
              for (var i in fields) {
                var field = fields[i];
                for (var j in scope.selectFtiForParcelle.fti.attributes) {
                  if (
                    scope.selectFtiForParcelle.fti.attributes[j].name == field
                  ) {
                    console.log('attribut ' + i);
                    console.log(
                      'type ' +
                        scope.selectFtiForParcelle.fti.attributes[j].type
                    );
                    if (
                      ~interdictionsParcelle[i].indexOf(
                        scope.selectFtiForParcelle.fti.attributes[j].type
                      )
                    ) {
                      scope.problemesLiaisonParcelle.push(
                        "L'attribut " +
                          i +
                          ' me peut pas être de type ' +
                          scope.selectFtiForParcelle.fti.attributes[j].type
                      );
                    }
                  }
                }
              }
            }
          },
          1
        );

        // if the fti is changed
        var watch5 = scope.$watch(
          'newParcelleCfg.type_emplacement',
          function(v) {
            if (angular.isDefined(v)) {
              if (v == 'defaut')
                scope.newParcelleCfg.emplacement = 'kis_anc_parcelle';
            }
            setDefaultParcelleAttributes();
          },
          1
        );
        var watch6 = scope.$watch(
          'selectFtiForParcelle',
          function(xd) {
            setDefaultParcelleAttributes();
            scope.newParcelleCfg.emplacement =
              scope.selectFtiForParcelle.fti.name;
          },
          1
        );

        /**
         * return whether the current parcelle cfg is valid
         */
        scope.isValidParcelleCfg = function() {
          var valid = false;

          if (
            scope.newParcelleCfg.fields.section &&
            scope.newParcelleCfg.fields.numero &&
            scope.newParcelleCfg.fields.surface &&
            scope.newParcelleCfg.fields.commune
          ) {
            valid = true;
          }
          if (scope.problemesLiaisonParcelle.length) valid = false;
          return valid;
        };

        /**
         * save saveParcellesCfg in ancAppCfg
         */
        scope.saveParcellesCfg = function() {
          CurrentAppFactory.appCfg.main.parcellesCfg = scope.newParcelleCfg;
          gaDomUtils.showGlobalLoader();
          CurrentAppFactory.updateAppCfg().then(function() {
            scope.parcellesCfg = CurrentAppFactory.appCfg.main.parcellesCfg;
            scope.parcellesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
              CurrentAppFactory.appCfg.main.datastore,
              scope.parcellesCfg.emplacement
            );
            $rootScope.$broadcast('refreshDatatable', {
              uid: scope.parcellesFti.uid,
            });
            gaDomUtils.hideGlobalLoader();
            // $window.location.reload();
          });
        };

        // cleanup
        scope.$on('$destroy', function() {
          watch1();
          watch2();
          watch3();
          watch4();
          watch5();
          watch6();
        });
      },
    };
  };

  ancbacLiaisonTables.$inject = [
    'AncAppFactory',
    'BacAppFactory',
    'FeatureTypeFactory',
    'gaDomUtils',
    '$rootScope',
  ];
  return ancbacLiaisonTables;
});
