'use strict';
define(function() {
  var ancBacVerificationIndexationDossier = function(
    $location,
    $window,
    $rootScope,
    AncAppFactory,
    ngDialog
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_verification_indexation_dossier.html',
      restrict: 'EA',
      scope: {
        dossier: '=',
      },
      link: function($scope) {
        var modalOpen = false;
        $scope.normalDialog = function() {
          if (modalOpen) return;
          modalOpen = true;

          AncAppFactory.indexDossierExists($scope.dossier.id).then(
            function(resultat) {
              $scope.documentIndexs = resultat.data;
              $scope.documentId = $scope.dossier.id;
              $scope.documentRef = $scope.dossier.ref_dossier;
              var dialog = ngDialog.open({
                template:
                  'js/XG/widgets/ancapp/main/views/modals/modal.verificationIndexation.html',
                className:
                  'ngdialog ngdialog-overlay nopadding ngdialog-theme-plain width80pct ng-scope',
                closeByDocument: false,
                preCloseCallback: function() {
                  modalOpen = false;
                },
                scope: $scope,
              });
            },
            function() {
              require('toastr').error(
                "Un problème TimeOut est survenu lors d'une recherche Elastic",
                'Erreur',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
            }
          );
        };
        $scope.getcontroledetail = function(dossier, controle) {
          var appname = $location.$$search.app;
          var portalid = $location.$$search.portal;
          var token = localStorage.getItem('auth_token');
          $window.open(
            $location.$$protocol +
              '://' +
              $location.$$host +
              '/services/' +
              portalid +
              '/ancapp/' +
              appname +
              '/getControleDetail?f=json&dossier=' +
              dossier +
              '&controle=' +
              controle +
              '&bacapp=&token=' +
              token +
              '&kis_app=anc&&application=' +
              appname
          );
        };
      },
    };
  };
  ancBacVerificationIndexationDossier.$inject = [
    '$location',
    '$window',
    '$rootScope',
    'AncAppFactory',
    'ngDialog',
  ];
  return ancBacVerificationIndexationDossier;
});
