'use strict';
define(function() {
  var recherchePointConsommation = function(
    OmegaFactory,
    FeatureTypeFactory,
    ngDialog,
    gaDomUtils,
    $filter
  ) {
    return {
      restrict: 'EA',
      replace: true,
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/recherche_point_consommation.html',
      scope: {
        filters: '=?', // nom_prenom, adresse_complete, commune: true,
        // id_compteur, id_point_conso
        filterDefaultValues: '=?',
        onSelect: '&?',
        res: '=?',
      },
      link: function($scope) {
        $scope.omegaQueryParams = {};
        $scope.resultatSelectionOmega = {};
        $scope.resultatSelectionOmega.data = [];
        if ($scope.$parent.$parent.omegaFilters) {
          $scope.omegaFilters = $scope.$parent.$parent.omegaFilters;
        }
        if ($scope.$parent.$parent.omegaQueryParams) {
          $scope.omegaQueryParams = $scope.$parent.$parent.omegaQueryParams;
        }
        if (
          $scope.omegaFilters &&
          angular.isDefined($scope.omegaFilters.multiple_selection)
        ) {
          $scope.omegaQueryParams.multipleSelection =
            $scope.omegaFilters.multiple_selection;
        }
        if ($scope.$parent.$parent.omegaVariable) {
          $scope.variable = $scope.$parent.$parent.omegaVariable;
        }
        if ($scope.$parent.$parent.modeDirective) {
          $scope.omegaFilters.mode_Widget = $scope.$parent.$parent.modeDirective;
        }
        $scope.recuperationOmegaFilters = function() {
          if ($scope.omegaFilters && !$scope.omegaFilters.multiple_selection) {
            if ($scope.omegaFilters.nom_prenom) {
              $scope.omegaQueryParams.nomAbonnee =
                $scope.$parent.$parent.res.current.properties.nomAbonnee;
              $scope.omegaQueryParams.prenomAbonnee =
                $scope.$parent.$parent.res.current.properties.prenomAbonnee;
            }
            if ($scope.omegaFilters.adresse_complete) {
              $scope.omegaQueryParams.adresseAbonnee =
                $scope.$parent.$parent.res.current.properties.adresseAbonnee;
            }
            if ($scope.omegaFilters.commune) {
              $scope.omegaQueryParams.communeAbonnee =
                $scope.$parent.$parent.res.current.properties.communeAbonnee;
            }
            if ($scope.omegaFilters.numero_compteur) {
              $scope.omegaQueryParams.numeroCompteur =
                $scope.$parent.$parent.res.current.properties.numeroCompteur;
            }
            if (
              $scope.omegaFilters.ref_point_conso &&
              !$scope.omegaQueryParams.numeroPointConsommation
            ) {
              $scope.omegaQueryParams.numeroPointConsommation =
                $scope.$parent.$parent.res.current.properties.numeroPointConsommation;
            }
            if ($scope.omegaFilters.num_contrat) {
              $scope.omegaQueryParams.numContrat =
                $scope.$parent.$parent.res.current.properties.numContrat;
            }
          } else {
            $scope.omegaQueryParams.numeroCompteurMultiple = '';
            $scope.omegaQueryParams.numeroPointConsommationMultiple = '';
            $scope.omegaQueryParams.numContratMultiple = '';
            $scope.omegaQueryParams.communeMultiple = '';

            var features = $scope.$parent.$parent.res.allResult.features;
            $scope.omegaQueryParams.data = [];
            for (let index = 0; index < features.length; index++) {
              let idfeature = features[index].id;
              if (idfeature.startsWith('AEP_COMPTEUR_ABONNE')) {
                $scope.omegaQueryParams.data[index] = {};
                if ($scope.omegaFilters && $scope.omegaFilters.commune) {
                  $scope.omegaQueryParams.data[index].commune =
                    features[index].properties.communeAbonnee;
                  if ($scope.omegaQueryParams.communeMultiple == '') {
                    $scope.omegaQueryParams.communeMultiple =
                      features[index].properties.communeAbonnee;
                  } else {
                    $scope.omegaQueryParams.communeMultiple =
                      $scope.omegaQueryParams.communeMultiple +
                      ';' +
                      features[index].properties.communeAbonnee;
                  }
                }
                if ($scope.omegaFilters && $scope.omegaFilters.num_contrat) {
                  $scope.omegaQueryParams.data[index].numContrat =
                    features[index].properties.numContrat;
                  if ($scope.omegaQueryParams.numContratMultiple == '') {
                    $scope.omegaQueryParams.numContratMultiple =
                      features[index].properties.numContrat;
                  } else {
                    $scope.omegaQueryParams.numContratMultiple =
                      $scope.omegaQueryParams.numContratMultiple +
                      ';' +
                      features[index].properties.numContrat;
                  }
                }
                if (
                  $scope.omegaFilters &&
                  $scope.omegaFilters.numero_compteur
                ) {
                  $scope.omegaQueryParams.data[index].numeroCompteur =
                    features[index].properties.numeroCompteur;
                  if ($scope.omegaQueryParams.numeroCompteurMultiple == '') {
                    $scope.omegaQueryParams.numeroCompteurMultiple =
                      features[index].properties.numeroCompteur;
                  } else {
                    $scope.omegaQueryParams.numeroCompteurMultiple =
                      $scope.omegaQueryParams.numeroCompteurMultiple +
                      ';' +
                      features[index].properties.numeroCompteur;
                  }
                }
                if (
                  $scope.omegaFilters &&
                  $scope.omegaFilters.ref_point_conso
                ) {
                  $scope.omegaQueryParams.data[index].numeroPointConsommation =
                    features[index].properties.numeroPointConsommation;
                  if (
                    $scope.omegaQueryParams.numeroPointConsommationMultiple ==
                    ''
                  ) {
                    $scope.omegaQueryParams.numeroPointConsommationMultiple =
                      features[index].properties.numeroPointConsommation;
                  } else {
                    $scope.omegaQueryParams.numeroPointConsommationMultiple =
                      $scope.omegaQueryParams.numeroPointConsommationMultiple +
                      ';' +
                      features[index].properties.numeroPointConsommation;
                  }
                }
              }
            }
          }
        };
        /**
         * Get Omega Templates
         */
        $scope.getOmegaTemplates = function() {
          $scope.templateDocument = {};
          $scope.omegaTemplates = [];
          OmegaFactory.getOmegaTemplates().then(
            function(res) {
              if (angular.isDefined(res.data)) {
                $scope.omegaTemplates = res.data;
              } else {
                require('toastr').warning('Aucune template.', {
                  positionClass: 'toast-bottom-left',
                });
              }
            },
            function() {
              require('toastr').error(
                'Impossible de récupérer la liste des templates Omega.',
                'Erreur',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
            }
          );
        };
        /**
         * resetOmegaFilters
         */
        $scope.resetOmegaFilters = function() {
          $scope.omegaQueryParams = {};
          $scope.omegaQueryParams.multipleSelection = false;
        
        };
        if ($scope.omegaFilters.mode_Widget) {
          $scope.resetOmegaFilters();
        }
        /**
         * omegaRecherchePointConsommation
         */
        $scope.omegaRecherchePointConsommation = function() {
          gaDomUtils.showGlobalLoader();

          if ($scope.variable === 'OmegaAnc') {
            $scope.omegaQueryParams.omegaAnc = true;
          }

          OmegaFactory.omegarecherchepointconsommation(
            $scope.omegaQueryParams
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              $scope.resultOmega = false;

              if (angular.isDefined(res.data) && res.data.totalFeatures > 0) {
                if ($scope.omegaFilters.show_table) {
                  $scope.ftiOmega = res.data.featureTypeInfo;
                  $scope.attributestouseindatatable =
                    res.data.featureTypeInfo.attributes;
                  var tmp = angular.copy(res.data);
                  delete tmp.featureTypeInfo;
                  delete tmp.tablename;
                  $scope.resultOmega = tmp;
                  if (res.data.totalFeatures == 1 && $scope.variable == 'OmegaAnc' ) {
                    $scope.resultatSelectionOmega.data[0] = tmp.features[0];
                    $scope.appliquerOmegaRecherchePointConsommation(true);
                  }
                }
                if ($scope.variable != 'OmegaAnc' &&
                  !$scope.omegaFilters.mode_Widget &&
                  !$scope.omegaFilters.multiple_selection
                ) {
                  if (!$scope.$parent.$parent.res[$scope.variable].properties) {
                    $scope.$parent.$parent.res[$scope.variable].properties = {};
                  }
                  $scope.$parent.$parent.res[
                    $scope.variable
                  ].properties.numeroPointConsommation =
                    res.data.features[0].properties.pc___id;
                  $scope.$parent.$parent.res[
                    $scope.variable
                  ].properties.nomAbonnee =
                    res.data.features[0].properties.redevable___nomComplet;
                  $scope.$parent.$parent.res[
                    $scope.variable
                  ].properties.adresseAbonnee =
                    res.data.features[0].properties.redevable___adresseComplete;
                  $scope.$parent.$parent.res[
                    $scope.variable
                  ].properties.communeAbonnee =
                    res.data.features[0].properties.redevable___adresse_ville;
                  $scope.$parent.$parent.res[
                    $scope.variable
                  ].properties.numeroCompteur =
                    res.data.features[0].properties.compteur___numeroSerie;
                  $scope.$parent.$parent.res[
                    $scope.variable
                  ].properties.indexCourant =
                    res.data.features[0].properties.nouvelIndex;
                  $scope.$parent.$parent.res[
                    $scope.variable
                  ].properties.indexPrécedent =
                    res.data.features[0].properties.ancienIndex;
                  $scope.$parent.$parent.res[
                    $scope.variable
                  ].properties.compteurMarque =
                    res.data.features[0].properties.compteur___marque;
                  $scope.$parent.$parent.res[
                    $scope.variable
                  ].properties.compteurCalibre =
                    res.data.features[0].properties.compteur___calibre;
                  $scope.$parent.$parent.res[
                    $scope.variable
                  ].properties.compteurDiametre =
                    res.data.features[0].properties.compteur___diametre;
                  $scope.$parent.$parent.res[
                    $scope.variable
                  ].properties.typeReleve =
                    res.data.features[0].properties.typeReleve;
                  $scope.$parent.$parent.res[
                    $scope.variable
                  ].properties.dateAncienIndex =
                    res.data.features[0].properties.dateAncienIndex;
                }

                if (!$scope.omegaFilters.show_table) {
                  $scope.$parent.$parent.recherchepointconsommation.close();
                }
              } else {
                require('toastr').warning('Aucune correspondance.', {
                  positionClass: 'toast-bottom-left',
                });
              }
            },
            function() {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                'Impossible de récupérer la liste des points de consommation.',
                'Erreur',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
            }
          );
        };
        $scope.parmasNotEmpty = function(omegaQueryParams) {
          if (!omegaQueryParams.multipleSelection)
            return (
              omegaQueryParams.numeroPointConsommation ||
              omegaQueryParams.numeroCompteur ||
              omegaQueryParams.numContrat ||
              omegaQueryParams.nomAbonnee ||
              omegaQueryParams.prenomAbonnee ||
              omegaQueryParams.numeroVoie ||
              omegaQueryParams.typeVoie ||
              omegaQueryParams.nomVoie ||
              omegaQueryParams.codePostaleCommune ||
              omegaQueryParams.nomCommune
            );
          else
            return (
              (omegaQueryParams.communeMultiple &&
                omegaQueryParams.communeMultiple != '') ||
              (omegaQueryParams.numContratMultiple &&
                omegaQueryParams.numContratMultiple != '') ||
              (omegaQueryParams.numeroCompteurMultiple &&
                omegaQueryParams.numeroCompteurMultiple != '') ||
              (omegaQueryParams.numeroPointConsommationMultiple &&
                omegaQueryParams.numeroPointConsommationMultiple != '')
            );
        };

        if (!$scope.omegaFilters.mode_Widget) {
          $scope.recuperationOmegaFilters();
          if ($scope.parmasNotEmpty($scope.omegaQueryParams))
            $scope.omegaRecherchePointConsommation();
          else
            require('toastr').warning('Aucun critère de recherche spécifié', {
              positionClass: 'toast-bottom-left',
            });
        }
        $scope.appliquerOmegaRecherchePointConsommation = function() {
          if ($scope.resultatSelectionOmega.data.length > 0) {
            if ($scope.variable === 'OmegaAnc') {
              $scope.$parent.$parent.pointConsoSelectionne($scope.resultatSelectionOmega.data[0]);
              return ;
            }
            if(!$scope.$parent.$parent) { 
              $scope.$parent.$parent = {} ;
            }
            if(!$scope.$parent.$parent.res) { 
              $scope.$parent.$parent.res = {};
            }
            $scope.$parent.$parent.res[$scope.variable] = {};
            $scope.$parent.$parent.res[$scope.variable].properties = {};
            $scope.$parent.$parent.res[
              $scope.variable
            ].properties.numeroPointConsommation =
              $scope.resultatSelectionOmega.data[0].properties.pc___id;
            $scope.$parent.$parent.res[$scope.variable].properties.nomAbonnee =
              $scope.resultatSelectionOmega.data[0].properties.redevable___nomComplet;
            $scope.$parent.$parent.res[
              $scope.variable
            ].properties.adresseAbonnee =
              $scope.resultatSelectionOmega.data[0].properties.redevable___adresseComplete;
            $scope.$parent.$parent.res[
              $scope.variable
            ].properties.communeAbonnee =
              $scope.resultatSelectionOmega.data[0].properties.redevable___adresse_ville;
            $scope.$parent.$parent.res[
              $scope.variable
            ].properties.numeroCompteur =
              $scope.resultatSelectionOmega.data[0].properties.numeroCompteur;
            $scope.$parent.$parent.res[
              $scope.variable
            ].properties.indexCourant =
              $scope.resultatSelectionOmega.data[0].properties.nouvelIndex;
            $scope.$parent.$parent.res[
              $scope.variable
            ].properties.indexPrécedent =
              $scope.resultatSelectionOmega.data[0].properties.ancienIndex;
            $scope.$parent.$parent.res[
              $scope.variable
            ].properties.compteurMarque =
              $scope.resultatSelectionOmega.data[0].properties.compteurMarque;
            $scope.$parent.$parent.res[
              $scope.variable
            ].properties.compteurCalibre =
              $scope.resultatSelectionOmega.data[0].properties.compteurCalibre;
            $scope.$parent.$parent.res[
              $scope.variable
            ].properties.compteurDiametre =
              $scope.resultatSelectionOmega.data[0].properties.compteurDiametre;
            $scope.$parent.$parent.res[$scope.variable].properties.typeReleve =
              $scope.resultatSelectionOmega.data[0].properties.typeReleve;
            // Les nouveaux donnés de contrat
            $scope.$parent.$parent.res[
              $scope.variable
            ].properties.nombreContrat =
              $scope.resultatSelectionOmega.data[0].properties.contrat_nombre;
            $scope.$parent.$parent.res[$scope.variable].properties.numContrat =
              $scope.resultatSelectionOmega.data[0].properties.contrat_numero;
            $scope.$parent.$parent.res[$scope.variable].properties.idContrat =
              $scope.resultatSelectionOmega.data[0].properties.contrat_id;
            $scope.$parent.$parent.res[$scope.variable].properties.actif =
              $scope.resultatSelectionOmega.data[0].properties.contrat_actif;
            $scope.$parent.$parent.res[$scope.variable].properties.tournee_id =
              $scope.resultatSelectionOmega.data[0].properties.pc___tournee_id;
            $scope.$parent.$parent.res[$scope.variable].properties.noordrlv =
              $scope.resultatSelectionOmega.data[0].properties.pc___noordrlv;
            $scope.$parent.$parent.res[$scope.variable].properties.rrnsmodule =
              $scope.resultatSelectionOmega.data[0].properties.rrnsmodule;
            $scope.$parent.$parent.res[$scope.variable].properties.releveRadio =
              $scope.resultatSelectionOmega.data[0].properties.releve_radio;
            $scope.$parent.$parent.res[$scope.variable].properties.libnat =
              $scope.resultatSelectionOmega.data[0].properties.libnat;
            $scope.$parent.$parent.res[$scope.variable].properties.consorlv =
              $scope.resultatSelectionOmega.data[0].properties.consorlv;
              $scope.$parent.$parent.res[$scope.variable].type =
              $scope.resultatSelectionOmega.data[0].type;


              if($scope.resultatSelectionOmega.data[0].geometry){
                $scope.$parent.$parent.res[$scope.variable].geometry =
                $scope.resultatSelectionOmega.data[0].geometry;
              } else {
                require('toastr').warning($filter('translate')('omegaManager.noGeomData'), {
                  positionClass: 'toast-bottom-left',
                });
              }
   

            $scope.$parent.$parent.recherchepointconsommation.close();
          }
        };

        $scope.openModalGenerateCourrier = function() {
          $scope.getOmegaTemplates();
          $scope.recherchepointconsommation = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.generatecourrierpointconsommation.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: $scope,
          });
        };
        $scope.generateCourrier = function(nameTemplate) {
          var featureUidByName = FeatureTypeFactory.getFeatureByName(
            'AEP_COMPTEUR_ABONNE'
          );
          var data = {};
          data.storeName = featureUidByName.storeName;
          data.resultatSelectionOmega = $scope.resultatSelectionOmega.data;
          data.nameTemplate = nameTemplate;

          OmegaFactory.getZipDocumentsTypes(data).then(
            function(res) {
              $scope.recherchepointconsommation.close();
              window.open(
                '/services/' +
                  res.data.portalid +
                  '/documents/downloaddocx?' +
                  '&name=' +
                  res.data.name
              );
              gaDomUtils.hideGlobalLoader();
            },
            function(error) {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(error.data, 'Erreur', {
                positionClass: 'toast-bottom-left',
              });
            }
          );
        };
      },
    };
  };
  recherchePointConsommation.$inject = [
    'OmegaFactory',
    'FeatureTypeFactory',
    'ngDialog',
    'gaDomUtils',
    '$filter'
  ];
  return recherchePointConsommation;
});
