'use strict';

define(function() {
  var DAUCtrl = function(
    $scope,
    AncAppFactory,
    BacAppFactory,
    ngDialog,
    FeatureTypeFactory,
    EditFactory,
    UsersFactory,
    $timeout,
    $rootScope
  ) {
    $scope.kis_bac_listes_deroulantes_controles = FeatureTypeFactory.getFeatureByUid(
      'kis_bac_listes_deroulantes_controles'
    );
    $scope.parcellesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
      BacAppFactory.appCfg.main.datastore,
      BacAppFactory.appCfg.main.parcellesCfg.emplacement
    );
    //Calcul destination des constructions et tableau des surfaces
    if (angular.isUndefined($scope.cdata.avis_tech)) {
      $scope.cdata.avis_tech = {};
      $scope.cdata.avis_tech.surfaces = [];
      $scope.cdata.avis_tech.total = {};
    }

    $scope.calculateAll = function() {
      $scope.cdata.avis_tech.total = {};
      $scope.cdata.avis_tech.total.a = 0;
      $scope.cdata.avis_tech.total.b = 0;
      $scope.cdata.avis_tech.total.c = 0;
      $scope.cdata.avis_tech.total.d = 0;
      $scope.cdata.avis_tech.total.e = 0;
      $scope.cdata.avis_tech.total.f = 0;

      $scope.cdata.avis_tech.surfaces.forEach(function(line, i) {
        var sum = 0;
        var minus = 0;
        if (angular.isDefined(line.a)) {
          sum += line.a;
          $scope.cdata.avis_tech.total.a += line.a;
        }

        if (angular.isDefined(line.b)) {
          sum += line.b;
          $scope.cdata.avis_tech.total.b += line.b;
        }
        if (angular.isDefined(line.c)) {
          sum += line.c;
          $scope.cdata.avis_tech.total.c += line.c;
        }
        if (angular.isDefined(line.d)) {
          minus += line.d;
          $scope.cdata.avis_tech.total.d += line.d;
        }
        if (angular.isDefined(line.e)) {
          minus += line.e;
          $scope.cdata.avis_tech.total.e += line.e;
        }

        $scope.cdata.avis_tech.surfaces[i].f = Math.round((sum - minus)*100)/100;
      });

      $scope.cdata.avis_tech.total.f =
        Math.round(($scope.cdata.avis_tech.total.a +
        $scope.cdata.avis_tech.total.b +
        $scope.cdata.avis_tech.total.c -
        $scope.cdata.avis_tech.total.d - 
        $scope.cdata.avis_tech.total.e)*100)/100
    };

    $scope.resetTab = function() {
      var ans = confirm(
        'Êtes-vous certain de vouloir réinitialiser le tableau de destinations des surface ?'
      );

      if (ans) {
        $scope.cdata.avis_tech.surfaces = [];
        $scope.cdata.avis_tech.total = {};
        $scope.addLines(3);
      }
    };

    $scope.addLines = function(number) {
      if (angular.isUndefined($scope.cdata.avis_tech)) {
        $scope.cdata.avis_tech = {};
        $scope.cdata.avis_tech.surfaces = [];
        $scope.cdata.avis_tech.total = {};
      }

      for (var i = 0; i < number; i++) {
        $scope.cdata.avis_tech.surfaces.push({});
      }
    };

    $scope.deleteLine = function(index) {
      var tmpArr = [];
      var tmpObj = {};

      $scope.cdata.avis_tech.surfaces.forEach(function(l, i) {
        if (index != i) {
          tmpArr.push($scope.cdata.avis_tech.surfaces[i]);
        }
      });

      $scope.cdata.avis_tech.surfaces = tmpArr;
    };

    if (
      angular.isUndefined($scope.cdata.avis_tech.surfaces) ||
      $scope.cdata.avis_tech.surfaces.length === 0
    ) {
      $scope.cdata.avis_tech.total = {};
      $scope.cdata.avis_tech.surfaces = [];
      $scope.addLines(3);
    } else {
      $scope.calculateAll();
    }

    $scope.genereEnvoiCourrier = function(type_courrier) {
      $scope.getDocxControle('dub_' + type_courrier + '.docx');
    };

    if (angular.isUndefined($scope.cdata.demande_autorisation_urbanisme))
      $scope.cdata.demande_autorisation_urbanisme = {};

    $scope.resetRadio = function() {
      if (angular.isUndefined($scope.cdata.info_generales.demande))
        $scope.cdata.info_generales.demande = {};

      if (angular.isDefined($scope.cdata.info_generales.demande.type))
        delete $scope.cdata.info_generales.demande.type;
    };

    $scope.resetCheckbox = function() {
      if (angular.isUndefined($scope.cdata.info_generales))
        $scope.cdata.info_generales = {};

      if (angular.isUndefined($scope.cdata.info_generales.demande))
        $scope.cdata.info_generales.demande = {};

      if (
        angular.isDefined($scope.cdata.info_generales.demande.permis_construire)
      )
        delete $scope.cdata.info_generales.demande.permis_construire;

      if (angular.isDefined($scope.cdata.info_generales.demande.permis_demolir))
        delete $scope.cdata.info_generales.demande.permis_demolir;

      if (angular.isDefined($scope.cdata.info_generales.demande.permis_lotir))
        delete $scope.cdata.info_generales.demande.permis_lotir;

      if (angular.isDefined($scope.cdata.info_generales.demande.modificatif))
        delete $scope.cdata.info_generales.demande.modificatif;

      if (angular.isDefined($scope.cdata.info_generales.demande.transfert))
        delete $scope.cdata.info_generales.demande.transfert;

      if (angular.isDefined($scope.cdata.info_generales.demande.autre))
        delete $scope.cdata.info_generales.demande.autre;
    };

    $scope.getType = function(type) {
      console.error('get type :-??', type);
      if (angular.isDefined($scope.cdata.info_generales)) {
        if (type === 'PC' || type === 'PD' || type === 'PL') {
          var pc = false;
          var pd = false;
          var pl = false;
          $scope.cdata.demande_autorisation_urbanisme = $scope.cdata.demande_autorisation_urbanisme || {};
          if (
            angular.isDefined(
              $scope.cdata.info_generales.demande.permis_construire
            )
          )
            pc = $scope.cdata.info_generales.demande.permis_construire;
          if (
            angular.isDefined(
              $scope.cdata.info_generales.demande.permis_demolir
            )
          )
            pd = $scope.cdata.info_generales.demande.permis_demolir;
          if (
            angular.isDefined($scope.cdata.info_generales.demande.permis_lotir)
          ) {
            pl = $scope.cdata.info_generales.demande.permis_lotir;
          }

          if (pd && !pc)
            $scope.cdata.demande_autorisation_urbanisme.type = 'PD';
          else if (!pd && !pc && pl)
            $scope.cdata.demande_autorisation_urbanisme.type = 'PL';
          else if (!pd && !pc && !pl)
            delete $scope.cdata.demande_autorisation_urbanisme.type;
          else $scope.cdata.demande_autorisation_urbanisme.type = 'PC';
        }

        if (angular.isUndefined($scope.cdata.demande_autorisation_urbanisme))
          $scope.cdata.demande_autorisation_urbanisme = {};

        if (angular.isDefined($scope.cdata.info_generales.demande.type))
          $scope.cdata.demande_autorisation_urbanisme.type = type;
      }
    };

    $scope.checkSurface = function() {
      if (
        $scope.cdata.avis_tech &&
        $scope.cdata.avis_tech.surface_declaree_proprietaire &&
        $scope.cdata.avis_tech.total.f
      )
        if (
          $scope.cdata.avis_tech.surface_declaree_proprietaire !=
            $scope.cdata.avis_tech.total.f &&
          $scope.cdata.avis_tech.surface_declaree_proprietaire != null
        )
          $scope.cdata.avis_tech.surface_declaree_proprietaire_differente = true;
        else
          $scope.cdata.avis_tech.surface_declaree_proprietaire_differente = false;
    };
  };

  DAUCtrl.$inject = [
    '$scope',
    'AncAppFactory',
    'BacAppFactory',
    'ngDialog',
    'FeatureTypeFactory',
    'EditFactory',
    'UsersFactory',
    '$timeout',
    '$rootScope',
  ];
  return DAUCtrl;
});
