'use strict';
define(function() {
  var multicritereConfig = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    HpoAppServices,
    ngProgressFactory,
    $location,
    InitProvider,
    $interval,
    HpoMulticritereServices
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/analye_multicritere/views/directives/multicritere_config.html',
      restrict: 'EA',
      scope: {
        initNewParam: '=',
        getService: '=',
        deleteService: '=',
        saveService: '=',
        multicritereTemplate: '=',
        configName: '=?',
        getReturnedTemplate: '=?',
        disableButtons: '=?',
        ftiComponent: '=?',
        ftis: '=?',
        types: '=?',
        keysToCheckOblig: '=?',
        keysToCheckNotoblig: '=?',
        currentParameter: '=?',
        oldParameter: '=?',
        addTitle: '=?',
        removeTitle: '=?',
        elementsNames: '=?',
        hasFti: '=?',
        parameters: '=?',
        previewExpression: '=?',
        initialseFilter: '=?',
        advancedExpression: '=?',
        advanced: '=?',
        availableCritereas: '=?',
        getAvailablePrevision: '=?',
        getCritereaInfo: '=?',
        getWeightChartData: '=?',
        extraFunctions: '=?',
        hideprev: '=?',
        specialFunctionBeforeSave: '=?',
        apptype: '=?',
      },
      link: function(scope) {
        scope.isInit = false;
        scope.saveTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.templates.html';
        scope.getTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.gettemplates.html';
        scope.propertiestoexclude = {};
        var DATE_FORMAT = 'dd.MM.yy';
        scope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;
        scope.filtering = {
          filterValue: '',
        };

        scope.attributes = [];
        scope.validName = function(name) {
          if (name && scope.attributes && scope.attributes.length > 0) {
            for (var i = 0; i < scope.attributes.length; i++) {
              var x = scope.attributes[i];
              if (~name.indexOf(x)) {
                return false;
              }
            }
          }
          return /^[A-Za-z0-9-_\ éèêûùà]+$/.test(name);
        };

        scope.tree_handler = function(branch) {
          if (
            branch &&
            (branch.hasOwnProperty('type') || branch.special === 'categorie')
          ) {
            if (branch.hasOwnProperty('ftiuid') && branch.ftiuid) {
              var idx = scope.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(branch.ftiuid);
              if (~idx) {
                branch.fti = scope.ftis[idx];
                scope.attributes = branch.fti.attributes.map(function(x) {
                  return x.name;
                });
              } else {
                branch.fti = undefined;
                branch.ftiuid = undefined;
              }
            } else if (branch.hasOwnProperty('fti') && branch.fti) {
              var idx = scope.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(branch.fti.uid);
              if (~idx) {
                branch.fti = scope.ftis[idx];
                scope.attributes = branch.fti.attributes.map(function(x) {
                  return x.name;
                });
              } else {
                branch.fti = undefined;
                branch.ftiuid = undefined;
              }
            }

            scope.currentParameter = branch;
            scope.oldParameter = angular.copy(scope.currentParameter);
            if (scope.currentParameter.categorie) {
              scope.tapecategorie = false;
              scope.changedCategorieSelectionMode(scope.tapecategorie);
            } else {
              scope.tapecategorie = true;
            }
          } else {
            scope.attributes = [];
            initVariables();
          }
        };

        var getAvailableCategories = function() {
          var categories = [];
          scope.parameters_data.map(function(x) {
            if (!x.isNew && x.label && !~categories.indexOf(x.label))
              categories.push(x.label);
          });
          scope.ftis.map(function(x) {
            if (x && x.alias && !~categories.indexOf(x.alias)) {
              categories.push(x.alias);
            }
          });
          return categories;
        };

        var getRealAvailableCategories = function() {
          var categories = [];
          scope.parameters_data.map(function(x) {
            if (!x.isNew && x.label && !~categories.indexOf(x.label))
              categories.push(x.label);
            else {
              categories.push('$$$$$$$');
            }
          });
          scope.ftis.map(function(x) {
            if (x && x.alias && !~categories.indexOf(x.alias)) {
              categories.push(x.alias);
            }
          });
          return categories;
        };

        scope.changedCategorieSelectionMode = function(tapecategorie) {
          if (!tapecategorie) {
            scope.categories = getAvailableCategories();
          }
        };

        function sortLayersByIndex(layer1, layer2) {
          var index1 = (layer1 && layer1.label) || layer1;
          var index2 = (layer2 && layer2.label) || layer2;
          if (index1 == null) return -1;
          else if (index2 == null) return 1;
          else if (index1 < index2) return -1;
          return 1;
        }

        scope.parameters_control = [];
        scope.parameters_data = [];
        gaDomUtils.showGlobalLoader();
        scope.getService(scope.ftiComponent.uid).then(
          function(res) {
            scope.isInit = true;
            gaDomUtils.hideGlobalLoader();
            if (scope.parameters_control.reset_rows)
              scope.parameters_control.reset_rows();
            if (res && res.data) {
              if (scope.hasFti)
                var uidscomponents = scope.ftis.map(function(x) {
                  return x.uid;
                });
              res.data.map(function(x, i) {
                if (x) {
                  x.isNew = true;
                  if (x.name && !x.label)
                    x.label =
                      x.name +
                      ' - ' +
                      HpoCarteAppFactory.getAppFactory().formatDateShow(
                        x.date,
                        DATE_FORMAT
                      );
                  if (scope.hasFti && x.ftiuid && angular.isUndefined(x.fti)) {
                    var idx = uidscomponents.indexOf(x.ftiuid);
                    if (~idx) x.fti = scope.ftis[idx];
                  }
                  addParameterToData(x);
                }
              });
              setTimeout(function() {
                if (
                  scope.parameters_control &&
                  scope.parameters_control.collapse_all
                )
                  scope.parameters_control.collapse_all();
                if (scope.parameters_data.length > 0) {
                  scope.parameters_data = scope.parameters_data.sort(
                    sortLayersByIndex
                  );
                  for (var i = 0; i < scope.parameters_data.length; i++) {
                    if (
                      scope.parameters_data[i] &&
                      scope.parameters_data[i].children &&
                      scope.parameters_data[i].children.length > 0
                    ) {
                      scope.parameters_data[i].children = scope.parameters_data[
                        i
                      ].children.sort(sortLayersByIndex);
                    }
                  }
                  scope.selectBranch(scope.parameters_data[0]);
                }
                try {
                  scope.$apply();
                } catch(err) {}
              }, 200);
            }
          },
          function(res) {
            scope.isInit = true;
            gaDomUtils.hideGlobalLoader();
            AlertHpoFactory.showErrorMessage(res);
          }
        );

        scope.emptyParameter = function() {
          var callback = function(isconfirm) {
            if (isconfirm) {
              scope.currentParameter = angular.copy(scope.oldParameter);
              if (
                scope.currentParameter &&
                scope.currentParameter.fti &&
                scope.ftis &&
                scope.ftis.length > 0
              ) {
                var idx = scope.ftis
                  .map(function(x) {
                    return x.uid;
                  })
                  .indexOf(scope.currentParameter.fti.uid);
                if (~idx) scope.currentParameter.fti = scope.ftis[idx];
              }
              AlertHpoFactory.getSimpleSuccess(
                $filter('translate')('hpo.data.exchange.succes'),
                $filter('translate')('hpo.multicritere.parameters.empty'),
                false
              );
              try {
                scope.$apply();
              } catch(err) {}
            }
          };
          var message =
            $filter('translate')('hpo.multicritere.parameters.empty') +
            '. ' +
            $filter('translate')('hpo.common.sur');
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            message,
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };

        var keys_to_check = scope.keysToCheckOblig.concat(
          scope.keysToCheckNotoblig
        );
        scope.changedParameter = function(str) {
          if (
            angular.isUndefined(scope.currentParameter) ||
            angular.isUndefined(scope.oldParameter)
          )
            return false;
          if (scope.nameExistsInData(scope.currentParameter)) return false;
          if (str == 'save') {
            for (var i = 0; i < scope.keysToCheckOblig.length; i++) {
              if (
                scope.currentParameter.hasOwnProperty(
                  scope.keysToCheckOblig[i]
                ) &&
                !scope.currentParameter[scope.keysToCheckOblig[i]]
              ) {
                return false;
              }
            }
          }
          var changed = false;
          if (
            scope.currentParameter &&
            scope.oldParameter &&
            scope.currentParameter.uid == scope.oldParameter.uid
          ) {
            for (var i = 0; i < keys_to_check.length; i++) {
              if (
                scope.currentParameter.hasOwnProperty(keys_to_check[i]) &&
                scope.oldParameter.hasOwnProperty(keys_to_check[i]) &&
                scope.currentParameter[keys_to_check[i]] &&
                scope.currentParameter[keys_to_check[i]] !==
                  scope.oldParameter[keys_to_check[i]]
              ) {
                changed = true;
                break;
              }
            }
          }
          return changed;
        };

        scope.nameExistsInData = function(element) {
          if (element) {
            var names = [];
            if (scope.parameters_data && scope.parameters_data.length > 0) {
              scope.parameters_data.map(function(x) {
                if (x && !x.isNew && x.children && x.children.length > 0) {
                  x.children.map(function(y) {
                    if (y && y.name && y.uid !== element.uid)
                      names.push(y.name);
                  });
                }
              });
            }
            if (~names.indexOf(element.name)) return true;
            else {
              return false;
            }
          } else {
            return false;
          }
        };

        scope.addParameter = function() {
          if (scope.parameters_control && scope.parameters_control.collapse_all)
            scope.parameters_control.collapse_all();
          scope.isNew = true;
          scope.currentParameter = scope.initNewParam();
          scope.parameters_data.splice(0, 0, scope.currentParameter);
          if (
            scope.parameters_control.expand_all &&
            scope.parameters_control.select_first_branch
          ) {
            scope.parameters_control.select_first_branch();
          } else {
            var stop = $interval(function() {
              if (
                scope.parameters_control.expand_all &&
                scope.parameters_control.select_first_branch
              ) {
                scope.parameters_control.select_first_branch();
                $interval.cancel(stop);
              }
            }, 300);
          }
        };

        scope.removeParameter = function() {
          var callback = function(isconfirm) {
            if (isconfirm) {
              if (
                scope.currentParameter &&
                scope.currentParameter.special !== 'categorie'
              ) {
                if (scope.currentParameter.isNew) {
                  scope.parameters_data.splice(0, 1);
                } else {
                  var categorieidx = -1;
                  var elementidx = -1;
                  var canremovecategorie = false;
                  for (var i = 0; i < scope.parameters_data.length; i++) {
                    var categorie = scope.parameters_data[i];
                    if (!categorie.isNew) {
                      for (var j = 0; j < categorie.children.length; j++) {
                        var child = categorie.children[j];
                        if (child && child.uid === scope.currentParameter.uid) {
                          categorieidx = i;
                          elementidx = j;
                          if (categorie.children.length === 1)
                            canremovecategorie = true;

                          break;
                        }
                      }
                      if (categorieidx !== -1 && elementidx !== -1) break;
                    }
                  }
                  if (categorieidx !== -1 && elementidx !== -1) {
                    gaDomUtils.showGlobalLoader();
                    scope
                      .deleteService(
                        scope.ftiComponent.uid,
                        scope.parameters_data[categorieidx].children[elementidx]
                          .id
                      )
                      .then(
                        function(res) {
                          gaDomUtils.hideGlobalLoader();
                          if (res && res.data && JSON.parse(res.data)) {
                            scope.parameters_data[categorieidx].children.splice(
                              elementidx,
                              1
                            );
                            if (canremovecategorie) {
                              setTimeout(function() {
                                var callback = function(isconfirm) {
                                  if (isconfirm) {
                                    scope.parameters_data.splice(
                                      categorieidx,
                                      1
                                    );
                                    try {
                                      scope.$apply();
                                    } catch(err) {}
                                  }
                                };
                                AlertHpoFactory.alertConfirmCallback(
                                  $filter('translate')('hpo.common.warning'),
                                  scope.parameters_data[categorieidx].label +
                                    ' ' +
                                    $filter('translate')(
                                      'hpo.multicritere.parameters.dialog.categorieempty'
                                    ),
                                  'warning',
                                  true,
                                  undefined,
                                  '#F50072',
                                  true,
                                  undefined,
                                  undefined,
                                  true,
                                  true,
                                  callback
                                );
                              }, 300);
                            } else {
                              AlertHpoFactory.successDelete();
                            }
                          } else {
                            AlertHpoFactory.failDelete();
                          }
                        },
                        function(res) {
                          gaDomUtils.hideGlobalLoader();
                          AlertHpoFactory.showErrorMessage(res);
                        }
                      );
                  }
                }
              } else if (
                scope.currentParameter &&
                scope.currentParameter.special === 'categorie'
              ) {
                var idx = scope.parameters_data
                  .map(function(x) {
                    if (x.special === 'categorie') {
                      return x.label;
                    }
                  })
                  .indexOf(scope.currentParameter.label);
                if (~idx) {
                  var ids = scope.parameters_data[idx].children
                    .map(function(x) {
                      return x.id;
                    })
                    .filter(function(x) {
                      if (x) return x;
                    });
                  gaDomUtils.showGlobalLoader();
                  scope
                    .deleteService(scope.ftiComponent.uid, ids.join(','))
                    .then(
                      function(res) {
                        gaDomUtils.hideGlobalLoader();
                        if (res && res.data && JSON.parse(res.data)) {
                          scope.parameters_data.splice(idx, 1);
                          AlertHpoFactory.successDelete();
                        } else {
                          AlertHpoFactory.failDelete();
                        }
                      },
                      function(res) {
                        gaDomUtils.hideGlobalLoader();
                        AlertHpoFactory.showErrorMessage(res);
                      }
                    );
                }
              }
              initVariables();
              try {
                scope.$apply();
              } catch(err) {}
            }
          };
          var message =
            scope.currentParameter.special === 'categorie'
              ? $filter('translate')(
                  'hpo.multicritere.parameters.removecategorie'
                )
              : $filter('translate')('hpo.multicritere.parameters.remove') +
                '. ' +
                $filter('translate')('hpo.common.sur');
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            message,
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };

        scope.calcParameters = function(el) {
          var elements = [];
          if (scope.parameters_data) {
            switch (el) {
              case 'categorie':
                scope.parameters_data.map(function(x) {
                  if (x && !x.isNew) elements.push(x.label);
                });
                break;
              case 'params':
                scope.parameters_data.map(function(x) {
                  if (x && !x.isNew && x.children && x.children.length > 0) {
                    elements = elements.concat(x.children);
                  }
                });
                break;
            }
          }
          return elements.length;
        };

        var initVariables = function() {
          scope.currentParameter = undefined;
          scope.oldParameter = undefined;
        };

        scope.cleanBranch = function(branch) {
          var keys = Object.keys(branch);
          for (var i = 0; i < keys.length; i++) {
            if (!~keys_to_check.indexOf(keys[i])) delete branch[keys[i]];
          }
          return branch;
        };

        scope.selectBranch = function(obj) {
          if (scope.parameters_control.reset_rows)
            scope.parameters_control.reset_rows();
          var idx = scope.parameters_data
            .map(function(x) {
              return x.label;
            })
            .indexOf(obj.categorie);
          if (~idx) {
            if (scope.parameters_control.expand_branch) {
              scope.parameters_control.expand_branch(
                scope.parameters_data[idx]
              );
              scope.parameters_control.select_branch(
                scope.parameters_data[idx]
              );
            }
            var categorie = scope.parameters_data[idx];
            var idxb = categorie.children
              .map(function(x) {
                return x.uid;
              })
              .indexOf(obj.uid);
            if (~idxb) {
              if (scope.parameters_control.expand_branch) {
                scope.parameters_control.expand_branch(
                  categorie.children[idxb]
                );
                scope.parameters_control.select_branch(
                  categorie.children[idxb]
                );
              }
            }
          } else {
            idx = scope.parameters_data
              .map(function(x) {
                return x.label;
              })
              .indexOf(obj.label);
            if (~idx) {
              if (scope.parameters_control.expand_branch) {
                scope.parameters_control.expand_branch(
                  scope.parameters_data[idx]
                );
                scope.parameters_control.select_branch(
                  scope.parameters_data[idx]
                );
              }
              var categorie = scope.parameters_data[idx];
              var idxb = categorie.children
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(obj.uid);
              if (~idxb) {
                if (scope.parameters_control.expand_branch) {
                  scope.parameters_control.expand_branch(
                    categorie.children[idxb]
                  );
                  scope.parameters_control.select_branch(
                    categorie.children[idxb]
                  );
                }
              }
            }
          }
        };

        var getCategorieIndexAndBranch = function(obj) {
          var removecateg = false;
          var idxcateg = -1;
          var categories = getRealAvailableCategories();
          if (scope.parameters_data.length > 0) {
            for (var i = 0; i < scope.parameters_data.length; i++) {
              var categ = scope.parameters_data[i];
              if (categ.children && categ.children.length > 0) {
                var idx = categ.children
                  .map(function(x) {
                    return x.uid;
                  })
                  .indexOf(obj.uid);
                if (~idx) {
                  if (categ.label === obj.categorie) {
                    categ.children[idx] = obj;
                    break;
                  } else {
                    categ.children.splice(idx, 1);
                    if (categ.children.length === 0) {
                      removecateg = true;
                      idxcateg = i;
                    }
                    var categorie = obj.categorie;
                    var idxc = categories.indexOf(categorie);
                    if (~idxc) {
                      checkOrAddCatgeorie(idxc, obj);
                    } else {
                      var createCategorie = {
                        label: categorie,
                        special: 'categorie',
                        children: [obj],
                      };
                      scope.parameters_data.push(createCategorie);
                    }
                  }
                }
              }
            }
          }
          if (removecateg && idxcateg !== -1) {
            setTimeout(function() {
              var callback = function(isconfirm) {
                if (isconfirm) {
                  scope.parameters_data.splice(idxcateg, 1);
                  try {
                    scope.$apply();
                  } catch(err) {}
                }
              };
              AlertHpoFactory.alertConfirmCallback(
                $filter('translate')('hpo.common.warning'),
                scope.parameters_data[idxcateg].label +
                  ' ' +
                  $filter('translate')(
                    'hpo.multicritere.parameters.dialog.categorieempty'
                  ),
                'warning',
                true,
                undefined,
                '#F50072',
                true,
                undefined,
                undefined,
                true,
                true,
                callback
              );
            }, 300);
          }
          return removecateg && idxcateg !== -1;
        };

        var checkOrAddCatgeorie = function(idx, obj) {
          if (scope.parameters_data.length < idx + 1) {
            var createCategorie = {
              label: obj.categorie,
              special: 'categorie',
              children: [obj],
            };
            scope.parameters_data.push(createCategorie);
          } else {
            scope.parameters_data[idx].children.push(obj);
          }
        };

        var addParameterToData = function(objtoadd) {
          var categorie = objtoadd.categorie;
          var categories = getRealAvailableCategories();
          var idx = categories.indexOf(categorie);
          var elements = false;
          if (~idx) {
            if (objtoadd.isNew) {
              delete objtoadd.isNew;
              checkOrAddCatgeorie(idx, objtoadd);
              if (
                scope.parameters_data &&
                scope.parameters_data.length > 0 &&
                scope.parameters_data[0].hasOwnProperty('type')
              )
                scope.parameters_data.splice(0, 1);
            } else {
              elements = getCategorieIndexAndBranch(objtoadd);
            }
          } else {
            if (objtoadd.isNew) {
              delete objtoadd.isNew;
              if (
                scope.parameters_data &&
                scope.parameters_data.length > 0 &&
                scope.parameters_data[0].hasOwnProperty('type')
              )
                scope.parameters_data.splice(0, 1);
              var createCategorie = {
                label: categorie,
                special: 'categorie',
                children: [objtoadd],
              };
              scope.parameters_data.push(createCategorie);
            } else {
              elements = getCategorieIndexAndBranch(objtoadd);
            }
          }
          return elements;
        };

        scope.saveParameter = function() {
          if (scope.parameters_control && scope.parameters_control.collapse_all)
            scope.parameters_control.collapse_all();
          var objtoadd = angular.copy(scope.currentParameter);
          objtoadd.label =
            objtoadd.name +
            ' - ' +
            HpoCarteAppFactory.getAppFactory().formatDateShow(
              objtoadd.date,
              DATE_FORMAT
            );
          var sendata = angular.copy(objtoadd);
          scope.cleanBranch(sendata);
          if (scope.hasFti && sendata.fti) {
            sendata.ftiuid = sendata.fti.uid;
            delete sendata.fti;
          }
          if (scope.specialFunctionBeforeSave) {
            scope.specialFunctionBeforeSave(sendata);
          }
          gaDomUtils.showGlobalLoader();
          scope.saveService(sendata, scope.ftiComponent.uid).then(
            function(res) {
              try {
                if (res && res.data) {
                  scope.cleanBranch(objtoadd);
                  initVariables();
                  if (objtoadd.isNew) res.data.isNew = true;
                  Object.assign(objtoadd, res.data);
                  if (!addParameterToData(objtoadd))
                    AlertHpoFactory.successSave();
                  setTimeout(function() {
                    if (scope.parameters_control.reset_rows)
                      scope.parameters_control.reset_rows();
                    scope.selectBranch(objtoadd);
                  }, 200);
                } else {
                  AlertHpoFactory.failSave();
                }
              } catch (e) {
                AlertHpoFactory.showErrorMessage(e);
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        scope.minheight =
          angular.element('.xgos_content').height() -
          angular.element('#xgos_nav').height() -
          25 +
          'px';
      },
    };
  };

  multicritereConfig.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'HpoAppServices',
    'ngProgressFactory',
    '$location',
    'InitProvider',
    '$interval',
    'HpoMulticritereServices',
  ];
  return multicritereConfig;
});
