'use strict';
define(function() {
  var MappingHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $filter,
    $rootScope,
    InitProvider,
    $timeout
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/mapping_hpo.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        scope.destinationsftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'all'
        );

        var initFunction = function() {
          if (
            scope.hpo &&
            scope.hpo.importedFeatures &&
            scope.hpo.importedFeatures.length > 0
          )
            scope.hpo.importcfg = {
              liaisons: {},
              values: {},
              dateformatValues: {},
              maj: {},
              sources: scope.hpo.importedFeatures[0].attributes.map(function(
                x
              ) {
                return x.name;
              }),
              layer: scope.hpo.importedFeatures[0],
              sourceslayers: scope.hpo.importedFeatures,
              dateattributes: [],
              layerattributes: scope.hpo.importedFeatures[0].attributes,
            };
          $rootScope.$broadcast('changedsourceLayers');
        };
        initFunction();

        scope.$watch('hpo.importedFeatures', function(newval) {
          if (newval) initFunction();
        });

        var initApplicationInformations = function() {
          HpoCarteAppFactory.getInitProvider()
            .initialiseApplication()
            .then(
              function() {
                console.log('Init done with success');
              },
              function() {
                console.error('unable to reinitialise application parameter');
              }
            );
        };

        scope.save = function(res) {
          $rootScope.$broadcast('showwait');
          if (res.filetype === 'csv') {
            ImportExportFactory.loaddataCsv(
              res.processid,
              res.ftisourcename,
              res.ftuiddestination,
              res.liaison,
              res.defaultvalues,
              res.maj && res.maj.maj_component ? res.maj.maj_component : false,
              res.maj && res.maj.maj_component && res.maj.attribut
                ? res.maj.attribut
                : undefined,
              res.maj &&
                res.maj.maj_component &&
                res.maj.value &&
                res.maj.value.name
                ? res.maj.value.name
                : undefined,
              res.defaultDateFormat
            ).then(
              function(result) {
                if (
                  angular.isDefined(result.data) &&
                  parseInt(result.data) > 0
                ) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.data.exchange.succes'),
                    result.data +
                      $filter('translate')(
                        res.maj && res.maj.maj_component
                          ? 'hpo.data.exchange.update'
                          : 'hpo.data.exchange.add'
                      ),
                    true
                  );
                  $rootScope.$broadcast('removedelement', res.ftisourcename);
                  $rootScope.$broadcast('reloadDatatable');
                  scope.updateConfigure(res, result);
                  initApplicationInformations();
                } else {
                  AlertHpoFactory.getSimpleFail(
                    $filter('translate')('hpo.data.exchange.fail'),
                    result.data +
                      $filter('translate')(
                        res.maj && res.maj.maj_component
                          ? 'hpo.data.exchange.update'
                          : 'hpo.data.exchange.add'
                      ),
                    true
                  );
                }
                $rootScope.$broadcast('hidewait');
              },
              function(result) {
                if (angular.isDefined(result.data))
                  AlertHpoFactory.getSimpleFail(
                    $filter('translate')('hpo.data.exchange.fail'),
                    result.data,
                    true
                  );
                $rootScope.$broadcast('hidewait');
              }
            );
          } else {
            ImportExportFactory.loaddata(
              res.processid,
              res.filetype === 'db' ? res.ftiuidsource : res.ftisourcename,
              res.ftuiddestination,
              res.liaison,
              res.srsid,
              res.filetype === 'db' ? '1=1' : '',
              false,
              res.maj && res.maj.maj_component ? res.maj.maj_component : false,
              false,
              res.maj && res.maj.maj_component && res.maj.attribut
                ? res.maj.attribut
                : undefined,
              res.maj &&
                res.maj.maj_component &&
                res.maj.value &&
                res.maj.value.name
                ? res.maj.value.name
                : undefined,
              '',
              '',
              '',
              res.defaultvalues,
              res.copydata,
              res.defaultDateFormat
            ).then(
              function(result) {
                if (
                  angular.isDefined(result.data) &&
                  parseInt(result.data) > 0
                ) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.data.exchange.succes'),
                    result.data +
                      $filter('translate')(
                        res.maj && res.maj.maj_component
                          ? 'hpo.data.exchange.update'
                          : 'hpo.data.exchange.add'
                      ),
                    true
                  );
                  $rootScope.$broadcast('removedelement', res.ftisourcename);
                  $rootScope.$broadcast('reloadDatatable');
                  scope.updateConfigure(res, result);
                  initApplicationInformations();
                } else {
                  AlertHpoFactory.getSimpleFail(
                    $filter('translate')('hpo.data.exchange.fail'),
                    result.data +
                      $filter('translate')(
                        res.maj && res.maj.maj_component
                          ? 'hpo.data.exchange.update'
                          : 'hpo.data.exchange.add'
                      ),
                    true
                  );
                }
                $rootScope.$broadcast('hidewait');
              },
              function(res) {
                if (angular.isDefined(result.data))
                  AlertHpoFactory.getSimpleFail(
                    $filter('translate')('hpo.data.exchange.fail'),
                    result.data,
                    true
                  );
                $rootScope.$broadcast('hidewait');
              }
            );
          }
        };
      },
    };
  };

  MappingHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$filter',
    '$rootScope',
    'InitProvider',
    '$timeout',
  ];
  return MappingHpo;
});
