'use strict';
define(function() {
  var CssManipulate = function($window) {
    return {
      restrict: 'A',
      link: function(scope, elt, attrs, ctrl) {
        var f = function() {
          try {
            if (attrs.cssManipulate) {
              var x = JSON.parse(attrs.cssManipulate);
              if (x.mh) elt.css('max-height', x.mh);
              if (x.h) elt.css('height', x.h);

              if (x.mw) elt.css('max-width', x.mw);
              if (x.w) {
                if (x.w === 'full') {
                  var w = $window.innerWidth - 10 + 'px';
                  elt.css('width', w);
                } else {
                  elt.css('width', x.w);
                }
              }
              if (x.ovy) elt.css('overflow-y', x.ovy);
              if (x.mih) elt.css('min-height', x.mih);
            }
          } catch (e) {
            console.error(e.stack);
          }
        };

        attrs.$observe('cssManipulate', function(nv) {
          if (nv) f();
        });
      },
    };
  };

  CssManipulate.$inject = ['$window'];
  return CssManipulate;
});
