'use strict';
define(function() {
  var navGroup = function($location) {
    return {
      restrict: 'EA',
      scope: {
        checkpath: '=',
        infos: '=groupinfos',
        editsub: '=?',
        onlyonecollapsed: '=?',
        setbranch: '=?',
      },
      link: function($scope, element, attrs) {
        var groupLi = angular.element(element[0].querySelector('.group'));

        groupLi.on('click', function() {
          groupLi.removeClass('active');
          if (!$scope.infos.isCollapsed) {
            groupLi.addClass('active');
          }
        });

        var search = $location.url().split('?');
        $scope.urlParameters = '';
        if (search.length > 1) {
          $scope.urlParameters = '?' + search[1];
        }

        $scope.main_title = $scope.infos.main_title;
        $scope.icon = $scope.infos.icon;
        $scope.subs = $scope.infos.subs;

        /**
         * get sub link, nothing if disabled
         * @param sub
         * @returns {string}
         */
        $scope.getSubLink = function(sub) {
          return sub.disabled
            ? ''
            : '#' + sub.target + '' + $scope.urlParameters;
        };

        $scope.collapseOnlyOne = function() {
          $scope.infos.isCollapsed = !$scope.infos.isCollapsed;
          if (!$scope.infos.isCollapsed && $scope.onlyonecollapsed) {
            $scope.onlyonecollapsed($scope.infos.main_title);
          }
        };

        $scope.setPriBranch = function(branch, m) {
          $scope.infos.activeSub = !$scope.infos.isCollapsed;
          $scope.setbranch(branch, m);
        };
      },
      templateUrl:
        'js/XG/widgets/hpoapp/main/views/directives/navGroupSeppri.html',
    };
  };

  navGroup.$inject = ['$location'];
  return navGroup;
});
