'use strict';
define(function() {
  const refreshRerau = function (
    itvSoumFactory,
    $timeout,
    processFactory,
    $filter
  ) {
    return {
      templateUrl:
        'js/XG/widgets/indigauapp/home_admin_data/views/directives/refreshRerau.html',
      restrict: 'EA',
      scope: {},
      link: function(scope) {
        let arcgisConf;
        let indigauEngine = false;
        itvSoumFactory.getConf('indigauItvCfg').then(conf => {
          indigauEngine= conf.config.useIndigauEngine;
          arcgisConf = itvSoumFactory.arcgisConfToUrl(conf);
        });


        /**
         * Formate les messages d'avertissement d'une chaîne séparée par des sauts de ligne
         * en alertes HTML. Traduit les messages d'avertissement en utilisant le filtre
         * fourni et conserve le message original si aucune traduction n'est trouvée.
         *
         * @param {string} warningsStr - Chaîne de messages d'avertissement séparés par des sauts de ligne
         * @returns {string} Chaîne HTML contenant les messages d'avertissement formatés dans une div défilante
         */
        const warningMessages = (warningsStr) => {
          const warnings = warningsStr.split('\n');
          let message = '<div style="max-height: 300px; overflow-y: auto;text-align: left;">';
          for (const warning of warnings) {
            if (warning!=='') {
              let warningMessage = $filter('translate')('indigau.itv.refreshrerau.' + warning);
              if (warningMessage.startsWith('indigau.itv.refreshrerau.')) {
                warningMessage = warning;
              }
              message += '<div class="alert alert-warning">';
              message += warningMessage + '<br>';
              message += '</div>';
            }
          }
          message += '</div>';
          return message;
        };


        function checkRefreshProgression() {
          processFactory
            .getProcessByUid(scope.refreshProcesUid)
            .then(function(res) {
              if (res.data) {
                scope.refreshState = res.data.etat;
                switch (res.data.etat) {
                  case 'RUNNING':
                    scope.pbPercent = res.data.progress + '%';
                    scope.pipeCount = res.data.count;
                    $timeout(checkRefreshProgression, 1500);
                    break;
                  case 'FAILED':
                    swal({
                      title: $filter('translate')(
                        'indigau.itv.refreshrerau.failed'
                      ),
                      text: res.data.errorMessage,
                      type: 'error',
                    });
                    break;
                  case 'INTERRUPTED':
                    swal({
                      title: $filter('translate')(
                        'indigau.itv.refreshrerau.interrupted'
                      ),
                      text: '',
                      type: 'success',
                    });
                    break;
                  case 'FINISHED':
                    scope.pbPercent = '100%';
                    scope.pipeCount = res.data.count;
                    $timeout (() => {
                      swal({
                        title: $filter('translate')(
                          'indigau.itv.refreshrerau.finished'
                        ),
                        html: true,
                        text: warningMessages(res.data.warningMessage),
                        type: 'success'
                      });
                    });
                    break;
                }
              }
            });
        }

        function init() {
          scope.pbPercent = '0%';
          processFactory
            .getProcessByType('refresh indigau scores')
            .then(function(res) {
              if (res.data) {
                for (let ind = 0; ind < res.data.length; ind++) {
                  if (
                    res.data[ind].type == 'refresh indigau scores' &&
                    res.data[ind].etat == 'RUNNING'
                  ) {
                    //-- Un rafraichissement est en cours,
                    //-- il ne faut pas en lancer 2 en même temps.
                    scope.refreshState = 'RUNNING';
                    scope.refreshProcesUid = res.data[ind].uid;
                    checkRefreshProgression();
                    break;
                  }
                }
              }
            });
        }


        /**
         * Formate les messages d'erreur d'un objet de réponse en une chaîne HTML structurée.
         * Combine les informations de composant, fonction et message d'erreur dans un format lisible.
         * Les messages sont traduits lorsqu'une clé de traduction est disponible.
         *
         * @param {Object} data - Objet contenant la liste des erreurs
         * @param {Array<Object>} data.errorList - Tableau d'objets d'erreur
         * @param {string} [data.errorList[].composant] - Nom du composant concerné par l'erreur
         * @param {string} [data.errorList[].fonction] - Fonction concernée par l'erreur
         * @param {string} [data.errorList[].message_kis] - Clé de traduction du message d'erreur
         * @param {string} [data.errorList[].exception] - Message d'exception brut
         * @returns {string} Chaîne HTML formatée contenant les messages d'erreur dans une div défilante
         */
        const getErrorMessage = (data) => {
          let message = '<div style="max-height: 300px; overflow-y: auto;text-align: left;">';
          for (const error of data.errorList) {
            if (error.composant) {
              message += error.composant + '.';
            }
            if (error.fonction) {
              message += error.fonction;
            }
            if (message) {
              message += ': <br>';
            }
            if (error.message_kis) {
              message += $filter('translate')(error.message_kis) + '<br>';
            }
            if (error.exception) {
              message += error.exception + '<br>';
            }
          }
          message += '</div>';
          return message;
        };

        scope.refreshRerau = function() {
          itvSoumFactory.refreshRerau('', indigauEngine, arcgisConf)
            .then((res) => {
              if (res.data.etat == 'fini') {
                scope.refreshState = 'RUNNING';
                scope.refreshProcesUid = res.data.objValeur.uid;
                checkRefreshProgression();
              }
              else if (res.data.etat == 'erreur') {
                swal({
                  title: $filter('translate')(
                    'indigau.itv.refreshrerau.failed'
                  ),
                  text: getErrorMessage(res.data),
                  html: true,
                  type: 'error',
                });
              }
            });
        };

        scope.interruptRefresh = function() {
          itvSoumFactory.interruptRefresh(scope.refreshProcesUid);
        };

        init();
      },
    };
  };

  refreshRerau.$inject = [ 'itvSoumFactory', '$timeout', 'processFactory',
    '$filter',
  ];
  return refreshRerau;
});
