/**
 *
 */
'use strict';
define(function() {
  /**
   * OverviewController
   * @param $scope
   * @param ReportIndicatorFactory
   * @constructor
   */
  var OverviewController = function($scope, ReportIndicatorFactory) {
    $scope.pageIndex = 0;

    /**
     * Request the pageIndex page of report in jpeg format
     * Set the download jpeg page link to the popup <img> element
     * @returns {undefined}
     */
    $scope.getJpeg = function() {
      ReportIndicatorFactory.getJpeg(
        $scope.indicator.fileNameGenerated,
        $scope.pageIndex
      ).then(
        function(res) {
          var resultObject = res.data;
          $scope.reportimageSrc = resultObject;
          //                    var blob = new Blob([resultObject], {type: "image/jpeg"});
          //                    var objectUrl = URL.createObjectURL(blob);
          //                    window.open(objectUrl);
          //                    //Libération de la mémoire de l'objet URL
          //                    window.URL.revokeObjectURL();
        },
        function(reason) {
          var resultObject = reason;
          require('toastr').error(resultObject);
        }
      );
    };

    $scope.$on('ngDialog.opened', $scope.getJpeg());

    $scope.getNextPage = function() {
      if ($scope.pageIndex + 1 < $scope.totalPageNumber) {
        $scope.pageIndex++;
      }
      $scope.getJpeg();
    };
    $scope.getPreviousPage = function() {
      if ($scope.pageIndex > 0) {
        $scope.pageIndex--;
      }
      $scope.getJpeg();
    };
    $scope.getFirstPage = function() {
      $scope.pageIndex = 0;
      $scope.getJpeg();
    };
    $scope.getLastPage = function() {
      if ($scope.totalPageNumber > 0) {
        $scope.pageIndex = $scope.totalPageNumber - 1;
      } else {
        $scope.pageIndex = 0;
      }
      $scope.getJpeg();
    };
  };

  OverviewController.$inject = ['$scope', 'ReportIndicatorFactory'];
  return OverviewController;
});
