'use strict';
define(function() {

  var esriprint = function ($rootScope, ngDialog, ConfigFactory, gclayers,
      gaDomUtils, BaseMapFactory, $timeout,
      $filter, PrintFactory, mapJsUtils) {

    const WEB_MAP_AS_JSON_TEMPLATE = {
      'exportOptions' : {
        'dpi' : 96
      },
      'baseMap' : {
        'baseMapLayers' : []
      },
      'operationalLayers' : [],
      'layoutOptions' : {
        'legendOptions' : {
          'operationalLayers' : []
        },
        'authorText' : ' ',
        'customTextElements' : [],
        'copyrightText' : '2018',
        'titleText' : ' '
      }
    };

    return {

      templateUrl : 'js/XG/widgets/mapapp/esriprint/views/esriprint.html',
      restrict : 'AE',

      link : function(scope) {

        // Config file namefor esriprint (same for the widget and the DICT component)
        scope.ConfigName = 'configPrintEsri';

        scope.printDpis = [ '96', '120', '300' ];

        scope.tabs = {
          activeTab: 0,
          list: [
            { 'title': 'Cartographie' },
            { 'title': 'Textes' },
          ]
        };

        scope.configTabs = {
          activeTab: 0,
          list: [
            { 'title': 'Modèles' },
            { 'title': 'Textes' },
            { 'title': 'Options' },
          ]
        };


        scope.printparam = {
          scale : 1000,
          dpi: scope.printDpis[0],
          map_only_width: 21,
          map_only_height: 29
        };
        scope.CurrentResolution = scope.map.getView().getResolution();

        let printCenter;

        var printServiceInfo = {};
        scope.printTemplates = [];
        scope.printFormats = [];
        scope.extentFeature = null;

        //template rectangle draw
        var templateVectorSource = new ol.source.Vector();

        var templateVectorLayer = new ol.layer.Vector({
          source: templateVectorSource
        });

        //scope.map.addLayer(templateVectorLayer);
        templateVectorLayer.setMap(scope.map);
        var translateInteraction = new ol.interaction.Translate({
          layers: [templateVectorLayer]
        });
        //extent style
        var extentStroke = new ol.style.Stroke({
          color: 'blue',
          width: 2
        });

        var extentFill = new ol.style.Fill({
          color: 'rgba(0, 0, 255, 0.1)'
        });

        var extentStyle = new ol.style.Style({
          stroke : extentStroke,
          fill : extentFill
        });
        var mapWkid = null;

        scope.$on('openTools_esriprint', function(event, tool, isDict) {
          if(!isDict === !scope.ongeturl) {
            scope.drawTemplateRectangle();
          }
        });

        scope.$on('openCloseTools_esriprint', function() {
          scope.clearTemplateRectangle();
        });

        function getMapWkid() {
          var srid = scope.map.getView().getProjection().getCode();
          if(srid.indexOf(':') > -1)
          {
            var arraySplit = srid.split(':');
            mapWkid = arraySplit[1];
          }
        }


        function checkMapTexts() {
          if (!scope.config.mapTexts) {
            scope.config.mapTexts = [
              {
                name: 'title',
                alias: $filter('translate')('esriprint.title'),
                canChangeFont: false,
                canChangeFontSize: false
              },
              {
                name: 'author',
                alias: $filter('translate')('esriprint.author'),
                canChangeFont: false,
                canChangeFontSize: false
              }
            ];
          }
        }

        scope.newMapTextNameIsOk = function (newMt) {
          if (!newMt)
            return false;
          for (let ind = 0; ind < scope.config.mapTexts.length; ind++) {
            if (newMt == scope.config.mapTexts[ind].name)
              return false;
          }
          return true;
        };

        scope.addMapText = function (mt) {
          scope.config.mapTexts.push(
            {
              name: mt,
              canChangeFont: false,
              canChangeFontSize: false
            });
        };

        scope.removeMapText = function (mt) {
          for (let ii = 0; ii < scope.config.mapTexts.length; ii++) {
            if (mt == scope.config.mapTexts[ii]) {
              scope.config.mapTexts.splice(ii, 1);
              return;
            }
          }
        };

        scope.moveMapText = function (mt, inc) {
          let temp;
          for (let ii = 0; ii < scope.config.mapTexts.length; ii++) {
            if (mt == scope.config.mapTexts[ii]) {
              temp = scope.config.mapTexts.splice(ii, 1);
              scope.config.mapTexts.splice(ii + inc, 0, temp[0]);
              return;
            }
          }
        };

        scope.ws = {};
        scope.config = {};
        scope.config.printTmplts = [];
        scope.config.url = '';
        scope.getConfig = function () {

          ConfigFactory
          .get('widgets', scope.ConfigName)
          .then(
              function (res) {

                if (res.data !== ''
                    && res.status == 200) {
                  scope.config = res.data;
                  getPrintServiceInfo();
                  console
                  .info('Configuration de esriprintwidget chargée.');
                }
                setOptions(res.data);
                checkMapTexts();
              },
              function (reason) {
                console
                .error('Configuration de esriprintwidget non chargée: '
                    + reason);
              });

        };

        /**
         * use options from config file
         * @param options
         */
        function setOptions(receivedConfig) {
          if (!scope.config.options) {
            scope.config.options = {}
          }
          // Hide rotation
          if (receivedConfig && receivedConfig.options && receivedConfig.options.hideRotation) {
            scope.config.options.hideRotation = receivedConfig.options.hideRotation;
          } else {
            scope.config.options.hideRotation = false;
          }
          // Zoom on scale change
          if (receivedConfig && receivedConfig.options && receivedConfig.options.zoomOnScaleChange) {
            scope.config.options.zoomOnScaleChange = receivedConfig.options.zoomOnScaleChange;
          } else {
            scope.config.options.zoomOnScaleChange = false;
          }
        }

        scope.getConfig();
        //$timeout(scope.getConfig, 15000);

        function getPrintServiceInfo() {
          if (scope.config.url && scope.config.url.length > 0) {
            scope.ws.waitingConfig = true;
            $.get(scope.config.url + '?f=json').then(
              function(info) {

                if (typeof info == 'string')
                  printServiceInfo = JSON.parse(info);
                else
                  printServiceInfo = info;
                if (printServiceInfo.error) {
                  require('toastr').error('Impression: '+printServiceInfo.error.message);
                }
                else {
                  initTemplatesFromInfo();
                  initPrintFormatsFromInfo();
                  initCurrentUser();
                }
                scope.ws.waitingConfig = false;
              },
              function () {
                scope.ws.waitingConfig = false;
              }
            );
          }
        }

        function initCurrentUser() {
          scope.printparam.author = {};
          if($rootScope.xgos.user.fullname) {
            scope.printparam.author.text = $rootScope.xgos.user.fullname;
          } else {
            scope.printparam.author.text = $rootScope.xgos.user.vorname + ' ' + $rootScope.xgos.user.name;
          }
        }

        function initPrintFormatsFromInfo() {

          var layoutFormatParam = getParameterByName('Format');

          scope.printFormats = layoutFormatParam.choiceList;
          if (scope.printFormats.length > 0) {
            scope.printparam.format = scope.printFormats[0];
          }
        }

        function initTemplatesFromInfo() {

          var layoutTemplateParam = getParameterByName('Layout_Template');

          if (layoutTemplateParam != null) {

            if (scope.printTemplates.length) {
              scope.printTemplates.splice(0, scope.printTemplates.length);
            }
            for (let ind = 0; ind < layoutTemplateParam.choiceList.length; ind++) {
              scope.printTemplates.push(layoutTemplateParam.choiceList[ind]);
            }

            /*
            var delIdx = scope.printTemplates.indexOf('MAP_ONLY');

            if (delIdx > -1) {

              scope.printTemplates.splice(delIdx, 1);

            }
*/
            if (scope.printTemplates.length > 0) {

              scope.printparam.template = scope.printTemplates[scope.printTemplates.length - 1];

              initTemplatesConfig();
            }

          }

        }

        /**
         * Allow to use the mouse to move the print preview
         */
        scope.moveCustomizedExtent = function () {
          if (scope.extentFeature != null) {
            scope.map.addInteraction(translateInteraction);
          }
        };

        /**
         * Clean the print preview
         */
        scope.clearTemplateRectangle = function () {
          //getBaseMapLayer();
          scope.map.removeInteraction(translateInteraction);
          templateVectorSource.clear();
          scope.extentFeature = null;
        };

        /**
         * Draw the print preview in the center of the view
         */
        scope.centerTemplateRectangle = () => {
          scope.drawTemplateRectangle(true);
          // Change the map scale
          $rootScope.$broadcast('change_scale',
              scope.printparam.scale * 3);
          // Center the map view on the object
          scope.map.getView().setCenter(printCenter);
        };

        /**
         * Modify the print preview scale,
         * changing at the same time the map view scale and position
         */
        scope.changePreviewScale = () => {
          scope.drawTemplateRectangle();
          if (scope.config.options.zoomOnScaleChange) {
            // Change the map scale
            $rootScope.$broadcast('change_scale',
                scope.printparam.scale * 3);
            // Center the map view on the object
            scope.map.getView().setCenter(printCenter);
          }
        };

        /**
         *  Clean and reDraw the print rectangle on the map, setting it movable
         */
        scope.drawTemplateRectangle = (center) => {
          // Get the last position to redraw it with the same center
          if (!center && scope.extentFeature) {
            printCenter = scope.extentFeature.getGeometry().getInteriorPoint().getCoordinates();
          }
          // If needed, draw in the center of displayed map
          else {
            printCenter = scope.map.getView().getCenter();
          }
          if (scope.printparam.scale && scope.printparam.scale != ''
              && scope.printparam.scale > 0) {
            let widthHeight = getTemplateDimensionFromConfig(
                scope.printparam.template);
            if (widthHeight != null) {
              scope.clearTemplateRectangle();
              scope.extentFeature = null;
              let width = widthHeight[0];
              let height = widthHeight[1];
              if (width > 0 && height > 0) {
                // Compute and draw the print preview
                let customizedExtent = computeTemplateExtent(printCenter,
                    scope.printparam.scale, width, height);
                let extentPolygon = ol.geom.Polygon.fromExtent(
                    customizedExtent);
                scope.extentFeature = new ol.Feature(extentPolygon);
                scope.extentFeature.setStyle(extentStyle);
                if (scope.printparam.rotation) {
                  const rotation_in_radians = scope.printparam.rotation
                      * Math.PI / 180;
                  extentPolygon.rotate(rotation_in_radians, printCenter);
                }
                templateVectorSource.addFeature(scope.extentFeature);

                // Make the preview movable
                scope.moveCustomizedExtent();
              }
            }
          }
        }

        function getTemplateDimensionFromConfig(templateName) {
          if (templateName == 'MAP_ONLY') {
            return [scope.printparam.map_only_width,
              scope.printparam.map_only_height];
          }

          for (var i = 0; i < scope.config.printTmplts.length; i++) {
            var loopConf = scope.config.printTmplts[i];
            if( loopConf.name ==  templateName)
            {
              var result = [ loopConf.width , loopConf.height];
              return result;
            }
          }
          return null;
        }

        function computeTemplateExtent(mapCenter, scale, width, height) {
          var mapWidthPU = width * scale; //PaperUnits
          var mapHeightPU = height * scale; //PaperUnits
          var mapWidth = mapWidthPU / 100;
          var mapHeight = mapHeightPU /100;
          var centerX = mapCenter[0];
          var centerY = mapCenter[1];
          var extent = [centerX - (mapWidth / 2), centerY - (mapHeight / 2),
            centerX + (mapWidth / 2), centerY + (mapHeight / 2)];
          return extent;
        }

        function existeTemplInList(template, tmplList) {
          for (let ii = 0; ii < tmplList.length; ii++) {
            if (tmplList[ii] == template || tmplList[ii].name == template)
              return true;
          }
          return false;
        }


        function initTemplatesConfig() {

          for (var i = 0; i < scope.printTemplates.length; i++) {

            if (!existeTemplInList(scope.printTemplates[i],scope.config.printTmplts)) {
              var printTmpltRow = {
                'name': scope.printTemplates[i],
                'width': 0,
                'height': 0
              };

              scope.config.printTmplts.push(printTmpltRow);
            }
          }

          //-- Enlever de la configuration un modéle d'impression
          //-- qui n'existe plus.
          for (let ii = scope.config.printTmplts.length-1; ii >=0 ; ii--) {
            if (!existeTemplInList(scope.config.printTmplts[ii].name, scope.printTemplates))
              scope.config.printTmplts.splice(ii, 1);
          }
        }

        function getParameterByName(name) {

          if (!angular.isUndefined(printServiceInfo.parameters)
              && printServiceInfo.parameters != null) {

            for (var i = 0; i < printServiceInfo.parameters.length; i++) {

              var loopParam = printServiceInfo.parameters[i];

              if (loopParam.name == name) {

                return loopParam;

              }

            }

          }

          return null;

        }

        var ngDialogPromise;
        scope.openConfig = function() {

          ngDialogPromise = ngDialog
            .openConfirm({
              template : 'js/XG/widgets/mapapp/esriprint/views/configuration.html',
              className : 'ngdialog-theme-plain overflowY width800 nopadding miniclose',
              scope : scope
            });

          ngDialogPromise.then(function(data) {

            scope.saveconfig();
            require('toastr').info(data);

          }, function(data) {

            scope.getConfig();
            require('toastr').info(data);

          });

        };
        scope.resetTemplatesConfig = function() {
          scope.config.printTmplts = [];
          for (var i = 0; i < scope.printTemplates.length; i++) {

            var printTmpltRow = {
              'name' : scope.printTemplates[i],
              'width' : 0,
              'height' : 0
            };

            scope.config.printTmplts.push(printTmpltRow);

          }
        };

        scope.saveconfig = function() {

          ConfigFactory
            .add(scope.config, 'widgets', scope.ConfigName)
            .then(function(res) {

              require('toastr').success(res.data);

              getPrintServiceInfo();

            }, function(reason) {

              require('toastr').error(reason);

            });

        };

        function compareUrls(url1, url2) {
          return url1.replace('MapServer/', 'MapServer') == url2
            .replace('MapServer/', 'MapServer');
        }

        function updateLayersConfigs(l, urlESRI, urlDirectESRI,
          LAYERSnewESRI, OPACITYnewESRI, FILTERnewESRI,
          STYLESnewESRI, LABELSnewESRI) {
          if ((compareUrls(l.fti.wms, urlESRI) || compareUrls(
            l.fti.wms, urlDirectESRI))
              && l.visible
              && l.getMaxResolution() > scope.CurrentResolution
              && l.getMinResolution() < scope.CurrentResolution) {

            LAYERSnewESRI.push(l.fti.ogcId);

            if (STYLESnewESRI != null) {
              STYLESnewESRI.push(l.style);
            }

            if (LABELSnewESRI != null) {
              LABELSnewESRI.push(l.label);
            }

            if (angular.isUndefined(l.invertedOpacity)) {
              OPACITYnewESRI.push(1);
            } else {
              OPACITYnewESRI.push(1 - l.invertedOpacity);
            }
            if (angular.isUndefined(l.cql_filter)) {
              FILTERnewESRI.push('1=1');
            } else {
              FILTERnewESRI.push(l.cql_filter.replace(l.fti.name,
                l.fti.ogcId));
            }
          }
        }

        function getDynamicLayers(LAYERSnewESRI, OPACITYnewESRI,
          FILTERnewESRI, STYLESnewESRI, LABELSnewESRI) {
          var dynamicLayers = [];
          for (var i = 0; i < LAYERSnewESRI.length; i++) {
            var dynamicLayerEntry = {
              'id' : LAYERSnewESRI[i],
              'source' : {
                'type' : 'mapLayer',
                'mapLayerId' : LAYERSnewESRI[i]
              }
            };
            var filter = FILTERnewESRI[i];
            if (filter != null && filter != '1=1')
              dynamicLayerEntry.definitionExpression = filter;
            var opacity = OPACITYnewESRI[i];

            var layerStyle;

            if (STYLESnewESRI != null) {
              layerStyle = STYLESnewESRI[i];
            }

            var layerLabel;

            if (LABELSnewESRI != null) {
              layerLabel = LABELSnewESRI[i];
            }

            if (opacity != null) {

              dynamicLayerEntry.drawingInfo = {
                'transparency' : opacity == 1 ? 0
                  : 100 - (opacity * 100)
              };

            }

            if (!angular.isUndefined(layerStyle)) {

              if (!angular
                .isUndefined(dynamicLayerEntry.drawingInfo)) {

                dynamicLayerEntry.drawingInfo.renderer = layerStyle;

              } else {

                dynamicLayerEntry.drawingInfo = {
                  'renderer' : layerStyle
                };
              }
            }

            if (!angular.isUndefined(layerLabel)) {
              if (!angular
                .isUndefined(dynamicLayerEntry.drawingInfo)) {

                dynamicLayerEntry.drawingInfo.labelingInfo = layerLabel;
              } else {
                dynamicLayerEntry.drawingInfo = {
                  'labelingInfo' : layerLabel
                };
              }
            }
            dynamicLayers.push(dynamicLayerEntry);
          }

          return dynamicLayers;
        }

        function getUrl(olLayer) {
          return olLayer.getSource().getUrl ? olLayer.getSource()
            .getUrl() : olLayer.getSource().getUrls()[0];
        }

        function getRandomId() {
          var min = Math.ceil(1000);
          var max = Math.floor(100000);
          return 'IDRANDOM' + Math.floor(Math.random() * (max - min))
              + min;
        }

        function getCfgOfMapText(mtName) {
          for (let ii = 0; ii < scope.config.mapTexts.length; ii++) {
            if (scope.config.mapTexts[ii].name == mtName)
              return scope.config.mapTexts[ii];
          }
          return undefined;
        }
        /**
         * Condifugartion d'un texte à écrire dans la carte générée
         * par ArcGIS Server.
         * Une police de caractère avec sa taille peuvent être configurés.
         * Dans ce cas, on les prend en compte.
         *
         * @param {*} mt
         * @param {*} webMapAsJson
         */
        function setPrintParam(mt, webMapAsJson) {
          let fontDesc = '', theText='';
          let param = scope.printparam[mt.name];
          if (!angular.isUndefined(param)
              && !angular.isUndefined(param.text)
              && param.text != null
              && param.text != '') {
            let elt = {};
            theText = param.text;
            let cfg = getCfgOfMapText(mt.name);
            if (cfg.canChangeFont) {
              if (param.bold)
                theText = '<BOL>' + theText + '</BOL>';
              if (param.underlined)
                theText = '<UND>' + theText + '</UND>';
              if (param.italic)
                theText = '<ITA>' + theText + '</ITA>';
              if (param.font && param.font != '------')
                fontDesc = ' name=\'' + param.font + '\'';
            }
            if (cfg.canChangeFontSize) {
              if (param.fontSize && param.fontSize != '------')
                fontDesc += ' size=\'' + param.fontSize + '\'';
            }
            if (fontDesc != '') {
              fontDesc = '<FNT' + fontDesc + '>' + theText + '</FNT>';
              elt[mt.name] = fontDesc;
            }
            else
              elt[mt.name] = theText;
            if (mt.name == 'title')
              webMapAsJson.layoutOptions.titleText = elt[mt.name];
            else if (mt.name == 'author')
              webMapAsJson.layoutOptions.authorText = elt[mt.name];
            else
              webMapAsJson.layoutOptions.customTextElements.push(elt);
          }
        }

        function getLayerIdsFromLayers(layers) {
          let list = [];
          for (let ii =0; ii < layers.length; ii++) {
            list.push(layers[ii].id);
          }
          return list;
        }

        function setMapOption(webMapAsJson, option) {
          if (scope.printparam[option] && scope.printparam[option] != ''
              && scope.printparam[option] > 0)
            webMapAsJson.mapOptions[option] = scope.printparam[option];
        }

        /**
         * Dans le cas de la carte seulement 'MAP_ONLY), on doit
         * fournir une dimension en pixeL, d'où la nécessité
         * de cette conversion.
         *
         * @param {*} size
         */
        function getSizeInPixels(size) {
          //-- SIze est en centimetre, on le trnsforme en inch
          //-- let newSize = size / 2.54;

          //-- SI 96 dpi, 96 point pour un pouce ....
          //-- new Size = newSize * scope.printparam.dpi;
          return size / 2.54 * scope.printparam.dpi;
        }

        function setMapOptions(webMapAsJson) {
          var currentExtent;
          if(scope.extentFeature == null)
          {
            currentExtent = scope.map.getView().calculateExtent();
          }else
          {
            var poly = scope.extentFeature.getGeometry();
            currentExtent = poly.getExtent();
          }
          webMapAsJson.mapOptions = {
            extent : {
              xmin : currentExtent[0],
              ymin : currentExtent[1],
              xmax : currentExtent[2],
              ymax : currentExtent[3]
            }
          };
          getMapWkid();
          if (mapWkid != null) {
            webMapAsJson.mapOptions.extent.spatialReference
              = { 'wkid': mapWkid };
            webMapAsJson.mapOptions.spatialReference = {'wkid' : mapWkid};
          }

          setMapOption(webMapAsJson, 'scale');
          setMapOption(webMapAsJson, 'rotation');

          if (scope.printparam.template == 'MAP_ONLY') {
            webMapAsJson.exportOptions.outputSize = [
              getSizeInPixels(scope.printparam.map_only_width),
              getSizeInPixels(scope.printparam.map_only_height)
            ];
          }
          else {
            if (webMapAsJson.exportOptions.outputSize)
              delete webMapAsJson.exportOptions.outputSize;
          }
        }

        /**
         * vit 20/05/21
         * The goal of this function is to get all the map informations in a JSON
         * witch will be sent in the print request
         * doc:
         * https://enterprise.arcgis.com/en/server/latest/publish-services/windows/exportwebmap-specification.htm?lg=en
         * @returns {*}
         */
        function getWebMapAsJSON() {
          let webMapAsJson = angular.copy(WEB_MAP_AS_JSON_TEMPLATE);
          scope.CurrentResolution = scope.map.getView()
          .getResolution();

          // Base map / background
          // !! set in operationalLayers for wms backgrounds !!
          setBaseMap(webMapAsJson);

          // operationalLayers
          // treat all layer groups (eg: Cadastre, Reseau)
          const layerGroups = gclayers.layersGroupedByStore.layerGroups;
          for (let layerGroup of layerGroups) {
            if (layerGroup.type === 'ESRI') {
              let urlDirectESRI;
              let LAYERSnewESRI = [];
              let STYLESnewESRI = [];
              let LABELSnewESRI = [];
              let OPACITYnewESRI = [];
              let FILTERnewESRI = [];
              for (let olLayer of layerGroup.layers) {
                if (olLayer.get('id')
                    && olLayer.getSource().getParams().type
                    === 'esri') {
                  let urlESRI = getUrl(olLayer);
                  let ftiDataStore = mapJsUtils.getFtiDataStore(olLayer.fti);
                  urlDirectESRI = ftiDataStore ? ftiDataStore.url
                      : olLayer.fti.wms;
                  if (urlESRI && urlDirectESRI) {
                    updateLayersConfigs(
                        olLayer,
                        urlESRI,
                        urlDirectESRI,
                        LAYERSnewESRI,
                        OPACITYnewESRI,
                        FILTERnewESRI,
                        STYLESnewESRI,
                        LABELSnewESRI);
                  }
                }
              }
              let dynamicLayers = getDynamicLayers(
                  LAYERSnewESRI,
                  OPACITYnewESRI,
                  FILTERnewESRI,
                  STYLESnewESRI,
                  LABELSnewESRI);

              let randomId = getRandomId();
              let detailedDynamicLayers = [];
              for (let j = 0; j < dynamicLayers.length; j++) {
                let dynamicLayer = dynamicLayers[j];
                detailedDynamicLayers
                .push({
                  layerDefinition: dynamicLayer,
                  id: dynamicLayer.id
                });
              }
              if (detailedDynamicLayers.length !== 0) {
                let operationalLayerEntry = {
                  title: randomId,
                  id: randomId,
                  url: urlDirectESRI,
                  layers: detailedDynamicLayers
                };

                webMapAsJson.operationalLayers
                .push(operationalLayerEntry);
              }
            }
          }

          // mapOptions
          setMapOptions(webMapAsJson);

          // layoutOptions
          webMapAsJson.layoutOptions.legendOptions.operationalLayers = [];
          webMapAsJson.layoutOptions.legendOptions.operationalLayers.push(
              {
                id: webMapAsJson.operationalLayers[0].id,
                subLayerIds: getLayerIdsFromLayers(
                    webMapAsJson.operationalLayers[0].layers)
              }
          );
          for (let ind = 0; ind < scope.config.mapTexts.length; ind++) {
            setPrintParam(scope.config.mapTexts[ind], webMapAsJson);
          }

          // exportOptions
          webMapAsJson.exportOptions.dpi = scope.printparam.dpi;

          return webMapAsJson;
        }

        /**
         * Set the background in webMapAsJson
         * in baseMap for OSM or operationalLayers for WMS
         * @param webMapAsJson
         */
        function setBaseMap(webMapAsJson) {
          let baseMapRes = [];

          // Look for the visible background(s)
          const baseLayers = BaseMapFactory.resources.basemaps;
          const allMapLayers = scope.map.getLayers().getArray();
          baseLayers.forEach(function (background) {
            allMapLayers.forEach(function (layer) {
              if (layer.getVisible()) {
                if (background.name === layer.get('name')) {
                  if (layer.get('type') === 'OSM') {
                    baseMapRes.push(
                        {
                          'type': 'OpenStreetMap',
                          'url': 'https://a.tile.openstreetmap.org',
                        }
                    );
                  } else if (layer.get('type') === 'WMSBACK') {
                    let backgroundLayerNames = [];
                    for (let name of background.layer.split(',')) {
                      backgroundLayerNames.push({'name': name})
                    }
                    webMapAsJson.operationalLayers.push(
                        {
                          'url': background.url,
                          'type': 'wms',
                          'layers': backgroundLayerNames
                        }
                    );
                  }
                }
              }
            });
          });

          // Add the found? OSM background(s) to baseMap
          if (baseMapRes.length > 0) {
            webMapAsJson.baseMap = {
              'title': 'Base Maps',
              'baseMapLayers': baseMapRes
            };
          }
        }



        function printFailureMessage (mess) {
          gaDomUtils.hideGlobalLoader();
          if (mess==undefined) mess = '';
          else mess = ': '+mess;
          swal({
            title: $filter('translate')('common.print'),
            text: $filter('translate')('print.printFailure')+mess,
            type: 'error',
            closeOnConfirm: false,
            closeOnCancel: false
          });
        }


        function getPrintFile (res) {
          let jsonRes;
          if (typeof res == 'string')
            jsonRes = JSON.parse(res);
          else
            jsonRes = res;
          if (jsonRes.jobStatus=='esriJobFailed') {
            printFailureMessage();
          }
          else if (jsonRes.error) {
            printFailureMessage(jsonRes.error.message);
          }
          else if (jsonRes.results) {
            gaDomUtils.hideGlobalLoader();
            if (jsonRes.jobStatus=='esriJobSucceeded') {
              //var fileUrl = jsonRes.results[0].value.url;
              var fileUrl = scope.config.url + '/jobs';
              fileUrl += '/' + jsonRes.jobId + '/results/Output_File?f=pjson';
              $.get(fileUrl).then(
                function (newres) {
                  var jsonRes2 = JSON.parse(newres);
                  var fileUrl2 = jsonRes2.value.url;
                  if (scope.ongeturl) {
                    PrintFactory.lastPrintUrl = fileUrl2;
                    scope.ongeturl();
                  } else {
                    window.open(fileUrl2);
                  }
                }
              );

            }
            else
              printFailureMessage();
          }
          else {
            var url = scope.config.url + '/jobs';
            url += '/' + jsonRes.jobId + '?f=pjson';
            $.get(url).then(
              function (newres) {
                $timeout( function() {
                  getPrintFile(newres);
                }, 500
                );

              }
            );
          }
        }


        scope.submitPrint = function() {

          let postData = {};
          gaDomUtils.showGlobalLoader();

          var webMapAsJson = getWebMapAsJSON();
          // console.log($rootScope.xgos.user);

          var format = scope.printparam.format;
          var layout = scope.printparam.template;

          //console.log(webMapAsJson);
          var encodedWebMapAsJson = JSON.stringify(webMapAsJson);
/*
          var printurl = scope.config.url + '/submitJob'
                                  + '/execute?f=json&Web_Map_as_JSON='
                                  + encodedWebMapAsJson + '&Format='
                                  + format
            + '&Layout_Template=' + layout;
          */
          var printurl = scope.config.url + '/submitJob/execute?f=json';
          postData.Web_Map_as_JSON = encodedWebMapAsJson;
          postData.Format = format;
          postData.Layout_Template = layout;
//          $.get(printurl).then(
          $.post(printurl,postData).then(
            function(res) {
              $timeout( function() {
                getPrintFile(res);
              }, 500
              );
            }
          );
        };








        /*

Impression en mode synchrone.

        scope.submitPrint = function() {
          gaDomUtils.showGlobalLoader();

          var webMapAsJson = getWebMapAsJSON();
          // console.log($rootScope.xgos.user);

          var format = scope.printparam.format;

          var layout = scope.printparam.template;

          //console.log(webMapAsJson);
          var encodedWebMapAsJson = encodeURIComponent(JSON
              .stringify(webMapAsJson));

          $.get(
              scope.config.url
                  + '/execute?f=json&Web_Map_as_JSON='
                  + encodedWebMapAsJson + '&Format=' + format
                  + '&Layout_Template=' + layout).then(

            function(res) {
              gaDomUtils.hideGlobalLoader();
              var jsonRes = JSON.parse(res);
              //console.log(jsonRes);
              var fileUrl = jsonRes.results[0].value.url;
              window.open(fileUrl);
            }

          );

        };
                */
        scope.$on('closeTools_esriprint', function (){
          scope.clearTemplateRectangle();
        });

      }
    };
  };

  esriprint.$inject = [ '$rootScope', 'ngDialog', 'ConfigFactory',
    'gclayers', 'gaDomUtils', 'BaseMapFactory',
    '$timeout', '$filter', 'PrintFactory', 'mapJsUtils'];
  return esriprint;

});
