'use strict';
define(function() {
  var importTransferLayerWidget = function(
    ImportTransferLayerFactory,
    $filter,
    FeatureTypeFactory,
    ngDialog,
    extendedNgDialog,
    gaDomUtils,
    ConfigFactory,
    QueryFactory,
    $rootScope,
    AssociationFactory,
    gaJsUtils,
    SelectManager,
    $timeout
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/importTransferLayer/views/importTransferLayerWidget.html',
      restrict: 'A',

      link: function(scope) {
        const SAVE_CONFIG_DIRECTORY = 'importTransferLayerWidget';
        const CONFIG_SAVE = 'importTransferLayerWidget_saveConfig';
        const CONFIG_REMOVE = 'importTransferLayerWidget_removeConfig';
        const CONFIG_GET_LIST = 'importTransferLayerWidget_getList';
        const CONFIG_GET_FEATS = 'importTransferLayerWidget_getFeatures';
        const CONFIG_DO_TRANSFER_LAYER = 'importTransferLayerWidget_doTransferLayerFromWidget';

        const initWidget = () => {
          //init tabs
          scope.tabs = [
            { title:  $filter('translate')('importexportwidget.import') },
            { title:  $filter('translate')('importexportwidget.dataset') }
          ];
          scope.tabs.activeTab = 0;
          scope.showFilterAssociations = false;
          scope.showAssociations = false;

          setDefaultValues();

          getComponentsList();

          initAssociations();

          scope.loadAllMappingConfigs();

          getWidgetConfig();

          scope.rawJointureData = {};
          scope.$watch('rawJointureData', () => {
            if (scope.rawJointureData && scope.rawJointureData.maj_component === true
              && scope.rawJointureData.attribut && scope.rawJointureData.value
              && scope.rawJointureData.value.name) {
              scope.currentConfig.configByLayer[0].updateFeatures = true;
              scope.currentConfig.configByLayer[0].jointureSourceAttribute =
                scope.rawJointureData.attribut;
              scope.currentConfig.configByLayer[0].jointureDestinationAttribute =
                scope.rawJointureData.value.name;
            } else {
              scope.currentConfig.configByLayer[0].updateFeatures = false;
              scope.currentConfig.configByLayer[0].jointureSourceAttribute = '';
              scope.currentConfig.configByLayer[0].jointureDestinationAttribute = '';
            }
          }, true);
        };

        /**
         * récupère tous les FTIs de composant géographique du portail
         * -- KIS-3819: Si le composant est Géographique, on ne l'accepte que s'il est publié
         */
        const getComponentsList = () => {
          FeatureTypeFactory.get().then((components) => {
            scope.allComponentsList = components;
            scope.geographicComponentsList = components.filter(
              component => component.geographic===true && component.published);
          });
        };

        /**
         * recupérer tous les associations
         * cette fonction récupérer toutes les associations disponible dans le portail
         * la variable allAssociations contiendra ces associations
         */
        const initAssociations = () => {
          scope.allAssociations = [];
          if(gaJsUtils.notNullAndDefined($rootScope.xgos, 'portal.parameters.mainDB')){
            AssociationFactory.getAll($rootScope.xgos.portal.parameters.mainDB).then((res) => {
              scope.allAssociations = res.data;
            });
          }
        };

        /**
         * initialiser les dualBox pour les associations
         * préparer les associations qu'il faut presenter dans la partie droit et gauche du dualBox
         */
        scope.initDualBoxAssociations = (fromLoadConfig) => {
          scope.showAssociations = false;
          scope.showFilterAssociations = false;
          if(scope.currentConfig.sourceComponentFtid && scope.currentConfig.sourceComponentFtid !==''){
            if(!fromLoadConfig || !Array.isArray(scope.currentConfig.associationToLoad)){
              scope.currentConfig.associationToLoad = [];
            }
            const fti = scope.allComponentsList.find(comp => comp.uid === scope.currentConfig.sourceComponentFtid);
            if(fti){
              let availableAllAssos = scope.allAssociations.filter(
                ass =>  (ass.atable===fti.name || ass.btable===fti.name) &&
                      (scope.currentConfig.associationToLoad.findIndex(asso => asso.ID === ass.ID))===-1);
              let availableAssos = [];
              if(availableAllAssos.length>0){
                if(scope.currentConfig.concernedAssociations === 'patrimony'){
                  availableAssos = availableAllAssos.filter(ass =>  ass.type_patrimoine );
                }else{
                  availableAssos = availableAllAssos;
                }
                if(fti.geographic){
                  scope.showFilterAssociations = true;
                }
              }else if((Array.isArray(scope.currentConfig.associationToLoad) &&
                        scope.currentConfig.associationToLoad.length>0) && fti.geographic){
                scope.showFilterAssociations = true;
              }
              if(availableAssos.length>0
                || (Array.isArray(scope.currentConfig.associationToLoad) && scope.currentConfig.associationToLoad.length>0)){
                availableAssos = availableAssos.map(ass =>  Object({'name' : ass.name, 'alias':ass.alias, 'ID':ass.ID}));
                scope.associationToLoad = {
                  leftData: scope.currentConfig.associationToLoad,
                  leftDisplayAttribute: 'alias',
                  rightData: availableAssos,
                  rightDisplayAttribute: 'alias',
                  leftTitle: 'tools.builder.association.associationLoaded',
                  rightTitle: 'tools.builder.association.associationAvailable',
                  source: 'right'
                };
                scope.showAssociations = true;
              }
            }
          }
        };

        const setDefaultValues = () => {
          scope.disableInput = false;
          scope.layersToMap = []; // les layers à mapper via la config
          scope.selectedMappingConfig =  undefined;
          scope.featuresToTransfer = undefined;
          scope.showNonGeographicComponents = false;
          scope.useCurrentSelection = false;
          scope.showAssociations = false;
          scope.showFilterAssociations = false;
          scope.currentConfig = {
            configVersion: ImportTransferLayerFactory.LATEST_CONFIG_VERSION,
            configName: '',
            sourceComponentFtid: '',
            destinationComponentFtid: '',
            filterOnData: '',
            concernedAssociations: 'all',
            associationToLoad: [],
            configByLayer: [
              {
                applyBusinessRules: {value: false},
                fieldsMapping: {},
                defaultValues: {},
                updateFeatures: false,
                jointureSourceAttribute: '',
                jointureDestinationAttribute: '',
                fieldsApplyCurrentDate: {}
              }
            ]
          };
        };

        /**
         * lock source layer and get features to transfer
         */
        scope.validateSource = () => {
          if (scope.currentConfig.sourceComponentFtid) {
            const fti = scope.allComponentsList.find( fti => fti.uid === scope.currentConfig.sourceComponentFtid);
            const selectFeatures = SelectManager.getFeaturesByftiType(fti.name);
            if(!scope.useCurrentSelection ||  selectFeatures.features.length>0){
              gaDomUtils.showGlobalLoader(CONFIG_GET_FEATS);
              //there is only one layer imported for the moment
              QueryFactory.data(scope.currentConfig.sourceComponentFtid, scope.currentConfig.filterOnData).then(res => {
                if (res.data && Array.isArray(res.data.features)) {
                  if(!scope.useCurrentSelection){
                    scope.featuresToTransfer = res.data.features;
                  }else{
                    scope.featuresToTransfer = selectFeatures.features.filter(feature=>
                      res.data.features.findIndex(feat =>
                        feat.id ==feature.id)>=0);
                  }
                  scope.tabs.activeTab = 1;
                  scope.disableInput = true;

                  scope.layersToMap = [];
                  if (fti && Array.isArray(fti.attributes)) {
                    scope.layersToMap.push({
                      fti: fti,
                      totalFeatures: scope.featuresToTransfer.length
                    });
                  } else {
                    console.error('can\'t get correct fti with this ftid:' + scope.currentConfig.sourceComponentFtid);
                  }
                }
              }, () => {
                require('toastr').error(
                  $filter('translate')('common.error'));
              }).finally( () => {
                gaDomUtils.hideGlobalLoader(CONFIG_GET_FEATS);
              });
            }else{
              require('toastr').error(
                $filter('translate')('importTransferLayerWidget.no_selection'));
            }
          } else {
            require('toastr').error(
              $filter('translate')('importTransferLayerWidget.no_component_source'));
          }
        };

        scope.clearWidget = () => {
          setDefaultValues();
        };

        scope.openMappingDialog = (selectedComponent) => {
          scope.listOfAttributesNames = selectedComponent.attributes
            .map(attribute => attribute.name);
          scope.sourceFti = selectedComponent;
          // Le filtre permet d'afficher seulement les composants du même type
          // (POINT, LIGNE, POLYGONE, TABLE)
          scope.hasFtiListFilter = true;
          scope.ftiListFilter = (component) => component.typeInfo === selectedComponent.typeInfo;
          // open dialog
          if (!scope.currentConfig.configByLayer[0].fieldsMapping) {
            scope.currentConfig.configByLayer[0].fieldsMapping = {};
          }
          if (!scope.currentConfig.configByLayer[0].defaultValues) {
            scope.currentConfig.configByLayer[0].defaultValues = {};
          }
          if (!scope.currentConfig.configByLayer[0].fieldsApplyCurrentDate) {
            scope.currentConfig.configByLayer[0].fieldsApplyCurrentDate = {};
          }
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/importTransferLayer/views/dialogs/transferLayerDialog.html',
            title: $filter('translate')('csvgeocoder.import_title'),
            className:
              'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });

          if (scope.currentConfig.destinationComponentFtid) {
            const configByLayer = scope.currentConfig.configByLayer[0];
            const deleteSourceLayer = configByLayer.deleteSourceLayer.value;
            ImportTransferLayerFactory.verifyTransferLayerConfig(
              scope.currentConfig.sourceComponentFtid,
              scope.currentConfig.destinationComponentFtid,
              scope.currentConfig.filterOnData,
              scope.currentConfig.associationToLoad,
              configByLayer.applyBusinessRules.value,
              configByLayer.fieldsMapping,
              configByLayer.defaultValues,
              configByLayer.updateFeatures,
              configByLayer.jointureSourceAttribute,
              configByLayer.jointureDestinationAttribute,
              !deleteSourceLayer ? false : true
            ).then(() => {
              require('toastr').success('configuration ok');
            }, (error) => {
              switch (error.status) {
                case 400:
                  console.error('TransferLayerWidget: config is wrong' + error.data);
                  require('toastr')
                    .error($filter('translate')('importTransferLayerWidget.mapping_is_wrong'));
                  break;
                case 500:
                  console.error('error verifyTransferLayerConfig: ' + error.data);
                  break;
                default:
                  console.error('error verifyTransferLayerConfig unknown error');
                  break;
              }
            });
          }
        };

        /**
         * save a mapping configuration
         * it can be a new or existing one
         */
        const saveMappingConfig = (mappingConfig) => {
          gaDomUtils.showGlobalLoader(CONFIG_SAVE);
          ConfigFactory.add(mappingConfig, SAVE_CONFIG_DIRECTORY, mappingConfig.configName).then((res) => {
            gaDomUtils.hideGlobalLoader(CONFIG_SAVE);
            if (res.data==true) {
              require('toastr').success($filter('translate')
              ('common.configuration_saved'));
              // we use angular.copy because 'mappingConfig' is the object for currentConfig
              // and it needs to be modified separately from allMappingConfig
              const newMappingConfig = angular.copy(mappingConfig);
              // refresh config list
              const configIndex = scope.allMappingConfig.findIndex(config => config.configName===mappingConfig.configName);
              if (configIndex > -1) {
                scope.allMappingConfig[configIndex] = newMappingConfig;
              } else {
                scope.allMappingConfig.push(newMappingConfig);
              }
            } else {
              require('toastr').error($filter('translate')
              ('common.configuration_not_saved'));
            }
          }, err => {
            require('toastr').error($filter('translate')
            ('common.configuration_not_saved'));
            gaDomUtils.hideGlobalLoader(CONFIG_SAVE);
          });
        };

        scope.saveConfig = (configName) => {
          configName = configName.trim();
          scope.selectedMappingConfig = configName;
          scope.currentConfig.configName = configName;
          // -- kis-3772: Dans le fichier config, "deleteSourceLayer"
          // -- doit être un boooléen et non un objet.
          const config = angular.copy(scope.currentConfig);
          for (const layer of config.configByLayer) {
            if (layer.deleteSourceLayer instanceof Object) {
              layer.deleteSourceLayer = layer.deleteSourceLayer.value;
            }
          }

          saveMappingConfig(config);
        };

        scope.preSaveConfig = () => {
          // if we have a config selected it already has a name.
          if (scope.selectedMappingConfig) {
            scope.saveConfig(scope.selectedMappingConfig);
          } else {
            scope.newConfigName = '';
            //prompt for name of the new config
            let dialogHandle = ngDialog.openConfirm({
              template:
                'js/XG/widgets/mapapp/importTransferLayer/views/dialogs/transferLayerNameDialog.html',
              className:
                'ngdialog-theme-plain width500',
              closeByDocument: false,
              scope: scope,
            });
          }
        };

        /**
         * delete the a mapping configuration
         */
        const removeMappingConfig = (configName) => {
          if (typeof configName === 'string' && configName.length > 0) {
            gaDomUtils.showGlobalLoader(CONFIG_REMOVE + configName);
            ConfigFactory.remove(SAVE_CONFIG_DIRECTORY, configName).then((res) => {
              if (res.data==true) {
                scope.allMappingConfig = scope.allMappingConfig.filter(config => config.configName != configName);
                // reset selected config
                scope.selectedMappingConfig = undefined;
                scope.onConfigPicked();
                scope.disableInput = false;
                require('toastr').success($filter('translate')
                ('common.successDelete'));
              } else {
                require('toastr').error($filter('translate')
                ('common.failDelete'));
              }
              gaDomUtils.hideGlobalLoader(CONFIG_REMOVE + configName);
            }, err => {
              require('toastr').error($filter('translate')
              ('common.failDelete'));
              gaDomUtils.hideGlobalLoader(CONFIG_REMOVE + configName);
            });
          }
        };

        scope.removeCurrentMappingConfig = () => {
          swal({
            title: $filter('translate')('importTransferLayerWidget.confirm_delete_selected_config'),
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#DD6B55',
            confirmButtonText: $filter('translate')('common.yes'),
            cancelButtonText: $filter('translate')('common.no'),
            closeOnConfirm: true,
          },
          isConfirm => {
            if (isConfirm) {
              removeMappingConfig(scope.selectedMappingConfig);
            }
          });
        };

        /**
         * get all mapping configurations
         */
        scope.loadAllMappingConfigs = () => {
          gaDomUtils.showGlobalLoader(CONFIG_GET_LIST);
          ImportTransferLayerFactory.getAllConfigsContent().then(res => {
            gaDomUtils.hideGlobalLoader(CONFIG_GET_LIST);
            switch(res.status) {
              case 200:
                scope.allMappingConfig = res.data;
                if (Array.isArray(scope.allComponentsList)){
                  for (let config of scope.allMappingConfig) {
                    config = ImportTransferLayerFactory.updateConfigToLastVersion(config);
                  }
                }
                break;
              case 204: // no content
                scope.allMappingConfig = [];
                break;
            }
            require('toastr').success($filter('translate')
            ('common.configuration_loaded'));
          }, err => {
            require('toastr').error($filter('translate')
            ('common.configuration_not_loaded'));
            gaDomUtils.hideGlobalLoader(CONFIG_GET_LIST);
          });
        };

        /**
         * take a config as saved in the repo and display it in the widget
         * @param {*} configToLoad
         */
        const loadWidgetWithConfig = (configToLoad) => {
          scope.showNonGeographicComponents = !scope.geographicComponentsList.find(fti => fti.uid===configToLoad.sourceComponentFtid);

          scope.currentConfig = angular.copy(configToLoad);

          // remplir rawJointureData pour correspondre au format
          // attendu par gcImportLayer.
          scope.rawJointureData.maj_component = scope.currentConfig.configByLayer[0].updateFeatures;
          if (scope.currentConfig.configByLayer[0].updateFeatures && scope.currentConfig.configByLayer[0].jointureSourceAttribute
            && scope.currentConfig.configByLayer[0].jointureDestinationAttribute) {

            scope.rawJointureData.attribut = scope.currentConfig.configByLayer[0].jointureSourceAttribute;
            const ftiDestination = scope.allComponentsList.find( fti => fti.uid === scope.currentConfig.destinationComponentFtid);
            if (ftiDestination) {
              scope.rawJointureData.value = ftiDestination.attributes.find(
                attribute => attribute.name === scope.currentConfig.configByLayer[0].jointureDestinationAttribute);
            }
          }
          scope.initDualBoxAssociations(true);
        };

        scope.onConfigPicked = () => {
          scope.disableInput = false;
          const selectedConfig = scope.allMappingConfig.find(config => config.configName === scope.selectedMappingConfig);
          if (typeof selectedConfig === 'object') {
            loadWidgetWithConfig(selectedConfig);
          } else {
            setDefaultValues();
          }
        };

        scope.onConfigNameChange = () => {
          if (scope.newConfigName) {
            scope.newConfigName = scope.newConfigName.replaceAll(' ', '_');
            //remove all special characters
            scope.newConfigName = scope.newConfigName.replaceAll( /[^a-z0-9_]/gi, '');
          }

          if (scope.newConfigName) {
            scope.isConfigNameValid = scope.allMappingConfig
              .find(config => config.configName === scope.newConfigName) === undefined;
          } else {
            scope.isConfigNameValid = false;
          }
        };
        scope.transferSuccessful = {
          value: false
        };
        scope.startLayerTransfer = () => {

          gaDomUtils.showGlobalLoader(CONFIG_DO_TRANSFER_LAYER);
          let parameters =  {
            sourceComponentFtid: scope.currentConfig.sourceComponentFtid,
            destinationComponentFtid: scope.currentConfig.destinationComponentFtid,
            filterOnData : scope.currentConfig.filterOnData,
            associationToLoad: scope.currentConfig.associationToLoad,
            applyBusinessRules: scope.currentConfig.configByLayer[0].applyBusinessRules.value,
            deleteSourceLayer: scope.currentConfig.configByLayer[0].deleteSourceLayer.value,
            fieldsMapping: scope.currentConfig.configByLayer[0].fieldsMapping,
            defaultValues: scope.currentConfig.configByLayer[0].defaultValues,
            updateFeatures: scope.currentConfig.configByLayer[0].updateFeatures,
            jointureSourceAttribute: scope.currentConfig.configByLayer[0].jointureSourceAttribute,
            jointureDestinationAttribute: scope.currentConfig.configByLayer[0].jointureDestinationAttribute,
            filterSelection:[]
          };

          // Quand on efface une valeur par défaut dans un mapping de champ
          // la valeur par défaut devient null au lieu de se supprimer
          purgeNullDefaultValues();

          if(scope.useCurrentSelection && Array.isArray(scope.featuresToTransfer)){
            parameters.filterSelection= scope.featuresToTransfer.map(feature => feature.id);
          }
          ImportTransferLayerFactory.doTransferLayerFromWidget(parameters).then((res) => {
            require('toastr').success($filter('translate')('model.featuretypes.import_shape.validLayerTransfer')
                              .replace('$1',Object.keys(res.data.createdFids).length));
             // Sauvegarder les résultats, y compris l'URL du journal dans scope.transferResult
            scope.transferResult = res.data; // res.data contient maintenant l'URL du journal
            $timeout(() => {
              scope.transferSuccessful.value = true;
            });
          }, (error) => {
            switch (error.status) {
              case 400:
                console.error('TransferLayerWidget: config is wrong');
                break;
              case 500:
                require('toastr').error($filter('translate')('model.featuretypes.import_shape.failedLayerTransfer'));
                console.error('error doTransferLayerFromWidget: ' + error.data);
                break;
              default:
                console.error('error doTransferLayerFromWidget unknown error');
                break;
            }
          }).finally(() => {
            gaDomUtils.hideGlobalLoader(CONFIG_DO_TRANSFER_LAYER);
          });
        };

        scope.downloadJournal = () => {
          // Vérifie si l'URL du journal est disponible
          if (scope.transferSuccessful && scope.transferResult.journalUrl) {
            const journalUrl = scope.transferResult.journalUrl;
            window.open(ImportTransferLayerFactory.downloadJournal(journalUrl)); // Lance le téléchargement directement
          } else {
            require('toastr').error($filter('translate')('model.featuretypes.import_shape.noJournalAvailable'));
          }
        };
        /**
         * Quand on efface une valeur par défaut dans un mapping de champ
         * la valeur par défaut devient null au lieu de se supprimer de l'objet scope.currentConfig.configByLayer[0].defaultValues
         */
        const purgeNullDefaultValues = () => {
          if (Object.keys(scope.currentConfig.configByLayer[0].defaultValues).length > 0) {
            const defaultValues = {};
            for (const [attrName, defValue] of Object.entries(scope.currentConfig.configByLayer[0].defaultValues)) {
              if (defValue !== null) {
                defaultValues[attrName] = defValue;
              }
            }
            scope.currentConfig.configByLayer[0].defaultValues = defaultValues;
          }
        };

        scope.openWidgetConfig = () => {
          ngDialog.open({
            template:
                'js/XG/widgets/mapapp/importTransferLayer/views/dialogs/transfertLayerConfigDialog.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            title: $filter('translate')('importTransferLayerWidget.config.title'),
            scope: scope
          });
        };

        scope.saveWidgetConfig = () => {
          ConfigFactory.add(scope.widgetConfig, 'widgets', scope.ConfigName).then(res => {
            if (res.data === true) {
              require('toastr').success($filter('translate')('importexportwidget.config.SaveSuccessMsg'));
            } else {
              require('toastr').error($filter('translate')('importexportwidget.config.SaveErrorMsg'));
            }
          });
        };

        const getWidgetConfig = () => {
          ConfigFactory.get('widgets', scope.ConfigName).then(
              res => {
                if(res && res.data && res.data !== '') {
                  scope.widgetConfig = res.data;
                } else {
                  scope.widgetConfig = {};
                }
              },
              () => {
                require('toastr').error($filter('translate')
                ('importexportwidget.config.getConfigErrorMsg'));
              }
          );
        };



        ///--------////
        initWidget();
      },
    };
  };

  importTransferLayerWidget.$inject = [
    'ImportTransferLayerFactory',
    '$filter',
    'FeatureTypeFactory',
    'ngDialog',
    'extendedNgDialog',
    'gaDomUtils',
    'ConfigFactory',
    'QueryFactory',
    '$rootScope',
    'AssociationFactory',
    'gaJsUtils',
    'SelectManager',
    '$timeout'
  ];
  return importTransferLayerWidget;
});
