'use strict';
define(function () {
  var localisationMultiLevelWidget = function (
    ConfigFactory,
    ngDialog,
    FeatureTypeFactory,
    $filter,
    QueryFactory,
    localisationMultiLevelFactory,
    SelectManager,
    gcPopup,
    gaDomUtils,
    attributeRestrictionsUtils
  ) {
    // widget 'Localisation par niveaux de découpage'
    return {
      templateUrl:
        'js/XG/widgets/mapapp/localisationMultiLevel/views/localisationMultiLevelWidget.html',
      restrict: 'A',
      link: function (scope) {
        const SAVE_CONFIG_DIRECTORY = 'localisationMultiLevelWidget';
        const WIGET_NAME = 'localisationMultiLevelWidget';
        const CONFIG_LOAD = "CONFIG_LOAD" + WIGET_NAME;
        const CONFIG_SAVE = "CONFIG_SAVE" + WIGET_NAME;
        const DROPDOWN_LOADING = "DROPDOWN_LOADING" + WIGET_NAME;

        const WITHIN = 'WITHIN';
        
        //init function
        const initWidget = () => {
          // init listes deroulantes array
          scope.pickedValues = [];
          // init all dropdown of the widget
          scope.allDropdownValues = [];
          if (scope.config.levels.length > 0) {
            initDropDownAtIndex(0);
          }
        };

        const getWidgetConfigThenInitWidget = () => {
          gaDomUtils.showGlobalLoader(CONFIG_LOAD);
          ConfigFactory.get(SAVE_CONFIG_DIRECTORY, scope.ConfigName).then((res) => {
              gaDomUtils.hideGlobalLoader(CONFIG_LOAD);
              if (res.data) {
                scope.config = res.data;
              } else {
                scope.config = getDefaultConfiguration();
              }
              initWidget();
            }, err => {
              gaDomUtils.hideGlobalLoader(CONFIG_LOAD);
            });
        };

        const initDropDownAtIndex = (index) => {
          // remove further data that will be reloaded anyway
          scope.allDropdownValues.splice(index);
          if (scope.config.levels.length > index) {
            const currentLevelConfig = scope.config.levels[index];
            const nextLevelConfig = scope.config.levels[index+1];
            const superiorLevelConfig = scope.config.levels[index-1];
            // we need to get this attribute to avoid bugs if a non-spacial level is under a spacial one.
            // this attribute will be used to filter the level underneath.
            const extraAttributeName = (nextLevelConfig && !nextLevelConfig.isSpacialSearch) ?
              nextLevelConfig.filterAttributeAtSuperiorLevel : "";

            if (typeof currentLevelConfig === 'object') {
              const currentLevelFti = FeatureTypeFactory.getFeatureByName(currentLevelConfig.ftiName);
              if (currentLevelFti && currentLevelFti.uid) {
                if (!currentLevelConfig.isSpacialSearch) {
                  if (index === 0 || (index > 0 && scope.pickedValues[index-1])) {
                    //this where clause will filter values with the data picked in the superior dropdown
                    let whereClause = '';
                    if (currentLevelConfig.filterAttributeAtSuperiorLevel
                      && scope.pickedValues[index-1] && scope.pickedValues[index-1][currentLevelConfig.filterAttributeAtSuperiorLevel]) {
                      whereClause = currentLevelConfig.filterAttributeAtCurrentLevel + 
                        " = '" + scope.pickedValues[index-1][currentLevelConfig.filterAttributeAtSuperiorLevel] + "'";
                    }

                    gaDomUtils.showGlobalLoader(DROPDOWN_LOADING);
                    QueryFactory.dataattributes(currentLevelFti.uid, currentLevelConfig.pickAttribute, extraAttributeName, whereClause)
                      .then((res) => {
                        gaDomUtils.hideGlobalLoader(DROPDOWN_LOADING);
                        if (res.data) {
                          updateDropdownWithData(res.data, index, currentLevelFti);
                        }
                      }, error => {
                        gaDomUtils.hideGlobalLoader(DROPDOWN_LOADING);
                        switch (error.status) {
                          case 401:
                            // Non-Autorisé
                            require('toastr').error($filter('translate')('rights.restriction.cant_access_layer') 
                                + currentLevelFti.name + ' (uid: ' + currentLevelFti.uid + ')');
                            break;
                          default:
                            require('toastr').error($filter('translate')('common.error'));
                            break;
                        }
                      });
                  }
                } else {
                  // first level should be configured as spacial search
                  if (index>0 && superiorLevelConfig && scope.pickedValues[index-1] &&
                    scope.pickedValues[index-1].fid && scope.pickedValues[index-1].fid.indexOf('.')> -1) {
                    const superiorLevelFti = FeatureTypeFactory.getFeatureByName(superiorLevelConfig.ftiName);
                    //get the feature that intersect the one we picked
                    gaDomUtils.showGlobalLoader(DROPDOWN_LOADING);
                    localisationMultiLevelFactory.localisationMultiLevelSpacial(
                      superiorLevelFti.uid,
                      scope.pickedValues[index-1].fid.split('.')[1],
                      currentLevelFti.uid,
                      currentLevelConfig.pickAttribute,
                      currentLevelConfig.spacialBuffer,
                      currentLevelConfig.spatialSearchOperator,
                      extraAttributeName,
                      currentLevelConfig.ftiName
                      ).then((res) => {
                        if (res.data) {
                          updateDropdownWithData(res.data, index, currentLevelFti);
                        }
                        gaDomUtils.hideGlobalLoader(DROPDOWN_LOADING);
                      }, err => {
                        gaDomUtils.hideGlobalLoader(DROPDOWN_LOADING);
                      });
                  }
                }
              }
            }
          }
        };

        /**
         * handle the data reloading when value is changed
         * @param {*} index 
         */
        scope.valueChangedAtIndex = (index) => {
          if (index > -1) {
            // empty results under index
            scope.pickedValues.splice(index+1);
            // reload values for next dropdown
            initDropDownAtIndex(index+1);
          }
        }

        /**
         * update a Dropdown with the data from a featureCollection
         * @param {object} data: featureCollection
         * @param {integer} index of the dropdown to update
         * @param {object} currentLevelFti fti corresponding to the dropdown at {index}
         */
        const updateDropdownWithData = (data, index, currentLevelFti) => {
          if (data && Array.isArray(data.features)) {

            const currentLevelConfig = scope.config.levels[index];
            const attribute = currentLevelFti.attributes.find(
              it => it.name === currentLevelConfig.pickAttribute);
            const domainRestriction = attribute && Array.isArray(attribute.restrictions) ?
              attribute.restrictions.find(restriction => restriction.type === attributeRestrictionsUtils.DOMAIN) : undefined;
            const tableRestriction = attribute && Array.isArray(attribute.restrictions) ?
              attribute.restrictions.find(restriction => restriction.type === attributeRestrictionsUtils.TABLE) : undefined;

            scope.allDropdownValues[index] = data.features.map(feature => {
              let result = feature.properties;
              result.fid = feature.id;
              if (domainRestriction && typeof domainRestriction.listofValues === 'object'
                && domainRestriction.listofValues.hasOwnProperty(feature.properties[currentLevelConfig.pickAttribute])) {
                // handle domain restrictions
                result.valueToDisplay_ = domainRestriction.listofValues[feature.properties[currentLevelConfig.pickAttribute]];
              } else if (tableRestriction) {
                // handle table restrictions
                QueryFactory.getValueRestrictionTable(currentLevelFti.uid, attribute.name, feature.properties[currentLevelConfig.pickAttribute])
                .then(res => {
                  if (res.data && res.data.value) {
                    result.valueToDisplay_ = res.data.value;
                  } else {
                    result.valueToDisplay_ = '';
                  }
                });
              } else {
                result.valueToDisplay_ = feature.properties[currentLevelConfig.pickAttribute];
              }
              return result
            });
            scope.allDropdownValues.splice(index+1);
          }
        };

        /**
         * localise the most precise data picked
         * (wich is the highest non-null index in scope.pickedValues)
         */
        scope.localiseData = () => {
          let mostPreciseLevel; // index in scope.pickedValues
          // most precise level may not be scope.pickedValues.length-1
          for (let index in scope.pickedValues) {
            if (scope.pickedValues[index] && scope.pickedValues[index].fid) {
              mostPreciseLevel = index;
            }
          }
          console.log("LocalisationMultiLevelWidget: Trying to localise index " + mostPreciseLevel);
          if (mostPreciseLevel && Array.isArray(scope.allDropdownValues[mostPreciseLevel])
            && scope.config.levels[mostPreciseLevel]) {
            const attributeName = scope.config.levels[mostPreciseLevel].pickAttribute;
            const featureCompleteId = scope.pickedValues[mostPreciseLevel].fid;
            if (featureCompleteId.indexOf('.')>-1) {
              const a = featureCompleteId.split('.');
              const featureTypeName = a[0];
              const fid = a[1];
              const fti = FeatureTypeFactory.getFeatureByName(featureTypeName);
              QueryFactory.get(fti.uid, fid).then((res) => {
                  if (res.data && Array.isArray(res.data.features)
                    && res.data.features.length > 0) {
                    SelectManager.addFeaturesFromGeojson(res.data);

                    if (scope.popup) {
                      scope.popup.destroy();
                    }

                    scope.popup = gcPopup.open({
                      scope: scope.$new(),
                      title: 'Informations : ',
                      content: '<div selectfeaturetreewidget></div>',
                      showClose: true,
                      onclose: function() {
                        SelectManager.clear();
                      },
                    });
                  }
                })
            }
          }
        }


        /**
         * 
         *  CONFIGURATION DIALOG
         * 
         */

        /**
         * init with the default configuration
         */
        const getDefaultConfiguration = () => {
          return { levels: [] };
        };

        /**
         * open the configuration dialog
         */
        scope.openConfig = () => {
          getSurfaceComponents();
          scope.configNotSaved = angular.copy(scope.config);
          ngDialog.openConfirm({
            template:
              'js/XG/widgets/mapapp/localisationMultiLevel/views/localisationMultiLevelConfig.html',
            className:
              'ngdialog-theme-plain overflowY width800 nopadding miniclose',
            scope: scope,
          }).then(
              (data) => {
                scope.saveConfig();
                require('toastr').info(data);
              },
              (data) => {
                require('toastr').info(data);
              }
            );
        };

        /**
         * save the widget's configuration
         */
        scope.saveConfig = () => {
          gaDomUtils.showGlobalLoader(CONFIG_SAVE);
          ConfigFactory.add(scope.configNotSaved, SAVE_CONFIG_DIRECTORY, scope.ConfigName).then((res) => {
              if (res.data==true) {
                scope.config = scope.configNotSaved;
                initWidget();
                require('toastr').success($filter('translate')
                  ('common.configuration_saved'));
              } else {
                require('toastr').error($filter('translate')
                  ('common.configuration_not_saved'));
              }
              gaDomUtils.hideGlobalLoader(CONFIG_SAVE);
            }, err => {
              require('toastr').error($filter('translate')
              ('common.configuration_not_saved'));
              gaDomUtils.hideGlobalLoader(CONFIG_SAVE);
            });
        };

        /**
         * récupère tous les composants surfacique du portail
         */
        const getSurfaceComponents = () => {
          FeatureTypeFactory.get().then((components) => {
              scope.surfaceComponentsList = components.filter(
                (component) => component.geographic===true &&
                (component.typeInfo==="POLYGON" || component.typeInfo==="MULTIPOLYGON")
                );
            });
        };

        /**
         *  add a new level to the config
         * @param {Object} addLevelSelection fti of the component
         */
        scope.addLevel = (addLevelSelection) => {
          if (addLevelSelection && addLevelSelection.name && addLevelSelection.alias) {
            let newLevel = {
                ftiName: addLevelSelection.name,
                customAlias: addLevelSelection.alias,
                pickAttribute: undefined
              };
            // there is less data in the first level of the config
            if (scope.configNotSaved.levels.length > 0) {
              newLevel.filterAttributeAtCurrentLevel = undefined;
              newLevel.filterAttributeAtSuperiorLevel = undefined;
              newLevel.isSpacialSearch = false;
              newLevel.spatialSearchOperator = WITHIN;
              newLevel.spacialBuffer = 0;
            }
            scope.configNotSaved.levels.push(newLevel);
          }
        };

        /**
         * remove a level in the configuration
         * @param {int} index 
         */
        scope.removeLevel = (index) => {
          scope.configNotSaved.levels.splice(index, 1);
          if (index===0 && scope.configNotSaved.levels[0]) {
            // Le (nouveau) premier element n'a pas besoin de ces attributs
            delete scope.configNotSaved.levels[0].filterAttributeAtCurrentLevel;
            delete scope.configNotSaved.levels[0].filterAttributeAtSuperiorLevel;
            delete scope.configNotSaved.levels[0].isSpacialSearch;
            delete scope.configNotSaved.levels[0].spacialBuffer;
          }
        };

        /**
         * get the 'attributes' array from an fti
         * @param {*} index of the level in the unsaved config
         * @returns the attributes array
         */
        scope.getAttributesForLevel = (index) => {
          if (Array.isArray(scope.configNotSaved.levels) && scope.configNotSaved.levels.length > index
            && scope.surfaceComponentsList) {
            const ftiName = scope.configNotSaved.levels[index].ftiName;
            const fti = scope.surfaceComponentsList.find(component => component.name === ftiName);
            if (fti) {
              return fti.attributes;
            } else {
              require('toastr').error($filter('translate')
              ('localisationMultiLevelWidget.componentNotFound')
              + scope.configNotSaved.levels[index].ftiName);
              return [];
            }
          }
          return [];
        };

        getWidgetConfigThenInitWidget();
      },
    };
  };

  localisationMultiLevelWidget.$inject = [
    'ConfigFactory',
    'ngDialog',
    'FeatureTypeFactory',
    '$filter',
    'QueryFactory',
    'localisationMultiLevelFactory',
    'SelectManager',
    'gcPopup',
    'gaDomUtils',
    'attributeRestrictionsUtils'
  ];
  return localisationMultiLevelWidget;
});
