/**
 *
 */
'use strict';
define(function() {
  var gcWFS = function() {
    this.$get = function(
      gcPropertiesLayers,
      gcMapUtils,
      gaUrlUtils,
      ogcFactory,
      $http,
      $q,
      PortalsFactory
    ) {
      var Wfs = function() {
        var createWfsLayer = function(params, options, isEsri, filters) {
          options = options || {};
          if(angular.isDefined(params.FLAYERS))
          {
            var names = "";

            angular.forEach(params.FLAYERS, function(fti) {
               names = names + fti.name + ',';
            });
            names = names.substr(0,names.length -1 );

            options.label = names;
            options.name = names;
          }
          var attributions;
          var spatialsClauses = [];
          var promises = [];
          var geojsonFormat = new ol.format.GeoJSON();

          let loaderGoeserver = function(extent, resolution, projection) {
            var leftX = extent[0];
            var bottomY = extent[1];

            var rightX = extent[2];
            var topY = extent[3];
            /**
             * PPWSA deux portails avec mme nom d'objet : wfs ne reconnait pas
             */
            var n = params.LAYERS;
            try {
              var layernames = params.LAYERS.split(',');
              var n = layernames
                .map(function(x) {
                  return PortalsFactory.getPortalId() + ':' + x;
                })
                .join(',');
            } catch (e) {
              console.error(e.stack);
            }
            var spatialClause =
              'INTERSECTS(geom, POLYGON((' +
              leftX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              bottomY +
              ')))';
            var catchments_url =
              '/services/' +
              PortalsFactory.getPortalId() +
              '/geoserver/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=' +
              n +
              '&outputformat=json&srsName=' +
              projection.getCode() +
              '&bbox=' +
              extent +
              ',' +
              projection.getCode();
            /*if ( spatialsClauses.map(function(x){return ol.extent.containsExtent(x, extent);}).filter(function(x){
                     if ( x ) return x;
                   }).length === 0 ){
                     var defer = $q.defer();
                     defer.promise.id = Math.round();
                     $q.all(promises).then(function(){
                       var promise = ogcFactory.getfeatures('GetFeature', 'WFS', '1.0.0', params.LAYERS, 'json', options.srsname, spatialClause);
                       promise.then(function(response){
                          if ( response.totalFeatures !== 0 )
                              source.addFeatures(geojsonFormat.readFeatures(response.data));
                          defer.resolve();
                          spatialsClauses.push(extent);
                          var idx = promises.map(function(x){return x.id;}).indexOf(defer.promise.id);
                          if ( ~idx )
                            promises.splice(idx , 1);
                       }, function(){
                          defer.resolve();
                          var idx = promises.map(function(x){return x.id;}).indexOf(defer.promise.id);
                          if ( ~idx )
                            promises.splice(idx , 1);
                       });
                     });
                     promises.push(defer.promise);
                 }*/
            //var promise = ogcFactory.getfeatures('GetFeature', 'WFS', '1.0.0', params.LAYERS, 'json', options.srsname, spatialClause);
            var promise = $http.get(catchments_url);
            var promise2 = promise.then(function(response) {
              if (
                response.data &&
                ((response.data.totalFeatures &&
                  response.data.totalFeatures > 0) ||
                  (response.data.features &&
                    response.data.features.length > 0))
              )
                source.addFeatures(geojsonFormat.readFeatures(response.data));
            });
          }

          let loaderEsri = function(extent, resolution) {

            function getClause(ftiUid, filters, spatialClause) {
              var ind;

              for (ind = 0; ind < filters.length; ind++) {
                if (filters[ind].ftiUid == ftiUid) {
                  return spatialClause + ' AND ' + filters[ind].filter;
                }
              }
              return spatialClause;
            }

            function addFeaturesToSnapLayer(response) {
              if (response.totalFeatures !== 0)
                source.addFeatures(geojsonFormat.readFeatures(response.data));
              if (response.data.totalFeatures !== 0) {
                var features = geojsonFormat.readFeatures(response.data);
                console.log(features.length);
                for (var i = 0; i < features.length; i++) {
                  var feature = features[i];
                  //if(ol.extent.intersects(filExtent, feature.getGeometry().getExtent()))
                  //source.addFeature(feature);
                }
              }

              if (
                angular.isDefined(response.data.unrenderedFtisNames) &&
                response.data.unrenderedFtisNames.length > 0
              ) {
                require('toastr').warning(
                  'Unable to do snapping at this scale. Too many features to render'
                );
              }
            }

            source.set('resolution', resolution);

            var leftX = extent[0];
            var bottomY = extent[1];

          var rightX = extent[2];
          var topY = extent[3];

          var exGeomCql = 'POLYGON((' + leftX + ' ' + bottomY + ',' + rightX + ' ' + bottomY +
                  ',' + rightX + ' ' + topY + ',' + leftX +
                  ' ' + topY + ',' + leftX + ' ' + bottomY + '))';

          var spatialClause  = 'INTERSECTS(geom, '+ exGeomCql +')';
          var typesNames;

          if (angular.isDefined(params.MAP) && angular.isDefined(params.FLAYERS))
              {
              typesNames = "";
              var names = "";

              angular.forEach(params.FLAYERS, function(l) {
                if(gcMapUtils.layerIsVisible(params.MAP, l))
                {
                  var fti = l.fti;
                    typesNames = typesNames+fti.uid +",";
                }
              });
              if(typesNames.length > 0)
                typesNames = typesNames.substr(0,typesNames.length -1 );
              }
          else
              typesNames = params.LAYERS;

          console.log(typesNames);
          if(typesNames.length == 0) {
                source.clear(true);
                source.set('NoFtiToRender', true);
              }
          else
             {
              if (filters == undefined) {
                  var promise = ogcFactory.getfeatures('GetFeature', 'WFS', '1.0.0', params.uids, 'json', options.srsname, spatialClause, null, null, true);
                  // var promise = $http.get(catchments_url);
                  promise.then(function(response){
                      addFeaturesToSnapLayer (response);
                 });
              }
              else {
                  var ftiUids = typesNames.split(",");
                  var ind, promise;

                  for (ind=0;ind<ftiUids.length;ind++) {
                       promise = ogcFactory.getfeatures('GetFeature', 'WFS', '1.0.0', params.uids, 'json', options.srsname, getClause(ftiUids[ind],filters,spatialClause), null, null, true);
                      // var promise = $http.get(catchments_url);
                      promise.then(function(response){
                          addFeaturesToSnapLayer (response);
                     });
                  }
              }
          }
         }
          
          let loaderToUse = isEsri ? loaderEsri : loaderGoeserver;

          var source = new ol.source.Vector({
            loader: loaderToUse,
            /*strategy: ol.loadingstrategy.tile(ol.tilegrid.createXYZ({
                  maxZoom: 19
                })),*/
            strategy: ol.loadingstrategy.bbox,
          });
          var layer = new ol.layer.Vector({
            source: source,
            opacity: options.opacity,
            visible: options.visible,
            theme: options.theme,
            name: options.name,
            type: 'wfs',
            style: new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: 'rgba(181, 78, 16, 0.8)',
                width: 2,
              }),
            }),
          });
          /*          var layer = new ol.layer.Image({
            id: 'WMS||' + options.label + '||' + options.url + '||' +
                params.LAYERS,
            url: options.url,
            type: 'WMS',
            opacity: options.opacity,
            visible: options.visible,
            attribution: options.attribution,
            source: source
          });*/
          gcPropertiesLayers(layer);
          layer.preview = options.preview;
          layer.displayInLayerManager = !layer.preview;
          layer.label = options.label;
          return layer;
        };
        this.getOlLayerFromGetCapLayer = function(getCapLayer) {
          var wfsParams = {
            LAYERS:
              getCapLayer.id /*FeaturetypeInfo.uid*/ /*'2876e39a-f795-4122-b6eb-49bab16eb066,271340c8-bb22-49a1-8b4f-5c665f15e477'*/,
            TILED: true,
          };
          var wfsOptions = {
            //url: 'http://localhost:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
            url: getCapLayer.wfsUrl,
            label: getCapLayer.Title,
            srsname: 'EPSG:900913',
            /*theme:FeaturetypeInfo.theme,
              name:FeaturetypeInfo.name,*/
            //extent: getCapLayer.extent,
            //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
          };
          ////////////////////////////////////////////////////////
          ///
          ////////////////////////////////////////////////////////
          var options = wfsOptions || {};
          var attributions;
          var gmlFormat = new ol.format.GML2();

          var catchments_url =
            getCapLayer.wfsUrl +
            '&service=WFS&version=1.1.0&request=GetFeature&typename=' +
            getCapLayer.Name +
            '&srsname=EPSG:900913';
          var promise = $http.get(catchments_url);

          var source = new ol.source.Vector({
            /* loader: function(extent, resolution, projection) {

                          var catchments_url =getCapLayer.wfsUrl +
                              '&service=WFS&version=1.1.0&request=GetFeature&typename='+getCapLayer.Name+'&' +
                              'outputFormat=GML3&format_options=callback:loadFeatures' +
                              '&srsname=EPSG:900913&bbox=' + extent.join(',') + ',EPSG:900913';

                         var promise = $http.get(catchments_url);
                           var promise2 =promise.then(function(response){
                              if ( response.totalFeatures !== 0 )
                                  source.addFeatures(geojsonFormat.readFeatures(response.data));
                           });


                      },
                      strategy: ol.loadingstrategy.tile(ol.tilegrid.createXYZ({
                        maxZoom: 19
                      })),*/
          });

          promise.then(function(response) {
            var featsl = gmlFormat.readFeatures(response.data);
            var source = new ol.source.Vector({
              features: featsl,
            });

            var layer = new ol.layer.Vector({
              source: source,
              opacity: options.opacity,
              visible: options.visible,
              theme: options.theme,
              name: options.name,
              type: 'wfs',
              style: new ol.style.Style({
                stroke: new ol.style.Stroke({
                  color: 'rgba(181, 78, 16, 0.8)',
                  width: 2,
                }),
              }),
            });
            /*          var layer = new ol.layer.Image({
                  id: 'WMS||' + options.label + '||' + options.url + '||' +
                      params.LAYERS,
                  url: options.url,
                  type: 'WMS',
                  opacity: options.opacity,
                  visible: options.visible,
                  attribution: options.attribution,
                  source: source
                });*/
            gcPropertiesLayers(layer);
            layer.preview = options.preview;
            layer.displayInLayerManager = !layer.preview;
            layer.label = options.label;
            return layer;
            //console.log(featsl.length);
            //   source.addFeatures(featsl);
          });

          //};

          //return createWfsLayer(wfsParams, wfsOptions);
        };

        // Create an ol WMS layer from FeatureTypeInformation informations
        this.getOlLayerFromFeaturetypeInfoArray = function(FeaturetypeInfos, map, filterExtent) {
          var typeNames = '';
          var names = '';
          let uids = '';

          angular.forEach(FeaturetypeInfos, function(fti) {
            typeNames = typeNames + fti.name + ',';
            names = names + fti.name;
            uids += fti.uid + ",";
          });
          typeNames = typeNames.substr(0, typeNames.length - 1);
          var wfsParams = {
            LAYERS: typeNames /*FeaturetypeInfo.uid*/ /*'2876e39a-f795-4122-b6eb-49bab16eb066,271340c8-bb22-49a1-8b4f-5c665f15e477'*/,
            TILED: true,
            uids: uids
          };
          let crs = map.getView().getProjection().getCode();
          var wfsOptions = {
            //url: 'http://localhost:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
            url:
              '/services/' +
              PortalsFactory.getPortalId() +
              '/ogc/wfs?token=' + localStorage.auth_token + '&',
            label: names,
            name: names,
            srsname: crs,
            /*theme:FeaturetypeInfo.theme,
            name:FeaturetypeInfo.name,*/
            //extent: getCapLayer.extent,
            //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
          };
          let isEsri  = null
          if ((FeaturetypeInfos) && (FeaturetypeInfos[0])) {
            isEsri = (FeaturetypeInfos[0].type == "esri");
          }

          return createWfsLayer(wfsParams, wfsOptions, isEsri, filterExtent);
        };
        this.getOlLayerFromFeaturetypeInfo = function(FeaturetypeInfo) {
          if (FeaturetypeInfo.type == 'esri') {
            var wfsParams = {
              LAYERS:
                FeaturetypeInfo.name /*FeaturetypeInfo.uid*/ /*'2876e39a-f795-4122-b6eb-49bab16eb066,271340c8-bb22-49a1-8b4f-5c665f15e477'*/,
              TILED: true,
            };
            var wfsOptions = {
              //url: 'http://localhost:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
              url: FeaturetypeInfo.wfs,
              label: FeaturetypeInfo.alias,
              srsname: 'EPSG:3857',
              /*theme:FeaturetypeInfo.theme,
              name:FeaturetypeInfo.name,*/
              //extent: getCapLayer.extent,
              //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
            };
          } else {
            var wfsParams = {
              LAYERS:
                FeaturetypeInfo.name /*FeaturetypeInfo.uid*/ /*'2876e39a-f795-4122-b6eb-49bab16eb066,271340c8-bb22-49a1-8b4f-5c665f15e477'*/,
              TILED: true,
            };
            var wfsOptions = {
              //url: 'http://localhost:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
              url:
                '/services/' +
                PortalsFactory.getPortalId() +
                '/ogc/wfs?token=007&',
              label: FeaturetypeInfo.alias,
              srsname: 'EPSG:3857',
              /*theme:FeaturetypeInfo.theme,
              name:FeaturetypeInfo.name,*/
              //extent: getCapLayer.extent,
              //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
            };
          }

          return createWfsLayer(wfsParams, wfsOptions);
        };
        //Create WFS layer from WMS Layer
        this.getOlLayerFromWMSLayer = function(layer) {
          console.log(layer);
          if (layer.fti.type == 'esri') {
            var wmsParams = { LAYERS: layer.fti.name, TILED: true };
            var wmsOptions = {
              //url: 'http://localhost:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
              url: layer.fti.wfs,
              label: layer.label + ' Vector',
              uid: layer.uid,

              //extent: getCapLayer.extent,
              //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
            };
          } else {
            var wmsParams = { LAYERS: layer, TILED: true };
            var wmsOptions = {
              //url: 'http://localhost:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
              url:
                '/services/' +
                PortalsFactory.getPortalId() +
                '/ogc/wfs?token=007&',
              label: layer.label + ' Vector',
              uid: layer.uid,

              //extent: getCapLayer.extent,
              //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
            };
          }
          return createWfsLayer(wmsParams, wmsOptions);
        };
        // Create a WMS layer and add it to the map
        this.addWfsToMap = function(map, layerParams, layerOptions, index) {
          var olLayer = createWfsLayer(layerParams, layerOptions);
          if (index) {
            map.getLayers().insertAt(index, olLayer);
          } else {
            map.addLayer(olLayer);
          }
          return olLayer;
        };
      };
      return new Wfs();
    };
    this.$get.$inject = [
      'gcPropertiesLayers',
      'gcMapUtils',
      'gaUrlUtils',
      'ogcFactory',
      '$http',
      '$q',
      'PortalsFactory',
    ];
  };

  return gcWFS;
});
