/**
 *
 */
'use strict';
define(function() {
  var gcWMS = function() {
    this.$get = function(
      gcPropertiesLayers,
      gcMapUtils,
      gaUrlUtils,
      DataStoreFactory,
      gaJsUtils,
      PortalsFactory
    ) {
      var Wms = function() {
        var createTiledWmsLayer = function(params, options, index) {
          options = options || {};
          var attributions;

          /*if (options.attribution) {
            attributions = [
              gaMapUtils.getAttribution(options.attribution)
            ];
          }*/
          var source = new ol.source.TileWMS({
            params: params,
            url: options.url,
            extent: options.extent,
            attributions: attributions,
            ratio: options.ratio || 1,
          });

          var layer = new ol.layer.Tile({
            id:
              'WMS||' +
              options.label +
              '||' +
              options.url +
              '||' +
              params.LAYERS,
            url: options.url,
            type: 'WMS',
            opacity: options.opacity,
            visible: options.visible,
            attribution: options.attribution,
            fti: options.fti,
            name: options.name,
            source: source,
          });
          gcPropertiesLayers(layer);
          layer.preview = options.preview;
          layer.displayInLayerManager = !layer.preview;
          layer.label = options.label;
          return layer;
        };

        function getFtiDataStore(fti) {
          if (
            DataStoreFactory.resources &&
            DataStoreFactory.resources.datastores
          )
            for (
              var i = 0;
              i < DataStoreFactory.resources.datastores.length;
              i++
            ) {
              var dataStore = DataStoreFactory.resources.datastores[i];
              if (fti.storeName == dataStore.name) return dataStore;
            }

          return null;
        }
        var createWmsLayer = function(params, options, index) {
          options = options || {};
          var attributions;
          if (angular.isUndefined(params.WIDTH)) params.WIDTH = 256;
          if (angular.isUndefined(params.HEIGHT)) params.HEIGHT = 256;

          /*if (options.attribution) {
            attributions = [
              gaMapUtils.getAttribution(options.attribution)
            ];
          }*/
          var source = new ol.source.ImageWMS({
            params: params,
            url: options.url,
            extent: options.extent,
            attributions: attributions,
            ratio: options.ratio || 1,
          });
          source.setImageLoadFunction(gaJsUtils.customLoader);
          var layer = new ol.layer.Image({
            id:
              'WMS||' +
              options.label +
              '||' +
              options.url +
              '||' +
              params.LAYERS,
            url: options.url,
            type: 'WMS',
            //filter: options.filter,
            //opacity: options.opacity,
            visible: options.visible,
            attribution: options.attribution,
            fti: options.fti,
            index: options.index,

            theme: options.theme,
            name: options.name,
            gctype: options.gctype,
            selected: options.selected,
            source: source,
          });
          gcPropertiesLayers(layer);
          //console.log(layer);
          layer.preview = options.preview;
          layer.displayInLayerManager = !layer.preview;
          layer.label = options.label;
          //fa2c1fc6-a914-4dec-a7a2-788c910eb32a/wms?
          if (angular.isDefined(layer.fti) && layer.fti.type == 'g2c') {
            layer.legend =
              '/services/{portalid}/printLegend' +
              '/getLegendGraphic?&WIDTH=20&HEIGHT=20' +
              '&LAYER=' +
              options.name;
            if (!angular.isUndefined(layer.style)) {
              layer.legend += '&STYLE=' + layer.style;
            }
          } else if (angular.isDefined(layer.fti) && layer.fti.type == 'esri') {
            var fti = layer.fti;
            var ftiDataStore = getFtiDataStore(fti);
            var dynamicLayer = [
              {
                id: fti.ogcId,
                source: {
                  type: 'mapLayer',
                  mapLayerId: fti.ogcId,
                },
                drawingInfo: {
                  transpareency: 0,
                },
              },
            ];
            var layersArrayStr = JSON.stringify(dynamicLayer);
            layer.legend =
              '../services/esriproxy/' + ftiDataStore.proxykey + '/MapServer';
            layer.legend +=
              '/legend?f=json&dynamicLayers=' +
              encodeURIComponent(layersArrayStr);

            /*
            if (!angular.isUndefined(layer.style))
            {
              layer.legend =  options.url + '?service=WMS&REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=20&LAYER='+params.LAYERS+'&STYLE='+layer.style;
            }
            else
            {
              layer.legend =  options.url + '?service=WMS&REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=20&LAYER='+params.LAYERS;
            }
            */
          }
          if (angular.isDefined(layer.fti)) {
            if (
              !angular.isUndefined(options.cql_filter) &&
              options.cql_filter != ''
            ) {
              layer.cql_filter = options.cql_filter;
            }
          }

          if (angular.isDefined(layer.fti) && layer.fti.type == 'esri') {
            if (
              !angular.isUndefined(options.ogcDefinitionExpression) &&
              options.ogcDefinitionExpression != ''
            ) {
              layer.ogcDefinitionExpression = options.ogcDefinitionExpression;
            }
          }
          if (!angular.isUndefined(options.style) && options.style != '') {
            layer.style = options.style;
          }

          if (
            !angular.isUndefined(options.ogcMaxScale) &&
            options.ogcMaxScale != ''
          ) {
            layer.ogcMaxScale = options.ogcMaxScale;
          } else if (
            !angular.isUndefined(options.maxScale) &&
            options.maxScale != ''
          ) {
            layer.maxScale = options.maxScale;
          }

          if (
            !angular.isUndefined(options.ogcMinScale) &&
            options.ogcMinScale != ''
          ) {
            layer.ogcMinScale = options.ogcMinScale;
          } else if (
            !angular.isUndefined(options.minScale) &&
            options.minScale != ''
          ) {
            layer.minScale = options.minScale;
          }

          if (
            !angular.isUndefined(options.invertedOpacity) &&
            options.invertedOpacity != ''
          ) {
            layer.invertedOpacity = options.invertedOpacity;
          }
          //invertedOpacity:options.invertedOpacity,
          layer.selected = options.selected;
          return layer;
        };
        // Create an ol WMS layer from GetCapabilities informations
        this.getOlLayerFromGetCapLayer = function(getCapLayer) {
          if (getCapLayer.type == 'esri') {
            var wmsParams = { LAYERS: getCapLayer.fti.name };
            var wmsOptions = {
              url: getCapLayer.wmsUrl,
              label: getCapLayer.Title,
              extent: getCapLayer.extent,
              /*gctype:"wmsext",
              theme:"WMS",*/
              gctype: 'wmsext',
              theme: 'WMS',
              attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl),
            };
          } else {
            wmsParams = { LAYERS: getCapLayer.Name };
            wmsOptions = {
              url: getCapLayer.wmsUrl,
              label: getCapLayer.Title,
              extent: getCapLayer.extent,
              gctype: 'wmsext',
              theme: 'WMS',
              attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl),
            };
          }
          return createTiledWmsLayer(wmsParams, wmsOptions);
        };
        // Create an ol WMS layer from FeatureTypeInformation informations
        this.getOlLayerFromFeaturetypeInfo = function(FeaturetypeInfo, ind) {
          if (FeaturetypeInfo.type == 'esri') {
            var wmsParams = {
              LAYERS: FeaturetypeInfo.name,
              TILED: false,
              type: 'esri',
            };
            var ogcProperties = FeaturetypeInfo.ogcProperties;
            var wmsOptions = {
              //url: 'http://46.105.100.62:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
              //url:'/wsgi/wms-win-esri.py?url='+FeaturetypeInfo.wms,
              //url:'/geoserver/'+PortalsFactory.getPortalId()+'/wms?token=' +'007',
              //url:'/services/'+PortalsFactory.getPortalId()+'/ogc/g2c?token=' +'007',
              url: FeaturetypeInfo.wms,
              label: FeaturetypeInfo.alias,
              uid: FeaturetypeInfo.uid,
              fti: FeaturetypeInfo,
              name: FeaturetypeInfo.name,
              theme: FeaturetypeInfo.theme,
              //style:FeaturetypeInfo.defaultStyle,
              //theme:"Non Defini",
              invertedOpacity:
                ogcProperties.transparency == 0
                  ? 0
                  : (100 - ogcProperties.transparency) / 100,
              ogcDefinitionExpression: ogcProperties.definitionExpression,
              ogcMaxScale: ogcProperties.minScale,
              ogcMinScale: ogcProperties.maxScale,
              index: ind,
              gctype: 'esri',
              //extent: getCapLayer.extent,
              //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
            };
          } else if (typeof ancAppAndroid !== 'undefined') {
            return false;
          } else {
            var ftiDataStore = getFtiDataStore(FeaturetypeInfo);
            let layerName = FeaturetypeInfo.name;
            if (ftiDataStore.type === 'oracle') {
              layerName = layerName.toUpperCase();
            }
            var wmsParams = {
              LAYERS: layerName,
              TILED: false,
              type: 'g2c',
            };
            var wmsOptions = {
              //url: 'http://46.105.100.62:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
              //url:'/wsgi/wms-win.py?portal='+PortalsFactory.getPortalId()+'&token=' +'007',
              url:
                '/services/' +
                PortalsFactory.getPortalId() +
                '/geoserver/wms?token=' +
                localStorage.auth_token,
              //url:'/services/'+PortalsFactory.getPortalId()+'/ogc/g2c?token=' +'007',
              label: FeaturetypeInfo.alias,
              uid: FeaturetypeInfo.uid,
              fti: FeaturetypeInfo,
              name: layerName,
              theme: FeaturetypeInfo.theme,
              style: FeaturetypeInfo.defaultStyle,
              //theme:"Non Defini",
              index: ind,
              gctype: 'g2c',
              scaleMethod: 'OGC',
              //extent: getCapLayer.extent,
              //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
            };
          }

          return createWmsLayer(wmsParams, wmsOptions);
        };

        //http://46.105.100.62:6080/arcgis/services/ecomed/couchesMetiersl93_v4/MapServer/WmsServer?
        /**
         * [wmsParamsesri description]
         * @type {Object}
         */
        /*this.getOlLayerESRIFromGetCapLayer = function(getCapLayer) {
          var wmsParams = { LAYERS: getCapLayer.Name };
          var wmsOptions = {
            url: getCapLayer.wmsUrl,
            label: getCapLayer.Title,
            extent: getCapLayer.extent,
            gctype:"wmsext",
            theme:"WMS",
            attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
          };
          return createWmsLayer(wmsParams, wmsOptions);
        };*/
        // Create an ol WMS layer from FeatureTypeInformation informations
        /*this.getOlLayerESRIFromFeaturetypeInfo = function(FeaturetypeInfo, ind) {
          var wmsParams = {LAYERS: FeaturetypeInfo.name ,TILED:false , type:'esri' , url : FeaturetypeInfo.wms};
          var wmsOptions = {
            //url: 'http://46.105.100.62:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
            //url:'/wsgi/wms-win.py?portal='+PortalsFactory.getPortalId()+'&token=' +'007',
            //url:'/geoserver/'+PortalsFactory.getPortalId()+'/wms?token=' +'007',
            //url:'/services/'+PortalsFactory.getPortalId()+'/ogc/g2c?token=' +'007',
            url: FeaturetypeInfo.wms,
            label: FeaturetypeInfo.alias,
            uid:FeaturetypeInfo.uid,
            fti:FeaturetypeInfo,
            name:FeaturetypeInfo.name,
            theme:FeaturetypeInfo.theme,
            style:FeaturetypeInfo.defaultStyle,
            //theme:"Non Defini",
            index :ind,
            gctype:"esri"
            //extent: getCapLayer.extent,
            //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
          };

          return createWmsLayer(wmsParams, wmsOptions);
        };*/
        /*this.getOlESRILayerFromMapModelElement = function(MapModelElement) {
          //console.log(MapModelElement,"wms esri")
          //var folder = "ecomed" ; var service = "couchesMetiersl93_v4" ; var service_type = "MapServer"; var ESRI_id = 5; var URL_WMS = "46.105.100.62:6080";
          var wmsParamsesri = { layers: MapModelElement.fti.name , tiled:true, layerDefs : '{"'+MapModelElement.fti.name+'":"'+MapModelElement.cql_filter+'"}' , type:'esri' , url : MapModelElement.fti.wms};
          var wmsOptionsesri = {
              //url: 'http://46.105.100.62:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
             // url:'/services/'+PortalsFactory.getPortalId()+'/ogc/g2c?token=' +'007',
              //url:'http://46.105.100.62:6080/arcgis/services/ecomed/couchesMetiersl93_v4/MapServer/WmsServer?layers=5&styles=&',
              //url: 'http://46.105.100.62:6080/arcgis/services/ecomed/couchesMetiersl93_v4/MapServer/WmsServer?',
              url: MapModelElement.fti.wms,
              //url:'/wsgi/wms-win.py?portal='+PortalsFactory.getPortalId()+'&token=' +'007',
              label: MapModelElement.fti.alias,
              uid:MapModelElement.fti.uid,
              fti:MapModelElement.fti,
              name:MapModelElement.fti.name,
              theme:MapModelElement.theme,
              visible:MapModelElement.visible,
              invertedOpacity : MapModelElement.invertedOpacity,
              cql_filter : MapModelElement.cql_filter,
              layerDefs : '{"'+MapModelElement.fti.name+'":"'+MapModelElement.cql_filter+'"}',
              maxScale : MapModelElement.maxScale,
              minScale : MapModelElement.minScale,
              selected :MapModelElement.selected,
              style : MapModelElement.fti.defaultStyle,
              index : MapModelElement.index,
              //theme:"Non Defini",
              gctype:"esri"
              //extent: getCapLayer.extent,
              //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
          };
          //var wmslayeresri = createTiledWmsLayer(wmsParamsesri,wmsOptionsesri);
          //$scope.map.addLayer(wmslayeresri);
          return createWmsLayer(wmsParamsesri, wmsOptionsesri);
        };*/
        /**
         *
         */

        this.getOlLayerFromMapModelElement = function(MapModelElement) {
          if (MapModelElement.fti.type == 'esri') {
            var wmsParams = {
              layers: MapModelElement.fti.name,
              tiled: true,
              type: 'esri',
            };
            var ogcProperties = MapModelElement.fti.ogcProperties;
            var wmsOptions = {
              //url: 'http://46.105.100.62:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
              // url:'/services/'+PortalsFactory.getPortalId()+'/ogc/g2c?token=' +'007',
              //url:'http://46.105.100.62:6080/arcgis/services/ecomed/couchesMetiersl93_v4/MapServer/WmsServer?layers=5&styles=&',
              //url: 'http://46.105.100.62:6080/arcgis/services/ecomed/couchesMetiersl93_v4/MapServer/WmsServer?',
              url: MapModelElement.fti.wms,
              //url:'/wsgi/wms-win-esri.py?url='+MapModelElement.fti.wms,
              //label: MapModelElement.fti.alias,
              uid: MapModelElement.fti.uid,
              fti: MapModelElement.fti,
              name: MapModelElement.fti.name,
              theme: MapModelElement.theme,
              visible: MapModelElement.visible,
              invertedOpacity: MapModelElement.invertedOpacity,
              cql_filter: MapModelElement.cql_filter,
              maxScale: MapModelElement.maxScale,
              minScale: MapModelElement.minScale,
              selected: MapModelElement.selected,
              //style : MapModelElement.fti.defaultStyle,
              ogcDefinitionExpression: ogcProperties.definitionExpression,
              ogcMaxScale: ogcProperties.minScale,
              ogcMinScale: ogcProperties.maxScale,
              index: MapModelElement.index,
              //layerDefs : MapModelElement.layerDefs.replace('undefined','1=1'),
              //theme:"Non Defini",
              gctype: 'esri',
              //extent: getCapLayer.extent,
              //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
            };
          } else {
            // console.log(MapModelElement);
            var wmsParams = {
              LAYERS: MapModelElement.fti.name,
              TILED: false,
              CQL_FILTER: MapModelElement.cql_filter,
              type: 'g2c',
              scaleMethod: 'Accurate',
            };
            if (
              MapModelElement.style &&
              MapModelElement.fti.styles.indexOf(MapModelElement.style) == -1
            )
              MapModelElement.style = undefined;
            var wmsOptions = {
              //url: 'http://46.105.100.62:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
              url: '/services/' + PortalsFactory.getPortalId() + '/ogc/g2c?',
              // url:'/wsgi/wms-win.py?portal='+PortalsFactory.getPortalId()+'&token=' +'007',
              //url:'/geoserver/'+PortalsFactory.getPortalId()+'/wms?token=' +'007',
              label: MapModelElement.fti.alias,
              uid: MapModelElement.fti.uid,
              fti: MapModelElement.fti,
              name: MapModelElement.fti.name,
              theme: MapModelElement.theme,
              visible: MapModelElement.visible,
              invertedOpacity: MapModelElement.invertedOpacity,
              cql_filter: MapModelElement.cql_filter,
              maxScale: MapModelElement.maxScale,
              minScale: MapModelElement.minScale,
              selected: MapModelElement.selected,
              style: MapModelElement.style || MapModelElement.fti.defaultStyle,
              index: MapModelElement.index,

              gctype: 'g2c',

              //extent: getCapLayer.extent,
              //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
            };
          }

          return createWmsLayer(wmsParams, wmsOptions);
        };
        // Create a WMS layer and add it to the map
        this.addWmsToMap = function(map, layerParams, layerOptions, index) {
          var olLayer = createWmsLayer(layerParams, layerOptions);
          if (index) {
            map.getLayers().insertAt(index, olLayer);
          } else {
            map.addLayer(olLayer);
          }
          return olLayer;
        };
        this.getDynamicLayer = function(fti) {
          var dynamicLayerEntry = {
            id: fti.ogcId,
            source: {
              type: 'mapLayer',
              mapLayerId: fti.ogcId,
            },
            drawingInfo: {
              transparency: 0,
            },
          };
          return dynamicLayerEntry;
        };
      };
      return new Wms();
    };
    this.$get.$inject = [
      'gcPropertiesLayers',
      'gcMapUtils',
      'gaUrlUtils',
      'DataStoreFactory',
      'gaJsUtils',
      'PortalsFactory',
    ];
  };

  return gcWMS;
});
