'use strict';
define(function() {
  var toolbarmeteo = function() {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/openweathermap/views/toolbarmeteo.html',

      restrict: 'A',

      link: function(scope, element, attrs, ctrl) {
        var m = scope.map;
        var cf = scope.config;
        scope.meteolayers = [
          {
            label: 'Nuages',
          },
          {
            label: 'Precipitation',
          },
          {
            label: 'Pressions',
          },
        ];

        /**
         *
         */
        scope.add = function(layer) {
          if (layer == 'Nuages') {
            var nuages = new ol.layer.Tile({
              label: 'Nuages',
              source: new ol.source.XYZ({
                //attributions: [attribution],
                url:
                  'http://{s}.tile.openweathermap.org/map/clouds/{z}/{x}/{y}/256/png',
              }),
            });
            gcPropertiesLayers(nuages);
            scope.map.addLayer(nuages);
          }
          if (layer == 'Pressions') {
            var nuages = new ol.layer.Tile({
              label: 'Pressions',
              source: new ol.source.XYZ({
                //attributions: [attribution],
                url:
                  'http://{s}.tile.openweathermap.org/map/pressure_cntr/{z}/{x}/{y}/256/png',
              }),
            });
            gcPropertiesLayers(nuages);
            scope.map.addLayer(nuages);
          }
          if (layer == 'Precipitation') {
            var nuages = new ol.layer.Tile({
              label: 'Precipitation',
              source: new ol.source.XYZ({
                //attributions: [attribution],
                url:
                  'http://{s}.tile.openweathermap.org/map/precipitation/{z}/{x}/{y}/256/png',
              }),
            });
            gcPropertiesLayers(nuages);
            scope.map.addLayer(nuages);
          }
        };

        var btnElt = $(element.children()[0]);
        btnElt.bind('click', function() {
          if (scope.isActive) {
            btnElt.removeClass('btn-info');
            btnElt.addClass('btn-default');
            scope.isActive = false;
          } else {
            btnElt.removeClass('btn-default');
            btnElt.addClass('btn-info');
            scope.isActive = true;
          }
        });

        scope.$on('closeToolsBar_toolbarmeteo', function(event) {
          if (scope.isActive) $('#toolbar_meteo_popover').click();
          btnElt.removeClass('btn-info');
          btnElt.addClass('btn-default');
          scope.isActive = false;
        });

        // alert (m);
        // element.bind("click", function(){

        //alert(m);
        //scope.addtools({title: "Meteo ", name: "Meteo" ,directive:"meteowidget"});
        //scope.$apply(scope);

        //});
      },
    };
  };

  toolbarmeteo.$inject = [];
  return toolbarmeteo;
});
