'use strict';
define(function() {
  var FontAwesomeFactory = function() {
    var FontAwesomeFactory = [
      { name: 'fa-500px', unicode: '&#xf26e;' },
      { name: 'fa-adjust', unicode: '&#xf042;' },
      { name: 'fa-adn', unicode: '&#xf170;' },
      { name: 'fa-align-center', unicode: '&#xf037;' },
      { name: 'fa-align-justify', unicode: '&#xf039;' },
      { name: 'fa-align-left', unicode: '&#xf036;' },
      { name: 'fa-align-right', unicode: '&#xf038;' },
      { name: 'fa-ambulance', unicode: '&#xf0f9;' },
      { name: 'fa-anchor', unicode: '&#xf13d;' },
      { name: 'fa-android', unicode: '&#xf17b;' },
      { name: 'fa-angellist', unicode: '&#xf209;' },
      { name: 'fa-angle-double-down', unicode: '&#xf103;' },
      { name: 'fa-angle-double-left', unicode: '&#xf100;' },
      { name: 'fa-angle-double-right', unicode: '&#xf101;' },
      { name: 'fa-angle-double-up', unicode: '&#xf102;' },
      { name: 'fa-angle-down', unicode: '&#xf107;' },
      { name: 'fa-angle-left', unicode: '&#xf104;' },
      { name: 'fa-angle-right', unicode: '&#xf105;' },
      { name: 'fa-angle-up', unicode: '&#xf106;' },
      { name: 'fa-apple', unicode: '&#xf179;' },
      { name: 'fa-archive', unicode: '&#xf187;' },
      { name: 'fa-area-chart', unicode: '&#xf1fe;' },
      { name: 'fa-arrow-circle-down', unicode: '&#xf0ab;' },
      { name: 'fa-arrow-circle-left', unicode: '&#xf0a8;' },
      { name: 'fa-arrow-circle-o-down', unicode: '&#xf01a;' },
      { name: 'fa-arrow-circle-o-left', unicode: '&#xf190;' },
      { name: 'fa-arrow-circle-o-right', unicode: '&#xf18e;' },
      { name: 'fa-arrow-circle-o-up', unicode: '&#xf01b;' },
      { name: 'fa-arrow-circle-right', unicode: '&#xf0a9;' },
      { name: 'fa-arrow-circle-up', unicode: '&#xf0aa;' },
      { name: 'fa-arrow-down', unicode: '&#xf063;' },
      { name: 'fa-arrow-left', unicode: '&#xf060;' },
      { name: 'fa-arrow-right', unicode: '&#xf061;' },
      { name: 'fa-arrow-up', unicode: '&#xf062;' },
      { name: 'fa-arrows', unicode: '&#xf047;' },
      { name: 'fa-arrows-alt', unicode: '&#xf0b2;' },
      { name: 'fa-arrows-h', unicode: '&#xf07e;' },
      { name: 'fa-arrows-v', unicode: '&#xf07d;' },
      { name: 'fa-asterisk', unicode: '&#xf069;' },
      { name: 'fa-at', unicode: '&#xf1fa;' },
      { name: 'fa-automobile (alias)', unicode: '&#xf1b9;' },
      { name: 'fa-backward', unicode: '&#xf04a;' },
      { name: 'fa-ban', unicode: '&#xf05e;' },
      { name: 'fa-bank (alias)', unicode: '&#xf19c;' },
      { name: 'fa-bar-chart', unicode: '&#xf080;' },
      { name: 'fa-bar-chart-o (alias)', unicode: '&#xf080;' },
      { name: 'fa-barcode', unicode: '&#xf02a;' },
      { name: 'fa-bars', unicode: '&#xf0c9;' },
      { name: 'fa-bed', unicode: '&#xf236;' },
      { name: 'fa-beer', unicode: '&#xf0fc;' },
      { name: 'fa-behance', unicode: '&#xf1b4;' },
      { name: 'fa-behance-square', unicode: '&#xf1b5;' },
      { name: 'fa-bell', unicode: '&#xf0f3;' },
      { name: 'fa-bell-o', unicode: '&#xf0a2;' },
      { name: 'fa-bell-slash', unicode: '&#xf1f6;' },
      { name: 'fa-bell-slash-o', unicode: '&#xf1f7;' },
      { name: 'fa-bicycle', unicode: '&#xf206;' },
      { name: 'fa-binoculars', unicode: '&#xf1e5;' },
      { name: 'fa-birthday-cake', unicode: '&#xf1fd;' },
      { name: 'fa-bitbucket', unicode: '&#xf171;' },
      { name: 'fa-bitbucket-square', unicode: '&#xf172;' },
      { name: 'fa-bitcoin (alias)', unicode: '&#xf15a;' },
      { name: 'fa-bold', unicode: '&#xf032;' },
      { name: 'fa-bolt', unicode: '&#xf0e7;' },
      { name: 'fa-bomb', unicode: '&#xf1e2;' },
      { name: 'fa-book', unicode: '&#xf02d;' },
      { name: 'fa-bookmark', unicode: '&#xf02e;' },
      { name: 'fa-bookmark-o', unicode: '&#xf097;' },
      { name: 'fa-briefcase', unicode: '&#xf0b1;' },
      { name: 'fa-btc', unicode: '&#xf15a;' },
      { name: 'fa-bug', unicode: '&#xf188;' },
      { name: 'fa-building', unicode: '&#xf1ad;' },
      { name: 'fa-building-o', unicode: '&#xf0f7;' },
      { name: 'fa-bullhorn', unicode: '&#xf0a1;' },
      { name: 'fa-bullseye', unicode: '&#xf140;' },
      { name: 'fa-bus', unicode: '&#xf207;' },
      { name: 'fa-buysellads', unicode: '&#xf20d;' },
      { name: 'fa-cab (alias)', unicode: '&#xf1ba;' },
      { name: 'fa-calculator', unicode: '&#xf1ec;' },
      { name: 'fa-calendar', unicode: '&#xf073;' },
      { name: 'fa-calendar-o', unicode: '&#xf133;' },
      { name: 'fa-camera', unicode: '&#xf030;' },
      { name: 'fa-camera-retro', unicode: '&#xf083;' },
      { name: 'fa-car', unicode: '&#xf1b9;' },
      { name: 'fa-caret-down', unicode: '&#xf0d7;' },
      { name: 'fa-caret-left', unicode: '&#xf0d9;' },
      { name: 'fa-caret-right', unicode: '&#xf0da;' },
      { name: 'fa-caret-square-o-down', unicode: '&#xf150;' },
      { name: 'fa-caret-square-o-left', unicode: '&#xf191;' },
      { name: 'fa-caret-square-o-right', unicode: '&#xf152;' },
      { name: 'fa-caret-square-o-up', unicode: '&#xf151;' },
      { name: 'fa-caret-up', unicode: '&#xf0d8;' },
      { name: 'fa-cart-arrow-down', unicode: '&#xf218;' },
      { name: 'fa-cart-plus', unicode: '&#xf217;' },
      { name: 'fa-cc', unicode: '&#xf20a;' },
      { name: 'fa-cc-amex', unicode: '&#xf1f3;' },
      { name: 'fa-cc-discover', unicode: '&#xf1f2;' },
      { name: 'fa-cc-mastercard', unicode: '&#xf1f1;' },
      { name: 'fa-cc-paypal', unicode: '&#xf1f4;' },
      { name: 'fa-cc-stripe', unicode: '&#xf1f5;' },
      { name: 'fa-cc-visa', unicode: '&#xf1f0;' },
      { name: 'fa-certificate', unicode: '&#xf0a3;' },
      { name: 'fa-chain (alias)', unicode: '&#xf0c1;' },
      { name: 'fa-chain-broken', unicode: '&#xf127;' },
      { name: 'fa-check', unicode: '&#xf00c;' },
      { name: 'fa-check-circle', unicode: '&#xf058;' },
      { name: 'fa-check-circle-o', unicode: '&#xf05d;' },
      { name: 'fa-check-square', unicode: '&#xf14a;' },
      { name: 'fa-check-square-o', unicode: '&#xf046;' },
      { name: 'fa-chevron-circle-down', unicode: '&#xf13a;' },
      { name: 'fa-chevron-circle-left', unicode: '&#xf137;' },
      { name: 'fa-chevron-circle-right', unicode: '&#xf138;' },
      { name: 'fa-chevron-circle-up', unicode: '&#xf139;' },
      { name: 'fa-chevron-down', unicode: '&#xf078;' },
      { name: 'fa-chevron-left', unicode: '&#xf053;' },
      { name: 'fa-chevron-right', unicode: '&#xf054;' },
      { name: 'fa-chevron-up', unicode: '&#xf077;' },
      { name: 'fa-child', unicode: '&#xf1ae;' },
      { name: 'fa-circle', unicode: '&#xf111;' },
      { name: 'fa-circle-o', unicode: '&#xf10c;' },
      { name: 'fa-circle-o-notch', unicode: '&#xf1ce;' },
      { name: 'fa-circle-thin', unicode: '&#xf1db;' },
      { name: 'fa-clipboard', unicode: '&#xf0ea;' },
      { name: 'fa-clock-o', unicode: '&#xf017;' },
      { name: 'fa-close (alias)', unicode: '&#xf00d;' },
      { name: 'fa-cloud', unicode: '&#xf0c2;' },
      { name: 'fa-cloud-download', unicode: '&#xf0ed;' },
      { name: 'fa-cloud-upload', unicode: '&#xf0ee;' },
      { name: 'fa-cny (alias)', unicode: '&#xf157;' },
      { name: 'fa-code', unicode: '&#xf121;' },
      { name: 'fa-code-fork', unicode: '&#xf126;' },
      { name: 'fa-codepen', unicode: '&#xf1cb;' },
      { name: 'fa-coffee', unicode: '&#xf0f4;' },
      { name: 'fa-cog', unicode: '&#xf013;' },
      { name: 'fa-cogs', unicode: '&#xf085;' },
      { name: 'fa-columns', unicode: '&#xf0db;' },
      { name: 'fa-comment', unicode: '&#xf075;' },
      { name: 'fa-comment-o', unicode: '&#xf0e5;' },
      { name: 'fa-comments', unicode: '&#xf086;' },
      { name: 'fa-comments-o', unicode: '&#xf0e6;' },
      { name: 'fa-compass', unicode: '&#xf14e;' },
      { name: 'fa-compress', unicode: '&#xf066;' },
      { name: 'fa-connectdevelop', unicode: '&#xf20e;' },
      { name: 'fa-copy (alias)', unicode: '&#xf0c5;' },
      { name: 'fa-copyright', unicode: '&#xf1f9;' },
      { name: 'fa-credit-card', unicode: '&#xf09d;' },
      { name: 'fa-crop', unicode: '&#xf125;' },
      { name: 'fa-crosshairs', unicode: '&#xf05b;' },
      { name: 'fa-css3', unicode: '&#xf13c;' },
      { name: 'fa-cube', unicode: '&#xf1b2;' },
      { name: 'fa-cubes', unicode: '&#xf1b3;' },
      { name: 'fa-cut (alias)', unicode: '&#xf0c4;' },
      { name: 'fa-cutlery', unicode: '&#xf0f5;' },
      { name: 'fa-dashboard (alias)', unicode: '&#xf0e4;' },
      { name: 'fa-dashcube', unicode: '&#xf210;' },
      { name: 'fa-database', unicode: '&#xf1c0;' },
      { name: 'fa-dedent (alias)', unicode: '&#xf03b;' },
      { name: 'fa-delicious', unicode: '&#xf1a5;' },
      { name: 'fa-desktop', unicode: '&#xf108;' },
      { name: 'fa-deviantart', unicode: '&#xf1bd;' },
      { name: 'fa-diamond', unicode: '&#xf219;' },
      { name: 'fa-digg', unicode: '&#xf1a6;' },
      { name: 'fa-dollar (alias)', unicode: '&#xf155;' },
      { name: 'fa-dot-circle-o', unicode: '&#xf192;' },
      { name: 'fa-download', unicode: '&#xf019;' },
      { name: 'fa-dribbble', unicode: '&#xf17d;' },
      { name: 'fa-dropbox', unicode: '&#xf16b;' },
      { name: 'fa-drupal', unicode: '&#xf1a9;' },
      { name: 'fa-edit (alias)', unicode: '&#xf044;' },
      { name: 'fa-eject', unicode: '&#xf052;' },
      { name: 'fa-ellipsis-h', unicode: '&#xf141;' },
      { name: 'fa-ellipsis-v', unicode: '&#xf142;' },
      { name: 'fa-empire', unicode: '&#xf1d1;' },
      { name: 'fa-envelope', unicode: '&#xf0e0;' },
      { name: 'fa-envelope-o', unicode: '&#xf003;' },
      { name: 'fa-envelope-square', unicode: '&#xf199;' },
      { name: 'fa-eraser', unicode: '&#xf12d;' },
      { name: 'fa-eur', unicode: '&#xf153;' },
      { name: 'fa-euro (alias)', unicode: '&#xf153;' },
      { name: 'fa-exchange', unicode: '&#xf0ec;' },
      { name: 'fa-exclamation', unicode: '&#xf12a;' },
      { name: 'fa-exclamation-circle', unicode: '&#xf06a;' },
      { name: 'fa-exclamation-triangle', unicode: '&#xf071;' },
      { name: 'fa-expand', unicode: '&#xf065;' },
      { name: 'fa-external-link', unicode: '&#xf08e;' },
      { name: 'fa-external-link-square', unicode: '&#xf14c;' },
      { name: 'fa-eye', unicode: '&#xf06e;' },
      { name: 'fa-eye-slash', unicode: '&#xf070;' },
      { name: 'fa-eyedropper', unicode: '&#xf1fb;' },
      { name: 'fa-facebook', unicode: '&#xf09a;' },
      { name: 'fa-facebook-f (alias)', unicode: '&#xf09a;' },
      { name: 'fa-facebook-official', unicode: '&#xf230;' },
      { name: 'fa-facebook-square', unicode: '&#xf082;' },
      { name: 'fa-fast-backward', unicode: '&#xf049;' },
      { name: 'fa-fast-forward', unicode: '&#xf050;' },
      { name: 'fa-fax', unicode: '&#xf1ac;' },
      { name: 'fa-feed (alias)', unicode: '&#xf09e;' },
      { name: 'fa-female', unicode: '&#xf182;' },
      { name: 'fa-fighter-jet', unicode: '&#xf0fb;' },
      { name: 'fa-file', unicode: '&#xf15b;' },
      { name: 'fa-file-archive-o', unicode: '&#xf1c6;' },
      { name: 'fa-file-audio-o', unicode: '&#xf1c7;' },
      { name: 'fa-file-code-o', unicode: '&#xf1c9;' },
      { name: 'fa-file-excel-o', unicode: '&#xf1c3;' },
      { name: 'fa-file-image-o', unicode: '&#xf1c5;' },
      { name: 'fa-file-movie-o (alias)', unicode: '&#xf1c8;' },
      { name: 'fa-file-o', unicode: '&#xf016;' },
      { name: 'fa-file-pdf-o', unicode: '&#xf1c1;' },
      { name: 'fa-file-photo-o (alias)', unicode: '&#xf1c5;' },
      { name: 'fa-file-picture-o (alias)', unicode: '&#xf1c5;' },
      { name: 'fa-file-powerpoint-o', unicode: '&#xf1c4;' },
      { name: 'fa-file-sound-o (alias)', unicode: '&#xf1c7;' },
      { name: 'fa-file-text', unicode: '&#xf15c;' },
      { name: 'fa-file-text-o', unicode: '&#xf0f6;' },
      { name: 'fa-file-video-o', unicode: '&#xf1c8;' },
      { name: 'fa-file-word-o', unicode: '&#xf1c2;' },
      { name: 'fa-file-zip-o (alias)', unicode: '&#xf1c6;' },
      { name: 'fa-files-o', unicode: '&#xf0c5;' },
      { name: 'fa-film', unicode: '&#xf008;' },
      { name: 'fa-filter', unicode: '&#xf0b0;' },
      { name: 'fa-fire', unicode: '&#xf06d;' },
      { name: 'fa-fire-extinguisher', unicode: '&#xf134;' },
      { name: 'fa-flag', unicode: '&#xf024;' },
      { name: 'fa-flag-checkered', unicode: '&#xf11e;' },
      { name: 'fa-flag-o', unicode: '&#xf11d;' },
      { name: 'fa-flash (alias)', unicode: '&#xf0e7;' },
      { name: 'fa-flask', unicode: '&#xf0c3;' },
      { name: 'fa-flickr', unicode: '&#xf16e;' },
      { name: 'fa-floppy-o', unicode: '&#xf0c7;' },
      { name: 'fa-folder', unicode: '&#xf07b;' },
      { name: 'fa-folder-o', unicode: '&#xf114;' },
      { name: 'fa-folder-open', unicode: '&#xf07c;' },
      { name: 'fa-folder-open-o', unicode: '&#xf115;' },
      { name: 'fa-font', unicode: '&#xf031;' },
      { name: 'fa-forumbee', unicode: '&#xf211;' },
      { name: 'fa-forward', unicode: '&#xf04e;' },
      { name: 'fa-foursquare', unicode: '&#xf180;' },
      { name: 'fa-frown-o', unicode: '&#xf119;' },
      { name: 'fa-futbol-o', unicode: '&#xf1e3;' },
      { name: 'fa-gamepad', unicode: '&#xf11b;' },
      { name: 'fa-gavel', unicode: '&#xf0e3;' },
      { name: 'fa-gbp', unicode: '&#xf154;' },
      { name: 'fa-ge (alias)', unicode: '&#xf1d1;' },
      { name: 'fa-gear (alias)', unicode: '&#xf013;' },
      { name: 'fa-gears (alias)', unicode: '&#xf085;' },
      { name: 'fa-gift', unicode: '&#xf06b;' },
      { name: 'fa-git', unicode: '&#xf1d3;' },
      { name: 'fa-git-square', unicode: '&#xf1d2;' },
      { name: 'fa-github', unicode: '&#xf09b;' },
      { name: 'fa-github-alt', unicode: '&#xf113;' },
      { name: 'fa-github-square', unicode: '&#xf092;' },
      { name: 'fa-gittip (alias)', unicode: '&#xf184;' },
      { name: 'fa-glass', unicode: '&#xf000;' },
      { name: 'fa-globe', unicode: '&#xf0ac;' },
      { name: 'fa-google', unicode: '&#xf1a0;' },
      { name: 'fa-google-plus', unicode: '&#xf0d5;' },
      { name: 'fa-google-plus-square', unicode: '&#xf0d4;' },
      { name: 'fa-google-wallet', unicode: '&#xf1ee;' },
      { name: 'fa-graduation-cap', unicode: '&#xf19d;' },
      { name: 'fa-gratipay', unicode: '&#xf184;' },
      { name: 'fa-group (alias)', unicode: '&#xf0c0;' },
      { name: 'fa-h-square', unicode: '&#xf0fd;' },
      { name: 'fa-hacker-news', unicode: '&#xf1d4;' },
      { name: 'fa-hand-o-down', unicode: '&#xf0a7;' },
      { name: 'fa-hand-o-left', unicode: '&#xf0a5;' },
      { name: 'fa-hand-o-right', unicode: '&#xf0a4;' },
      { name: 'fa-hand-o-up', unicode: '&#xf0a6;' },
      { name: 'fa-hdd-o', unicode: '&#xf0a0;' },
      { name: 'fa-header', unicode: '&#xf1dc;' },
      { name: 'fa-headphones', unicode: '&#xf025;' },
      { name: 'fa-heart', unicode: '&#xf004;' },
      { name: 'fa-heart-o', unicode: '&#xf08a;' },
      { name: 'fa-heartbeat', unicode: '&#xf21e;' },
      { name: 'fa-history', unicode: '&#xf1da;' },
      { name: 'fa-home', unicode: '&#xf015;' },
      { name: 'fa-hospital-o', unicode: '&#xf0f8;' },
      { name: 'fa-hotel (alias)', unicode: '&#xf236;' },
      { name: 'fa-html5', unicode: '&#xf13b;' },
      { name: 'fa-ils', unicode: '&#xf20b;' },
      { name: 'fa-image (alias)', unicode: '&#xf03e;' },
      { name: 'fa-inbox', unicode: '&#xf01c;' },
      { name: 'fa-indent', unicode: '&#xf03c;' },
      { name: 'fa-info', unicode: '&#xf129;' },
      { name: 'fa-info-circle', unicode: '&#xf05a;' },
      { name: 'fa-inr', unicode: '&#xf156;' },
      { name: 'fa-institution (alias)', unicode: '&#xf19c;' },
      { name: 'fa-intersex (alias)', unicode: '&#xf224;' },
      { name: 'fa-ioxhost', unicode: '&#xf208;' },
      { name: 'fa-italic', unicode: '&#xf033;' },
      { name: 'fa-joomla', unicode: '&#xf1aa;' },
      { name: 'fa-jpy', unicode: '&#xf157;' },
      { name: 'fa-jsfiddle', unicode: '&#xf1cc;' },
      { name: 'fa-key', unicode: '&#xf084;' },
      { name: 'fa-keyboard-o', unicode: '&#xf11c;' },
      { name: 'fa-krw', unicode: '&#xf159;' },
      { name: 'fa-language', unicode: '&#xf1ab;' },
      { name: 'fa-laptop', unicode: '&#xf109;' },
      { name: 'fa-lastfm', unicode: '&#xf202;' },
      { name: 'fa-lastfm-square', unicode: '&#xf203;' },
      { name: 'fa-leaf', unicode: '&#xf06c;' },
      { name: 'fa-leanpub', unicode: '&#xf212;' },
      { name: 'fa-legal (alias)', unicode: '&#xf0e3;' },
      { name: 'fa-lemon-o', unicode: '&#xf094;' },
      { name: 'fa-level-down', unicode: '&#xf149;' },
      { name: 'fa-level-up', unicode: '&#xf148;' },
      { name: 'fa-life-bouy (alias)', unicode: '&#xf1cd;' },
      { name: 'fa-life-buoy (alias)', unicode: '&#xf1cd;' },
      { name: 'fa-life-ring', unicode: '&#xf1cd;' },
      { name: 'fa-life-saver (alias)', unicode: '&#xf1cd;' },
      { name: 'fa-lightbulb-o', unicode: '&#xf0eb;' },
      { name: 'fa-line-chart', unicode: '&#xf201;' },
      { name: 'fa-link', unicode: '&#xf0c1;' },
      { name: 'fa-linkedin', unicode: '&#xf0e1;' },
      { name: 'fa-linkedin-square', unicode: '&#xf08c;' },
      { name: 'fa-linux', unicode: '&#xf17c;' },
      { name: 'fa-list', unicode: '&#xf03a;' },
      { name: 'fa-list-alt', unicode: '&#xf022;' },
      { name: 'fa-list-ol', unicode: '&#xf0cb;' },
      { name: 'fa-list-ul', unicode: '&#xf0ca;' },
      { name: 'fa-location-arrow', unicode: '&#xf124;' },
      { name: 'fa-lock', unicode: '&#xf023;' },
      { name: 'fa-long-arrow-down', unicode: '&#xf175;' },
      { name: 'fa-long-arrow-left', unicode: '&#xf177;' },
      { name: 'fa-long-arrow-right', unicode: '&#xf178;' },
      { name: 'fa-long-arrow-up', unicode: '&#xf176;' },
      { name: 'fa-magic', unicode: '&#xf0d0;' },
      { name: 'fa-magnet', unicode: '&#xf076;' },
      { name: 'fa-mail-forward (alias)', unicode: '&#xf064;' },
      { name: 'fa-mail-reply (alias)', unicode: '&#xf112;' },
      { name: 'fa-mail-reply-all (alias)', unicode: '&#xf122;' },
      { name: 'fa-male', unicode: '&#xf183;' },
      { name: 'fa-map-marker', unicode: '&#xf041;' },
      { name: 'fa-mars', unicode: '&#xf222;' },
      { name: 'fa-mars-double', unicode: '&#xf227;' },
      { name: 'fa-mars-stroke', unicode: '&#xf229;' },
      { name: 'fa-mars-stroke-h', unicode: '&#xf22b;' },
      { name: 'fa-mars-stroke-v', unicode: '&#xf22a;' },
      { name: 'fa-maxcdn', unicode: '&#xf136;' },
      { name: 'fa-meanpath', unicode: '&#xf20c;' },
      { name: 'fa-medium', unicode: '&#xf23a;' },
      { name: 'fa-medkit', unicode: '&#xf0fa;' },
      { name: 'fa-meh-o', unicode: '&#xf11a;' },
      { name: 'fa-mercury', unicode: '&#xf223;' },
      { name: 'fa-microphone', unicode: '&#xf130;' },
      { name: 'fa-microphone-slash', unicode: '&#xf131;' },
      { name: 'fa-minus', unicode: '&#xf068;' },
      { name: 'fa-minus-circle', unicode: '&#xf056;' },
      { name: 'fa-minus-square', unicode: '&#xf146;' },
      { name: 'fa-minus-square-o', unicode: '&#xf147;' },
      { name: 'fa-mobile', unicode: '&#xf10b;' },
      { name: 'fa-mobile-phone (alias)', unicode: '&#xf10b;' },
      { name: 'fa-money', unicode: '&#xf0d6;' },
      { name: 'fa-moon-o', unicode: '&#xf186;' },
      { name: 'fa-mortar-board (alias)', unicode: '&#xf19d;' },
      { name: 'fa-motorcycle', unicode: '&#xf21c;' },
      { name: 'fa-music', unicode: '&#xf001;' },
      { name: 'fa-navicon (alias)', unicode: '&#xf0c9;' },
      { name: 'fa-neuter', unicode: '&#xf22c;' },
      { name: 'fa-newspaper-o', unicode: '&#xf1ea;' },
      { name: 'fa-openid', unicode: '&#xf19b;' },
      { name: 'fa-outdent', unicode: '&#xf03b;' },
      { name: 'fa-pagelines', unicode: '&#xf18c;' },
      { name: 'fa-paint-brush', unicode: '&#xf1fc;' },
      { name: 'fa-paper-plane', unicode: '&#xf1d8;' },
      { name: 'fa-paper-plane-o', unicode: '&#xf1d9;' },
      { name: 'fa-paperclip', unicode: '&#xf0c6;' },
      { name: 'fa-paragraph', unicode: '&#xf1dd;' },
      { name: 'fa-paste (alias)', unicode: '&#xf0ea;' },
      { name: 'fa-pause', unicode: '&#xf04c;' },
      { name: 'fa-paw', unicode: '&#xf1b0;' },
      { name: 'fa-paypal', unicode: '&#xf1ed;' },
      { name: 'fa-pencil', unicode: '&#xf040;' },
      { name: 'fa-pencil-square', unicode: '&#xf14b;' },
      { name: 'fa-pencil-square-o', unicode: '&#xf044;' },
      { name: 'fa-phone', unicode: '&#xf095;' },
      { name: 'fa-phone-square', unicode: '&#xf098;' },
      { name: 'fa-photo (alias)', unicode: '&#xf03e;' },
      { name: 'fa-picture-o', unicode: '&#xf03e;' },
      { name: 'fa-pie-chart', unicode: '&#xf200;' },
      { name: 'fa-pied-piper-alt', unicode: '&#xf1a8;' },
      { name: 'fa-pied-piper-pp', unicode: '&#xf1a7;' },
      { name: 'fa-pinterest', unicode: '&#xf0d2;' },
      { name: 'fa-pinterest-p', unicode: '&#xf231;' },
      { name: 'fa-pinterest-square', unicode: '&#xf0d3;' },
      { name: 'fa-plane', unicode: '&#xf072;' },
      { name: 'fa-play', unicode: '&#xf04b;' },
      { name: 'fa-play-circle', unicode: '&#xf144;' },
      { name: 'fa-play-circle-o', unicode: '&#xf01d;' },
      { name: 'fa-plug', unicode: '&#xf1e6;' },
      { name: 'fa-plus', unicode: '&#xf067;' },
      { name: 'fa-plus-circle', unicode: '&#xf055;' },
      { name: 'fa-plus-square', unicode: '&#xf0fe;' },
      { name: 'fa-plus-square-o', unicode: '&#xf196;' },
      { name: 'fa-power-off', unicode: '&#xf011;' },
      { name: 'fa-print', unicode: '&#xf02f;' },
      { name: 'fa-puzzle-piece', unicode: '&#xf12e;' },
      { name: 'fa-qq', unicode: '&#xf1d6;' },
      { name: 'fa-qrcode', unicode: '&#xf029;' },
      { name: 'fa-question', unicode: '&#xf128;' },
      { name: 'fa-question-circle', unicode: '&#xf059;' },
      { name: 'fa-quote-left', unicode: '&#xf10d;' },
      { name: 'fa-quote-right', unicode: '&#xf10e;' },
      { name: 'fa-ra (alias)', unicode: '&#xf1d0;' },
      { name: 'fa-random', unicode: '&#xf074;' },
      { name: 'fa-rebel', unicode: '&#xf1d0;' },
      { name: 'fa-recycle', unicode: '&#xf1b8;' },
      { name: 'fa-reddit', unicode: '&#xf1a1;' },
      { name: 'fa-reddit-square', unicode: '&#xf1a2;' },
      { name: 'fa-refresh', unicode: '&#xf021;' },
      { name: 'fa-remove (alias)', unicode: '&#xf00d;' },
      { name: 'fa-renren', unicode: '&#xf18b;' },
      { name: 'fa-reorder (alias)', unicode: '&#xf0c9;' },
      { name: 'fa-repeat', unicode: '&#xf01e;' },
      { name: 'fa-reply', unicode: '&#xf112;' },
      { name: 'fa-reply-all', unicode: '&#xf122;' },
      { name: 'fa-resistance (alias)', unicode: '&#xf1d0;' },
      { name: 'fa-retweet', unicode: '&#xf079;' },
      { name: 'fa-rmb (alias)', unicode: '&#xf157;' },
      { name: 'fa-road', unicode: '&#xf018;' },
      { name: 'fa-rocket', unicode: '&#xf135;' },
      { name: 'fa-rotate-left (alias)', unicode: '&#xf0e2;' },
      { name: 'fa-rotate-right (alias)', unicode: '&#xf01e;' },
      { name: 'fa-rouble (alias)', unicode: '&#xf158;' },
      { name: 'fa-rss', unicode: '&#xf09e;' },
      { name: 'fa-rss-square', unicode: '&#xf143;' },
      { name: 'fa-rub', unicode: '&#xf158;' },
      { name: 'fa-ruble (alias)', unicode: '&#xf158;' },
      { name: 'fa-rupee (alias)', unicode: '&#xf156;' },
      { name: 'fa-save (alias)', unicode: '&#xf0c7;' },
      { name: 'fa-scissors', unicode: '&#xf0c4;' },
      { name: 'fa-search', unicode: '&#xf002;' },
      { name: 'fa-search-minus', unicode: '&#xf010;' },
      { name: 'fa-search-plus', unicode: '&#xf00e;' },
      { name: 'fa-sellsy', unicode: '&#xf213;' },
      { name: 'fa-send (alias)', unicode: '&#xf1d8;' },
      { name: 'fa-send-o (alias)', unicode: '&#xf1d9;' },
      { name: 'fa-server', unicode: '&#xf233;' },
      { name: 'fa-share', unicode: '&#xf064;' },
      { name: 'fa-share-alt', unicode: '&#xf1e0;' },
      { name: 'fa-share-alt-square', unicode: '&#xf1e1;' },
      { name: 'fa-share-square', unicode: '&#xf14d;' },
      { name: 'fa-share-square-o', unicode: '&#xf045;' },
      { name: 'fa-shekel (alias)', unicode: '&#xf20b;' },
      { name: 'fa-sheqel (alias)', unicode: '&#xf20b;' },
      { name: 'fa-shield', unicode: '&#xf132;' },
      { name: 'fa-ship', unicode: '&#xf21a;' },
      { name: 'fa-shirtsinbulk', unicode: '&#xf214;' },
      { name: 'fa-shopping-cart', unicode: '&#xf07a;' },
      { name: 'fa-sign-in', unicode: '&#xf090;' },
      { name: 'fa-sign-out', unicode: '&#xf08b;' },
      { name: 'fa-signal', unicode: '&#xf012;' },
      { name: 'fa-simplybuilt', unicode: '&#xf215;' },
      { name: 'fa-sitemap', unicode: '&#xf0e8;' },
      { name: 'fa-skyatlas', unicode: '&#xf216;' },
      { name: 'fa-skype', unicode: '&#xf17e;' },
      { name: 'fa-slack', unicode: '&#xf198;' },
      { name: 'fa-sliders', unicode: '&#xf1de;' },
      { name: 'fa-slideshare', unicode: '&#xf1e7;' },
      { name: 'fa-smile-o', unicode: '&#xf118;' },
      { name: 'fa-soccer-ball-o (alias)', unicode: '&#xf1e3;' },
      { name: 'fa-sort', unicode: '&#xf0dc;' },
      { name: 'fa-sort-alpha-asc', unicode: '&#xf15d;' },
      { name: 'fa-sort-alpha-desc', unicode: '&#xf15e;' },
      { name: 'fa-sort-amount-asc', unicode: '&#xf160;' },
      { name: 'fa-sort-amount-desc', unicode: '&#xf161;' },
      { name: 'fa-sort-asc', unicode: '&#xf0de;' },
      { name: 'fa-sort-desc', unicode: '&#xf0dd;' },
      { name: 'fa-sort-down (alias)', unicode: '&#xf0dd;' },
      { name: 'fa-sort-numeric-asc', unicode: '&#xf162;' },
      { name: 'fa-sort-numeric-desc', unicode: '&#xf163;' },
      { name: 'fa-sort-up (alias)', unicode: '&#xf0de;' },
      { name: 'fa-soundcloud', unicode: '&#xf1be;' },
      { name: 'fa-space-shuttle', unicode: '&#xf197;' },
      { name: 'fa-spinner', unicode: '&#xf110;' },
      { name: 'fa-spoon', unicode: '&#xf1b1;' },
      { name: 'fa-spotify', unicode: '&#xf1bc;' },
      { name: 'fa-square', unicode: '&#xf0c8;' },
      { name: 'fa-square-o', unicode: '&#xf096;' },
      { name: 'fa-stack-exchange', unicode: '&#xf18d;' },
      { name: 'fa-stack-overflow', unicode: '&#xf16c;' },
      { name: 'fa-star', unicode: '&#xf005;' },
      { name: 'fa-star-half', unicode: '&#xf089;' },
      { name: 'fa-star-half-empty (alias)', unicode: '&#xf123;' },
      { name: 'fa-star-half-full (alias)', unicode: '&#xf123;' },
      { name: 'fa-star-half-o', unicode: '&#xf123;' },
      { name: 'fa-star-o', unicode: '&#xf006;' },
      { name: 'fa-steam', unicode: '&#xf1b6;' },
      { name: 'fa-steam-square', unicode: '&#xf1b7;' },
      { name: 'fa-step-backward', unicode: '&#xf048;' },
      { name: 'fa-step-forward', unicode: '&#xf051;' },
      { name: 'fa-stethoscope', unicode: '&#xf0f1;' },
      { name: 'fa-stop', unicode: '&#xf04d;' },
      { name: 'fa-street-view', unicode: '&#xf21d;' },
      { name: 'fa-strikethrough', unicode: '&#xf0cc;' },
      { name: 'fa-stumbleupon', unicode: '&#xf1a4;' },
      { name: 'fa-stumbleupon-circle', unicode: '&#xf1a3;' },
      { name: 'fa-subscript', unicode: '&#xf12c;' },
      { name: 'fa-subway', unicode: '&#xf239;' },
      { name: 'fa-suitcase', unicode: '&#xf0f2;' },
      { name: 'fa-sun-o', unicode: '&#xf185;' },
      { name: 'fa-superscript', unicode: '&#xf12b;' },
      { name: 'fa-support (alias)', unicode: '&#xf1cd;' },
      { name: 'fa-table', unicode: '&#xf0ce;' },
      { name: 'fa-tablet', unicode: '&#xf10a;' },
      { name: 'fa-tachometer', unicode: '&#xf0e4;' },
      { name: 'fa-tag', unicode: '&#xf02b;' },
      { name: 'fa-tags', unicode: '&#xf02c;' },
      { name: 'fa-tasks', unicode: '&#xf0ae;' },
      { name: 'fa-taxi', unicode: '&#xf1ba;' },
      { name: 'fa-tencent-weibo', unicode: '&#xf1d5;' },
      { name: 'fa-terminal', unicode: '&#xf120;' },
      { name: 'fa-text-height', unicode: '&#xf034;' },
      { name: 'fa-text-width', unicode: '&#xf035;' },
      { name: 'fa-th', unicode: '&#xf00a;' },
      { name: 'fa-th-large', unicode: '&#xf009;' },
      { name: 'fa-th-list', unicode: '&#xf00b;' },
      { name: 'fa-thumb-tack', unicode: '&#xf08d;' },
      { name: 'fa-thumbs-down', unicode: '&#xf165;' },
      { name: 'fa-thumbs-o-down', unicode: '&#xf088;' },
      { name: 'fa-thumbs-o-up', unicode: '&#xf087;' },
      { name: 'fa-thumbs-up', unicode: '&#xf164;' },
      { name: 'fa-ticket', unicode: '&#xf145;' },
      { name: 'fa-times', unicode: '&#xf00d;' },
      { name: 'fa-times-circle', unicode: '&#xf057;' },
      { name: 'fa-times-circle-o', unicode: '&#xf05c;' },
      { name: 'fa-tint', unicode: '&#xf043;' },
      { name: 'fa-toggle-down (alias)', unicode: '&#xf150;' },
      { name: 'fa-toggle-left (alias)', unicode: '&#xf191;' },
      { name: 'fa-toggle-off', unicode: '&#xf204;' },
      { name: 'fa-toggle-on', unicode: '&#xf205;' },
      { name: 'fa-toggle-right (alias)', unicode: '&#xf152;' },
      { name: 'fa-toggle-up (alias)', unicode: '&#xf151;' },
      { name: 'fa-train', unicode: '&#xf238;' },
      { name: 'fa-transgender', unicode: '&#xf224;' },
      { name: 'fa-transgender-alt', unicode: '&#xf225;' },
      { name: 'fa-trash', unicode: '&#xf1f8;' },
      { name: 'fa-trash-o', unicode: '&#xf014;' },
      { name: 'fa-tree', unicode: '&#xf1bb;' },
      { name: 'fa-trello', unicode: '&#xf181;' },
      { name: 'fa-trophy', unicode: '&#xf091;' },
      { name: 'fa-truck', unicode: '&#xf0d1;' },
      { name: 'fa-try', unicode: '&#xf195;' },
      { name: 'fa-tty', unicode: '&#xf1e4;' },
      { name: 'fa-tumblr', unicode: '&#xf173;' },
      { name: 'fa-tumblr-square', unicode: '&#xf174;' },
      { name: 'fa-turkish-lira (alias)', unicode: '&#xf195;' },
      { name: 'fa-twitch', unicode: '&#xf1e8;' },
      { name: 'fa-twitter', unicode: '&#xf099;' },
      { name: 'fa-twitter-square', unicode: '&#xf081;' },
      { name: 'fa-umbrella', unicode: '&#xf0e9;' },
      { name: 'fa-underline', unicode: '&#xf0cd;' },
      { name: 'fa-undo', unicode: '&#xf0e2;' },
      { name: 'fa-university', unicode: '&#xf19c;' },
      { name: 'fa-unlink (alias)', unicode: '&#xf127;' },
      { name: 'fa-unlock', unicode: '&#xf09c;' },
      { name: 'fa-unlock-alt', unicode: '&#xf13e;' },
      { name: 'fa-unsorted (alias)', unicode: '&#xf0dc;' },
      { name: 'fa-upload', unicode: '&#xf093;' },
      { name: 'fa-usd', unicode: '&#xf155;' },
      { name: 'fa-user', unicode: '&#xf007;' },
      { name: 'fa-user-md', unicode: '&#xf0f0;' },
      { name: 'fa-user-plus', unicode: '&#xf234;' },
      { name: 'fa-user-secret', unicode: '&#xf21b;' },
      { name: 'fa-user-times', unicode: '&#xf235;' },
      { name: 'fa-users', unicode: '&#xf0c0;' },
      { name: 'fa-venus', unicode: '&#xf221;' },
      { name: 'fa-venus-double', unicode: '&#xf226;' },
      { name: 'fa-venus-mars', unicode: '&#xf228;' },
      { name: 'fa-viacoin', unicode: '&#xf237;' },
      { name: 'fa-video-camera', unicode: '&#xf03d;' },
      { name: 'fa-vimeo-square', unicode: '&#xf194;' },
      { name: 'fa-vine', unicode: '&#xf1ca;' },
      { name: 'fa-vk', unicode: '&#xf189;' },
      { name: 'fa-volume-down', unicode: '&#xf027;' },
      { name: 'fa-volume-off', unicode: '&#xf026;' },
      { name: 'fa-volume-up', unicode: '&#xf028;' },
      { name: 'fa-warning (alias)', unicode: '&#xf071;' },
      { name: 'fa-wechat (alias)', unicode: '&#xf1d7;' },
      { name: 'fa-weibo', unicode: '&#xf18a;' },
      { name: 'fa-weixin', unicode: '&#xf1d7;' },
      { name: 'fa-whatsapp', unicode: '&#xf232;' },
      { name: 'fa-wheelchair', unicode: '&#xf193;' },
      { name: 'fa-wifi', unicode: '&#xf1eb;' },
      { name: 'fa-windows', unicode: '&#xf17a;' },
      { name: 'fa-won (alias)', unicode: '&#xf159;' },
      { name: 'fa-wordpress', unicode: '&#xf19a;' },
      { name: 'fa-wrench', unicode: '&#xf0ad;' },
      { name: 'fa-xing', unicode: '&#xf168;' },
      { name: 'fa-xing-square', unicode: '&#xf169;' },
      { name: 'fa-y-combinator-square (alias)', unicode: '&#xf1d4;' },
      { name: 'fa-yahoo', unicode: '&#xf19e;' },
      { name: 'fa-yc-square (alias)', unicode: '&#xf1d4;' },
      { name: 'fa-yelp', unicode: '&#xf1e9;' },
      { name: 'fa-yen (alias)', unicode: '&#xf157;' },
      { name: 'fa-youtube', unicode: '&#xf167;' },
      { name: 'fa-youtube-play', unicode: '&#xf16a;' },
      { name: 'fa-youtube-square', unicode: '&#xf166;' },
    ];

    var FontAwesomeBaseline = [
      'bottom',
      'top',
      'middle',
      'alphabetic',
      'hanging',
      'ideographic',
    ];

    var FontAwesomeTextAlign = ['left', 'right', 'center', 'end', 'start'];

    function getUnicodeByName(name) {
      var idx = FontAwesomeFactory.map(function(x) {
        return x.name;
      }).indexOf(name);
      return FontAwesomeFactory[idx].unicode;
    }

    function getNameByUnicode(unicode) {
      var idx = FontAwesomeFactory.map(function(x) {
        return x.unicode;
      }).indexOf(unicode);
      return FontAwesomeFactory[idx].name;
    }

    function getFontAwesomeIcons() {
      return FontAwesomeFactory;
    }

    function getFontAwesomeNames() {
      return FontAwesomeFactory.map(function(x) {
        return x.name;
      });
    }

    function getFontAwesomeUnicodes() {
      return FontAwesomeFactory.map(function(x) {
        return x.unicode;
      });
    }

    function addFontAwesomeIcon(icon) {
      return FontAwesomeFactory.push(icon);
    }

    function updateFontAwesomeIcon(icon) {
      var idx = FontAwesomeFactory.map(function(x) {
        return x.name;
      }).indexOf(icon.name);
      FontAwesomeFactory[idx] = icon;
    }

    return {
      FontAwesomeFactory: FontAwesomeFactory,
      FontAwesomeBaseline: FontAwesomeBaseline,
      FontAwesomeTextAlign: FontAwesomeTextAlign,
      getUnicodeByName: getUnicodeByName,
      getNameByUnicode: getNameByUnicode,
      getFontAwesomeIcons: getFontAwesomeIcons,
      getFontAwesomeNames: getFontAwesomeNames,
      getFontAwesomeUnicodes: getFontAwesomeUnicodes,
      addFontAwesomeIcon: addFontAwesomeIcon,
      updateFontAwesomeIcon: updateFontAwesomeIcon,
    };
  };
  FontAwesomeFactory.$inject = [];
  return FontAwesomeFactory;
});
