'use strict';
define(function() {
  var toolbarselecttool = function(
    gcStyleFactory,
    $http,
    SelectManager,
    gclayers,
    gcPopup,
    $filter,
    gcRestrictionProvider,
    gcInteractions,
    $rootScope,
    gaJsUtils,
    ogcFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/selecttoolbypolygon/views/toolbarselecttool.html',

      restrict: 'AE',

      link: function(scope, element) {
        scope.pop = null;
        scope.isActive = false;
        scope.altKeyPressed = false;
        var map = scope.map;
        //                var btnElt = $(element.children()[0]);
        var btnElt = $(element[0]);
        scope.$on('closeToolsBar_toolbarselecttoolbypolygon', function() {
          if (scope.drawinteractByPg.getActive()) {
            deactivate();
          }
        });
        btnElt.bind('click', function() {
          if (
            !scope.drawinteractByPg &&
            gclayers.getDrawLayer() instanceof ol.layer.Vector
          )
            setInteraction();

          if (scope.drawinteractByPg) {
            if (scope.drawinteractByPg.getActive()) {
              deactivate();
            } else {
              activate();
            }
          }
        });

        const deactivate = () => {
          scope.drawinteractByPg.setActive(false);
          map.removeInteraction(scope.drawinteractByPg);
          if (scope.toolbarInfo){
            scope.toolbarInfo.setActiveBtn(undefined);
          }
        }

        const activate = () => {
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          scope.drawinteractByPg.setActive(true);
          map.addInteraction(scope.drawinteractByPg);
          if (scope.toolbarInfo){
            scope.toolbarInfo.setActiveBtn('toolbarselecttoolbypolygon');
          }
        }

        function setInteraction() {
          scope.drawinteractByPg = new ol.interaction.Draw({
            source: gclayers.getDrawLayer().getSource(),
            type: 'Polygon',
            condition: function(e) {
              scope.altKeyPressed = e.originalEvent.ctrlKey;
              return true; //always return true but need to set whether shift key is pressed or not
            },
          });

          scope.drawinteractByPg.set('gctype', 'kis');
          scope.drawinteractByPg.set('interaction', 'Draw');
          scope.drawinteractByPg.set('widget', 'select');
          scope.drawinteractByPg.setActive(false);
          gclayers
            .getDrawLayer()
            .getSource()
            .clear();

          //map.addInteraction(scope.drawinteractByPg);

          scope.drawinteractByPg.on('drawend', function(evt) {
            var wktObj = new ol.format.WKT();

            //console.log( );
            var wktStr = wktObj.writeGeometry(evt.feature.getGeometry());
            var spatialClause = 'INTERSECTS(geom, ' + wktStr + ')';
            //console.log(spatialClause);
            var filter = gclayers.getSelectFilterasStringuid(map);
            if (filter != '') {
              ogcFactory.getfeaturespost(
                spatialClause,
                filter,
                map.getView()
                  .getProjection()
                  .getCode()
                ).then(
                function(res) {
                  if (
                    $rootScope.xgos &&
                    $rootScope.xgos.sector === 'hpo' &&
                    $rootScope.xgos.hpo
                  ) {
                    //require('toastr').info($filter('translate')('hpo.common.utilisercefilter'));
                    $rootScope.xgos.hpo.clauseWhere = spatialClause;
                    if (scope.map && scope.map.getView)
                      $rootScope.xgos.hpo.srid = scope.map
                        .getView()
                        .getProjection()
                        .getCode();
                  }

                  gaJsUtils.prepareThingsWhenNewSelection(
                    scope,
                    SelectManager,
                    res
                  );

                  if (res.data.totalFeatures == 0) {
                    gclayers.clearhighLightFeatures();
                    SelectManager.clear();
                    require('toastr').error(
                      $filter('translate')('layermanager.no_selectable_layer')
                    );
                  } else {
                    SelectManager.addFeaturesFromGeojson(res.data);
                    var newScope = $rootScope.$new();
                    newScope.map = scope.map;
                    newScope.panelsManager = scope.panelsManager;
                    var pop = gcPopup.open({
                      scope: newScope,
                      title: 'Informations : ',
                      content: '<div selectfeaturetreewidget></div>',
                      showClose: true,
                      resizable: true,
                      minimizeMaximize: true,
                      minWidth: 430,
                      className: 'no-default-height',
                      onclose: function() {
                        SelectManager.clear();
                      },
                    });
                    gclayers
                      .getDrawLayer()
                      .getSource()
                      .clear();
                    SelectManager.setpop(pop);
                  }
                  gclayers
                    .getDrawLayer()
                    .getSource()
                    .clear();
                },
                function(result) {
                  gcRestrictionProvider.showDetailsErrorMessage(result);
                  if (SelectManager.getpop()) {
                    try {
                      if (SelectManager.getpop().element) {
                        SelectManager.getpop().destroy();
                      }
                      if (SelectManager.getpop().scope) {
                        SelectManager.getpop().scope.$broadcast('$destroy');
                      }
                    } catch (e) {
                      SelectManager.setpop(null);
                    }
                  }
                  gclayers.clearhighLightFeatures();
                  gclayers
                    .getDrawLayer()
                    .getSource()
                    .clear();
                  SelectManager.clear();
                }
              );
            } else {
              gclayers
                .getDrawLayer()
                .getSource()
                .clear();
              map.removeLayer(gclayers.getDrawLayer());
              require('toastr').error(
                $filter('translate')('layermanager.no_selectable_layer')
              );
            }
          });
        }

        if (gclayers.getDrawLayer() instanceof ol.layer.Vector)
          setInteraction();
      },
    };
  };

  toolbarselecttool.$inject = [
    'gcStyleFactory',
    '$http',
    'SelectManager',
    'gclayers',
    'gcPopup',
    '$filter',
    'gcRestrictionProvider',
    'gcInteractions',
    '$rootScope',
    'gaJsUtils',
    'ogcFactory'
  ];
  return toolbarselecttool;
});
