'use strict';
define(function() {
  var staticImageWidget = function(
    gcPropertiesLayers,
    gclayers,
    ParametersFactory,
    FilesFactory,
    gcInteractions,
    PortalsFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/staticImage/views/staticImage.html',

      restrict: 'A',

      link: function(scope, elt, attrs, ctrl) {
        var mode = '';
        var map = scope.map;
        var portalid = angular.module('gcMain').portalid;

        if (portalid == undefined || portalid == '') {
          portalid = PortalsFactory.getPortalId();
        }
        var wgs84Sphere = new ol.Sphere(6378137);
        var sqr = function(a) {
          return a * a;
        };

        var Distance = function(x1, y1, x2, y2) {
          return Math.sqrt(sqr(y2 - y1) + sqr(x2 - x1));
        };
        var XcoordCircle = function(r, cx, a) {
          return cx + r * Math.cos(a);
        };
        var YcoordCircle = function(r, cx, a) {
          return cx + r * Math.sin(a);
        };
        scope.theGraphicUrl;
        scope.XPos;
        scope.YPos;
        scope.X2Pos;
        scope.Y2Pos;
        scope.XMPos;
        scope.YMPos;
        scope.theWidthGeo = 300 * map.getView().getResolution();
        scope.theHeightGeo = 300 * map.getView().getResolution();
        scope.theWidth = 300;
        scope.theHeight = 300;

        scope.theXOffset;
        scope.theYOffset;
        scope.theRotation = 0.0;
        scope.theResolution = 0.0;
        scope.theOpacity = 0.9;
        scope.myImg = null;

        scope.fileNameChanged = function(a) {
          scope.reset();
          scope.staticFile = a.files[0];
          scope.staticFileName = scope.staticFile.name;
          var fd = new FormData();
          fd.append('file', scope.staticFile);
          FilesFactory.uploadprocess(fd).then(function(data) {
            scope.myImg = new Image();
            scope.myImg.onload = function() {
              map.once('click', function(e) {
                var coord = e.coordinate;
                scope.XPos = coord[0];
                scope.YPos = coord[1];
                scope.theHeight = scope.myImg.height;
                scope.theWidth = scope.myImg.width;
                scope.theHeightGeo =
                  scope.theHeight * map.getView().getResolution();
                scope.theWidthGeo =
                  scope.theWidth * map.getView().getResolution();

                scope.X2Pos = scope.XPos + scope.theWidthGeo;
                scope.Y2Pos = scope.YPos + scope.theHeightGeo;
                scope.XMPos = (scope.XPos + scope.X2Pos) / 2;
                scope.YMPos = (scope.YPos + scope.Y2Pos) / 2;
                //console.log(scope.myImg.width);
                //console.log(scope.myImg.height);
                scope.theGraphicUrl = data;
                scope.addStaticImage();
              });
              /*var coord = map.getView().getCenter();
                               scope.XPos = coord[0];
                               scope.YPos = coord[1];
                              scope.theHeight  = scope.myImg.height;
                              scope.theWidth  = scope.myImg.width;
                              scope.theHeightGeo = scope.theHeight * map.getView().getResolution();
                              scope.theWidthGeo = scope.theWidth * map.getView().getResolution() ;
                                           
                         
                              scope.X2Pos   = scope.XPos + scope.theWidthGeo;      
                              scope.Y2Pos   = scope.YPos + scope.theHeightGeo;
                              scope.XMPos   = (scope.XPos + scope.X2Pos)/2;      
                              scope.YMPos   =  (scope.YPos + scope.Y2Pos)/2;      
                              console.log(scope.myImg.width);
                              console.log(scope.myImg.height);
                              scope.theGraphicUrl = data;
                              scope.addStaticImage();*/
              //alert ('The image size is '+width+'*'+height);
            };
            scope.myImg.src =
              '/services/' +
              portalid +
              '/files/getfile?f=json' +
              '&fileName=' +
              scope.staticFileName;
          });
        };

        scope.setWidth = function(v) {
          scope.theWidth = scope.theWidth + v;
          /*  scope.myImg = new Image(scope.theWidth,scope.theHeight );
                  scope.myImg.onload = function() {
                        /*scope.theHeight  = scope.myImg.height;
                        scope.theWidth  = scope.myImg.width;*/
          //alert ('The image size is '+width+'*'+height);
          //scope.pointFeature.setStyle(scope.generateStyle());
          // }
          //scope.myImg.src = '/services/'+portalid+'/files/getfile?f=json' +'&fileName=' +  scope.staticFileName;
          // scope.staticImageLayer.getFeatures().clear();

          //scope.staticImageLayer.addFeature(feature);
        };
        scope.setHeight = function(v) {
          scope.theHeight = scope.theHeight + v;
          /* scope.myImg = new Image(scope.theWidth,scope.theHeight );
                  scope.myImg.onload = function() {
                        /*scope.theHeight  = scope.myImg.height;
                        scope.theWidth  = scope.myImg.width;*/
          //alert ('The image size is '+width+'*'+height);
          //  scope.pointFeature.setStyle(scope.generateStyle());
          // }
          // scope.myImg.src = '/services/'+portalid+'/files/getfile?f=json' +'&fileName=' +  scope.staticFileName;

          // scope.staticImageLayer.getFeatures().clear();
          //scope.pointFeature.setStyle(scope.generateStyle());
          //scope.staticImageLayer.addFeature(feature);
        };
        scope.setOpacity = function(v) {
          scope.theOpacity = scope.theOpacity + v;
          scope.canvasLayer.getSource().changed();

          // scope.staticImageLayer.getFeatures().clear();
          // scope.pointFeature.setStyle(scope.generateStyle());
          //scope.staticImageLayer.addFeature(feature);
        };
        var Xangle = function(Xp, Yp, Xc, Yc, anglerad) {
          return (
            (Xp - Xc) * Math.cos(anglerad) - (Yp - Yc) * Math.sin(anglerad) + Xc
          );
        };
        var Yangle = function(Xp, Yp, Xc, Yc, anglerad) {
          return (
            (Yp - Yc) * Math.cos(anglerad) + (Xp - Xc) * Math.sin(anglerad) + Yc
          );
        };
        scope.setRotation = function(v) {
          scope.theRotation = scope.theRotation + v;
          /* var c1 = ol.proj.transform([scope.XPos, scope.YPos], "EPSG:3857", 'EPSG:4326');
                          var c2 = ol.proj.transform([scope.XMPos, scope.YMPos], "EPSG:3857", 'EPSG:4326');
                          var length = wgs84Sphere.haversineDistance(c1, c2);*/

          var length = Distance(
            scope.XPos,
            scope.YPos,
            scope.XMPos,
            scope.YMPos
          );
          var XPos = Xangle(
            scope.XPos,
            scope.YPos,
            scope.YMPos,
            (scope.theRotation * Math.PI) / 180
          ); //(scope.XPos-scope.XMPos)* Math.cos((scope.theRotation)* Math.PI / 180) - (scope.YPos-scope.YMPos)*Math.sin((scope.theRotation)* Math.PI / 180) +scope.XMPos;
          var YPos = Yangle(
            scope.XPos,
            scope.YPos,
            scope.YMPos,
            (scope.theRotation * Math.PI) / 180
          ); //(scope.YPos-scope.YMPos)* Math.cos((scope.theRotation)* Math.PI / 180) + (scope.XPos-scope.XMPos)*Math.sin((scope.theRotation)* Math.PI / 180) +scope.YMPos;
          var X2Pos = Xangle(
            scope.X2Pos,
            scope.Y2Pos,
            scope.YMPos,
            (scope.theRotation * Math.PI) / 180
          ); //(scope.X2Pos-scope.XMPos)* Math.cos((scope.theRotation)* Math.PI / 180) - (scope.Y2Pos-scope.YMPos)*Math.sin((scope.theRotation)* Math.PI / 180) +scope.XMPos;
          var Y2Pos = Yangle(
            scope.X2Pos,
            scope.Y2Pos,
            scope.YMPos,
            (scope.theRotation * Math.PI) / 180
          ); //(scope.Y2Pos-scope.YMPos)* Math.cos((scope.theRotation)* Math.PI / 180) + (scope.X2Pos-scope.XMPos)*Math.sin((scope.theRotation)* Math.PI / 180) +scope.YMPos;
          var XRotPos = Xangle(
            scope.XPos,
            scope.Y2Pos,
            scope.YMPos,
            (scope.theRotation * Math.PI) / 180
          ); //(scope.XPos-scope.XMPos)* Math.cos((scope.theRotation)* Math.PI / 180) - (scope.Y2Pos-scope.YMPos)*Math.sin((scope.theRotation)* Math.PI / 180) +scope.XMPos;
          var YRotPos = Yangle(
            scope.XPos,
            scope.Y2Pos,
            scope.YMPos,
            (scope.theRotation * Math.PI) / 180
          ); //(scope.Y2Pos-scope.YMPos)* Math.cos((scope.theRotation)* Math.PI / 180) + (scope.XPos-scope.XMPos)*Math.sin((scope.theRotation)* Math.PI / 180) +scope.YMPos;
          /* scope.XPos = XPos;
                          scope.YPos = YPos;
                          scope.X2Pos = X2Pos;
                          scope.Y2Pos = Y2Pos;
                          scope.XMPos = (XPos+X2Pos)/2;
                          scope.YMPos = (YPos+Y2Pos)/2;*/

          var fXPOS1_j = scope.vectorLayer.getSource().getFeatureById('fXPOS1');
          fXPOS1_j.setGeometry(new ol.geom.Point([XPos, YPos]));
          var fXPOS2_j = scope.vectorLayer.getSource().getFeatureById('fXPOS2');
          fXPOS2_j.setGeometry(new ol.geom.Point([X2Pos, Y2Pos]));
          var fXPOSROT_j = scope.vectorLayer
            .getSource()
            .getFeatureById('fXPOSROT');
          fXPOSROT_j.setGeometry(new ol.geom.Point([XRotPos, YRotPos]));
          scope.canvasLayer.getSource().changed();
          // scope.staticImageLayer.getFeatures().clear();
          //scope.pointFeature.setStyle(scope.generateStyle());
          //scope.staticImageLayer.addFeature(feature);
        };
        scope.setselectionLayer = function(layer) {
          //console.log("setvisibilituy");
          if (layer.getVisible()) {
            scope.select.setActive(true);
            scope.modify.setActive(true);
            gcInteractions.setCurrentToolBar(scope.toolBarWidget);
            map.addInteraction(scope.select);
            map.addInteraction(scope.modify);
          } else {
            scope.select.setActive(false);
            scope.modify.setActive(false);
            map.removeInteraction(scope.select);
            map.removeInteraction(scope.modify);
          }
        };
        scope.setVisibilityLayer = function(layer) {
          //console.log("setvisibilituy");
          if (layer.getVisible()) {
            layer.setVisible(false);
          } else {
            layer.setVisible(true);
          }
        };
        scope.reset = function() {
          map.removeInteraction(scope.select);
          map.removeInteraction(scope.modify);
          map.removeLayer(scope.canvasLayer);
          map.removeLayer(scope.vectorLayer);
          scope.canvasLayer = undefined;
          scope.vectorLayer = undefined;
          scope.staticFileName = null;
          scope.layeropacity.value = 10;
          scope.theRotation = 0.0;
        };

        scope.canvasFunction = function(
          extent,
          resolution,
          pixelRatio,
          size,
          projection
        ) {
          var canvas = document.createElement('canvas');
          var context = canvas.getContext('2d');
          var canvasWidth = size[0],
            canvasHeight = size[1];
          canvas.setAttribute('width', canvasWidth);
          canvas.setAttribute('height', canvasHeight);
          //console.log(fXPOS1.getGeometry().getCoordinates()[0] );
          //context.rotate(scope.theRotation* Math.PI / 180);
          // Move registration point to the center of the canvas

          // Canvas extent is different than map extent, so compute delta between
          // left-top of map and canvas extent.
          var mapExtent = map.getView().calculateExtent(map.getSize());
          var canvasOrigin = map.getPixelFromCoordinate([extent[0], extent[3]]);
          var mapOrigin = map.getPixelFromCoordinate([
            mapExtent[0],
            mapExtent[3],
          ]);
          var delta = [
            mapOrigin[0] - canvasOrigin[0],
            mapOrigin[1] - canvasOrigin[1],
          ];

          var pixel = map.getPixelFromCoordinate([
            fXPOS1.getGeometry().getCoordinates()[0],
            fXPOS1.getGeometry().getCoordinates()[1],
          ]);

          var cartoXYpx = map.getPixelFromCoordinate([
            fXPOS1.getGeometry().getCoordinates()[0],
            fXPOS1.getGeometry().getCoordinates()[1],
          ]);

          var cartoX1Y1px = map.getPixelFromCoordinate([
            fXPOS2.getGeometry().getCoordinates()[0],
            fXPOS2.getGeometry().getCoordinates()[1],
          ]);
          var XPost = Xangle(
            fXPOS1.getGeometry().getCoordinates()[0],
            fXPOS1.getGeometry().getCoordinates()[1],
            fXPOSM.getGeometry().getCoordinates()[0],
            fXPOSM.getGeometry().getCoordinates()[1],
            (-scope.theRotation * Math.PI) / 180
          );
          var YPost = Yangle(
            fXPOS1.getGeometry().getCoordinates()[0],
            fXPOS1.getGeometry().getCoordinates()[1],
            fXPOSM.getGeometry().getCoordinates()[0],
            fXPOSM.getGeometry().getCoordinates()[1],
            (-scope.theRotation * Math.PI) / 180
          );
          var X2Post = Xangle(
            fXPOS2.getGeometry().getCoordinates()[0],
            fXPOS2.getGeometry().getCoordinates()[1],
            fXPOSM.getGeometry().getCoordinates()[0],
            fXPOSM.getGeometry().getCoordinates()[1],
            (-scope.theRotation * Math.PI) / 180
          );

          var Y2Post = Yangle(
            fXPOS2.getGeometry().getCoordinates()[0],
            fXPOS2.getGeometry().getCoordinates()[1],
            fXPOSM.getGeometry().getCoordinates()[0],
            fXPOSM.getGeometry().getCoordinates()[1],
            (-scope.theRotation * Math.PI) / 180
          );
          var cartoXYpxl = map.getPixelFromCoordinate([XPost, YPost]);

          var cartoX1Y1pxl = map.getPixelFromCoordinate([X2Post, Y2Post]);
          scope.theWidth = Distance(
            cartoXYpxl[0],
            cartoXYpxl[1],
            cartoX1Y1pxl[0],
            cartoXYpxl[1]
          );
          scope.theHeight = Distance(
            cartoXYpxl[0],
            cartoXYpxl[1],
            cartoXYpxl[0],
            cartoX1Y1pxl[1]
          );

          var cX = pixel[0] + delta[0],
            cY = pixel[1] + delta[1] - scope.theHeight;

          //var cartoY1 = map.getPixelFromCoordinate([]);
          //context.save();
          context.globalAlpha = scope.theOpacity;
          var tx = cX; //-scope.theWidth/2;
          var ty = cY + scope.theHeight; //-scope.theHeight/2;
          context.translate(tx, ty);

          // Rotate 1 degree
          context.rotate((-scope.theRotation * Math.PI) / 180);

          //context.restore();
          context.drawImage(
            scope.myImg,
            0,
            0,
            scope.myImg.width,
            scope.myImg.height,
            0,
            -scope.theHeight,
            scope.theWidth,
            scope.theHeight
          );

          //context.restore();
          context.translate(-tx, -ty);
          //.translate(cX - (scope.theWidth /2),cY-(scope.theHeight /2));
          //context.rotate(-(scope.theRotation* Math.PI / 180));
          // Move registration point back to the top left corner of canvas
          //context.translate( - canvasWidth/2 -scope.theWidth/2, -canvasHeight /2 - scope.theHeight/2);

          return canvas;
        };

        scope.layeropacity = {
          value: Math.round((1 - scope.theOpacity) * 100 * 2) / 2,
        };
        scope.$watch(
          'layeropacity',
          function(opacity) {
            scope.theOpacity = 1 - scope.layeropacity.value / 100;
            if (angular.isDefined(scope.canvasLayer)) {
              scope.canvasLayer.getSource().changed();
            }
            //$rootScope.$broadcast('gcOperationalLayerChange',scope.currlayer,"opacity");
          },
          1
        );
        var fXPOSM, fXPOS1, fXPOS2, fXPOSROT, fXPOS3;
        scope.addStaticImage = function() {
          scope.select = new ol.interaction.Select();
          scope.select.set('gctype', 'kis');
          scope.select.set('interaction', 'Select');
          scope.select.set('widget', 'staticimage');
          scope.modify = new ol.interaction.Modify({
            features: scope.select.getFeatures(),
          });
          scope.modify.set('gctype', 'kis');
          scope.modify.set('interaction', 'Modify');
          scope.modify.set('widget', 'staticimage');

          scope.canvasLayer = new ol.layer.Image({
            source: new ol.source.ImageCanvas({
              canvasFunction: scope.canvasFunction,
              projection: 'EPSG:3857',
            }),
          });
          fXPOSM = new ol.Feature({
            geometry: new ol.geom.Point([scope.XMPos, scope.YMPos]),
          });
          fXPOSM.setId('fXPOSM');
          fXPOS1 = new ol.Feature({
            geometry: new ol.geom.Point([scope.XPos, scope.YPos]),
          });
          fXPOS1.setId('fXPOS1');
          fXPOS3 = new ol.Feature({
            geometry: new ol.geom.Point([scope.X2Pos, scope.YPos]),
            id: 'fXPOS3',
          });

          fXPOS3.setId('fXPOS3');

          fXPOS2 = new ol.Feature({
            geometry: new ol.geom.Point([scope.X2Pos, scope.Y2Pos]),
            id: 'fXPOS2',
          });
          fXPOS2.setId('fXPOS2');
          var fXPOSROT = new ol.Feature({
            geometry: new ol.geom.Point([scope.XPos, scope.Y2Pos]),
            id: 'fXPOSROT',
          });
          fXPOSROT.setId('fXPOSROT');
          var vectorSource = new ol.source.Vector({
            features: [fXPOS1, fXPOS2, fXPOSM, fXPOSROT],
          });

          scope.vectorLayer = new ol.layer.Vector({
            source: vectorSource,
          });

          var lastcoordinate = [0, 0];
          var XL = 0;
          var YL = 0;

          map.on('click', function(evt) {
            lastcoordinate = evt.coordinate;
            var XMPos = fXPOSM.getGeometry().getCoordinates()[0];
            var YMPos = fXPOSM.getGeometry().getCoordinates()[1];

            var XPost = Xangle(
              fXPOS1.getGeometry().getCoordinates()[0],
              fXPOS1.getGeometry().getCoordinates()[1],
              XMPos,
              YMPos,
              (-scope.theRotation * Math.PI) / 180
            );
            var YPost = Yangle(
              fXPOS1.getGeometry().getCoordinates()[0],
              fXPOS1.getGeometry().getCoordinates()[1],
              XMPos,
              YMPos,
              (-scope.theRotation * Math.PI) / 180
            );

            XL = Math.abs(XPost - lastcoordinate[0]);
            YL = Math.abs(YPost - lastcoordinate[1]);
          }); // mouvement du centre
          fXPOSM.on('change', function(evt) {
            //console.log(evt);
            if (
              scope.select
                .getFeatures()
                .item(0)
                .getId() == 'fXPOSM'
            ) {
              //console.log("fXPOSM Change");
              var XMPos = fXPOSM.getGeometry().getCoordinates()[0];
              var YMPos = fXPOSM.getGeometry().getCoordinates()[1];

              var deltaX = XMPos - lastcoordinate[0];
              var deltaY = YMPos - lastcoordinate[1];

              var XPost = Xangle(
                fXPOS1.getGeometry().getCoordinates()[0],
                fXPOS1.getGeometry().getCoordinates()[1],
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );
              var YPost = Yangle(
                fXPOS1.getGeometry().getCoordinates()[0],
                fXPOS1.getGeometry().getCoordinates()[1],
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );
              var X2Post = Xangle(
                fXPOS2.getGeometry().getCoordinates()[0],
                fXPOS2.getGeometry().getCoordinates()[1],
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );

              var Y2Post = Yangle(
                fXPOSROT.getGeometry().getCoordinates()[0],
                fXPOSROT.getGeometry().getCoordinates()[1],
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );
              var X2Rost = Xangle(
                fXPOSROT.getGeometry().getCoordinates()[0],
                fXPOSROT.getGeometry().getCoordinates()[1],
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );
              var Y2Rost = Yangle(
                fXPOSROT.getGeometry().getCoordinates()[0],
                fXPOSROT.getGeometry().getCoordinates()[1],
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );
              //var XL = Math.abs(XPost-lastcoordinate[0]);
              //var YL = Math.abs(YPost-lastcoordinate[1]);
              XPost = XMPos - XL;
              YPost = YMPos - YL;
              X2Post = XMPos + XL;
              Y2Post = YMPos + YL;

              X2Rost = XMPos - XL;
              Y2Rost = YMPos + YL;
              var XPos = Xangle(
                XPost,
                YPost,
                fXPOSM.getGeometry().getCoordinates()[0],
                fXPOSM.getGeometry().getCoordinates()[1],
                (scope.theRotation * Math.PI) / 180
              );
              var YPos = Yangle(
                XPost,
                YPost,
                fXPOSM.getGeometry().getCoordinates()[0],
                fXPOSM.getGeometry().getCoordinates()[1],
                (scope.theRotation * Math.PI) / 180
              );
              var X2Pos = Xangle(
                X2Post,
                Y2Post,
                fXPOSM.getGeometry().getCoordinates()[0],
                fXPOSM.getGeometry().getCoordinates()[1],
                (scope.theRotation * Math.PI) / 180
              );
              var Y2Pos = Yangle(
                X2Post,
                Y2Post,
                fXPOSM.getGeometry().getCoordinates()[0],
                fXPOSM.getGeometry().getCoordinates()[1],
                (scope.theRotation * Math.PI) / 180
              );
              var X2Ros = Xangle(
                X2Rost,
                Y2Rost,
                XMPos,
                YMPos,
                (scope.theRotation * Math.PI) / 180
              );
              var Y2Ros = Yangle(
                X2Rost,
                Y2Rost,
                XMPos,
                YMPos,
                (scope.theRotation * Math.PI) / 180
              );
              var fXPOS1_j = scope.vectorLayer
                .getSource()
                .getFeatureById('fXPOS1');
              fXPOS1_j.setGeometry(new ol.geom.Point([XPos, YPos]));
              var fXPOS2_j = scope.vectorLayer
                .getSource()
                .getFeatureById('fXPOS2');
              fXPOS2_j.setGeometry(new ol.geom.Point([X2Pos, Y2Pos]));
              var fXPOSROT_j = scope.vectorLayer
                .getSource()
                .getFeatureById('fXPOSROT');
              fXPOSROT_j.setGeometry(new ol.geom.Point([X2Ros, Y2Ros]));
              /*var fXPOS1_j = scope.vectorLayer.getSource().getFeatureById("fXPOS1");
                 fXPOS1_j.setGeometry(new ol.geom.Point([scope.XPos, scope.YPos ]));
                 var fXPOS2_j = scope.vectorLayer.getSource().getFeatureById("fXPOS2");
                 fXPOS2_j.setGeometry(new ol.geom.Point([scope.X2Pos, scope.Y2Pos ]))
                 var fXPOSROT_j = scope.vectorLayer.getSource().getFeatureById("fXPOSROT");
                 fXPOSROT_j.setGeometry(new ol.geom.Point([scope.XPos, scope.Y2Pos]))*/
              scope.canvasLayer.getSource().changed();
            }
            // scope.canvasLayer.getSource().changed();
          });
          fXPOS1.on('change', function(evt) {
            if (
              scope.select
                .getFeatures()
                .item(0)
                .getId() == 'fXPOS1'
            ) {
              //console.log("fXPOS1 Change");
              var XPos = fXPOS1.getGeometry().getCoordinates()[0];
              var YPos = fXPOS1.getGeometry().getCoordinates()[1];

              var XMPos = (fXPOS2.getGeometry().getCoordinates()[0] + XPos) / 2;
              var YMPos = (fXPOS2.getGeometry().getCoordinates()[1] + YPos) / 2;
              var Xtemp = Xangle(
                XPos,
                YPos,
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );
              var Ytemp = Yangle(
                XPos,
                YPos,
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );

              var Xtemp2 = Xangle(
                fXPOS2.getGeometry().getCoordinates()[0],
                fXPOS2.getGeometry().getCoordinates()[1],
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );
              var Ytemp2 = Yangle(
                fXPOS2.getGeometry().getCoordinates()[0],
                fXPOS2.getGeometry().getCoordinates()[1],
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );

              var XRotPos = Xangle(
                Xtemp,
                Ytemp2,
                XMPos,
                YMPos,
                (scope.theRotation * Math.PI) / 180
              );
              var YRotPos = Yangle(
                Xtemp,
                Ytemp2,
                XMPos,
                YMPos,
                (scope.theRotation * Math.PI) / 180
              );

              var fXPOSROT_j = scope.vectorLayer
                .getSource()
                .getFeatureById('fXPOSROT');
              fXPOSROT_j.setGeometry(new ol.geom.Point([XRotPos, YRotPos]));
              var fXPOSM_j = scope.vectorLayer
                .getSource()
                .getFeatureById('fXPOSM');
              fXPOSM_j.setGeometry(new ol.geom.Point([XMPos, YMPos]));
              //scope.canvasLayer.getSource().changed();
            }
          });
          fXPOS2.on('change', function(evt) {
            if (
              scope.select
                .getFeatures()
                .item(0)
                .getId() == 'fXPOS2'
            ) {
              //console.log("fXPOS2 Change");
              var XPos = fXPOS2.getGeometry().getCoordinates()[0];
              var YPos = fXPOS2.getGeometry().getCoordinates()[1];
              var XMPos = (fXPOS1.getGeometry().getCoordinates()[0] + XPos) / 2;
              var YMPos = (fXPOS1.getGeometry().getCoordinates()[1] + YPos) / 2;
              var Xtemp = Xangle(
                XPos,
                YPos,
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );
              var Ytemp = Yangle(
                XPos,
                YPos,
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );

              var Xtemp2 = Xangle(
                fXPOS1.getGeometry().getCoordinates()[0],
                fXPOS1.getGeometry().getCoordinates()[1],
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );
              var Ytemp2 = Yangle(
                fXPOS1.getGeometry().getCoordinates()[0],
                fXPOS1.getGeometry().getCoordinates()[1],
                XMPos,
                YMPos,
                (-scope.theRotation * Math.PI) / 180
              );

              var XRotPos = Xangle(
                Xtemp2,
                Ytemp,
                XMPos,
                YMPos,
                (scope.theRotation * Math.PI) / 180
              );
              var YRotPos = Yangle(
                Xtemp2,
                Ytemp,
                XMPos,
                YMPos,
                (scope.theRotation * Math.PI) / 180
              );

              var fXPOSROT_j = scope.vectorLayer
                .getSource()
                .getFeatureById('fXPOSROT');
              fXPOSROT_j.setGeometry(new ol.geom.Point([XRotPos, YRotPos]));
              /*scope.X2Pos = X2Pos;
                    scope.Y2Pos = Y2Pos;
                    scope.XMPos = XMPos;
                    scope.YMPos = YMPos*/
              /*var fXPOSROT_j = scope.vectorLayer.getSource().getFeatureById("fXPOSROT");
                   fXPOSROT_j.setGeometry(new ol.geom.Point([scope.XPos, Y2Pos]))*/
              var fXPOSM_j = scope.vectorLayer
                .getSource()
                .getFeatureById('fXPOSM');
              fXPOSM_j.setGeometry(new ol.geom.Point([XMPos, YMPos]));
            }
            //scope.canvasLayer.getSource().changed();
            //var y=scope.resgeometry.coordinates[1];
            // console.log( fXPOS1.getGeometry().getCoordinates());
            /* scope.X2Pos = fXPOS2.getGeometry().getCoordinates()[0]   ;
                    scope.Y2Pos = fXPOS2.getGeometry().getCoordinates()[1] ;
                     scope.canvasLayer.getSource().changed();*/

            scope.canvasLayer.getSource().changed();
          });

          var angle = function(cx, cy, ex, ey) {
            var dy = ey - cy;
            var dx = ex - cx;
            var theta = Math.atan2(dy, dx); // range (-PI, PI]
            theta *= 180 / Math.PI; // rads to degs, range (-180, 180]
            return theta + 225;
          };
          var angle360 = function(cx, cy, ex, ey) {
            var theta = angle(cx, cy, ex, ey); // range (-180, 180]
            if (theta < 0) theta = 360 + theta; // range [0, 360)
            return theta;
          };
          ///ROTATION A PEU PRES
          fXPOSROT.on('change', function(evt) {
            if (
              scope.select
                .getFeatures()
                .item(0)
                .getId() == 'fXPOSROT'
            ) {
              var XPosROT = fXPOSROT.getGeometry().getCoordinates()[0];
              var YPosROT = fXPOSROT.getGeometry().getCoordinates()[1];

              // current context
              // scope.theRotation = -findAngle(scope.XMPos,YPosROT,scope.XMPos,scope.YMPos,XPosROT,YPosROT);

              var XPost = Xangle(
                fXPOS1.getGeometry().getCoordinates()[0],
                fXPOS1.getGeometry().getCoordinates()[1],
                fXPOSM.getGeometry().getCoordinates()[0],
                fXPOSM.getGeometry().getCoordinates()[1],
                (-scope.theRotation * Math.PI) / 180
              );
              var YPost = Yangle(
                fXPOS1.getGeometry().getCoordinates()[0],
                fXPOS1.getGeometry().getCoordinates()[1],
                fXPOSM.getGeometry().getCoordinates()[0],
                fXPOSM.getGeometry().getCoordinates()[1],
                (-scope.theRotation * Math.PI) / 180
              );
              var X2Post = Xangle(
                fXPOS2.getGeometry().getCoordinates()[0],
                fXPOS2.getGeometry().getCoordinates()[1],
                fXPOSM.getGeometry().getCoordinates()[0],
                fXPOSM.getGeometry().getCoordinates()[1],
                (-scope.theRotation * Math.PI) / 180
              );
              var Y2Post = Yangle(
                fXPOS2.getGeometry().getCoordinates()[0],
                fXPOS2.getGeometry().getCoordinates()[1],
                fXPOSM.getGeometry().getCoordinates()[0],
                fXPOSM.getGeometry().getCoordinates()[1],
                (-scope.theRotation * Math.PI) / 180
              );
              scope.theRotation = angle360(
                fXPOSM.getGeometry().getCoordinates()[0],
                fXPOSM.getGeometry().getCoordinates()[1],
                XPosROT,
                YPosROT
              );

              var XPos = Xangle(
                XPost,
                YPost,
                fXPOSM.getGeometry().getCoordinates()[0],
                fXPOSM.getGeometry().getCoordinates()[1],
                (scope.theRotation * Math.PI) / 180
              );
              var YPos = Yangle(
                XPost,
                YPost,
                fXPOSM.getGeometry().getCoordinates()[0],
                fXPOSM.getGeometry().getCoordinates()[1],
                (scope.theRotation * Math.PI) / 180
              );
              var X2Pos = Xangle(
                X2Post,
                Y2Post,
                fXPOSM.getGeometry().getCoordinates()[0],
                fXPOSM.getGeometry().getCoordinates()[1],
                (scope.theRotation * Math.PI) / 180
              );
              var Y2Pos = Yangle(
                X2Post,
                Y2Post,
                fXPOSM.getGeometry().getCoordinates()[0],
                fXPOSM.getGeometry().getCoordinates()[1],
                (scope.theRotation * Math.PI) / 180
              );
              //var XRotPos = (fXPOS1.getGeometry().getCoordinates()[0]  -scope.XMPos)* Math.cos((scope.theRotation)* Math.PI / 180) - (scope.Y2Pos-scope.YMPos)*Math.sin((scope.theRotation)* Math.PI / 180) +scope.XMPos;
              //var YRotPos = (scope.Y2Pos-scope.YMPos)* Math.cos((scope.theRotation)* Math.PI / 180) + (scope.XPos-scope.XMPos)*Math.sin((scope.theRotation)* Math.PI / 180) +scope.YMPos;

              var fXPOS1_j = scope.vectorLayer
                .getSource()
                .getFeatureById('fXPOS1');
              fXPOS1_j.setGeometry(new ol.geom.Point([XPos, YPos]));
              var fXPOS2_j = scope.vectorLayer
                .getSource()
                .getFeatureById('fXPOS2');
              fXPOS2_j.setGeometry(new ol.geom.Point([X2Pos, Y2Pos]));
            }
            //var y=scope.resgeometry.coordinates[1];
            // console.log( fXPOS1.getGeometry().getCoordinates());

            scope.canvasLayer.getSource().changed();
          });
          map.addLayer(scope.canvasLayer);
          map.addLayer(scope.vectorLayer);
          scope.iselect = true;
          scope.aselect = true;
          scope.select.setActive(true);
          scope.modify.setActive(true);
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          map.addInteraction(scope.select);
          map.addInteraction(scope.modify);

          /*   scope.pointFeature = new ol.Feature(new ol.geom.Point(coord));
                scope.staticImageLayer =
                  new ol.layer.Vector({
                          source: new ol.source.Vector({
                            features: [scope.pointFeature]
                          }),
                          style:scope.generateStyle(),
                        })

                /* new ol.layer.Image({
                          source: new ol.source.ImageStatic({
                            
                            url: '/services/'+portalid+'/files/getfile?f=json' +'&fileName=' + fileName,
                            projection: map.getView().getProjection(),
                            imageExtent:  map.getView().calculateExtent(map.getSize())
                          })
                        });*/
          //map.addLayer(scope.staticImageLayer);
        };
      },
    };
  };

  staticImageWidget.$inject = [
    'gcPropertiesLayers',
    'gclayers',
    'ParametersFactory',
    'FilesFactory',
    'gcInteractions',
    'PortalsFactory',
  ];
  return staticImageWidget;
});
