/*global define */
define(function() {
  'use strict';

  var symbollibrary = function() {
    var types = {};

    types.POINT = [
      {
        label: 'Big blue dot!',
        json: [
          {
            PointSymbolizer: [
              {
                Graphic: {
                  Mark: {
                    WellKnownName: 'circle',
                    Fill: {
                      CssParameter: {
                        _name: 'fill',
                        __text: '#0000ff',
                      },
                    },
                  },
                },
              },
            ],
          },
        ],
      },
      {
        label: 'Strange!',
        json: [
          {
            PointSymbolizer: [
              {
                Graphic: {
                  Size: 20,
                  Mark: {
                    WellKnownName: 'circle',
                    Fill: {
                      CssParameter: {
                        _name: 'fill',
                        __text: '#0faf00',
                      },
                    },
                    Stroke: {
                      CssParameter: [
                        {
                          _name: 'stroke',
                          __text: '#ee0439',
                        },
                        {
                          _name: 'stroke-dasharray',
                          __text: '4 2',
                        },
                        {
                          _name: 'stroke-width',
                          __text: '5',
                        },
                      ],
                    },
                  },
                },
              },
              {
                Graphic: {
                  Size: 15,
                  Mark: {
                    WellKnownName: 'circle',
                    Fill: {
                      CssParameter: {
                        _name: 'fill',
                        __text: '#ff0000',
                      },
                    },
                    Stroke: {
                      CssParameter: {
                        _name: 'stroke',
                        __text: '#000000',
                      },
                    },
                  },
                },
              },
              {
                Graphic: {
                  Size: 10,
                  Mark: {
                    WellKnownName: 'circle',
                    Fill: {
                      CssParameter: {
                        _name: 'fill',
                        __text: '#00ff00',
                      },
                    },
                  },
                },
              },
            ],
          },
        ],
      },
    ];

    types.LINE = [
      {
        label: 'River',
        json: [
          {
            LineSymbolizer: [
              {
                Stroke: {
                  CssParameter: [
                    { _name: 'stroke', __text: '#c0dfff' },
                    { _name: 'stroke-width', __text: '3' },
                  ],
                },
              },
            ],
          },
        ],
      },
      {
        label: 'Road',
        json: [
          {
            LineSymbolizer: [
              {
                Stroke: {
                  CssParameter: [
                    { _name: 'stroke', __text: '#444444' },
                    { _name: 'stroke-width', __text: '10' },
                  ],
                },
              },
              {
                Stroke: {
                  CssParameter: [
                    { _name: 'stroke', __text: '#ffffff' },
                    { _name: 'stroke-width', __text: '3' },
                    {
                      _name: 'stroke-dasharray',
                      __text: '5',
                    },
                    {
                      _name: 'stroke-dashoffset',
                      __text: '5',
                    },
                  ],
                },
              },
            ],
          },
        ],
      },
      {
        label: 'Yellowish',
        json: [
          {
            LineSymbolizer: [
              {
                Stroke: {
                  CssParameter: [
                    { _name: 'stroke', __text: '#febc00' },
                    { _name: 'stroke-width', __text: '8' },
                  ],
                },
              },
              {
                Stroke: {
                  CssParameter: [
                    { _name: 'stroke', __text: '#f7a70b' },
                    { _name: 'stroke-width', __text: '5' },
                  ],
                },
              },
              {
                Stroke: {
                  CssParameter: [
                    { _name: 'stroke', __text: '#949206' },
                    { _name: 'stroke-width', __text: '2' },
                  ],
                },
              },
            ],
          },
        ],
      },
    ];

    types.POLYGON = [
      {
        label: 'Griddy',
        json: [
          {
            PolygonSymbolizer: [
              {
                Fill: {
                  CssParameter: {
                    _name: 'fill',
                    __text: '#f1f4c7',
                  },
                },
                Stroke: {
                  CssParameter: [
                    { _name: 'stroke', __text: '#afb38a' },
                    {
                      _name: 'stroke-width',
                      __text: '0.26',
                    },
                    {
                      _name: 'stroke-linejoin',
                      __text: 'bevel',
                    },
                  ],
                },
              },
              {
                Fill: {
                  GraphicFill: {
                    Graphic: {
                      Mark: {
                        WellKnownName: 'shape://times',
                        Stroke: {
                          CssParameter: [
                            {
                              _name: 'stroke',
                              __text: '#990099',
                            },
                            {
                              _name: 'stroke-width',
                              __text: '1',
                            },
                          ],
                        },
                      },
                    },
                  },
                },
              },
            ],
          },
        ],
      },
    ];

    return {
      templateUrl: 'js/XG/widgets/mapapp/style/views/symbollibrary.html',
      restrict: 'A',
      scope: {
        type: '@',
        symbol: '=',
      },
      link: function(scope) {
        scope.selectSymbol = function(symbol) {
          scope.symbol = symbol;
        };

        types.MULTIPOINT = types.POINT;
        scope.symbols = types[scope.type];
        if (!scope.symbols) {
          console.error('Unknown symbol type in library:', scope.type);
        }
      },
    };
  };

  symbollibrary.$inject = [];

  return symbollibrary;
});
