'use strict';
define([
  'angular',
  'widgets/mapapp/style/services/sldUtils',
  'widgets/mapapp/style/directives/styleeditor',
  'widgets/mapapp/style/directives/styleeditorunique',
  'widgets/mapapp/style/directives/symbollibrary',
  'widgets/mapapp/style/directives/palettelibrary',
  'widgets/mapapp/style/directives/sldfilter',
  'widgets/mapapp/style/directives/sldlegend',
  'widgets/mapapp/style/directives/paletteviewer',
  'widgets/mapapp/style/directives/fontdisplayer',
  'widgets/mapapp/style/directives/radiuspicker',
  'widgets/mapapp/style/directives/radiusattributepicker',
  'widgets/mapapp/style/directives/xgoscolourpicker',

  'widgets/mapapp/style/directives/symbolizer/sldpointsymbolizer',
  'widgets/mapapp/style/directives/symbolizer/sldsimplepointsymbolizer',
  'widgets/mapapp/style/directives/symbolizer/sldimagesymbolizer',
  'widgets/mapapp/style/directives/symbolizer/sldlinesymbolizer',
  'widgets/mapapp/style/directives/symbolizer/sldsimplelinesymbolizer',
  'widgets/mapapp/style/directives/symbolizer/sldpolygonsymbolizer',
  'widgets/mapapp/style/directives/symbolizer/sldtextsymbolizer',
], function(
  angular,
  sldUtils,
  styleeditor,
  styleeditorunique,
  symbollibrary,
  palettelibrary,
  sldfilter,
  sldlegend,
  paletteviewer,
  fontdisplayer,
  radiuspicker,
  radiusattributepicker,
  xgoscolourpicker,
  sldpointsymbolizer,
  sldsimplepointsymbolizer,
  sldimagesymbolizer,
  sldlinesymbolizer,
  sldsimplelinesymbolizer,
  sldpolygonsymbolizer,
  sldtextymbolizer
) {
  // generation du module
  var gcstyleeditor = angular.module('gc_style', []);

  /**
   * Finds the css parameter in the parent array according to its name
   */
  gcstyleeditor.filter('cssParam', [
    function() {
      return function(parent, name) {
        // parent has to be defined
        if (typeof parent == 'undefined') return {};
        // force parent.CssParameter as an array if it doesnt exist / contains a signle value
        if (!parent.hasOwnProperty('CssParameter'))
          parent = { CssParameter: [] };
        if (!angular.isArray(parent.CssParameter))
          parent.CssParameter = [parent.CssParameter];

        var found = false;
        parent.CssParameter.forEach(function(cssp) {
          if (cssp._name == name) found = cssp;
        });

        if (!found) {
          parent.CssParameter.push({
            _name: name,
            __text: '',
          });
          found = parent.CssParameter[parent.CssParameter.length - 1];
        }

        return found;
      };
    },
  ]);

  /**
   * Finds the vendor parameter in the parent array according to its name
   */
  gcstyleeditor.filter('vendorParam', [
    function() {
      return function(parent, name) {
        // parent has to be defined
        if (typeof parent == 'undefined') return {};

        var found = null;
        if (parent && parent.hasOwnProperty('VendorOption')) {
          parent.VendorOption.forEach(function(vdo) {
            if (vdo._name == name) found = vdo;
          });

          return found;
        }
      };
    },
  ]);

  // sld Utils
  gcstyleeditor.provider('sldUtils', sldUtils);

  // Directives
  gcstyleeditor.directive('styleEditor', styleeditor);
  gcstyleeditor.directive('styleEditorUnique', styleeditorunique);
  gcstyleeditor.directive('symbolLibrary', symbollibrary);
  gcstyleeditor.directive('paletteLibrary', palettelibrary);
  gcstyleeditor.directive('sldFilter', sldfilter);
  gcstyleeditor.directive('sldLegend', sldlegend);
  gcstyleeditor.directive('paletteViewer', paletteviewer);
  gcstyleeditor.directive('fontDisplayer', fontdisplayer);
  gcstyleeditor.directive('radiusPicker', radiuspicker);
  gcstyleeditor.directive('radiusAttributePicker', radiusattributepicker);
  gcstyleeditor.directive('xgosColourPicker', xgoscolourpicker);

  // ---------- Symbolizers
  gcstyleeditor.directive('sldPointSymbolizer', sldpointsymbolizer);
  gcstyleeditor.directive('sldSimplePointSymbolizer', sldsimplepointsymbolizer);
  gcstyleeditor.directive('sldImageSymbolizer', sldimagesymbolizer);
  gcstyleeditor.directive('sldLineSymbolizer', sldlinesymbolizer);
  gcstyleeditor.directive('sldSimplelineSymbolizer', sldsimplelinesymbolizer);
  gcstyleeditor.directive('sldPolygonSymbolizer', sldpolygonsymbolizer);
  gcstyleeditor.directive('sldTextSymbolizer', sldtextymbolizer);

  return gcstyleeditor;
});
