'use strict';
define(function() {
  var tierceController = function($scope, tierceService, zoomService) {
    $scope.data = data;
    $scope.map = $scope.getMap($scope);

    /**
     * Get map
     * @param aScope
     */
    $scope.getMap = function(aScope) {
      if (aScope == null) {
        return undefined;
      }

      if (aScope.map != undefined) {
        return aScope.map;
      } else {
        return $scope.getMap(aScope.$parent);
      }
    };

    /**
     * get data
     * @param arg1
     */
    $scope.getData = function(arg1) {
      console.log('Getting data in controller for the input param : ' + arg1);
      return tierceService.getData(arg1);
    };

    /**
     * set data
     * @param arg1
     */
    $scope.setData = function(arg1) {
      console.log('Setting data in controller for the input param : ' + arg1);
      tierceService.setData(arg1);
    };

    /**
     * Get current date
     * @param arg1
     */
    $scope.getCurrentDate = function(arg1) {
      console.log(
        'Getting current date in controller for the input param : ' + arg1
      );
      return zoomService.getCurrentYear();
    };

    $scope.zoomPlus = function() {
      console.log('Zooming ...');
      return zoomService.zoom($scope.map);
    };
  };

  tierceController.$inject = ['$scope', 'tierceService', 'zoomService'];

  return tierceController;
});
