/**
 *
 */
'use strict';
define(function() {
  var gcMainCarteController = function(
    $scope,
    CarteAppFactory,
    AlertHpoFactory,
    $filter,
    ngDialog,
    DataStoreFactory,
    CarteInitProvider,
    gaDomUtils,
    ConfigFactory,
    $rootScope,
    $location,
    $interval
  ) {
    $scope.isConfigDone = undefined;
    $scope.updateConfig = function() {
      gaDomUtils.showGlobalLoader();
      CarteAppFactory.updateConfig($scope.CarteConfig).then(
        function(res) {
          if (res && res.data) {
            $scope.CarteConfig = res.data;
            CarteInitProvider.setHpoConfig($scope.CarteConfig);
            CarteInitProvider.initialiseApplication().then(
              function() {
                CarteAppFactory.initFactory();
                $scope.isConfigDone = true;
                $scope.dialog.close();
                gaDomUtils.hideGlobalLoader();
              },
              function() {
                gaDomUtils.hideGlobalLoader();
              }
            );
          } else {
            gaDomUtils.hideGlobalLoader();
          }
        },
        function(res) {
          AlertHpoFactory.showErrorMessage(res);
          gaDomUtils.hideGlobalLoader();
        }
      );
    };

    $scope.initApp = function(datastore, manipulate_data, multicritere) {
      if (datastore) {
        $scope.CarteConfig.datastoreuid = datastore.uid;
        $scope.CarteConfig.datastoreName = datastore.name;
        $scope.CarteConfig.dbmutualise = datastore.dbmutualise;
        $scope.CarteConfig.manipulate_data = manipulate_data;
        $scope.CarteConfig.multicritere = multicritere;
        CarteInitProvider.setHpoConfig($scope.CarteConfig);
        CarteAppFactory.initFactory();
        $scope.updateConfig();
      }
    };

    ConfigFactory.get('main', 'appconfig').then(
      function(res) {
        if (((res && res.data) || res.data === '')&& (res.data.code !== 403)) {
          CarteInitProvider.initialiseApplication().then(function() {
            if (res.data && res.data.datastoreuid) {
              $scope.CarteConfig = res.data;
              CarteInitProvider.setHpoConfig($scope.CarteConfig);
              CarteAppFactory.initFactory();
              $scope.isConfigDone = true;
            } else {
              $scope.CarteConfig = {};
              CarteInitProvider.setHpoConfig($scope.CarteConfig);
              CarteAppFactory.initFactory();
              $scope.isConfigDone = false;
              DataStoreFactory.get().then(
                function(res) {
                  if (res && res.data) {
                    $scope.datastores = res.data;
                    $scope.initDatastore = undefined;
                    $scope.multicritere = false;
                    $scope.dialog = ngDialog.open({
                      template:
                        'js/XG/widgets/mapappv2/main/views/controller/config.html',
                      className: 'ngdialog-theme-plain width800 configHpo',
                      closeByDocument: false,
                      title: $filter('translate')('hpo.init.datastore'),
                      scope: $scope,
                    });
                  }
                },
                function(res) {
                  AlertHpoFactory.showErrorMessage(res);
                }
              );
            }
          });
        }
      },
      function(res) {
        AlertHpoFactory.showErrorMessage(res);
      }
    );

    // TODO Recup id from URL
    function getParameterByName(name) {
      name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
      var regex = new RegExp('[\\?&]' + name + '=([^&#]*)'),
        results = regex.exec($location.$$absUrl);
      return results === null
        ? ''
        : decodeURIComponent(results[1].replace(/\+/g, ' '));
    }

    $scope.mode = getParameterByName('mode');
    localStorage.setItem('mode', $scope.mode);

    $scope.app = getParameterByName('app');
    localStorage.setItem('app', $scope.app);

    $scope.portalid = getParameterByName('portal');

    var gcMain = angular.module('gcMainHpo');
    gcMain.app = $scope.app;
    gcMain.portalid = $scope.portalid;

    if (!$rootScope.xgos) $rootScope.xgos = {};
    if (!$rootScope.xgos.hpo)
      $rootScope.xgos.hpo = {
        clauseWhere: '1=1',
        srid: undefined,
        operands: [],
      };

    $rootScope.initApplicationInformations = function() {
      CarteInitProvider.initialiseApplication().then(
        function() {
          console.log('Init done with success');
          var callback = function(isconfirm) {
            if (isconfirm) {
              $rootScope.$broadcast('inititaliseApplicationBranch');
            }
          };
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.info'),
            $filter('translate')('hpo.common.refreshModule'),
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
          // AlertHpoFactory.getSimpleSuccess( $filter('translate')('hpo.common.info'),
          //         $filter('translate')('hpo.common.reloaded') , false , "success");
        },
        function() {
          console.error('unable to reinitialise application parameter');
          AlertHpoFactory.showErrorMessage(res);
        }
      );
    };
  };
  gcMainCarteController.$inject = [
    '$scope',
    'CarteAppFactory',
    'AlertHpoFactory',
    '$filter',
    'ngDialog',
    'DataStoreFactory',
    'CarteInitProvider',
    'gaDomUtils',
    'ConfigFactory',
    '$rootScope',
    '$location',
    '$interval',
  ];

  return gcMainCarteController;
});
