'use strict';
define(function() {
  var InitCtrl = function(
    $scope,
    ngDialog,
    SirocoFactory,
    ParametersFactory,
    FeatureTypeFactory,
    QueryFactory,
    $window,
    $timeout,
    gaDomUtils,
    $location,
    gaJsUtils,
    SridFactory,
    $rootScope,
    $translate
  ) {
    var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));
    //$scope.allowValidation = !sirocoCfg.mainConfig.validation_faite;
    $scope.allowValidation = true;
    $scope.readyToCommit = false;
    $scope.countGotten = false;
    $scope.countGottenOnce = false;

    $scope.layerInfo = {};
    $scope.layerInfo.cana = { cfgLayerId: 'cana_aep_import', count: null };
    $scope.layerInfo.leak = { cfgLayerId: 'fuite', count: null };
    $scope.layerInfo.node = { cfgLayerId: 'noeud_import', count: null };

    $scope.srids = SridFactory.sridsList;
    $scope.forceIEWSrcSrid = {};

    /*
         *  on aura par exemple:

         *    $scope.layerInfo.cana.count: nombre d'enregistrement dans la table
         *    $scope.layerInfo.cana.lastImportDate: date du dernier import
         *    $scope.layerInfo.cana.fullfilled:  correspondance complète (true/false)
         *
         *    $scope.layerInfo.lastCommitDate: date de la dernière validation
         */

    var canaAepName = sirocoCfg.layersNames.cana_aep_import;
    var fuiteName = sirocoCfg.layersNames.fuite;
    var noeudName = sirocoCfg.layersNames.noeud_import;

    $scope.checkAllCountAreGotten = function() {
      for (var li in $scope.layerInfo)
        if ($scope.layerInfo[li].count == null) {
          $scope.countGotten = false;
          return;
        }
      if ($scope.countGottenOnce) $scope.countGotten = true;
      else $scope.countGottenOnce = true;
    };

    $scope.getLayerContentSize = function(fTypeUid, layerid) {
      QueryFactory.data(fTypeUid, '', undefined, 1, 0).then(function(res) {
        $scope.layerInfo[layerid].count = res.data.realTotalFeatures;
        $scope.checkAllCountAreGotten();
      });
    };

    $scope.getLayerFullfilled = function(layerid) {
      $scope.layerInfo[layerid].fullfilled = true;
      SirocoFactory.getsirocomissinginfo(
        sirocoCfg.appname,
        $scope.layerInfo[layerid].cfgLayerId
      ).then(function(res) {
        console.log('getLayerFullfilled: ' + res.data.valeur);
        if (res.data.valeur == null)
          $scope.layerInfo[layerid].fullfilled = false;
        else
          for (var ind = 0; ind < res.data.valeur.length; ind++) {
            if (
              res.data.valeur[ind].obligatoire &&
              !res.data.valeur[ind].obtenuDepuisDonneesDescriptive
            ) {
              $scope.layerInfo[layerid].fullfilled = false;
              break;
            }
          }
      });
    };

    $scope.getLayerInfo = function(fTypeUid, layerid) {
      console.log('getLayerInfo');
      $scope.layerInfo[layerid].ftUid = fTypeUid;
      $scope.getLayerContentSize(fTypeUid, layerid);
      $scope.getLayerFullfilled(layerid);
      $scope.getLastImportDate(fTypeUid, layerid);
    };

    FeatureTypeFactory.get().then(function() {
      console.log('canaAepName:' + canaAepName);

      FeatureTypeFactory.resources.featuretypes.forEach(function(fType) {
        if (fType.name == canaAepName) {
          $scope.canaAepFt = fType;
          $scope.getLayerInfo(fType.uid, 'cana');
        }
        if (fType.name == fuiteName) {
          $scope.fuiteFt = fType;
          $scope.getLayerInfo(fType.uid, 'leak');
        }
        if (fType.name == noeudName) {
          $scope.noeudFt = fType;
          $scope.getLayerInfo(fType.uid, 'node');
        }
      });
    });

    /**
         s        * Import SHP FILE
         */
    $scope.importSHP = function(shapetype, action) {
      $scope.impLayerId = shapetype;
      switch (shapetype) {
        case 'cana':
          $scope.destftiuid = $scope.canaAepFt.uid;
          break;
        case 'leak':
          $scope.destftiuid = $scope.fuiteFt.uid;
          break;
        case 'node':
          $scope.destftiuid = $scope.noeudFt.uid;
          break;
      }

      $scope.noPrj = false;
      $scope.replaceMode = action == 'replace';
      $scope.impDialog = ngDialog.open({
        template:
          'js/XG/widgets/sirocoapp/init/views/modals/modal.importshp.html',
        className: 'ngdialog-theme-plain width800 nopadding miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.getLastImportDate = function(destftiuid, layerid) {
      ParametersFactory.getbyname('dernier_import' + destftiuid).then(function(
        res
      ) {
        if (res.data != undefined && res.data != '')
          $scope.layerInfo[layerid].lastImportDate =
            res.data.data.lastImportDate;
      });
    };

    $scope.getLastCommitDate = function() {
      ParametersFactory.getbyname('siroco_derniere_validation').then(function(
        res
      ) {
        if (res.data != undefined && res.data != '')
          $scope.lastCommitDate = res.data.data.lastCommitDate;
      });
    };
    $scope.getLastCommitDate();

    $scope.storeValidationDate = function(destftiuid) {
      ParametersFactory.getbyname('siroco_derniere_validation').then(function(
        res
      ) {
        var theData;
        var d = new Date();
        if (res.data != undefined && res.data != '') {
          theData = res.data.data;
          theData.lastCommitDate = d.getTime();
          ParametersFactory.update(res.data, res.data.id).then(function(res1) {
            console.log('storeValidationDate: ' + res1.data);
          });
        } else {
          theData = {};
          theData.lastCommitDate = d.getTime();
          ParametersFactory.add(
            theData,
            'siroco_data',
            'siroco_derniere_validation'
          ).then(function(res1) {
            ParametersFactory.publish(res1.data.id, '', '', '', 'public_rw');
            console.log('storeValidationDate2: ' + res.data);
          });
        }
        $scope.lastCommitDate = d.getTime();
      });
    };

    $scope.storeLastImportDate = function(destftiuid) {
      ParametersFactory.getbyname('dernier_import' + destftiuid).then(function(
        res
      ) {
        var theData;
        var d = new Date();
        console.log('storeLastImportDate');
        if (res.data != undefined && res.data != '') {
          theData = res.data.data;
          theData.lastImportDate = d.getTime();
          ParametersFactory.update(res.data, res.data.id).then(function(res1) {
            console.log('storeLastImportDate: ' + res1.data);
            $scope.getLayerInfo($scope.destftiuid, $scope.impLayerId);
          });
        } else {
          theData = {};
          theData.lastImportDate = d.getTime();
          ParametersFactory.add(
            theData,
            'siroco_data',
            'dernier_import' + destftiuid
          ).then(function(res1) {
            ParametersFactory.publish(res1.data.id, '', '', '', 'public_rw');
            console.log('storeLastImportDate2: ' + res.data);
            $scope.getLayerInfo($scope.destftiuid, $scope.impLayerId);
          });
        }
        $scope.lastCommmitDate = d.getTime();
      });
    };

    /*
     *      Quand on ferme la fenêtre d'import, récupérer la quantité d'objet du composant
     *  dans lequel des données ont trés probablement été chargées.
     *  ceci permet l'actualisation des commandes de la fenêtre.'
     */
    $scope.$on('importexportwidget_importdone', function(e, data) {
      $scope.importDoneWhen = Date.now();
      $scope.noPrj = false;
      if (e.currentScope.$id == $scope.$id) {
        console.log('importexportwidget_importdone');
        $scope.storeLastImportDate($scope.destftiuid);
        $scope.getLayerInfo($scope.destftiuid, $scope.impLayerId);
      }
    });

    /**
     * checkMissingImportFiles
     * @param files
     */
    var checkMissingImportFiles = function(files) {
      console.log('yo');
      var loadedShapeFiles = {};
      files.forEach(function(f) {
        var extension = gaJsUtils.getFileExtension(f.name);
        if (extension != '') loadedShapeFiles[extension.replace('.', '')] = 1;
      });
      ['shp', 'shx', 'dbf'].forEach(function(ext) {
        if (!loadedShapeFiles[ext])
          require('toastr').error(
            'Aucun fichier <b>' + ext + "</b> n'a été chargé.",
            null,
            {
              closeButton: true,
              timeOut: '0',
              extendedTimeOut: '0',
            }
          );
      });

      $scope.noPrj = !loadedShapeFiles.prj;
    };

    // whenever the importexport widget dropzone is ready
    var delayCheckMissing = 0;
    $scope.$on('importexportwidget_dropzone_ready', function(e, data) {
      if (data.destftiuid == $scope.destftiuid) {
        data.dz.on('addedfile', function(file) {
          // dropzone exposes only this event, which is called multiple times if multiple files are loaded at once
          // so we use a timeout and a cancel if its called again anytime soon (.5s)

          if (delayCheckMissing) $timeout.cancel(delayCheckMissing);
          delayCheckMissing = $timeout(function() {
            checkMissingImportFiles(data.dz.files);
          }, 500);
        });

        data.dz.on('removedfile', function(file) {
          if (Date.now().getTime - $scope.importDoneWhen > 1000)
            $scope.noPrj = file.name.indexOf('.prj') != -1;
        });
      }
    });

    /**
     * import donnees descriptives
     */
    $scope.importDescriptionData = function(layerid) {
      var ftType = $scope.layerInfo[layerid].cfgLayerId;

      $scope.descFT = {
        id: 'donnees_descriptives_' + ftType,
        featuretype: 'siroco',
      };

      var descDialog = ngDialog.open({
        template:
          'js/XG/widgets/sirocoapp/init/views/modals/modal.importdescdata.html',
        className: 'ngdialog-theme-plain  nopadding miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /**
     *
     * @param appname
     * @param ftType
     * @returns {*}
     */
    $scope.getAvailabeDataForMissingData = function(appname, ftType) {
      var promise = SirocoFactory.getstructuredonnesdescriptives(
        sirocoCfg.appname,
        ftType
      );
      promise.then(function(res) {
        $scope.descdata.available = res.data.objValeur;
      });

      return promise;
    };
    var currentFtTupe;
    $scope.$on('feature_attachment_edit', function() {
      $scope.getAvailabeDataForMissingData(sirocoCfg.appname, currentFtTupe);
    });

    $scope.getLinksFromSavedConfig = function(ftType) {
      var promise = ParametersFactory.getbyname(
        'configuration_donnees_descriptives'
      );
      promise.then(function(res) {
        var alreadyExists = false;
        var savedData = {
          app: sirocoCfg.appname,
        };
        if (res.data != undefined && res.data != '') {
          savedData = res.data.data;
          alreadyExists = true;
        }

        if (alreadyExists && savedData[ftType] != undefined)
          $scope.links = savedData[ftType].links;
      });
      return promise;
    };

    $scope.clearLinksRmAlreadyLinked = function() {
      var indLnk, indMd;
      var lnk, md;
      var suppression = true;
      var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));

      while (suppression) {
        suppression = false;
        for (indLnk = 0; indLnk < $scope.links.length; indLnk++) {
          lnk = $scope.links[indLnk];
          for (indMd = 0; indMd < $scope.descdata.missing.length; indMd++) {
            md = $scope.descdata.missing[indMd];
            if (md.information == lnk.info && md.obtenuDepuisDonneesDescriptive)
              break;
          }
          if (indMd == $scope.descdata.missing.length) {
            //-- Lien non trouvé dans les données manquantes:
            //-- La correspondance a changée et,
            //-- ce lien n'est plus utile car on prend désormais
            //-- l'information dans les cana directement.
            $scope.links.splice(indLnk, 1);
            suppression = true;
          }
        }
      }
    };

    $scope.clearLinksSortLinks = function() {
      var indLnk,
        indMd,
        indLnkPrec = -1;
      var lnk, md;
      var deplace = true;

      while (deplace) {
        deplace = false;
        //-- Tente de mettre en phase la liste des liens
        //-- avec celle des données manquantes du point
        //-- de vue de l'ordre des informations.
        for (indLnk = 0; indLnk < $scope.links.length; indLnk++) {
          lnk = $scope.links[indLnk];
          for (indMd = 0; indMd < $scope.descdata.missing.length; indMd++) {
            md = $scope.descdata.missing[indMd];
            if (md.information == lnk.info) {
              if (indLnk != indMd) {
                //-- Déplacement du lien au même indice que celui de la donnée manquante.
                $scope.links.splice(
                  indMd,
                  0,
                  $scope.links.splice(indLnk, 1)[0]
                );
                deplace = true;
              }
              break;
            }
          }
        }
        if (indLnkPrec == indLnk) {
          //-- Si on fait plusieurs le déplacement du même lien,
          //-- c'est qu'il est impossible de le déplacer,
          //-- donc on va déplacer la donnée manquante.
          //-- Une des cause possibles est qu'il y a plus
          //-- de données manquantes que de liens.
          //-- Tente de mettre en phase la liste des données manquantes
          //-- avec celle des liens du point
          //-- de vue de l'ordre des informations.
          for (indMd = 0; indMd < $scope.descdata.missing.length; indMd++) {
            md = $scope.descdata.missing[indMd];
            for (indLnk = 0; indLnk < $scope.links.length; indLnk++) {
              lnk = $scope.links[indLnk];
              if (md.information == lnk.info) {
                if (indLnk != indMd) {
                  //-- Déplacement de la donnée manquante au même indice que celui du lien.
                  $scope.descdata.missing.splice(
                    indLnk,
                    0,
                    $scope.descdata.missing.splice(indMd, 1)[0]
                  );
                  deplace = true;
                }
                break;
              }
            }
          }
        }
        indLnkPrec = indLnk;
      }
    };

    $scope.clearLinksAddLinksFromMd = function() {
      var indMd;
      for (
        indMd = $scope.links.length;
        indMd < $scope.descdata.missing.length;
        indMd++
      ) {
        $scope.links.push({
          info: $scope.descdata.missing[indMd].information,
        });
      }
    };

    $scope.clearLinks = function() {
      $scope.clearLinksRmAlreadyLinked();
      $scope.clearLinksSortLinks();
      $scope.clearLinksAddLinksFromMd();
    };

    /**
     * checkDescriptionData
     */
    $scope.checkDescriptionData = function(layerid) {
      var ftType = $scope.layerInfo[layerid].cfgLayerId;
      currentFtTupe = ftType;

      $scope.descFT = {
        id: 'donnees_descriptives_' + ftType,
        featuretype: 'siroco',
      };

      $scope.descdata = {
        missing: [],
        available: [],
      };
      $scope.links = [];

      $scope
        .getAvailabeDataForMissingData(sirocoCfg.appname, ftType)
        .then(function(res) {
          // columns array
          SirocoFactory.getsirocomissinginfo(sirocoCfg.appname, ftType).then(
            function(res) {
              $scope.descdata.missing = res.data.valeur;

              $scope.descdata.missing.forEach(function(a, i) {
                $scope.links[i] = {
                  info: a.information,
                };
              });

              $scope.getLinksFromSavedConfig(ftType).then(function() {
                $scope.clearLinks();
                $scope.destftiuid = $scope.layerInfo[layerid].ftUid;
                $scope.impLayerId = layerid;
                var missingDataDialog = ngDialog.open({
                  template:
                    'js/XG/widgets/sirocoapp/init/views/modals/modal.missingdata.html',
                  className:
                    'ngdialog-theme-plain width800 nopadding miniclose',
                  closeByDocument: false,
                  scope: $scope,
                });
              });
            }
          );
        });
    };

    /**
     * return available columns in a file
     */
    $scope.getFileCols = function(index) {
      var cols = [];
      if (angular.isDefined($scope.links[index])) {
        $scope.descdata.available.forEach(function(available) {
          if (available.fichier == $scope.links[index].fichier) {
            cols = available.cols.sort();
          }
        });
      }
      return cols;
    };

    /**
     * check whether description data links are correct
     */
    $scope.invalidLinks = function() {
      var invalid = false;
      $scope.descdata.missing.forEach(function(m, index) {
        var link = $scope.links[index],
          invalidLink =
            !angular.isDefined(link.fichier) || !angular.isDefined(link.champ);
        if (m.obligatoire && invalidLink) {
          invalid = true;
        }
      });

      return invalid;
    };

    /**
     * submit description data links
     */
    $scope.submitLinks = function() {
      ParametersFactory.getbyname('configuration_donnees_descriptives').then(
        function(res) {
          var alreadyExists = false;
          var saveData = {
            app: sirocoCfg.appname,
          };
          if (res.data != undefined && res.data != '') {
            saveData = res.data;
            alreadyExists = true;
          }
          var ftType = $scope.layerInfo[$scope.impLayerId].cfgLayerId;

          if (!alreadyExists) {
            console.log('submitLinks');
            if (saveData[ftType] == undefined) saveData[ftType] = {};
            saveData[ftType].links = $scope.links;
            ParametersFactory.add(
              saveData,
              '',
              'configuration_donnees_descriptives'
            ).then(
              function(res1) {
                console.log('ParametersFactory: ' + res1.data);
                //--   Quand on enregistre une correspondance,
                //-- actualiser les informations descriptive du layer.
                $scope.getLayerInfo($scope.destftiuid, $scope.impLayerId);
                require('toastr').success('Configuration enregistrée');
              },
              function() {
                require('toastr').error(
                  "L'enregistrement de la configuration a échoué !"
                );
              }
            );
          } else {
            if (saveData.data[ftType] == undefined) saveData.data[ftType] = {};
            saveData.data[ftType].links = $scope.links;
            ParametersFactory.update(saveData, res.data.id).then(
              function(res1) {
                console.log('ParametersFactory: ' + res1.data);
                //--   Quand on enregistre une correspondance,
                //-- actualiser les informations descriptive du layer.
                $scope.getLayerInfo($scope.destftiuid, $scope.impLayerId);
                require('toastr').success('Configuration enregistrée');
              },
              function() {
                require('toastr').error(
                  "L'enregistrement de la configuration a échoué !"
                );
              }
            );
          }
        }
      );
    };

    $scope.showDvReturnedInfo = function(jsonStr) {
      $scope.reportOfDomainsModif = JSON.parse(jsonStr);
      $scope.sdriDialog = ngDialog.open({
        template:
          'js/XG/widgets/sirocoapp/init/views/modals/modal.parametersevolution.html',
        className: 'ngdialog-theme-plain width800 nopadding miniclose',
        closeByDocument: false,
        scope: $scope,
      });
      $scope.sdriDialog.closePromise.then(function() {
        $timeout(function() {
          $location.search('done', null);
          $location.path('/siroco/map', null);
        }, 1000);
      });
    };

    $scope.getStepStyleReadyToCommit = function(layerid, readytocommit) {
      $scope.readyToCommit = false;
      if (
        $scope.layerInfo['cana'].state == 'donnees chargees et incompletes' ||
        $scope.layerInfo['node'].state == 'donnees chargees et incompletes'
      )
        return;

      if (
        $scope.layerInfo['cana'].state == 'donnees a valider' ||
        $scope.layerInfo['node'].state == 'donnees a valider'
      )
        $scope.readyToCommit = true;

      return;
    };

    $scope.getStepStyle = function(layerid, step) {
      if (
        $scope.layerInfo[layerid].count == 0 ||
        $scope.layerInfo[layerid].count == undefined
      )
        $scope.layerInfo[layerid].state = 'vide';
      else {
        $scope.layerInfo[layerid].state = 'donnees chargees';
        if (!$scope.layerInfo[layerid].fullfilled)
          $scope.layerInfo[layerid].state = 'donnees chargees et incompletes';
        else {
          $scope.layerInfo[layerid].state = 'donnees chargees et completes';
          if (
            $scope.lastCommitDate == undefined ||
            $scope.lastCommitDate < $scope.layerInfo[layerid].lastImportDate
          )
            $scope.layerInfo[layerid].state = 'donnees a valider';
          else $scope.layerInfo[layerid].state = 'donnees validees';
        }
      }
      $scope.getStepStyleReadyToCommit();

      if (step == 'loaded') {
        if (
          $scope.layerInfo[layerid].count == 0 ||
          $scope.layerInfo[layerid].count == undefined
        )
          return 'redstep';
        else return 'greenstep';
      }
      if (step == 'loaded_missing_data') {
        if (
          $scope.layerInfo[layerid].count == 0 ||
          $scope.layerInfo[layerid].count == undefined
        )
          return 'greystep';
        if (!$scope.layerInfo[layerid].fullfilled) return 'redstep';
        else return 'greenstep';
      }
      if (step == 'loaded_committed') {
        if (
          $scope.layerInfo[layerid].count == undefined ||
          $scope.layerInfo[layerid].count == 0
        )
          $scope[layerid + '_loaded_committed'] = 'greystep';
        if ($scope.layerInfo[layerid].lastImportDate != undefined) {
          if (!$scope.layerInfo[layerid].fullfilled)
            $scope[layerid + '_loaded_committed'] = 'greystep';
          else if (
            $scope.lastCommitDate == undefined ||
            $scope.lastCommitDate < $scope.layerInfo[layerid].lastImportDate
          ) {
            if (
              $scope.layerInfo[layerid].state == 'donnees chargees et completes'
            )
              $scope.layerInfo[layerid].state = 'donnees a valider';
            $scope[layerid + '_loaded_committed'] = 'redstep';
          } else {
            $scope[layerid + '_loaded_committed'] = 'greenstep';
            $scope.layerInfo[layerid].state = 'donnees validees';
          }
        }
        return $scope[layerid + '_loaded_committed'];
      }
    };

    /**
     * validateData
     */
    $scope.validateData = function() {
      var ans = confirm(
        "Êtes-vous certain de vouloir lancer la validation des données et l'initialisation de l'application ?"
      );
      if (ans) {
        gaDomUtils.showGlobalLoader();
        SirocoFactory.datavalidation(sirocoCfg.appname).then(
          function(res) {
            if (res.data.ok) {
              sirocoCfg.mainConfig.validation_faite = true;
              $rootScope.$broadcast('siroco.activateNavigationInit');
              $scope.storeValidationDate();
              require('toastr').success(
                'Application initialisée, chargement en cours...'
              );
              gaDomUtils.hideGlobalLoader();
              if (res.data.strValeur != '') {
                $scope.showDvReturnedInfo(res.data.strValeur);
              } else {
                $timeout(function() {
                  $location.search('done', null);
                  $location.path('/siroco/map', null);
                }, 1000);
              }
              /*
                         $timeout(function(){
                         SirocoFactory.getSirocoCfg().then(function(){
                         $location.search('done', '1');
                         $window.location.reload();
                         gaDomUtils.hideGlobalLoader();
                         });
                         }, 1000);
                         */
            } else {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                'Echec de la validation: ' + res.data.errorMessage
              );
            }
          },
          function(res) {
            require('toastr').error(res.data.errorMessage, 'Erreur', {
              closeButton: true,
              timeOut: '0',
              extendedTimeOut: '0',
              positionClass: 'toast-bottom-full-width',
            });
            gaDomUtils.hideGlobalLoader();
          }
        );
      }
    };

    /**
     * load parameter mapping
     * @param data
     */
    $scope.loadMapping = function(data) {
      data.data.forEach(function(x, i) {
        $scope.links.forEach(function(y, j) {
          if (x.info == y.info) {
            $scope.descdata.available.forEach(function(file) {
              if (x.fichier && file.fichier == x.fichier) {
                y.fichier = x.fichier;
                if (x.champ) y.champ = x.champ;
              }
            });
          }
        });
      });
    };

    /**
     * save parameter mapping
     * @param data
     */
    $scope.saveMapping = function(data) {
      ParametersFactory.add(
        $scope.links,
        'siroco_import_donnees_descriptive',
        data
      ).then(function(res) {
        $translate('common.configuration_saved').then(function(res) {
          $rootScope.$broadcast('refreshParameterMappingList', {
            type: 'siroco_import_donnees_descriptive',
          });
          require('toastr').success(res);
        });
      });
    };

    $scope.loadInfoOfSirocoLayers = function() {
      FeatureTypeFactory.get().then(function() {
        console.log('loadInfoOfSirocoLayers: ' + canaAepName);

        FeatureTypeFactory.resources.featuretypes.forEach(function(fType) {
          if (fType.name == canaAepName) {
            $scope.canaAepFt = fType;
            $scope.getLayerInfo(fType.uid, 'cana');
          }
          if (fType.name == fuiteName) {
            $scope.fuiteFt = fType;
            $scope.getLayerInfo(fType.uid, 'leak');
          }
          if (fType.name == noeudName) {
            $scope.noeudFt = fType;
            $scope.getLayerInfo(fType.uid, 'node');
          }
        });
      });
    };

    $scope.loadInfoOfSirocoLayers0 = function() {
      if (!$scope.countGotten) {
        $scope.loadInfoOfSirocoLayers();
        $timeout($scope.loadInfoOfSirocoLayers0, 500);
      }
    };

    $scope.loadInfoOfSirocoLayers0();
  };

  InitCtrl.$inject = [
    '$scope',
    'ngDialog',
    'SirocoFactory',
    'ParametersFactory',
    'FeatureTypeFactory',
    'QueryFactory',
    '$window',
    '$timeout',
    'gaDomUtils',
    '$location',
    'gaJsUtils',
    'SridFactory',
    '$rootScope',
    '$translate',
  ];
  return InitCtrl;
});
