'use strict';
define(function() {
  var varianteCompareCtrl = function(
    $scope,
    ParametersFactory,
    $location,
    SirocoFactory,
    $sce,
    gaDomUtils
  ) {
    var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));

    /**
     * get liste variantes
     */
    var getListeVariantes = function() {
      ParametersFactory.getbytype('siroco_variante').then(function(res) {
        if (res.data.length > 0) {
          $scope.variantesList = {};
          res.data.forEach(function(cfg) {
            if (cfg.data.app == sirocoCfg.appuid && cfg.data.Generee == 'oui') {
              $scope.variantesList[cfg.name] = false;
            }
          });
        }
      });
    };
    getListeVariantes();

    $scope.comparisonLimit = {};

    /**
     * Check if at least two variantes are selected
     * @returns {boolean}
     */
    $scope.atLeastTwoVariantesSelected = function() {
      var nbselected = 0;
      for (var i in $scope.variantesList) {
        if ($scope.variantesList[i]) nbselected++;
      }
      return nbselected > 1;
    };

    /**
     * compareVariantes
     */

    $scope.compareVariantes = function() {
      var varianteNames = [];
      for (var name in $scope.variantesList) {
        if ($scope.variantesList[name]) varianteNames.push(name);
      }

      gaDomUtils.showGlobalLoader();
      SirocoFactory.generationgraphe(
        sirocoCfg.appname,
        'Comparaison',
        $scope.comparisonLimit.amount,
        '',
        '',
        varianteNames.join(';'),
        ''
      ).then(function(res) {
        if (res.data.ok) {
          $scope.comparisonResult = { src: res.data.strValeur };
          gaDomUtils.hideGlobalLoader();
          document
            .getElementById('comparoFrame')
            .contentDocument.location.reload(); // reload the frame
        } else {
          require('toastr').error(
            res.data.errorMessage,
            'Erreur dans lors de la comparaison',
            {
              closeButton: true,
              timeOut: '0',
              extendedTimeOut: '0',
              positionClass: 'toast-bottom-full-width',
            }
          );
          gaDomUtils.hideGlobalLoader();
        }
      });
    };
  };

  varianteCompareCtrl.$inject = [
    '$scope',
    'ParametersFactory',
    '$location',
    'SirocoFactory',
    '$sce',
    'gaDomUtils',
  ];
  return varianteCompareCtrl;
});
