'use strict';
define(function() {
  var paramsList = function(
    SirocoFactory,
    ParametersFactory,
    $filter,
    gaJsUtils,
    $sce
  ) {
    return {
      templateUrl:
        'js/XG/widgets/sirocoapp/init/views/directives/paramslist.html',
      restrict: 'EA',
      scope: {
        type: '=type',
        parametrage: '=parametrage',
        refresh: '&',
      },
      link: function(scope, elt, attrs, ctrl) {
        console.log(scope.parametrage);
        var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));
        scope.params = [];

        var feedDataOnlyFeed = function() {
          if (
            scope.parametrage.data.parametres == undefined ||
            scope.parametrage.data.parametres.length == undefined
          )
            return;
          var param;
          //scope.parametrage.data.parametres.forEach(function(param,index){
          for (
            var index = 0;
            index < scope.parametrage.data.parametres.length;
            index++
          ) {
            param = scope.parametrage.data.parametres[index];
            if (param.type_parametre == scope.type) {
              scope.params.push({
                label: param.NomEnClair,
                data: param,
                index: index,
                classes: [param.completeStyle],
              });
            }
          }
          setTimeout(scope.checkChildren, 600);
        };

        scope.checkChildren = function() {
          if (scope.$$childHead == undefined)
            setTimeout(scope.checkChildren, 600);
          else scope.$$childHead.$apply();
        };

        var feedData = function() {
          scope.params = [];
          feedDataOnlyFeed();
          scope.currentParam = false;
        };

        scope.displayParamDescription = function(d) {
          return $sce.trustAsHtml(d.replace(/\\n/g, '<br/>'));
        };

        var setParametrageData = function() {
          // load default model
          var isEmptyParam =
            !scope.parametrage.data.hasOwnProperty('parametres') ||
            scope.parametrage.data.parametres.length == 0;
          if (isEmptyParam) {
            SirocoFactory.getemptych(sirocoCfg.appname).then(function(res) {
              console.log(res.data);
              if (res.data.ok) {
                scope.parametrage.data.parametres = gaJsUtils.sortByKey(
                  res.data.valeur.Parametres,
                  'NomEnClair'
                );
                feedData();
                if (scope.parametrage.data.parametres.length != 0)
                  scope.currentParam = scope.parametrage.data.parametres[0];
              } else {
                //require('toastr').clear();
                require('toastr').error(
                  res.data.errorMessage,
                  'Erreur dans lors du la récupération du paramétrage',
                  {
                    closeButton: true,
                    timeOut: '0',
                    extendedTimeOut: '0',
                    positionClass: 'toast-bottom-full-width',
                  }
                );
              }
            });
          } else {
            feedData();
            if (scope.parametrage.data.parametres.length != 0)
              scope.currentParam = scope.parametrage.data.parametres[0];
          }
        };
        setParametrageData();

        // external change, another parametrage was loaded
        scope.$watch('parametrage.id', function(id, oldId) {
          if (id != oldId) {
            setParametrageData();
          }
        });

        scope.$watch('parametrage.changes', function() {
          var ll = scope.params.length;
          scope.params.splice(0, ll);
          feedDataOnlyFeed();
        });

        scope.$on('sirocoRefreshParamsList', function() {
          var ll = scope.params.length;
          scope.params.splice(0, ll);
          feedDataOnlyFeed();
        });

        scope.currentParam = false;
        scope.paramsFeat = {}; // tree handler
        scope.paramsFeatHandler = function(param) {
          scope.currentParam = param;
        };

        /**
         * saveCorpsHypotheses
         */
        scope.saveCorpsHypotheses = function() {
          scope.params.forEach(function(param) {
            var indexInFullList = param.index;
            scope.parametrage.data.parametres[indexInFullList] = param.data;
          });
          delete scope.parametrage['changes'];

          ParametersFactory.update(
            scope.parametrage,
            scope.parametrage.id
          ).then(function(res) {
            require('toastr').success($filter('translate')('common.saved'));
          });
        };

        /**
         * delete
         */
        scope.deleteCorpsHypotheses = function() {
          var ans = confirm(
            'Êtes-vous certain de vouloir supprimer ce parametrage ?'
          );
          if (ans) {
            ParametersFactory.remove(scope.parametrage.id).then(function() {
              scope.refresh();
            });
          }
        };

        /**
         * expand complexe (tableau)
         * @param index1
         * @param index2
         */
        scope.prepareExpandTableau = function(index1, index2) {
          scope.copyHistory = [];
          scope.expandParameters = {
            index1: index1,
            index2: index2,
            mode: 'complex',
          };
        };

        scope.prepareExpand = function(index) {
          scope.copyHistory = [];
          scope.expandParameters = {
            index1: index,
            mode: 'simple',
          };
        };

        // ---------------

        /**
         * cancelLastExpand
         */
        scope.cancelLastExpand = function() {
          var previous = scope.copyHistory.shift();

          if (scope.expandParameters.mode == 'simple') {
            scope.currentParam.data.ListeValeurs = previous;
          }
          if (scope.expandParameters.mode == 'complex') {
            scope.currentParam.data.TableauValeurs = previous;
          }
        };

        scope.copyParamValue = function(direction) {
          if (scope.expandParameters.mode == 'simple') {
            scope.copyHistory.push(
              angular.copy(scope.currentParam.data.ListeValeurs)
            );

            var index = scope.expandParameters.index1,
              value = scope.currentParam.data.ListeValeurs[index];

            for (var idx in scope.currentParam.data.ListeValeurs) {
              idx = parseInt(idx);
              if (
                (direction == 'top' && idx < index) ||
                (direction == 'bottom' && idx > index)
              ) {
                scope.currentParam.data.ListeValeurs[idx] = value;
              }
            }
          }

          if (scope.expandParameters.mode == 'complex') {
            scope.copyHistory.push(
              angular.copy(scope.currentParam.data.TableauValeurs)
            );

            var index1 = scope.expandParameters.index1,
              index2 = scope.expandParameters.index2,
              value = scope.currentParam.data.TableauValeurs[index1][index2];

            for (var idx1 in scope.currentParam.data.TableauValeurs) {
              var line = scope.currentParam.data.TableauValeurs[idx1];
              for (var idx2 in line) {
                idx1 = parseInt(idx1);
                idx2 = parseInt(idx2);
                // top left
                if (direction == 'topleft') {
                  if (idx1 <= index1 && idx2 <= index2) {
                    line[idx2] = value;
                  }
                }
                // top
                if (direction == 'top') {
                  if (idx1 < index1 && idx2 == index2) {
                    line[idx2] = value;
                  }
                }
                // top right
                if (direction == 'topright') {
                  if (idx1 <= index1 && idx2 >= index2) {
                    line[idx2] = value;
                  }
                }

                // top
                if (direction == 'left') {
                  if (idx1 == index1 && idx2 < index2) {
                    line[idx2] = value;
                  }
                }

                // top
                if (direction == 'right') {
                  if (idx1 == index1 && idx2 > index2) {
                    line[idx2] = value;
                  }
                }
                // bottom left
                if (direction == 'bottomleft') {
                  if (idx1 >= index1 && idx2 <= index2) {
                    line[idx2] = value;
                  }
                }
                // bottom
                if (direction == 'bottom') {
                  if (idx1 > index1 && idx2 == index2) {
                    line[idx2] = value;
                  }
                }
                // bottom right
                if (direction == 'bottomright') {
                  if (idx1 >= index1 && idx2 >= index2) {
                    line[idx2] = value;
                  }
                }
              }
              /*if(direction=='top' && idx<index ||
                             direction=='bottom' && idx>index) {
                             scope.currentParam.data.ListeValeurs[idx] = value;
                             }*/
            }
          }
        };
      },
    };
  };

  paramsList.$inject = [
    'SirocoFactory',
    'ParametersFactory',
    '$filter',
    'gaJsUtils',
    '$sce',
  ];
  return paramsList;
});
