'use strict';
define(function() {
  var gcelement = function(
    gclayers,
    $http,
    FeatureTypeFactory,
    elasticQueryService,
    ElasticFactory,
    ElasticReplacementFactory,
    $filter,
    SelectManager,
    gcPopup,
    panelsManager,
    gaDomUtils,
    ngDialog,
    $rootScope,
    ParametersFactory,
    AncAppSearchFactory,
    extendedNgDialog,
    $timeout,
    $q,
    AncAppFactory,
    BacAppFactory,
    $location,
    QueryFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/elastic/views/elasticfilter.html',
      restrict: 'A',
      scope: {
        map: '=?map',
        data: '=res',
        fti: '=?',
        mobileApplication: '=?',
        place: '=',
        ftid: '=?',
        relations: '=?',
        attributes: '=?',
        searchquery: '=?',
        addspecial: '=?',
        index: '=?',
        relationdashbord: '=?',
        querydashboard: '=?',
        onfinish: '&',
        restrictFtids: '=?', // if set, only ftids contained in this array can be used for searchs
        allowFieldsConfiguration: '=?', // allow the user to specifiy rule configuration (ie visibility)
        filterId: '=?', // uniqid of the filter, used to identify the filter amongst others,
        saveOriginalProperties: '=?', // if set to true, the json answer will contain, foreach attribute, a copy of the original properties,
        relationalQuery: '=?', // used to retrieve the relational query without saving it to a parameter
        interventionSimpleMode: '=?',
        broadcastResult: '=?', // whether to broadcast the result
        onSuccessCallback: '=?', // this function will be called on search success
        onNewSearch: '=?', // this function will be called on 'reset' button
        // AND 'search' button
        querySrid: '@querySrid'
      },
      link: function(scope) {
        let data = scope.data;
        scope.isSearching = false;
        scope.mode = $location.search().mode;
        scope.updateDashboard = {};

        /**
         * Partie concernant relational
         */
        scope.relations = scope.relations || [{}];
        scope.fieldsConfiguration = {};
        scope.resultsConfiguration = {};

        scope.disableAttributeSelection = false;
        if (scope.interventionSimpleMode == 'render') {
          scope.disableAttributeSelection = true;
        }

        if (!angular.isDefined(scope.pickFields)) scope.pickFields = false;
        scope.applicationType = $rootScope.xgos.sector;
        scope.applicationIsAnc = false;

        if (!angular.isDefined(scope.data)) scope.data = {};
        if (angular.isDefined(scope.relationalQuery)) {
          // @TODO unifier avec le comportement de base
          var d = { request: angular.copy(scope.relationalQuery) };
          console.log(angular.copy(d));

          var datas = d.request.relations;
          scope.relations = [];
          datas.map(function(x) {
            scope.relations.push(x);
          });
          scope.jointure = d.request.jointure;
          if (d.request.jointure && d.request.jointure.length > 0) {
            scope.relationdashbord = getSavedParameters(d.request.jointure);
          } else {
            $rootScope.$broadcast('elastic_resetRelationDashBoard', {});
          }
          // fieldsConfiguration
          scope.fieldsConfiguration = d.request.fieldsConfiguration
            ? d.request.fieldsConfiguration
            : {};
          scope.resultsConfiguration = d.request.resultsConfiguration
            ? d.request.resultsConfiguration
            : {};
          scope.writequeryname = false;
          scope.queryname = d.request.name;

          $timeout(function() {
            if (scope.interventionSimpleMode == 'builder') {
              scope.$watch(
                function() {
                  return [scope.relations, scope.fieldsConfiguration];
                },
                function() {
                  scope.relationalQuery = angular.copy({
                    user: $rootScope.xgos.user.login,
                    relations: scope.relations,
                    jointure: scope.relationdashbord,
                    fieldsConfiguration: scope.fieldsConfiguration,
                    resultsConfiguration: scope.resultsConfiguration,
                  });
                },
                1
              );
            }
          });
        }

        if (scope.applicationType == 'anc' || scope.applicationType == 'bac') {
          var CurrentAppFactory =
            scope.applicationType == 'bac' ? BacAppFactory : AncAppFactory;
          scope.applicationIsAnc = true;

          scope.fakeJsonFti = { v: {} };
          var nomControleJson =
            scope.applicationType === 'bac'
              ? 'kis_bac_dossier_controle'
              : 'kis_anc_dossier_controle';

          var checkCtrlAlias = FeatureTypeFactory.resources.featuretypes.filter(
            function(x) {
              // @TODO RB Reactiver ici pour faire apparaitre dans bac
              return x.name == nomControleJson;
            }
          );
          if (checkCtrlAlias.length)
            scope.controleAlias = checkCtrlAlias[0].alias;

          var champsJsonARecharger = [];
          var recuperationChampsExtraJson = false;
          scope.$watch(
            'fakeJsonFti.v',
            function(f) {
              if (f.attributes && f.attributes.length) {
                // si le fti comprends plus de champ, on le recupere dans la réponse
                recuperationChampsExtraJson =
                  f.attributes.length > checkCtrlAlias[0].attributes.length;

                scope.componentftis.map(function(c, i) {
                  if (c.name == nomControleJson) {
                    if (champsJsonARecharger.length) {
                      for (var i in champsJsonARecharger) {
                        f.attributes.map(function(x) {
                          if (x.name == champsJsonARecharger[i].name) {
                            x.selected = true;
                          }
                        });
                      }
                      champsJsonARecharger = [];
                    }
                    scope.componentftis[i] = f;
                  }
                });
              }
            },
            1
          );

          scope.doResetDashboard = function() {
            elasticQueryService
              .parseJointureRelationsAnc(scope.componentftis, scope.relations)
              .then(function(res) {
                scope.relationdashbord = angular.copy(res);
                console.log(res);
              });
          };
          scope.$watch('filterTabs.activeTab', function(t, prev) {
            if (angular.isDefined(t)) {
              // init relationdashbord
              if (t > 0) {
                console.log(scope.relationdashbord);

                elasticQueryService
                  .parseJointureRelationsAnc(
                    scope.componentftis,
                    scope.relations,
                    scope.relationdashbord
                  )
                  .then(function(res) {
                    scope.relationdashbord = angular.copy(res);
                    console.log(res);
                  });
              }
            }
          });
        }

        if (scope.applicationIsAnc == true || scope.interventionSimpleMode) {
          // tabs utilisés pour spécifier requete et attributs/jointures/ordre
          // anc seulement (pour le moment / intervention simple ?)

          scope.filterTabs = [
            { title: 'Requête' },
            { title: 'Attributs à retourner' },
            { title: 'Affichage des résultats' },
          ];
          scope.filterTabs.activeTab = 0;
        }

        if ($rootScope.xgos.user != undefined)
          scope.currentUser = $rootScope.xgos.user.login;
        scope.annulerModif = function() {
          scope.config = {
            sizes: [50, 100, 200, 500, 1000, 2000, 5000, 10000, 500000],
            size: 500000,
            personaliseParUser: false,
            searchExacte: false,
            consideredUniqueString: false,
            espaceInterpreted: false,
            espaceInterpretedS: true,
          };

          // limite le nb de resultats a 200 sur les interventions simples
          if (scope.interventionSimpleMode) {
            scope.config.size = 150;
          }
        };
        scope.annulerModif();
        scope.selectFti = {};
        if (!data) data = {};
        data.fields = {};

        /* displayTranslatedAlias
         * @param alias
         * @returns {string}
         */
        scope.displayTranslatedAlias = function(alias) {
          var name = scope.componentftis.filter(function(x) {
              return x.alias == alias;
            })[0].name,
            key = 'features.' + name + '.alias';

          return !~$filter('translate')(key).indexOf(key)
            ? $filter('translate')(key)
            : alias;
        };

        scope.filters = [];
        scope.myfilter = { inElasticSearch: true };

        function getFtis() {
          if (scope.applicationType != 'anc' || angular.isDefined(scope.map)) {
            var promise = FeatureTypeFactory.get();
          } else {
            var def = $q.defer();
            def.resolve();
            promise = def.promise;
          }

          promise.then(function(res) {
            if (scope.applicationType === 'anc') {
              scope.componentftis = FeatureTypeFactory.resources.featuretypes
              .filter( fti =>
                  [
                    'kis_anc_dossier',
                    'kis_anc_dossier_controle',
                    'kis_anc_dossier_filiere',
                    'kis_anc_vidange_formulaire',
                  ].includes(fti.name) ||
                    fti.name.startsWith('kis_anc_ef_')
                );
            } else if (scope.applicationType === 'bac') {
              scope.componentftis = FeatureTypeFactory.resources.featuretypes.filter(
                x => x.name === 'kis_bac_dossier' || x.name === 'kis_bac_dossier_controle');
            } else {
              scope.componentftis = FeatureTypeFactory.resources.featuretypes;
            }

            // remove non authorized components
            if (angular.isDefined(scope.restrictFtids)) {
              scope.componentftis = scope.componentftis.filter(function(x) {
                if (~scope.restrictFtids.indexOf(x.uid)) return x;
              });
            }

            // regroupe par categorie pour l'anc
            if (scope.applicationType === 'anc') {
              scope.component = scope.componentftis.map(function(x) {
                x.category =
                  [
                    'kis_anc_dossier',
                    'kis_anc_dossier_controle',
                    'kis_anc_vidange_formulaire',
                    'kis_anc_dossier_filiere',
                  ].indexOf(x.name) !== -1
                    ? 'Général'
                    : 'Éléments de filière';
                return x;
              });
            } else if (scope.applicationType === 'bac') {
              scope.component = scope.componentftis.map(function(x) {
                x.category =
                  ['kis_bac_dossier', 'kis_bac_dossier_controle'].indexOf(
                    x.name
                  ) !== -1
                    ? 'Général'
                    : 'Éléments de filière';
                return x;
              });
            } else {
              scope.component = scope.componentftis
                .map(function(x) {
                  return x.alias;
                })
                .filter(function(x) {
                  if (x) return x;
                });
            }
          });
          return promise;
        }
        getFtis();

        scope.$watch('selectGlobal', function(newval, oldval) {
          if (newval && newval !== oldval) {
            var index = scope.componentftis
              .map(function(x) {
                if (x.inElasticSearch) return x.alias;
              })
              .indexOf(newval);
            scope.selectGlobalFti = scope.componentftis[index];
          }
        });
        /**
         * gestion des tabselastic
         * @type {Array}
         */
        if (scope.place && scope.place == 'widget') {
          scope.tabselastic = [
            {
              title: $filter('translate')('elastic.search.search'),
            },
            {
              title: $filter('translate')('elastic.search.advanced'),
            },
            {
              title: $filter('translate')('elastic.search.relational'),
            },
          ];
        } else {
          scope.tabselastic = [
            {
              title: $filter('translate')('elastic.search.search'),
            },
          ];
        }
        scope.tabselastic.activeTab = 0;
        /**
         * Gestion des type global
         * @type {Array}
         */
        function setDefaultQuery() {
          scope.query = {
            query: {
              filtered: {
                query: {
                  bool: {
                    must: {
                      query_string: {
                        query: scope.globalSearch,
                        allow_leading_wildcard: true,
                        analyze_wildcard: true,
                      },
                    },
                  },
                },
              },
            },

            from: 0,
            size:
              scope.config && scope.config.size ? scope.config.size : 500000,
            sort: {
              _score: {
                order: 'asc',
              },
            },
          };
        }
        setDefaultQuery();

        /**
         * Ouvre une fenetre de consultation et de modification de la configuration.
         * @returns {undefined}
         *
         */
        var ngDialogPromise;
        scope.openConfig = function() {
          ngDialogPromise = ngDialog.openConfirm({
            template:
              'js/XG/widgets/utilities/elastic/views/elasticConfiguration.html',
            scope: scope,
            className: 'ngdialog-theme-plain width350 nopadding miniclose',
          });
          ngDialogPromise.then(
            function() {
              //scope.saveconfig();
              console.log(scope.config);
              require('toastr').success(
                $filter('translate')('elastic.search.done')
              );
            },
            function() {
              //scope.getConfig();
              console.log(scope.config);
              require('toastr').error(
                $filter('translate')('elastic.search.annuler')
              );
            }
          );
        };

        scope.$watch('config.size', function(newval) {
          if (newval) scope.query.size = newval;
        });

        scope.removeterms = function() {
          scope.globalSearch = '';
        };

        scope.globalSearch = '';
        scope.globalType = [];
        scope.addGlobalType = function(alias) {
          if (alias) {
            var index = scope.componentftis
              .map(function(x) {
                if (x.inElasticSearch) return x.alias;
              })
              .indexOf(alias);
            var fti = scope.componentftis[index];
            if (fti && scope.globalType.indexOf(fti) === -1) {
              scope.globalType.push(fti);
            }
          }
        };
        scope.addAllGlobalType = function() {
          scope.component.map(function(x) {
            if (x.inElasticSearch && scope.globalType.indexOf(x) === -1) {
              scope.globalType.push(x);
            }
          });
        };

        scope.removeGlobalType = function(idx) {
          scope.globalType.splice(idx, 1);
        };

        scope.removeAllGlobalType = function() {
          scope.globalType = [];
        };

        /**
         * Removes either Group or Rule
         */
        scope.removeChild = function(idx, filters) {
          var filterData = angular.copy(filters[idx]);
          if (
            angular.isDefined(filterData.guid) &&
            angular.isDefined(scope.fieldsConfiguration[filterData.guid])
          ) {
            console.log('reset field configuration ');
            delete scope.fieldsConfiguration[filterData.guid];
          }
          filters.splice(idx, 1);
        };

        scope.changesearchExacte = function() {
          if (scope.config.searchExacte)
            scope.config.personaliseParUser = false;
          if (!scope.config.searchExacte)
            scope.config.consideredUniqueString = false;
        };

        scope.checkSpaceAnd = function() {
          if (
            !scope.config.espaceInterpreted &&
            !scope.config.espaceInterpretedS
          )
            scope.config.espaceInterpretedS = true;
        };

        scope.checkSpaceOr = function() {
          if (
            !scope.config.espaceInterpreted &&
            !scope.config.espaceInterpretedS
          )
            scope.config.espaceInterpreted = true;
        };

        scope.changepersonaliseParUser = function() {
          if (scope.config.personaliseParUser) {
            scope.config.searchExacte = false;
            scope.config.consideredUniqueString = false;
          }
        };

        function parseQueryStringToUseWildscard(query) {
          if (scope.config.personaliseParUser) return query;
          if (
            !scope.config.searchExacte &&
            !scope.config.consideredUniqueString
          ) {
            var q = '';
            var splitted = query.split(' ');
            var splittedadd = splitted.map(function(x) {
              return '*' + x + '*';
            });
            if (scope.config.espaceInterpreted) {
              q = splittedadd.join(' AND ');
            } else {
              q = splittedadd.join(' ');
            }
            return q;
          } else if (
            scope.config.searchExacte &&
            !scope.config.consideredUniqueString
          ) {
            var q = '';
            var splitted = query.split(' ');
            var splittedadd = splitted.map(function(x) {
              return x;
            });
            if (scope.config.espaceInterpreted) {
              q = splittedadd.join(' AND ');
            } else {
              q = splittedadd.join(' ');
            }
            return q;
          } else {
            var q = '"' + query + '"';
            return q;
          }
        }

        /**
         * Adds a Group of Rules
         */
        scope.searchElastic = function() {
          if (angular.isUndefined(scope.fti)) {
            var types = scope.globalType
              .map(function(x) {
                return x.name;
              })
              .filter(function(x) {
                if (x !== undefined) return x;
              })
              .join(',');
          } else {
            var types = scope.fti.name;
          }
          scope.query.query.filtered.query.bool.must.query_string.query =
            scope.globalSearch;
          if (
            scope.query.query.filtered.query.bool.must.query_string ===
              undefined ||
            scope.query.query.filtered.query.bool.must.query_string.query ===
              undefined ||
            scope.query.query.filtered.query.bool.must.query_string.query === ''
          ) {
            scope.query.query.filtered.query.bool.must = { match_all: {} };
          } else {
            scope.query.query.filtered.query.bool.must.query_string.query = parseQueryStringToUseWildscard(
              scope.globalSearch
            );
          }

          if (
            scope.fti == undefined &&
            scope.globalType &&
            scope.globalType.length === 0 &&
            scope.query.size === 500000
          ) {
            scope.query.size = 500;
            require('toastr').warning(
              $filter('translate')('elastic.search.forcechoosing')
            );
          }

          var sendata = {};
          sendata.query = scope.query;
          if (scope.gbolabSearchFromCurrentSelection) {
            if (
              angular.isUndefined(SelectManager.getfeatures().totalFeatures)
            ) {
              scope.gbolabSearchFromCurrentSelection = false;
              require('toastr').error(
                $filter('translate')('elastic.search.noselectmanager')
              );
            } else {
              sendata.fromCurrentSelection =
                scope.gbolabSearchFromCurrentSelection;
              sendata.ids = getFeaturesIds(SelectManager.getfeatures());
            }
          }

          gaDomUtils.showGlobalLoader();
          if (types !== undefined && types != '') {
            ElasticFactory.searchInTypes(types, 'geojson', sendata, scope.map.getView().getProjection().getCode()).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                scope.data = res.data;
                setDefaultQuery();
                if (!scope.mobileApplication) {
                  addToSelectedFeature(scope.data);
                  if (!SelectManager.isGeojsonEmpty(res.data)) {
                    require('toastr').success(
                      $filter('translate')('elastic.search.search_success')
                    );
                  }
                }
              },
              function(error) {
                setDefaultQuery();
                gaDomUtils.hideGlobalLoader();
                require('toastr').error(
                  $filter('translate')('elastic.search.search_failed')
                );
              }
            );
          } else {
            ElasticFactory.searchInIndex('geojson', sendata, scope.map.getView().getProjection().getCode()).then(
              function(res) {
                scope.data = res.data;
                setDefaultQuery();
                require('toastr').success(
                  $filter('translate')('elastic.search.search_success')
                );
                addToSelectedFeature(scope.data);
                gaDomUtils.hideGlobalLoader();
              },
              function(error) {
                setDefaultQuery();
                require('toastr').error(
                  $filter('translate')('elastic.search.search_failed')
                );
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        if (scope.querydashboard) scope.queryname = scope.querydashboard;

        scope.$on('changedQueryDashboard', function(event, arg) {
          scope.queryname = arg.query;
          scope.fieldsConfiguration = arg.cfg.fieldsConfiguration
            ? arg.cfg.fieldsConfiguration
            : {};
          scope.resultsConfiguration = arg.cfg.resultsConfiguration
            ? arg.cfg.resultsConfiguration
            : {};
          scope.writequeryname = false;
        });

        scope.conditions = [{}];
        /**
         * Adds a Group of Rules
         */
        scope.addGroup = function() {
          scope.conditions.push({});
        };
        scope.removeRule = function(idx) {
          scope.conditions.splice(idx, 1);
        };

        /**
         * moveItem up and down
         * @param index
         * @param direction
         * @returns {boolean}
         */
        scope.moveItem = function(index, direction) {
          if (
            (index == 0 && direction == 'up') ||
            (index == scope.relations[0].filters.length - 1 && direction == 'down')
          )
            return false;
          var newIndex = direction == 'up' ? index - 1 : index + 1;
          scope.relations[0].filters.splice(
            index,
            0,
            scope.relations[0].filters.splice(newIndex, 1)[0]
          );
        };
        /**
         * Adds a Single Rule
         */
        scope.addRule = function(condition) {
          if (condition.selectGlobaladvancedFti) {
            if (!condition.filters) {
              condition.filters = [];
            }
            condition.filters.push({});
          } else {
            require('toastr').error(
              $filter('translate')('elastic.search.advanced_search_stop')
            );
            throw new Error('choose component first');
          }
        };

        if ($rootScope.xgos.user != undefined)
          scope.currentuser = $rootScope.xgos.user.login;

        /**
         * Adds a Group of Rules
         */
        scope.searchadvancedElastic = function() {
          //elasticRelationalSelectionLayers
          try {
            if (scope.conditions.length > 0) {
              var sendata = {};
              var boolean = false;
              var eLasticQueries = [];
              scope.ListOFLayers = [];
              scope.conditions.map(function(condition) {
                var result = {};

                result.fromCurrentSelection = condition.fromCurrentSelection
                  ? true
                  : false;
                if (condition.fromCurrentSelection) {
                  if (
                    angular.isUndefined(
                      SelectManager.getfeatures().totalFeatures
                    )
                  ) {
                    condition.fromCurrentSelection = false;
                    require('toastr').error(
                      $filter('translate')('elastic.search.noselectmanager')
                    );
                  } else {
                    var index = scope.componentftis
                      .map(function(x) {
                        if (x.inElasticSearch) return x.alias;
                      })
                      .indexOf(condition.selectGlobaladvancedFti);
                    var fti = scope.componentftis[index];
                    result.currentSelection = getFeaturesByName(
                      SelectManager.getfeatures(),
                      fti.name
                    )[1];
                  }
                }

                /*if ( angular.isUndefiend(condition.fromPreviousResult) ) condition.fromPreviousResult = false;
                                result.fromPreviousResult = condition.fromPreviousResult;*/

                if (condition.selectGlobaladvancedFti) {
                  var index = scope.componentftis
                    .map(function(x) {
                      if (x.inElasticSearch) return x.alias;
                    })
                    .indexOf(condition.selectGlobaladvancedFti);
                  var fti = scope.componentftis[index];
                  result.ftiname = fti.name;
                }
                if (condition.filters)
                  condition.queries = elasticQueryService.toQuery(
                    condition.filters,
                    scope.data.fields
                  );
                if (condition.queries == undefined || condition.queries == '') {
                  result.query = {
                    query: {
                      query: {
                        bool: {
                          must: {
                            match_all: {},
                          },
                        },
                      },
                    },
                    from: 0,
                    size:
                      scope.config && scope.config.size
                        ? scope.config.size
                        : 500000,
                    sort: {
                      _score: {
                        order: 'asc',
                      },
                    },
                  };
                } else {
                  result.query = {
                    query: {
                      query: {
                        bool: {
                          must: condition.queries,
                        },
                      },
                    },
                    from: 0,
                    size:
                      scope.config && scope.config.size
                        ? scope.config.size
                        : 500000,
                    sort: {
                      _score: {
                        order: 'asc',
                      },
                    },
                  };
                }

                if (
                  result.query.size === 500000 &&
                  condition.filters &&
                  condition.filters.length === 0
                ) {
                  result.query.size = 500;
                  boolean = true;
                }
                eLasticQueries.push(result);
              });

              sendata.eLasticQueries = eLasticQueries;

              if (boolean)
                require('toastr').warning(
                  $filter('translate')('elastic.search.forcechoosing')
                );
              gaDomUtils.showGlobalLoader();

              ElasticFactory.advancedSearch('geojson', sendata, scope.map.getView().getProjection().getCode()).then(
                function(res) {
                  scope.data = res.data;
                  //setDefaultQuery ();
                  if (!SelectManager.isGeojsonEmpty(res.data)) {
                    require('toastr').success(
                      $filter('translate')('elastic.search.search_success')
                    );
                    addToSelectedFeature(scope.data);
                  }
                  gaDomUtils.hideGlobalLoader();
                },
                function() {
                  //setDefaultQuery ();
                  gaDomUtils.hideGlobalLoader();
                  require('toastr').error(
                    $filter('translate')('elastic.search.search_failed')
                  );
                }
              );
            } else {
              require('toastr').error(
                $filter('translate')('elastic.search.advanced_search_stop')
              );
              throw new Error('choose component first');
            }
          } catch (e) {
            gaDomUtils.hideGlobalLoader();
            require('toastr').error(
              $filter('translate')('elastic.search.search_failed')
            );
            throw new Error(e.message);
          }
        };
        /**
         * Changes on the page update the Query
         */
        scope.$watch(
          'globalSearch',
          function(curr) {
            if (!curr) return;
            if (curr.split(' ')[curr.split(' ').length - 1].length >= 2) {
              var types = scope.globalType
                .map(function(x) {
                  return x.name;
                })
                .filter(function(x) {
                  if (x !== undefined) return x;
                });

              if (types.length > 0) {
                var str = curr.split(' ')[curr.split(' ').length - 1];
                var query = getDefaultSuggestion(str);
                var promise = ElasticFactory.getSuggestionsFromTypes(
                  str,
                  query,
                  types.join(',')
                );
                promise.then(
                  function(res) {
                    if (res.data.length > 0)
                      scope.autocompleteglobalsearch = res.data.map(function(
                        x
                      ) {
                        var data = curr.replace(str, '');
                        return data + x;
                      });
                  },
                  function(res) {
                    console.error(res);
                    scope.autocompleteglobalsearch = [];
                  }
                );
              } else {
                var str = curr.split(' ')[curr.split(' ').length - 1];
                var query = getDefaultSuggestion(str);
                var promise = ElasticFactory.getSuggestions(str, query);
                promise.then(
                  function(res) {
                    if (res.data.length > 0)
                      scope.autocompleteglobalsearch = res.data.map(function(
                        x
                      ) {
                        var data = curr.replace(str, '');
                        return data + x;
                      });
                  },
                  function(res) {
                    console.error(res);
                    scope.autocompleteglobalsearch = [];
                  }
                );
              }
            } else {
              scope.autocompleteglobalsearch = [];
            }
            scope.query.query.filtered.query.bool.must.query_string.query =
              scope.globalSearch;
          },
          true
        );

        scope.closepanel = function() {
          scope.showtablejointure = false;
          scope.panelsManager.removePanel('selecttab');
          SelectManager.clear();
          gclayers.clearhighLightFeatures();
        };

        function addToSelectedFeature(featureCollection) {
          var Obj = [
            'Point',
            'MultiPoint',
            'LineString',
            'MultiLineString',
            'Polygon',
            'MultiPolygon',
          ];
          featureCollection.features = featureCollection.features
            .map(function(x) {
              if (
                x.geometry &&
                x.geometry.type &&
                Obj.indexOf(x.geometry.type) != -1
              ) {
                var properties = {};

                angular.forEach(x.properties, function(value, key) {
                  if (
                    value != null &&
                    value != '' &&
                    key != 'geometry' &&
                    value != 'null'
                  ) {
                    properties[key] = value;
                  }
                });
                x.properties = {};
                x.properties = properties;
                return x;
              } else {
                var properties = {};

                angular.forEach(x.properties, function(value, key) {
                  if (
                    value != null &&
                    value != '' &&
                    key != 'geometry' &&
                    value != 'null'
                  ) {
                    properties[key] = value;
                  }
                });
                x.properties = {};
                x.properties = properties;
                return x;
              }
            })
            .filter(function(x) {
              if (x) return x;
            });

          try {
            SelectManager.addFeaturesFromGeojson(featureCollection);
            try {
              scope.map
                .getView()
                .fit(SelectManager.getExtent(), scope.map.getSize());
            } catch (e) {
              console.info(e.message);
            }
            scope.panelsManager = panelsManager;
            if (SelectManager.getpop()) {
              try {
                if (SelectManager.getpop().element) {
                  SelectManager.getpop().destroy();
                }
                if (SelectManager.getpop().scope) {
                  SelectManager.getpop().scope.$broadcast('$destroy');
                }
              } catch (e) {
                SelectManager.setpop(null);
              }
            }
            if (featureCollection.fti) {
              scope.elasticsearchjointurefti = featureCollection.fti;
              scope.geoj = featureCollection;
              // the default height of the datatable
              scope.height = 320;

              scope.panelsManager.removePanel('selecttab');
              scope.showtablejointure = true;
              scope.panelsManager.addPanel({
                id: 'selecttab',
                stickToRight: true,
                templateUrl:
                  'js/XG/widgets/utilities/elastic/views/elasticdatatable.html',
                scope: scope,
                stickToBorder: true,
                visible: true,
                resizable: true,
              });
            } else {
              var newScope = $rootScope.$new();
              newScope.map = scope.map;
              newScope.panelsManager = scope.panelsManager;
              var pop = gcPopup.open({
                scope: newScope,
                title: 'Informations : ',
                content: '<div selectfeaturetreewidget></div>',
                showClose: true,
                onclose: function() {
                  SelectManager.clear();
                },
              });
            }
            gclayers
              .getDrawLayer()
              .getSource()
              .clear();
            SelectManager.setpop(pop);
          } catch (e) {
            console.info(e.message);
          }
        }

        scope.removeSavedAdvanced = function(name) {
          var ans = confirm($filter('translate')('common.confirm_action'));
          if (ans) {
            var idx = scope.saved.queries.indexOf(name);
            //ElasticFactory.deleteSavedFile ( $rootScope.xgos.portal.name , scope.saved.realNames[idx].filename ).then(function(res){
            ParametersFactory.deletebyname(
              scope.saved.realNames[idx].name
            ).then(
              function(res) {
                console.log(res.data);
                scope.saved.realNames.splice(idx, 1);
                scope.saved.queries.splice(idx, 1);
              },
              function(res) {
                console.log(res.data);
                scope.saved.realNames.splice(idx, 1);
                scope.saved.queries.splice(idx, 1);
              }
            );
          }
        };

        scope.saveQuery = function() {
          ParametersFactory.getbytype('conditionalElastic').then(
            function(res) {
              if (res.data.length > 0) {
                scope.datas = res.data;
                //scope.conditions = scope.conditions;
                scope.saved = {
                  realNames: scope.datas,
                  queries: scope.datas
                    .map(function(x) {
                      return x.name;
                    })
                    .filter(function(x) {
                      if (x) return x;
                    }),
                  query: '',
                };
              }
            },
            function(data) {
              //scope.getConfig();
              console.log(scope.config);
              //                        require('toastr').info($filter('translate')('elastic.search.annuler'));
            }
          );
          scope.saveData = {
            user: $rootScope.xgos.user.login,
            conditions: scope.conditions,
          };
          ngDialogPromise = ngDialog.openConfirm({
            template: 'js/XG/widgets/utilities/elastic/views/elasticSave.html',
            scope: scope,
            className: 'ngdialog-theme-plain width300 nopadding miniclose',
          });
          ngDialogPromise.then(
            function(data) {
              ParametersFactory.getbytype('conditionalElastic').then(function(
                res
              ) {
                console.log(scope.saveData);

                var nameSaved = res.data.map(function(x) {
                  return x.name;
                });
                if (nameSaved.indexOf(data) !== -1) {
                  var idx = res.data
                    .map(function(x) {
                      return x.name;
                    })
                    .indexOf(data);
                  var id = res.data[idx].id;
                  ParametersFactory.remove(id).then(
                    function() {
                      ParametersFactory.add(
                        scope.saveData,
                        'conditionalElastic',
                        data
                      ).then(
                        function() {
                          require('toastr').success(
                            $filter('translate')('elastic.search.save_ok')
                          );
                        },
                        function() {
                          require('toastr').error(
                            $filter('translate')('elastic.search.save_nok')
                          );
                        }
                      );
                    },
                    function() {
                      require('toastr').error(
                        $filter('translate')('elastic.search.save_nok')
                      );
                    }
                  );
                } else {
                  ParametersFactory.add(
                    scope.saveData,
                    'conditionalElastic',
                    data
                  ).then(
                    function() {
                      require('toastr').success(
                        $filter('translate')('elastic.search.save_ok')
                      );
                    },
                    function() {
                      require('toastr').error(
                        $filter('translate')('elastic.search.save_nok')
                      );
                    }
                  );
                }
              });

              //ElasticFactory.saveConfig( data , $rootScope.xgos.portal.name , scope.saveData ).then (function(){
            },
            function(data) {
              //scope.getConfig();
              console.log(scope.config);
              require('toastr').info(
                $filter('translate')('elastic.search.annuler')
              );
            }
          );
        };

        scope.getQuery = function() {
          //ElasticFactory.getConfig( $rootScope.xgos.portal.name ).then (function(res){
          ParametersFactory.getbytype('conditionalElastic').then(
            function(res) {
              if (res.data.length > 0) {
                scope.datas = res.data;
                //scope.conditions = scope.conditions;
                scope.saved = {
                  realNames: scope.datas,
                  queries: scope.datas
                    .map(function(x) {
                      return x.name;
                    })
                    .filter(function(x) {
                      if (x) return x;
                    }),
                  query: '',
                };

                ngDialogPromise = ngDialog.openConfirm({
                  template:
                    'js/XG/widgets/utilities/elastic/views/elasticGetQuery.html',
                  scope: scope,
                  className:
                    'ngdialog-theme-plain width370 nopadding miniclose',
                });
                ngDialogPromise.then(
                  function(data) {
                    var filename = data;
                    var filenames = scope.datas.map(function(x) {
                      return x.name;
                    });
                    var index = filenames.indexOf(filename);
                    var datas = scope.datas[index].data.conditions;
                    scope.conditions = [];

                    datas.map(function(x) {
                      scope.conditions.push(x);
                    });
                    scope.writequeryname = false;
                    scope.queryname = data;
                  },
                  function(data) {
                    //scope.getConfig();
                    console.log(scope.config);
                    require('toastr').info(
                      $filter('translate')('elastic.search.annuler')
                    );
                  }
                );
              } else {
                require('toastr').info(
                  $filter('translate')('elastic.search.no_save')
                );
              }
            },
            function() {
              require('toastr').error(
                $filter('translate')('elastic.search.save_nok')
              );
            }
          );
        };

        /**
         * Adds a Group of Rules
         */
        scope.addRelationGroup = function() {
          scope.relations.push({});
        };
        scope.removeRelationRule = function(idx) {
          scope.relations.splice(idx, 1);
          $rootScope.$broadcast('elastic_resetRelationDashBoard', {});
        };

        /**
         * Adds a Single Rule
         */
        scope.addRelationRule = function(relation) {
          if (relation.selectGlobaladvancedFti) {
            if (!relation.filters) {
              relation.filters = [];
            }
            relation.filters.push({
              choice: 'rule',
            });
          } else {
            require('toastr').error(
              $filter('translate')('elastic.search.advanced_search_stop')
            );
            throw new Error('choose component first');
          }
        };

        /**
         * Adds a Single Rule
         */
        scope.addRelation = function(relation) {
          if (relation.selectGlobaladvancedFti) {
            if (!relation.filters) {
              relation.filters = [];
            }
            relation.filters.push({ choice: 'relation' });
          } else {
            require('toastr').error(
              $filter('translate')('elastic.search.advanced_search_stop')
            );
            throw new Error('choose component first');
          }
        };

        var parseFiltersJointure = function(parsed) {
          for (var i = 0; i < parsed.length; i++) {
            var p = parsed[i];
            if (p.fti) {
              var ind = scope.componentftis
                .map(function(x) {
                  if (x && x.uid) return x.uid;
                })
                .indexOf(p.fti.uid);
              if (ind !== -1) {
                // special rechargement d'une requete controle anc existante
                // le fti ne comprend pas encore les champs des json, on les mets de coté
                var champsJson = p.fti.attributes.filter(function(x) {
                  return x.isCtrJsonAttribute && x.selected;
                });
                if (champsJson.length) champsJsonARecharger = champsJson;

                var extractedattributeNamesSelected = p.fti.attributes
                  .map(function(att) {
                    if (att && att.selected && att.name) return att.name;
                  })
                  .filter(function(x) {
                    if (x) return x;
                  });
                if (extractedattributeNamesSelected.length > 0) {
                  var fti = angular.copy(scope.componentftis[ind]);
                  fti.attributes.map(function(x) {
                    if (
                      extractedattributeNamesSelected.indexOf(x.name) !== -1
                    ) {
                      x.selected = true;
                    }
                  });
                  p.fti = angular.copy(fti);
                  if (p.filters && p.filters.length > 0)
                    parseFiltersJointure(p.filters);
                } else {
                  p.fti = angular.copy(scope.componentftis[ind]);
                  if (p.filters && p.filters.length > 0)
                    parseFiltersJointure(p.filters);
                }
              }
            }
          }
        };

        var getSavedParameters = function(parsed) {
          if (!parsed) return parsed;
          parseFiltersJointure(parsed);

          return parsed;
        };

        scope.$watch('relationdashbord', function(val) {
          if (val) {
            // @typo ne rentre jamais dedans ? -> componentftis
            // if (scope.componentsftis){
            if (scope.componentsftis || scope.applicationIsAnc) {
              scope.relationdashbord = getSavedParameters(
                scope.relationdashbord
              );
            } else {
              getFtis().then(function() {
                scope.relationdashbord = getSavedParameters(
                  scope.relationdashbord
                );
              });
            }
          }
        });

        scope.writequeryname = true;
        scope.changeWrtieMode = function() {
          scope.writequeryname = !scope.writequeryname;
        };

        scope.saveRelationalQuery = function() {
          ParametersFactory.getbytype('relationalElastic').then(
            function(res) {
              if (res.data.length > 0) {
                scope.datas = res.data;
                scope.saved = {
                  realNames: scope.datas,
                  queries: scope.datas
                    .map(function(x) {
                      return x.name;
                    })
                    .filter(function(x) {
                      if (x) return x;
                    }),
                  query: '',
                };
              }
            },
            function(data) {
              //scope.getConfig();
              console.log(scope.config);
              //                        require('toastr').info($filter('translate')('elastic.search.annuler'));
            }
          );

          scope.saveData = {
            user: $rootScope.xgos.user.login,
            relations: scope.relations,
            jointure: scope.relationdashbord,
            fieldsConfiguration: scope.fieldsConfiguration,
            resultsConfiguration: scope.resultsConfiguration,
          };

          ngDialogPromise = ngDialog.openConfirm({
            template: 'js/XG/widgets/utilities/elastic/views/elasticSave.html',
            scope: scope,
            className: 'ngdialog-theme-plain width600 nopadding miniclose',
          });
          ngDialogPromise.then(
            function(data) {
              ParametersFactory.getbytype('relationalElastic').then(function(
                res
              ) {
                var nameSaved = res.data.map(function(x) {
                  return x.name;
                });
                if (nameSaved.indexOf(data) !== -1) {
                  var idx = res.data
                    .map(function(x) {
                      return x.name;
                    })
                    .indexOf(data);
                  var id = res.data[idx].id;
                  if (scope.writequeryname) {
                    var ans = confirm(
                      $filter('translate')('elastic.search.existsconf')
                    );
                    if (ans)
                      ParametersFactory.remove(id).then(
                        function() {
                          ParametersFactory.add(
                            scope.saveData,
                            'relationalElastic',
                            data
                          ).then(
                            function() {
                              //if (scope.place === "dashboard")
                              $rootScope.$broadcast('resultsavednewsearch', {
                                name: data,
                                place: scope.place,
                              });
                              require('toastr').info(
                                $filter('translate')('elastic.search.save_ok')
                              );
                            },
                            function() {
                              require('toastr').info(
                                $filter('translate')('elastic.search.save_nok')
                              );
                            }
                          );
                          scope.queryname = data;
                        },
                        function() {
                          require('toastr').info(
                            $filter('translate')('elastic.search.save_nok')
                          );
                        }
                      );
                  } else {
                    ParametersFactory.remove(id).then(
                      function() {
                        ParametersFactory.add(
                          scope.saveData,
                          'relationalElastic',
                          data
                        ).then(
                          function() {
                            //if (scope.place === "dashboard")
                            $rootScope.$broadcast('resultsavednewsearch', {
                              name: data,
                              place: scope.place,
                            });
                            require('toastr').info(
                              $filter('translate')('elastic.search.save_ok')
                            );
                          },
                          function() {
                            require('toastr').info(
                              $filter('translate')('elastic.search.save_nok')
                            );
                          }
                        );
                        scope.queryname = data;
                      },
                      function() {
                        require('toastr').info(
                          $filter('translate')('elastic.search.save_nok')
                        );
                      }
                    );
                  }
                } else {
                  ParametersFactory.add(
                    scope.saveData,
                    'relationalElastic',
                    data
                  ).then(
                    function() {
                      //if (scope.place === "dashboard")
                      $rootScope.$broadcast('resultsavednewsearch', {
                        name: data,
                        place: scope.place,
                      });
                      require('toastr').info(
                        $filter('translate')('elastic.search.save_ok')
                      );
                    },
                    function() {
                      require('toastr').info(
                        $filter('translate')('elastic.search.save_nok')
                      );
                    }
                  );
                }
              });
              /*ElasticFactory.saveRelationalConfig( data , $rootScope.xgos.portal.name , scope.saveData ).then (function(){
                                require('toastr').success($filter('translate')('elastic.search.save_ok'));
                            },function(){
                                require('toastr').error($filter('translate')('elastic.search.save_nok'));
                            });*/
            },
            function(data) {
              //scope.getConfig();
              console.log(scope.config);
              require('toastr').info(
                $filter('translate')('elastic.search.annuler')
              );
            }
          );
        };

        // @RB : fix reset relation dashboard quand la relation change - vu avec OUS
        $rootScope.$on('elastic_resetRelationDashBoard', function(a, e) {
          console.log('------- elastic_resetRelationDashBoard --------');
          console.log('---- relationdashbord reset 1 ----');
          scope.fakeJsonFti = { v: {} };
          scope.relationdashbord = undefined;
        });

        // @RB - load and execute request
        $rootScope.$on('elastic_LoadAndExecuteRequest', function(a, data) {


          var d = angular.copy(data);
          if (d.filterId != scope.filterId) return;
          scope.facturationAnnualise = d.annualisation ? d.annualisation : false ;
          var datas = d.request.relations;
          scope.relations = [];
          datas.map(function(x) {
            scope.relations.push(x);
          });
          scope.jointure = d.request.jointure;
          if (d.request.jointure && d.request.jointure.length > 0) {
            scope.relationdashbord = getSavedParameters(d.request.jointure);
          } else {
            $rootScope.$broadcast('elastic_resetRelationDashBoard', {});
          }
          // fieldsConfiguration
          scope.fieldsConfiguration = d.request.fieldsConfiguration
            ? d.request.fieldsConfiguration
            : {};
          scope.resultsConfiguration = d.request.resultsConfiguration
            ? d.request.resultsConfiguration
            : {};
          scope.writequeryname = false;
          scope.queryname = d.request.name;

          // firefox (61) a du mal a charger la requete avant de l'executer,
          // tmpfix : timeout de 2s
          var ffTimeout = navigator.userAgent.indexOf('Firefox') > 0 ? 2000 : 0;

          $timeout(function() {
            // direct
            scope.searchRelationalAdv(true);
          }, ffTimeout);
        });

        scope.getRelationalQuery = function(forceRequest) {
          //ElasticFactory.getRelationalConfig( $rootScope.xgos.portal.name ).then (function(res){
          ParametersFactory.getbytype('relationalElastic').then(
            function(res) {
              if (res.data.length > 0) {
                scope.datas = res.data;
                scope.saved = {
                  realNames: scope.datas,
                  queries: scope.datas
                    .map(function(x) {
                      return x.name;
                    })
                    .filter(function(x) {
                      if (x) return x;
                    }),
                  query: '',
                };

                ngDialogPromise = ngDialog.openConfirm({
                  template:
                    'js/XG/widgets/utilities/elastic/views/elasticGetQuery.html',
                  scope: scope,
                  className:
                    'ngdialog-theme-plain width370 nopadding miniclose',
                });
                ngDialogPromise.then(
                  function(data) {
                    var filename = data;
                    var filenames = scope.datas.map(function(x) {
                      return x.name;
                    });
                    var index = filenames.indexOf(filename);
                    var datas = scope.datas[index].data.relations;
                    scope.relations = [];
                    datas.map(function(x) {
                      scope.relations.push(x);
                    });

                    scope.jointure = scope.datas[index].data.jointure;
                    if (
                      scope.datas[index].data.jointure &&
                      scope.datas[index].data.jointure.length > 0
                    ) {
                      scope.relationdashbord = getSavedParameters(
                        scope.datas[index].data.jointure
                      );
                    } else {
                      $rootScope.$broadcast(
                        'elastic_resetRelationDashBoard',
                        {}
                      );
                    }

                    // fieldsConfiguration
                    scope.fieldsConfiguration = scope.datas[index].data
                      .fieldsConfiguration
                      ? scope.datas[index].data.fieldsConfiguration
                      : {};
                    scope.resultsConfiguration = scope.datas[index].data
                      .resultsConfiguration
                      ? scope.datas[index].data.resultsConfiguration
                      : {};

                    scope.writequeryname = false;
                    scope.queryname = data;

                    //if (scope.place === "dashboard")
                    $rootScope.$broadcast('resultsavednewsearch', {
                      name: data,
                      place: scope.place,
                    });
                  },
                  function() {
                    // scope.getConfig();
                    // console.log(scope.config)
                    require('toastr').info(
                      $filter('translate')('elastic.search.annuler')
                    );
                  }
                );
              } else {
                require('toastr').info(
                  $filter('translate')('elastic.search.no_save')
                );
              }
            },
            function() {
              require('toastr').error(
                $filter('translate')('elastic.search.save_nok')
              );
            }
          );
        };

        var checkSelectedJointure = function() {
          var jointure = false;
          if (
            scope.relations &&
            scope.relations.length > 0 &&
            scope.relations[0].jointure
          ) {
            for (var i = 0; i < scope.relations.length; i++) {
              var rel = scope.relations[i];
              if (rel.jointure) {
                jointure = true;
                break;
              }
            }
          }
          return jointure;
        };

        /**
         * dontAskForAttributeOrJointure - permet de ne pas redemander de specifier les attributs/jointures
         * temporaire, a corriger en distinguant la selection des attributs/jointures (dans un onglet par ex) et le fait de lancer la recherche
         */
        scope.searchRelationalAdv = function(dontAskForAttributeOrJointure) {
          if (typeof scope.onNewSearch === 'function') {
            scope.onNewSearch();
          }
          // pas dans le cas de l'ANC
          if (scope.applicationIsAnc) {
            dontAskForAttributeOrJointure = true;
            // force tjrs jointure
            var jointureSelectedOnce = true;
          } else {
            var jointureSelectedOnce = checkSelectedJointure();
          }


          // update attribute list with jointure data then execute query
          if (scope.updateDashboard && typeof scope.updateDashboard.update ==='function') {
            scope.updateDashboard.update();
          }

          scope.jointure = jointureSelectedOnce;
          if (jointureSelectedOnce) {
            scope.searchAdvancedRelationalElastic(
              dontAskForAttributeOrJointure
            );
          } else {
            scope.databaseSearch();
          }
        };

        /**
         * Les requetes associées aux tables controle anc/bac peuvent avoir un attribut supplémentaire (controle_json_filters)
         * qui permet de
         *  1 - Forcer la récupération des données json dans tous les cas
         *  2 - Filtrer sur les jsons associés
         *  3 - Restreindre le type des controles concernés
         * @param {*} relation
         */
        var transformAncCtrlReponseRequest = function(relation) {
          if (relation.filters) {
            for (var i in relation.filters) {
              if (relation.filters[i].choice == 'relation') {
                console.log(relation.filters[i]);
                transformAncCtrlReponseRequest(relation.filters[i]);
              }
            }
          }

          if (
            angular.isDefined(relation.controle_json_filters) &&
            ((angular.isDefined(relation.selectedfti) &&
              relation.selectedfti.alias == scope.controleAlias) ||
              (angular.isDefined(relation.relation_DOSSIER_CONTROLE_choosen) &&
                relation.relation_DOSSIER_CONTROLE_choosen.alias ==
                  scope.controleAlias))
          ) {
            console.log('im in');
            needToRecupereControleJsonData = true;

            /* ------------------------------------------------------------------
                        But 1 - Filtrer sur les jsons associés

                        transformer ->

                        relation = [
                            selectedfti: kis_anc/bac_dossier_controle,
                            filters: [
                                rule : attribut de la table controle,
                                rule : attribut dans un json de controle (1),
                                rule : attribut dans un json de controle (2)
                            ]

                        ]

                        en ->

                        relation = [
                            selectedfti: kis_anc/bac_dossier_controle,
                            filters: [
                                rule : attribut de la table controle,
                                relation : {
                                    selectedfti : kis_anc/bac_dossier_controle_reponse
                                    filters : [
                                        rule : attribut dans un json de controle (1),
                                        rule : attribut dans un json de controle (2)
                                    ]
                                }
                            ]


                        ]

                        si relation.filters.relation existe deja, on le remplace

                        */

            console.log(scope.componentftis);

            var dossierFtiName =
              scope.applicationType === 'bac'
                ? 'kis_bac_dossier'
                : 'kis_anc_dossier';
            var dossierfti = FeatureTypeFactory.getFeatureByNameAndDatastore(
              CurrentAppFactory.appCfg.main.datastore,
              dossierFtiName
            );
            var ctrlFtiname = dossierFtiName + '_controle';
            var ctrlJsonname = ctrlFtiname + '_reponse';

            // 1- Forcer la récupération des données json à partir du moment ou certains attributs en plus sont proposés depuis le fakeJsonFti
            // pour cela il faut forcer la présence d'un filtre de relation

            // 1.a on ajoute (recupere s'il existe) un filtre de type relation avec kis_anc/bac_dossier_controle
            var relationRuleIndex = false;
            for (var i in relation.filters) {
              // verifie que c'est une relation de controle vers controle_json (et non pas vers dossier anc)
              if (
                relation.filters[i].choice == 'relation' &&
                relation.filters[i].selectedfti.name == ctrlFtiname &&
                relation.filters[i].alias != dossierfti.alias
              ) {
                if (!relationRuleIndex) {
                  relationRuleIndex = i;
                }
              }
            }
            var ctrlJsonAttributes = relation.filters.filter(function(x) {
              // return x.choice == "rule" && x.attr && x.attr.alias && !x.attr.alias.indexOf("json_");
              return (
                x.choice == 'rule' &&
                x.attr &&
                x.attr.alias &&
                x.attr.isCtrJsonAttribute
              );
            });

            console.log(
              'recuperationChampsExtraJson',
              recuperationChampsExtraJson
            );
            console.log('ctrlJsonAttributes : ', ctrlJsonAttributes);

            if (recuperationChampsExtraJson) {
              var relationJsonRule;
              if (relationRuleIndex) {
                relationJsonRule = relation.filters[relationRuleIndex];
              } else {
                relationJsonRule = {
                  choice: 'relation',
                  attr: {},
                  selectedfti: FeatureTypeFactory.resources.featuretypes.filter(
                    function(x) {
                      return x.name == ctrlFtiname;
                    }
                  )[0],
                  choices: ['Contient'],
                  choicesdone: $filter('translate')(
                    'elastic.search.anc.contient'
                  ),
                  relation: 'REL_DOSSIER_CONTROLE',
                  alias: 'controle json',
                  filters: [],
                  selectGlobaladvancedFti: 'controle json',
                  relation_DOSSIER_CONTROLE_choosen: {
                    name: ctrlJsonname,
                    alias: 'controle json',
                    attributes: angular.copy(scope.fakeJsonFti.v.attributes),
                  },
                };
              }

              // 2. si présence de filtre sur des attributs prefixés par json
              //  il faut les remplacer par une relation avec le controle_json
              if (ctrlJsonAttributes.length) {
                // 1.b on transfere les ctrlJsonAttributes vers le filtre de type relation (relationJsonRule)
                var newRelationJsonRuleFilters = [];
                for (var i in ctrlJsonAttributes) {
                  var tmp = angular.copy(ctrlJsonAttributes[i]);
                  // set alias
                  // if (angular.isObject(tmp.att)) tmp.att = tmp.att.alias.replace("json_", "");
                  // set selectedfti
                  tmp.selectedfti = {
                    name: ctrlJsonname,
                    alias: 'controle json',
                    attributes: angular.copy(tmp.attributesaliases),
                  };

                  newRelationJsonRuleFilters.push(tmp);
                }
                relationJsonRule.filters = newRelationJsonRuleFilters;

                // 1.c enfin on nettoie tous les ctrlJsoNAttribute qui n'ont pas lieu d'être dans la requete
                relation.filters = relation.filters.filter(function(x) {
                  // return !(x.choice == "rule" && !x.attr.alias.indexOf("json_"));
                  return !(x.choice == 'rule' && x.attr.isCtrJsonAttribute);
                });

                console.log(JSON.stringify(relation.filters));
              }

              //  force le filtre "relation"
              if (relationRuleIndex) {
                relation.filters[relationRuleIndex] = relationJsonRule;
              } else {
                relation.filters.push(relationJsonRule);
              }
            }

            // 3. force le type du filter selon les types selectionnes
            var ftiRef = angular.isDefined(
              relation.relation_DOSSIER_CONTROLE_choosen
            )
              ? relation.relation_DOSSIER_CONTROLE_choosen
              : relation.selectedfti;
            var typeAttr = ftiRef.attributes.filter(function(x) {
              return x.name == 'type';
            })[0];

            var values = [];
            for (var j in relation.controle_json_filters.types)
              if (relation.controle_json_filters.types[j].selected == true)
                values.push(j);

            if (values.length) {
              var filter = {
                choice: 'rule',
                attr: typeAttr,
                showAllValues: true,
                name: 'type',
                type: typeAttr.type,
                att: typeAttr.alias,
                operand: 'include',
                value: values.join(','),
                selectedfti: angular.copy(scope.fti),
                attributesaliases: relation.selectedfti.attributes.map(function(
                  x
                ) {
                  return x.alias;
                }),
              };
              // console.log(filter);

              relation.filters.push(filter);
            }
          }
        };

        scope.cleanAllFieldsValue = () => {
          if (scope.relations && scope.relations.length) {
            if (Array.isArray(scope.relations[0].filters)) {
              for (let filter of scope.relations[0].filters) {
                ElasticFactory.cleanFieldValue(filter);
              }
            }
          }
          if(scope.interventionSimpleMode){
            //clear query result
            scope.data = {};

            if (typeof scope.onNewSearch === 'function') {
              scope.onNewSearch();
            }
          }
        };

        scope.databaseSearch = function () {

          function getStringForClause(clauseData) {
            /// clauseData.operand contains the operator, not the operand !
            let stringWhereClause = null;
            if (clauseData.name && clauseData.operand) {
              let correctValue = undefined;
              if (clauseData.operand != 'exists' &&
                clauseData.operand != 'notExists') {
                //Handle specific cases and correct format of the value
                if (clauseData.operand == 'last' ||
                  clauseData.operand == 'next') {
                  //for some reason, in this specific case, the value is stored in .newvalue
                  correctValue = clauseData.newvalue;
                } else if (clauseData.attr.restrictions && clauseData.attr.restrictions[0] &&
                  clauseData.operand === 'equals') {
                  //when the field has a restriction (table, domain, user, ...) value is stored in .restrictedValue
                  if (clauseData.restrictedValue != undefined) {
                    correctValue = clauseData.restrictedValue[clauseData.name];
                  }
                } else if (clauseData.type == 'java.util.Date') {
                  if (typeof clauseData.value == 'string') {
                    //sometimes it is a string, no format needed
                    correctValue = clauseData.value;
                  } else {
                  // format like that: 2012-03-31T22:00:00.000Z
                    if (clauseData.value != undefined) {
                      correctValue = clauseData.value.toISOString();
                    }
                  }
                } else if (clauseData.type == 'java.sql.Timestamp') {
                  if ((clauseData.newValueUtil != undefined) &&
                      (clauseData.newValueUtil[clauseData.name] != undefined)) {
                    correctValue = clauseData.newValueUtil[clauseData.name].toISOString();
                  }
                } else if ((clauseData.operand == 'equals') && (clauseData.type == 'java.lang.Boolean')) {
                  //for some reasons, in this specific case, the value is stored in weird location
                  if (clauseData.newValueUtil != undefined) {
                    correctValue = clauseData.newValueUtil[clauseData.name];
                  }
                } else {
                  // ignore filter if value is empty string
                  if (clauseData.value !== '' && typeof clauseData.value !== 'object') {
                    correctValue = clauseData.value;
                  }
                }
              }

              // ignore filter if correctValue is undefined
              //in case 'exists' and 'notExists' there is no value
              if (correctValue != undefined ||
                clauseData.operand == 'exists' ||
                clauseData.operand == 'notExists') {
                stringWhereClause = clauseData.name;
                switch (clauseData.operand) {
                  case 'startWith':
                    stringWhereClause += ' LIKE \'' + correctValue + '%\'';
                    break;
                  case 'endWith':
                    stringWhereClause += ' LIKE \'%' + correctValue + '\'';
                    break;
                  case 'regexp':
                    stringWhereClause += ' LIKE \'%' + correctValue + '%\'';
                    break;
                  case 'equals':
                    if ((clauseData.type == 'java.lang.String') || (clauseData.type == 'java.lang.Boolean')) {
                      stringWhereClause += ' = \'' + correctValue + '\'';
                    } else if(clauseData.type=='java.lang.Integer' && clauseData.attr.interpretAsBoolean){
                      stringWhereClause += (clauseData.newValueUtil[clauseData.name]? ' = ': ' <> ') + 1;
                    }else {
                      stringWhereClause += ' = ' + correctValue;
                    }
                    break;
                  case 'notEquals':
                    stringWhereClause += ' <> \'' + correctValue + '\'';
                    break;
                  case 'include':
                    // is included in a list of value
                    stringWhereClause += ' IN (' + correctValue + ')';
                    break;
                  case 'gt':
                    // '>' greater than
                    stringWhereClause += ' > ' + correctValue;
                    break;
                  case 'gte':
                    // '>=' greater than or equals
                    stringWhereClause += ' >= ' + correctValue;
                    break;
                  case 'lt':
                    // '<'
                    stringWhereClause += ' < ' + correctValue;
                    break;
                  case 'lte':
                    // '<='
                    stringWhereClause += ' <= ' + correctValue;
                    break;
                  case 'exists':
                    stringWhereClause += ' IS NOT NULL';
                    if (clauseData.type == 'java.lang.String') {
                      stringWhereClause += ' AND ' + clauseData.name + ' <> \'\'';
                    }
                    break;
                  case 'notExists':
                    stringWhereClause += ' IS NULL';
                    if (clauseData.type == 'java.lang.String') {
                      stringWhereClause = '(' + clauseData.name + ' IS NULL' +
                        ' OR ' + clauseData.name + ' = \'\')';
                    }
                    break;
                  case 'last':
                    stringWhereClause +=
                      ' BETWEEN datetime(\'now\', \'-' +
                      correctValue +
                      ' days\') AND datetime(\'now\', \'localtime\')';
                    break;
                  case 'next':
                    stringWhereClause +=
                      ' BETWEEN datetime(\'now\', \'+' +
                      correctValue +
                      ' days\') AND datetime(\'now\', \'localtime\')';
                    break;
                  default:
                    stringWhereClause = null;
                    break;
                }
              } else {
                stringWhereClause = null;
              }
            } else {
              stringWhereClause = null;
            }
            if ((stringWhereClause == null) && (clauseData.name != undefined)) {
              console.log('intervention simple: ignoring "WHERE" clause -> ' + clauseData.name);
            }
            return stringWhereClause;
          }

          let globalWhereClause = '';

          for (let attribute of scope.relations) {
            for (let clause of attribute.filters) {
              //add where clause
              let singleWhereClause = getStringForClause(clause);
              if(singleWhereClause != undefined) {
                if (globalWhereClause != '') {
                  globalWhereClause += ' AND ';
                }
                globalWhereClause += singleWhereClause;
              }
            }
          }

          scope.isSearching = true;
          //reset result list
          scope.data = null;
          let querySrid;
          if (scope.querySrid === 'map') {
            querySrid = scope.map.getView().getProjection().getCode();
          }
          else {
            querySrid = (scope.fti.srid == null) ? '' : scope.fti.srid;
          }

          QueryFactory.pdata(scope.fti.uid, globalWhereClause, querySrid).then(
            (res) => {
              scope.data = res.data;
              if (!SelectManager.isGeojsonEmpty(res.data)) {
                require('toastr').success(
                  $filter('translate')('elastic.search.search_success')
                );
              }
              if (res.data && res.data.totalFeatures > 0
                && scope.onSuccessCallback
                && typeof scope.onSuccessCallback === 'function') {
                scope.onSuccessCallback(globalWhereClause);
              }
            }, () => {
              require('toastr').error(
                $filter('translate')('elastic.search.search_failed'));
            }).finally(() => {
            scope.isSearching = false;
          });
        };

        var needToRecupereControleJsonData = false;
        /**
         * Adds a Group of Rules
         */
        scope.searchRelationalElastic = function(opts) {
          var relations = angular.copy(scope.relations);

          if (scope.applicationIsAnc) {
            // special controle anc
            for (var i in relations) {
              transformAncCtrlReponseRequest(relations[i]);
            }

            if (needToRecupereControleJsonData) {
              // recuperation des attributs selectionnes pour le controle
              var jsonAttributes = [];
              if (
                angular.isDefined(scope.resultsConfiguration) &&
                scope.resultsConfiguration.attributes
              ) {
                for (var i in scope.resultsConfiguration.attributes) {
                  var t = scope.resultsConfiguration.attributes[i].identifiant;
                  if (t.indexOf(nomControleJson + '_reponse') == 0) {
                    jsonAttributes.push(
                      t.replace(nomControleJson + '_reponse.', '')
                    );
                  }
                }
                //console.log(jsonAttributes);
                // jsonAttributes = ["info_generales.dossier.adresse_num_rue"]
              }

              var _ftiname =
                'kis_' + scope.applicationType + '_dossier_controle_reponse';
              opts[0][_ftiname] = {
                type: 'child',
                ftiname: _ftiname,
                attributes: jsonAttributes,
                fti: {
                  name: _ftiname,
                  attributes: angular.copy(scope.fakeJsonFti.v.attributes),
                },
                jointure: true,
                jointureType: 'getOnlyFirstline',
              };
            }
          }

          var sendata = {
            opts: angular.isDefined(opts) ? opts : null,
          };

          try {
            if (relations.length > 0) {
              gaDomUtils.showGlobalLoader();

              if (!scope.applicationIsAnc) {
                var eLasticQueries = [];
                relations.map(function(relation) {
                  var result = {};

                  result.fromCurrentSelection = relation.fromCurrentSelection
                    ? true
                    : false;
                  if (relation.fromCurrentSelection) {
                    if (
                      angular.isUndefined(
                        SelectManager.getfeatures().totalFeatures
                      )
                    ) {
                      relation.fromCurrentSelection = false;
                      require('toastr').error(
                        $filter('translate')('elastic.search.noselectmanager')
                      );
                    } else {
                      var index = scope.componentftis
                        .map(function(x) {
                          if (x.inElasticSearch) return x.alias;
                        })
                        .indexOf(relation.selectGlobaladvancedFti);
                      var fti = scope.componentftis[index];
                      result.currentSelection = getFeaturesByName(
                        SelectManager.getfeatures(),
                        fti.name
                      )[0];
                    }
                  }

                  if (relation.selectGlobaladvancedFti) {
                    var index = scope.componentftis
                      .map(function(x) {
                        if (x.inElasticSearch) return x.alias;
                      })
                      .indexOf(relation.selectGlobaladvancedFti);
                    fti = scope.componentftis[index];
                    result.fti = fti;
                  }

                  if (relation.filters && relation.filters.length > 0) {
                    var ruleFilter = relation.filters
                      .map(function(x) {
                        if (x.choice === 'rule') return x;
                      })
                      .filter(function(x) {
                        if (x) return x;
                      });
                    if (ruleFilter)
                      relation.queries = elasticQueryService.toQuery(
                        ruleFilter,
                        scope.data.fields
                      );
                    result.condition = {
                      query: elasticQueryService.ParseQuery(
                        relation.queries,
                        scope.config && scope.config.size
                          ? scope.config.size
                          : 500000
                      ),
                    };
                    if (
                      result.condition.query == undefined ||
                      result.condition.query == ''
                    )
                      result.condition.query = {
                        query: {
                          query: {
                            bool: {
                              must: {
                                match_all: {},
                              },
                            },
                          },
                        },
                      };

                    var relationFilter = relation.filters
                      .map(function(x) {
                        if (x.choice === 'relation') return x;
                      })
                      .filter(function(x) {
                        if (x) return x;
                      });
                    result.relations = elasticQueryService.ParseRelations(
                      relationFilter
                    );
                  }
                  if (angular.isUndefined(result.condition)) {
                    result.condition = {};
                  }
                  if (
                    angular.isUndefined(result.condition.query) ||
                    result.condition.query == ''
                  ) {
                    result.condition['query'] = {
                      query: {
                        match_all: {},
                      },
                      size:
                        scope.config && scope.config.size
                          ? scope.config.size
                          : result.fti
                            ? 500000
                            : 500,
                    };
                    if (!result.fti)
                      require('toastr').warning(
                        $filter('translate')('elastic.search.forcechoosing')
                      );
                  }

                  eLasticQueries.push(result);
                });

                sendata.eLasticQueries = eLasticQueries;

                // scope.map might be undefined
                // especially on KIS Administration
                // in this case we make the search without a specific SIG
                let sig = '';
                if (scope.map) {
                  sig = scope.map.getView().getProjection().getCode();
                }

                ElasticFactory.relationalSearch('geojson', sendata, sig).then(
                  function(res) {
                    scope.data = res.data;

                    //setDefaultQuery ();
                    if (!SelectManager.isGeojsonEmpty(res.data)) {
                      require('toastr').success(
                        $filter('translate')('elastic.search.search_success')
                      );
                    }
                    gaDomUtils.hideGlobalLoader();
                    if (scope.interventionSimpleMode) return;
                    if (res.data && res.data.totalFeatures > 0) {
                      addToSelectedFeature(scope.data);
                    }
                  },
                  function() {
                    //setDefaultQuery ();
                    gaDomUtils.hideGlobalLoader();
                    require('toastr').error(
                      $filter('translate')('elastic.search.search_failed')
                    );
                  }
                );
              } else {
                scope.searchquery = {};
                var relation = relations[0];
                const ftiDossier = scope.componentftis.find(
                    fti => fti.alias == relation.selectGlobaladvancedFti);
                if (ftiDossier) {
                  var type = ftiDossier.name;
                  scope.fti = ftiDossier;
                  scope.attributes = scope.fti.attributes;
                  scope.ftid = scope.fti.uid;
                } else {
                  console.error('can\'t find ' + relation.selectGlobaladvancedFti + 'in fti list (scope.componentftis)');
                }

                if (relation.filters.length === 0) {
                  scope.searchquery = {
                    query: {
                      query: {
                        bool: {
                          must: {
                            match_all: {},
                          },
                        },
                      },
                    },
                    from: 0,
                    size:
                      scope.config && scope.config.size
                        ? scope.config.size
                        : 500000,
                    sort: {
                      _score: {
                        order: 'asc',
                      },
                    },
                  };
                } else {
                  var queries = [];
                  var queriesAnnualisation = [];
                  var queriesCommun = [];
                  var liaisons = [];
                  for (const filter of relation.filters) {
                    if (filter.choice === 'rule') {
                      var res = elasticQueryService.parseFilter(filter);
                      if (angular.isDefined(res)) {
                        if (filter.guid == 'factu_statut_facture') {
                          queries.push(res);
                          if (scope.facturationAnnualise) {
                            filter.operand = 'equals';
                            filter.value = 'FACTURE_ANNUELLE_EN_COURS';
                            let resAnn =
                              elasticQueryService.parseFilter(filter);
                            queriesAnnualisation.push(resAnn);
                            filter.operand = 'notEquals';
                            filter.value = 'FACTURE_ANNUELLE_TERMINE';
                            queriesCommun.push(elasticQueryService.parseFilter(filter));
                          } else {
                            filter.operand = 'notEquals';
                            filter.value = 'FACTURE_ANNUELLE_EN_COURS';
                            res = elasticQueryService.parseFilter(filter);
                            queries.push(res);
                          }
                        } else if (filter.name == 'date_saisie_controle') {
                          queries.push(res);
                        } else {
                          queriesCommun.push(res);
                        }
                      }
                    } else {
                      if (filter && filter.choice) {
                        var res = elasticQueryService.parseAncRelation(
                          filter,
                          opts,
                          scope.applicationType
                        );
                        queriesCommun.push(res);
                      }
                    }
                  };

                  if (opts) {
                    liaisons = elasticQueryService.parseAncRelationReverse(
                      relation,
                      liaisons,
                      opts,
                      scope.applicationType
                    );
                  }

                  let queryElastic = {};
                  if (scope.facturationAnnualise) {
                    queryElastic = {
                      query: {
                        bool: {
                          must: [
                            {
                              bool: {
                                must: queriesCommun,
                              }
                            },
                            {
                              bool: {
                                should: [
                                  {
                                    bool: {
                                      must: queriesAnnualisation,
                                    },
                                  },
                                  {
                                    bool: {
                                      must: queries,
                                    },
                                  },
                                ],
                              },
                            },
                          ],
                        },
                      },
                    };
                  } else {
                    queries = queries.concat(queriesCommun);
                    queryElastic = {
                      query: {
                        bool: {
                          must: queries,
                        },
                      },
                    };
                  }
                  scope.searchquery = {
                    query: queryElastic,
                    from: 0,
                    size:
                      scope.config && scope.config.size
                        ? scope.config.size
                        : 500000,
                    sort: {
                      _score: {
                        order: 'asc',
                      },
                    }
                  };
                  if (scope.resultsConfiguration && scope.resultsConfiguration.sort == undefined) {
                    scope.resultsConfiguration.sort  = {
                      order: 'asc',
                      attribute : 'ref_dossier'
                    };
                  }
                }

                var promise;
                if (CurrentAppFactory.appCfg
                  && CurrentAppFactory.appCfg.main
                  && CurrentAppFactory.appCfg.main.properties
                  && CurrentAppFactory.appCfg.main.properties.billingQuery === 'database') {
                  promise = ElasticReplacementFactory.facturationDatabaseQuery(relations);
                  const def = $q.defer();
                  var needToRemapDossierControlNames =
                  Array.isArray(liaisons) &&
                  liaisons.length >= 0 &&
                  liaisons.filter(
                    liaison => liaison.child == 'kis_anc_dossier_controle_reponse' ||
                      liaison.child == 'kis_bac_dossier_controle_reponse'
                    ).length;

                  promise.then(
                    function(res) {
                      // comportement specifique kis_anc/bac_dossier_controle_reponse
                      // on remplace les a.b.c.d du json des controles par un alias
                      // @TODO : devrait etre fait cote serveur
                      if (needToRemapDossierControlNames && res.data.totalFeatures > 0) {
                        // console.log(options);
                        //  console.log(res.data);
                        // garde une copie des attributs non modifiées
                        if (scope.saveOriginalProperties) {
                          res.data.features.map(function(x) {
                            x.originalProperties = angular.copy(x.properties);
                          });
                        }
                      }

                      // fin comportement specifique kis_anc_dossier_controle_reponse
                      def.resolve(res);

                      // service level logic if any
                    },
                    function() {
                      def.reject();
                    }
                  );
                  promise = def.promise;
                } else {
                  if (!opts) {
                    promise = ElasticFactory.searchInType(
                      type,
                      'geojson',
                      scope.searchquery,
                      scope.map.getView().getProjection().getCode()
                    );
                  } else {
                    console.log('anc search : ');
                    console.log(scope.searchquery);

                    scope.searchquery = {
                      searchquery: scope.searchquery,
                      opts: angular.isDefined(opts) ? opts[0] : null,
                      fti: scope.fti,
                      liaisons: liaisons,
                      resultsConfiguration: angular.isDefined(
                        scope.resultsConfiguration
                      )
                        ? scope.resultsConfiguration
                        : null,
                    };

                    promise = ElasticFactory.searchInTypeAnc(
                      type,
                      'geojson',
                      scope.searchquery,
                      scope.saveOriginalProperties
                    );
                  }
                }
                promise.then(
                  function(res) {
                    var dateattributes = scope.fti.attributes
                      .map(function(x) {
                        if (
                          [
                            'java.sql.Timestamp',
                            'java.sql.Date',
                            'java.util.Date',
                          ].indexOf(x.type) !== -1
                        )
                          return x.name;
                      })
                      .filter(function(x) {
                        if (x !== undefined) return x;
                      });
                    res.data.features.map(function(x) {
                      for (var i = 0; i < dateattributes.length; i++) {
                        var key = dateattributes[i];
                        if (
                          x.properties &&
                          Object.keys(x.properties).indexOf(key) !== -1
                        ) {
                          var dateFormat = 'yyyy-MM-ddTHH:mm:ss.sssZ';
                          var n = $filter('date')(
                            x.properties[key],
                            dateFormat
                          );
                          x.properties[key] = n;
                        }
                      }
                    });
                    scope.data = res.data;

                    if (scope.applicationIsAnc && res.data.fti) {
                      AncAppSearchFactory.setSearchFTI(res.data.fti);
                      scope.fti = res.data.fti;
                      try {
                        scope.$apply();
                      } catch (e) {
                        e.stack;
                      }
                    }
                    if (scope.place !== 'dashboard') {
                      AncAppSearchFactory.setSearchResult(scope.data);

                      if (res.data.fti)
                        AncAppSearchFactory.setSearchFTI(res.data.fti);
                      else AncAppSearchFactory.setSearchFTI(scope.fti);

                      // nettoyage du fti contenu dans le searchquery et envoyé dans l'event resultelastic
                      //  pour ne retenir que les attributs réellement utilisés
                      // sans quoi le fti peut etre ENORME dans le cas des reponses_bac/anc
                      var mSearchQuery = angular.copy(scope.searchquery);
                      if (scope.applicationIsAnc) {
                        // on prend le fti renvoyé par le serveur qui peut avoir des alias/ordre différents
                        mSearchQuery.fti = res.data.fti;
                        // var _attrToKeep = Object.keys(res.data.fti.attributes);
                        // mSearchQuery.fti.attributes = mSearchQuery.fti.attributes.filter(function(x){
                        //     return _attrToKeep.indexOf(x.name)!==-1
                        // });
                      }
                      $rootScope.$broadcast(
                        'resultelastic',
                        mSearchQuery,
                        type,
                        relations[0],
                        scope.filterId,
                        scope.broadcastResult ? res.data : {}
                      );
                    } else {
                      $rootScope.$broadcast(
                        'searchsuccesssahbord',
                        scope.index
                      );
                    }
                    require('toastr').success(
                      $filter('translate')('elastic.search.search_success')
                    );
                    gaDomUtils.hideGlobalLoader();
                  },
                  function(error) {
                    gaDomUtils.hideGlobalLoader();
                    require('toastr').error(
                      $filter('translate')('elastic.search.search_failed')
                    );
                  }
                );
              }
            } else {
              require('toastr').error(
                $filter('translate')('elastic.search.advanced_search_stop')
              );
              throw new Error('choose component first');
            }
          } catch (e) {
            gaDomUtils.hideGlobalLoader();
            require('toastr').error(
              $filter('translate')('elastic.search.search_failed')
            );
            throw new Error(e.message);
          }
        };

        scope.fromCurrentSelection = function(relation) {
          if (relation instanceof Object) {
            if (angular.isUndefined(relation.fromCurrentSelection))
              relation.fromCurrentSelection = false;
            if (
              angular.isDefined(relation.fromCurrentSelection) &&
              SelectManager.getfeatures() &&
              SelectManager.getfeatures().totalFeatures > 0
            ) {
              relation.fromCurrentSelection = relation.fromCurrentSelection
                ? false
                : true;
            } else {
              relation.fromCurrentSelection = false;
              require('toastr').error(
                $filter('translate')('elastic.search.noselectmanager')
              );
            }
          } else {
            if (angular.isUndefined(scope.gbolabSearchFromCurrentSelection))
              scope.gbolabSearchFromCurrentSelection = false;
            if (
              angular.isDefined(scope.gbolabSearchFromCurrentSelection) &&
              SelectManager.getfeatures() &&
              SelectManager.getfeatures().totalFeatures > 0
            ) {
              scope.gbolabSearchFromCurrentSelection = scope.gbolabSearchFromCurrentSelection
                ? false
                : true;
            } else {
              scope.gbolabSearchFromCurrentSelection = false;
              require('toastr').error(
                $filter('translate')('elastic.search.noselectmanager')
              );
            }
          }
        };

        scope.fromPreviousResult = function(relation) {
          if (angular.isUndefined(relation.fromPreviousResult))
            relation.fromPreviousResult = false;
          relation.fromPreviousResult = relation.fromPreviousResult
            ? false
            : true;
        };

        scope.selectcomponetchange = function(relation) {
          if (angular.isDefined(relation)) {
            $rootScope.$broadcast('elastic_resetRelationDashBoard', {});
            relation.filters = [];
          }
        };

        scope.$on('refreshElasticSearch', function(event, params) {
          if (scope.fti != params.newFti) {
            //-- Réinitialiser le filtre si on change de composant
            scope.globalSearch = '';
            //-- Prendre en compte le nouveau composant
            scope.fti = params.newFti;
          }
          //-- Exécuter la recherche
          scope.searchElastic();
        });

        scope.changedalias = function(newval) {
          var idx = scope.component.indexOf(newval);
          scope.fti = scope.componentftis[idx];
        };

        function getFeaturesByName(geojson, name) {
          var result = angular.copy(geojson);
          var features = result.features
            .map(function(x) {
              if (x.id.split('.')[0] === name) return x;
            })
            .filter(function(x) {
              if (x) return x;
            });
          var ids = result.features
            .map(function(x) {
              if (x.id.split('.')[0] === name) return x.id;
            })
            .filter(function(x) {
              if (x) return x;
            });

          result.features = features;
          result.totalFeatures = features.length;
          return [result, ids];
        }

        function getFeaturesIds(geojson) {
          var ids = geojson.features.map(function(x) {
            return x.id;
          });
          return ids;
        }

        function getDefaultSuggestion(query) {
          return {
            query: {
              bool: {
                must: {
                  query_string: {
                    query: query + '.*',
                    allow_leading_wildcard: true,
                    analyze_wildcard: true,
                  },
                },
              },
            },
          };
        }

        scope.checkComponentsSelected = function() {
          var elements = scope.relations
            .map(function(x) {
              return x.selectGlobaladvancedFti;
            })
            .filter(function(x) {
              if (x) return x;
            });
          if (elements.length === 0) return true;
          else return false;
        };

        /**
         * displayTranslatedAlias
         * @param alias
         * @returns {string}
         */
        scope.displayTranslatedAlias = function(alias) {
          var aliases = scope.componentftis.filter(function(x) {
            return x.alias == alias;
          });

          var name = aliases.length ? aliases[0].name : alias,
            key = 'features.' + name + '.alias';

          return !~$filter('translate')(key).indexOf(key)
            ? $filter('translate')(key)
            : alias;
        };

        scope.selectallattributes = function(e) {
          e.fti.attributes.map(function(x) {
            // sauf pour controles anc json
            if (x.isCtrJsonAttribute) {
            } else {
              x.selected = true;
            }
          });
        };

        scope.removeallattributes = function(e) {
          e.fti.attributes.map(function(x) {
            x.selected = false;
          });
        };

        scope.searchAdvancedRelationalElastic = function(
          dontAskForAttributeOrJointure
        ) {
          if (!scope.applicationIsAnc) {
            scope.showtablejointure = false;
            var promise = elasticQueryService.parseJointureRelations(
              scope.componentftis,
              scope.relations,
              scope.relationdashbord
            );
          } else {
            var promise = elasticQueryService.parseJointureRelationsAnc(
              scope.componentftis,
              scope.relations,
              scope.relationdashbord
            );
          }
          promise.then(function(res) {
            scope.relationdashbord = angular.copy(res);

            scope.panel = {};

            scope.relationdashbord.map(function(x) {
              var ar = x.fti.attributes
                .map(function(res) {
                  if (res.selected) return res;
                })
                .filter(function(res) {
                  if (res) return res;
                });
              if (ar.length === 0) scope.selectallattributes(x);
            });

            if (!dontAskForAttributeOrJointure) {
              if (!scope.applicationIsAnc) {
                var ngDialogPromise = ngDialog.openConfirm({
                  template:
                    'js/XG/widgets/utilities/elastic/views/elasticSearchJointure.html',
                  scope: scope,
                  className:
                    'ngdialog-theme-plain width600 maxheight650 nopadding miniclose',
                });
              } else {
                var ngDialogPromise = ngDialog.openConfirm({
                  template:
                    'js/XG/widgets/utilities/elastic/views/elasticSearchJointureANC.html',
                  scope: scope,
                  className:
                    'ngdialog-theme-plain width600 maxheight650 nopadding miniclose',
                });
              }
            } else {
              // fake promise
              var deferred = $q.defer();
              deferred.resolve();
              ngDialogPromise = deferred.promise;
            }

            ngDialogPromise.then(
              function() {
                if (!scope.applicationIsAnc) {
                  elasticQueryService
                    .parseOptions(scope.relationdashbord)
                    .then(function(options) {
                      scope.searchRelationalElastic(options);
                    });
                } else {
                  elasticQueryService
                    .parseOptionsANC(scope.relationdashbord)
                    .then(function(options) {
                      scope.relationdashboardparsedopts = options;
                      scope.searchRelationalElastic(options);
                    });
                }
              },
              function() {
                require('toastr').info(
                  $filter('translate')('elastic.search.annuler')
                );
              }
            );
          });
        };

        scope.defaultUpdate = function(filter) {
          if (filter.nmjointure && angular.isUndefined(filter.jointurenmtype))
            filter.jointurenmtype = 'getOnlyFirstline';
        };

        scope.zoomOndata = function() {
          scope.displayAttributesType = {};
          gclayers.clearhighLightFeatures();

          var geojsonreader = new ol.format.GeoJSON();
          var g = geojsonreader.readFeatures(scope.geoj);
          var extent = ol.extent.createEmpty();
          g.forEach(function(feature, index) {
            ol.extent.extend(extent, feature.getGeometry().getExtent());
            gclayers.addhighLightFeatures(scope.geoj.features[index].id);
          });
          scope.map.getView().fit(extent, scope.map.getSize());
        };

        scope.opengraph = function() {
          $timeout(function() {
            extendedNgDialog.open({
              template:
                'js/XG/widgets/utilities/elastic/views/elasticSelectedCharts.html',
              className: 'ngdialog-theme-plain width1000 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
              title: 'Charts',
              draggable: true,
            });
          }, 1000);
        };

        /**
         * remove features and update datatable
         */
        scope.$on('elasticFilterDeleteItems', function (event, params) {
          if (params.name == scope.fti.name) {
            // format ids
            let featuresToDelete = params.delete.map(
              (id) => params.name + '.' + id
            );
            // remove featuresToDelete from scope.data.features
            scope.data.features = scope.data.features.filter(
              (feature) => !featuresToDelete.includes(feature.id)
            );
            scope.data.totalFeatures = scope.data.features.length;
            $rootScope.$broadcast('refreshDatatable', { uid: params.uid });
          }
        });
      },
    };
  };

  gcelement.$inject = [
    'gclayers',
    '$http',
    'FeatureTypeFactory',
    'elasticQueryService',
    'ElasticFactory',
    'ElasticReplacementFactory',
    '$filter',
    'SelectManager',
    'gcPopup',
    'panelsManager',
    'gaDomUtils',
    'ngDialog',
    '$rootScope',
    'ParametersFactory',
    'AncAppSearchFactory',
    'extendedNgDialog',
    '$timeout',
    '$q',
    'AncAppFactory',
    'BacAppFactory',
    '$location',
    'QueryFactory',
  ];
  return gcelement;
});
