'use strict';
define(function() {
  var formBuilderFtiArray = function(FeatureTypeFactory, $filter) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/form/views/formBuilderFtiArray.html',
      restrict: 'EA',
      scope: {
        res: '=?', // res contient le resultat de la dernière sélection sous le format "uid"
        ftidst: '=?ftidst', // ftidst contient la liste des toutes les sélectoin 
                            // sous le format "uid1/uid2"
        functionindex: '=?' // le rang de la fonction dans le formBuilder. 
                            // c'est très utile dans le cas ou on passe d'une fonction 
                            // à une autre de même type(setData -> set data) pour rafraichir la directive
      },
      link: function(scope) {
        let init = (checkRes) => {
          // a chaque reload on met ftid a undefined pour ne pas garder 
          // la valeur selection dans gccomponent
          scope.ftid = undefined;
          scope.myfti = {};
          scope.lines = [];
          if(checkRes){
            let lines = [];
            scope.uidLines = angular.isArray(scope.res) ? scope.res : [];
            scope.uidLines.forEach(function(uid) {
              let ft = FeatureTypeFactory.getFeatureByUid(uid);
              lines.push({
                uid: uid,
                alias: ft.alias,
              });
            });
            scope.lines = lines;
          }
          // If we dont find the lines in res, check in ftidst
          // If default value, initialise empty ftidst
          if(scope.ftidst === 'fids') {
            scope.ftidst = undefined;
          }
          else if (scope.ftidst && scope.lines.length === 0) {
            let ftidst = scope.ftidst.slice(1, scope.ftidst.length - 1);
            ftidst = ftidst.split('/');
            ftidst.forEach((uid) => {
              scope.lines.push({
                uid: uid,
                alias: FeatureTypeFactory.getFeatureByUid(uid).alias,
              });
            });
          }
        }
        
        init(true);
        scope.$watch('functionindex', function(newValue, oldValue) {
          if (newValue !== oldValue) {
            init();
          }
        }, true);

        /**
         * Add a line
         */
        scope.addLine = function() {
          if (scope.myfti.uid) {
            // check if already set
            var found = scope.lines
              .map(function(l) {
                return l.uid;
              })
              .indexOf(scope.myfti.uid);
            if (found === -1) {
              scope.lines.push({
                uid: scope.myfti.uid,
                alias: scope.myfti.alias,
              });
            } else {
              require('toastr').error(
                $filter('translate')('form_builder_fti_array.already_set')
              );
            }
          }
        };

        /**
         * Delete a line
         * @param index
         */
        scope.deleteLine = function(index) {
          scope.lines.splice(index, 1);
        };

        /**
         * Update res
         */
        scope.$watch(
          'lines',
          function(innerLines) {
            scope.res = innerLines.map(function(l) {
              return l.uid;
            });
            scope.resString = scope.res.join('/');
            if (scope.resString) {
              scope.ftidst = "'" + scope.resString + "'";
            }
          },
          1
        );
      },
    };
  };

  formBuilderFtiArray.$inject = ['FeatureTypeFactory', '$filter'];
  return formBuilderFtiArray;
});
