'use strict';
define(function() {
  var formBuilderFtiUniqueAttributeArray = function(FeatureTypeFactory, $filter) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/form/views/formBuilderFtiUniqueAttributeArray.html',
      restrict: 'EA',
      scope: {
        res: '=?',      // resultat de la dernière sélection sous le format "uid;attribut"
        ftidst: '=?ftidst',    // "'" + "uid;attribute" + "'"
        functionindex: '=?',
        minAttributes: '=minAttributes',  // Nombre minimum d'attributs à sélectionner
        maxAttributes: '=maxAttributes',  // Nombre maximum d'attributs à sélectionner
        keyOfAttributeDescriptions: '=keyOfAttributeDescriptions'
      },
      link: function(scope) {

        const FTIDST_RESERVED = ['fids', 'Composants'];

        scope.lines = [];

        // -- Si nombre min et max d'attributs à sélectionner non défini,
        // -- on met 1. Quand min et max sont différents, cela signifie que
        // -- l'on verra apparaître le bouton "Ajouter" pour sélectionner
        // -- les attributs au delà du min.
        scope.maxAttributes = scope.maxAttributes ? scope.maxAttributes : 1;
        scope.minAttributes = scope.minAttributes ? scope.minAttributes : 1;
        scope.myfti = {};

        // -- Définition des labels pour préciser l'utilisation de l'attribut à choisir
        if (scope.keyOfAttributeDescriptions) {
          // -- Cas de plusieurs attributs depuis une directive différente de celle d'origine
          scope.attributeDescriptions
            = $filter('translate')(scope.keyOfAttributeDescriptions).split('_;;_');
        }
        else {
          // -- Cas d'un seul attribut depuis la directive d'origine
          scope.attributeDescriptions = [
            $filter('translate')('functions_browser.functions.setStaticDataToCollection.p.2.desc')
          ];
        }


        /**
         * Réinitialisation de la directive
         */
        scope.init = () => {
          scope.ftid = undefined;
          scope.lines.splice(0);
          // Chargement initial si une valeur existe
          if (FTIDST_RESERVED.includes(scope.ftidst) ||
            scope.ftidst === '' || (scope.ftidst && scope.ftidst.trim() === "''")) {
            scope.ftidst = undefined;
          } else if (scope.ftidst && scope.lines.length === 0) {
            let ftidst = scope.ftidst.slice(1, scope.ftidst.length - 1);
            ftidst = ftidst.split('/');
            // -- Cette directive ne travaille que sur un composant
            // -- donc, on se contente de récupérer la première valeur
            // -- et une seule fois le FTI complet.
            let ftiUid;
            if (ftidst.length!==0) {
              ftiUid = ftidst[0].split(';')[0];
              if (scope.myfti.uid !== ftiUid) {
                scope.myfti = FeatureTypeFactory.getFeatureByUid(ftiUid, true);
              }
            }
            ftidst.forEach((uid) => {
              const attributeName = uid.split(';')[1];
              const attribute = scope.myfti.attributes.find(att => {
                return att.name === attributeName;
              });
              if (attribute) {
                scope.lines.push({
                  uid: ftiUid,
                  alias: scope.myfti.alias,
                  attribute: attribute
                });
              }
            });

          }
          // -- Si le nombre de sélecteur d'attribut est inférieur au nombre minimum d'attributs,
          // -- on ajoute autant de sélecteur d'attribut que nécessaire.
          if (scope.lines.length < scope.minAttributes) {
            for (let i = scope.lines.length; i < scope.minAttributes; i++) {
              scope.lines.push({
                uid: scope.myfti.uid,
                alias: scope.myfti.alias,
                attribute: undefined
              });
            }
          }
        };

        scope.init();

        // Reinit lors du changement de fonction
        scope.$watch('functionindex', (newValue, oldValue) => {
          if (newValue !== oldValue) {
            scope.init();
          }
        }, true);


        // Lors d'une sélection, met à jour le résultat unique

        scope.addLine = () => {
          if (scope.myfti && scope.myfti.uid) {
            // Clear existing line and push new one
            scope.lines.push({
              uid: scope.myfti.uid,
              alias: scope.myfti.alias,
              attribute: undefined
            });
          }
        };


        /**
         * Update res
         */
        scope.$watch(
          'lines',
          function(innerLines) {
            scope.res = innerLines.filter(l => l.attribute).map((l)=> {
              return scope.myfti.uid+';'+l.attribute.name;
            });
            const resString = scope.res.join('/');
            if (resString) {
              scope.ftidst = '\'' + resString + '\'';
            }
          },
          1
        );


        /**
         * Retourne les noms d'attributs déjà utilisés dans les autres lignes.
         * Exclut la ligne courante (index) et ignore les lignes sans attribut.
         * Une ligne est en fait un sélecteur d'attribut.
         *
         * @param {number} index
         *   Index de la ligne courante à exclure.
         * @returns {string[]}
         *   Noms des attributs utilisés par les autres lignes.
         */
        const attributesInUse = (index) => {
          const otherLines = scope.lines.filter((l, i) => i !== index && l.attribute);
          return otherLines.map((l) => l.attribute ? l.attribute.name : '');
        };


        /**
         * Retourne la liste des attributs encore disponibles pour une ligne donnée,
         * en excluant ceux déjà utilisés dans d'autres lignes.
         * Une ligne est en fait un sélecteur d'attribut.
         * On ne met pas dans un sélecteur un attribut
         * qui a été sélectionné dans un autre sélecteur.
         *
         * @param {number} index
         *   Index de la ligne courante dans le tableau.
         * @returns {Array<{name: string}>}
         *   Liste des attributs disponibles (au moins la clé 'name' est attendue).
         */
        scope.myftiAvailableAttributes = (index) => {
          const inUse = attributesInUse(index);
          if (inUse.length === 0) {
            return scope.myfti.attributes;
          }
          return scope.myfti.attributes.filter((att) => !inUse.includes(att.name));
        };

      }
    };
  };

  formBuilderFtiUniqueAttributeArray.$inject = ['FeatureTypeFactory', '$filter'];
  return formBuilderFtiUniqueAttributeArray;
});
