'use strict';
define(function() {
  var gccomponent = function(FeatureTypeFactory, $filter, $rootScope, $timeout) {
    return {
      templateUrl: 'js/XG/widgets/utilities/model/views/gccomponent.html',
      restrict: 'EAC',
      replace: true,
      scope: {
        result: '=?res',
        ftid: '=?ftid',
        ftidst: '=?ftidst',
        geomtype: '@geomtype',
        geomExclude: '@geomExclude',
        editable: '=',
        onchange: '&?',
        theme: '@?',
        ftisToUse: '=?',
        attributeToRetrieve: '@?', // what to retrieve when a component is selected, defaut = uid
        broadcastOnChange: '=?',
        autocomplete: '=?',
        // hideSelection: hide selected value.
        // Utilisé comme workaround pour éviter les bugs d'affichages.
        // si on modifie result -> ça ne modifie pas scope.selectedcomponent
        // le double-binding a été saboté dans cette directive donc ça fait des bugs d'affichages.
        hideSelection: '=?',
      },
      link: function(scope) {
        let attributeToRetrieve = angular.isDefined(scope.attributeToRetrieve)
          ? scope.attributeToRetrieve
          : 'uid';

        scope.activeTreatment = scope.$parent.$parent.$parent.$parent.$parent.activetreatment;

        const initComponent = () => {
          if (scope.result == undefined && scope.ftidst != undefined) {
            scope.ftid = scope.ftidst.replace(/'/g, '');
          }
          scope.selectedcomponent = scope.result;
          if (scope.selectedAutocomplete == undefined){
            scope.selectedAutocomplete = {
              selected: scope.result,
            };
          }
        };

        $timeout(() => {
          initComponent();
        });


        scope.component = [];
        scope.myfilter = {
          typeInfo: scope.geomtype,
        };

        if (angular.isDefined(scope.geomExclude)) {
          scope.myfilter = {
            typeInfo: '!' + scope.geomExclude,
          };
        }

        function setComponentList(theme) {
          var restrictlayers = [];
          var layers =
            scope.ftisToUse || FeatureTypeFactory.resources.featuretypes;
          for (var i = 0; i < layers.length; i++) {
            if (layers[i].theme == theme) {
              restrictlayers.push(layers[i]);
            }
          }
          scope.component = getFeaturesWithRelationsNotEmpty(restrictlayers);
        }
        // changement de theme
        scope.$watch('theme', function() {
          if (scope.theme == undefined) return;
          setComponentList(scope.theme);
          if (
            scope.component.length == 0 &&
            (scope.theme == '' || scope.theme == 'Default')
          ) {
            setComponentList('undefined');
          }
        });

        let getFeaturesWithRelationsNotEmpty = (features) => {
          if (scope.activeTreatment === 'SetInfoToRelation' || scope.activeTreatment === 'GetInfoFromRelation'){
            let allFeatures = angular.copy(features);
            let filtered = allFeatures.filter(feature => {
              let hasRelationsNotEmpty = feature && feature.hasOwnProperty(
                'relations')
                && Array.isArray(features)
                && feature.relations.length > 0;
              if (hasRelationsNotEmpty) {
                feature.relations = feature.relations.filter(
                  relation => relation.type === "REL_SIMPLE");
                return feature.relations.length > 0;
              }
              else {
                return false;
              }
            });
            return filtered;
          }
          else {
            return features;
          }
        };

        scope.selectComponentChange = function(changedByUser) {
          scope.selectedcomponent.isactivepoint = false;
          scope.ftid = scope.selectedcomponent[attributeToRetrieve];
          scope.ftidst = "'" + scope.ftid + "'";
          scope.result = scope.selectedcomponent;

          if (angular.isDefined(scope.broadcastOnChange)) {
            $rootScope.$broadcast('ftiChanged');
          }

          if (typeof scope.onchange === 'function') {
            scope.onchange({ changedByUser: changedByUser });
          }
        };

        /**
         * When a ftid is passed, we set the corresponding fti as scope.selectcomponent
         */
        var selectDefaultComponent = function() {
          if (angular.isDefined(scope.ftid) && scope.ftid != null) {
            var uidFound = false;
            scope.component.forEach(function(c) {
              if (c[attributeToRetrieve] == scope.ftid) {
                scope.selectedcomponent = c;
                if (scope.selectedAutocomplete) {
                  scope.selectedAutocomplete.selected = c;
                }
                scope.selectComponentChange();
                uidFound = true;
              }
            });
            if (!uidFound) {
              FeatureTypeFactory.get().then(function(res) {
                scope.component = getFeaturesWithRelationsNotEmpty(scope.ftisToUse || res );
                scope.component.forEach(function(c) {
                  if (c[attributeToRetrieve] == scope.ftid) {
                    scope.selectedcomponent = c;
                    scope.selectedAutocomplete.selected = c;
                    scope.selectComponentChange();
                  }
                });
              });
            }
          } else {
            scope.selectedcomponent = undefined;
            if (scope.selectedAutocomplete) {
              scope.selectedAutocomplete.selected = undefined;
            }
          }
        };

        if (FeatureTypeFactory.resources.featuretypes.length == 0) {
          FeatureTypeFactory.get().then(function(res) {
            // adapte aux modification de FeatureFactory.get (doit utiliser res et non plus res.data)
            scope.component = getFeaturesWithRelationsNotEmpty(scope.ftisToUse || res);
            selectDefaultComponent();
          });
        } else {
          scope.component = getFeaturesWithRelationsNotEmpty(scope.ftisToUse
            || FeatureTypeFactory.resources.featuretypes);
          selectDefaultComponent();
        }

        scope.$watch('ftid', function(newFti, oldFti) {
          selectDefaultComponent();
        });

        scope.translatealias = function(x) {
          var alias = x.alias;
          if (x.name)
            alias =
              $filter('translate')('features.' + x.name + '.alias').indexOf(
                'features.'
              ) === -1
                ? $filter('translate')('features.' + x.name + '.alias')
                : x.alias;
          return alias;
        };

        /**
         * Défini selectedComponent à partir de l'option de l'autocomplete sélectionnée
         * @param x option de l'autocomplete sélectionnée
         */
        scope.selectFromAutocomplete = (x) => {
          scope.selectedcomponent = x.selected;
          scope.selectComponentChange(true);
        };
      },
    };
  };

  gccomponent.$inject = ['FeatureTypeFactory', '$filter', '$rootScope', '$timeout'];
  return gccomponent;
});
