'use strict';
define(function() {
  var gcelement = function(
    NetworkFactory,
    $timeout,
    gaDomUtils,
    gcInteractions
  ) {
    var FEATURE_COLLECTION_TEMPLATE = {
      type: 'FeatureCollection',
      features: [],
    };

    var NOEUD_AMONT_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          anchor: [0.5, 46],
          anchorXUnits: 'fraction',
          anchorYUnits: 'pixels',
          opacity: 0.75,
          src: 'img/widget/network/noeudamont.png',
        })
      ),
    });

    var LAST_CLOSING_NODE_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          anchor: [0.5, 20],
          anchorXUnits: 'fraction',
          anchorYUnits: 'pixels',
          opacity: 0.75,
          src: 'img/widget/network/lastnode.png',
        })
      ),
    });

    var POSSIBLE_NEXT_NODE_STYLE = new ol.style.Style({
      image: new ol.style.Circle({
        radius: 6,
        fill: new ol.style.Fill({
          color: 'rgba(255,255,255,1)',
        }),
        stroke: new ol.style.Stroke({
          color: 'rgba(255,0,0,1)',
        }),
      }),
    });

    var PATH_STYLE = new ol.style.Style({
      stroke: new ol.style.Stroke({
        width: 4,
        color: 'rgba(255, 0, 0, 1)',
        lineDash: [0.1, 5],
      }),
      zIndex: 2,
    });

    var VALID_PATH_STYLE = new ol.style.Style({
      stroke: new ol.style.Stroke({
        width: 4,
        color: 'rgba(100, 0, 200, 1)',
        lineDash: [0.1, 5],
      }),
      zIndex: 2,
    });

    var GEOJSON_FORMAT = new ol.format.GeoJSON();

    return {
      templateUrl:
        'js/XG/widgets/utilities/network/views/gcgetamontavalpart.html',
      restrict: 'A',
      scope: {
        map: '=map',
        netname: '=netname',
        parttype: '@',
        pathprocessconfig: '=pathprocessconfig',
        noeudamont: '=noeudamont',
        barriers: '=barriers',
        result: '=res',
        nodesToParse: '=nodesToParse',
        featuresResult: '=featuresres',
        nfeaturesResult: '=netfeaturesres',
        originSource: '=originsource',
        pathsSource: '=pathssource',
        validPathSource: '=validpathsource',
        lastNodesSource: '=lastnodessource',
        lastClosingNodesSource: '=lastclosingnodessource',
        lastClosingNodesLayer: '=lastclosingnodeslayer',
        disabled: '=ngDisabled',
        resultIsNotReady: '=resultIsNotReady',
        allPaths: '=allPaths',
        networkExtendSelectInteraction: '=extendInteraction',
        onfinish: '&',
      },
      transclude: true,
      link: function(scope, element, attrs, ctrl) {
        var selectedFeature = null;
        scope.isAmontPartSeek =
          scope.parttype == null || scope.parttype == 'AMONT';
        scope.isActive = false;
        var startPathNode;
        scope.endPathNode = null;

        var networkName = scope.netname;
        var pathProcessConfig = null;

        scope.lastNetworkPartData = {};

        if (scope.pathprocessconfig)
          pathProcessConfig = simplifyPathProcessConfig(
            scope.pathprocessconfig
          );

        var map = scope.map;
        var inSrid = map
          .getView()
          .getProjection()
          .getCode();

        var btnElt = $(element.children()[0]);

        function activate() {
          if (scope.isActive == false) {
            scope.resultIsNotReady = true;
            scope.isActive = true;
          }
        }

        function deactivate() {
          scope.isActive = false;
          //map.removeInteraction(scope.pointer);
          if (scope.networkPathSelectInteraction) removePathSelectInteraction();

          if (scope.networkEdgeSelectInteraction) removeEdgeSelectInteraction();

          if (scope.networkExtendSelectInteraction)
            removeExtendSelectInteraction();

          startPathNode = null;
          scope.endPathNode = null;
          scope.allPaths = [];
          allEdges = [];
          scope.originNode = {};

          scope.resultIsNotReady = true;
        }

        function ftypeAttributeValuesToSavePartConfig(fTypeAttributeValues) {
          var elements = [];

          for (var ftiUID in fTypeAttributeValues) {
            var fTypeAttributeValues = fTypeAttributeValues[ftiUID];

            var ftiElements = [];

            angular.forEach(fTypeAttributeValues, function(attributeValue) {
              var attributeFilter = {
                attrName: attributeValue.attributeName,
                value: attributeValue.res[attributeValue.attributeName],
              };

              ftiElements.push(attributeFilter);
            });

            elements.push({
              ftiUID: ftiUID,
              attributesFilters: ftiElements,
            });
          }
          return elements;
        }

        function dataToSavePartConfig(data) {
          var fTypesUIDS = [];
          angular.forEach(data.leftData, function(choosedFType) {
            fTypesUIDS.push(choosedFType.uid);
          });

          return fTypesUIDS;
        }

        function simplifyPathProcessConfig(networkTool) {
          var networkToolConfig = {
            label: networkTool.label,
            toolType: networkTool.toolType,
            amontElements: [],
            avalElements: [],
            networkElements: [],
            amontElementsFilters: [],
            avalElementsFilters: [],
            networkElementsFilters: [],
          };

          var amontElementsConfigPart = dataToSavePartConfig(
            networkTool.amontElementsData
          );
          var avalElementsConfigPart = dataToSavePartConfig(
            networkTool.avalElementsData
          );
          var networkElementsConfigPart = dataToSavePartConfig(
            networkTool.edgesAndNodesData
          );

          networkToolConfig.amontElements = amontElementsConfigPart;
          networkToolConfig.avalElements = avalElementsConfigPart;
          networkToolConfig.networkElements = networkElementsConfigPart;

          var amontElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentAmontEditFTypeAttributeValues
          );
          var avalElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentAvalEditFTypeAttributeValues
          );
          var networkElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentEditFTypeAttributeValues
          );

          networkToolConfig.amontElementsFilters = amontElementsFiltersConfigPart;
          networkToolConfig.avalElementsFilters = avalElementsFiltersConfigPart;
          networkToolConfig.networkElementsFilters = networkElementsFiltersConfigPart;

          return networkToolConfig;
        }

        function toFeatureCollection(simpleResult, isNetworkFeatureCollection) {
          var resultFeatureCollection = angular.copy(
            FEATURE_COLLECTION_TEMPLATE
          );

          for (var j = 0; j < simpleResult.elements.length; j++) {
            var pathElement = simpleResult.elements[j];
            var feature = isNetworkFeatureCollection
              ? pathElement.feature
              : pathElement.modelFeature;
            resultFeatureCollection.features.push(angular.fromJson(feature));
          }

          return resultFeatureCollection;
        }

        function getNextNodeEl(path) {
          return path.elements[path.elements.length - 1];
        }

        function verifyIfEndNodeIsClosingNode(endNode, lastNodes) {
          for (var i = 0; i < lastNodes.length; i++) {
            var lastNode = lastNodes[i];
            if (endNode.id == lastNode.id) return true;
          }

          return false;
        }

        function handlePossiblePaths(nextNodePaths, initOrigin, clear) {
          //ap.un('pointermove', mapOnPointerMove);

          if (clear) {
            scope.pathsSource.clear();
            scope.lastNodesSource.clear();
            scope.lastClosingNodesSource.clear();
          }

          if (initOrigin) {
            scope.originSource.clear();
            startPathNode = nextNodePaths.origin;

            var olOriginGeometry = GEOJSON_FORMAT.readGeometry(
              startPathNode.geometry
            );
            var originFeature = new ol.Feature({
              name: '',
              geometry: olOriginGeometry,
            });

            originFeature.setStyle(NOEUD_AMONT_STYLE);

            scope.originSource.addFeature(originFeature);
          }
          var lastNodes = nextNodePaths.lastNodes;

          angular.forEach(nextNodePaths.nextPaths, function(path) {
            scope.allPaths.push(path);
            var olGeometry = GEOJSON_FORMAT.readGeometry(path.geometry);
            var possibleNextPath = new ol.Feature({
              name: '',
              geometry: olGeometry,
            });

            possibleNextPath.setStyle(PATH_STYLE);

            scope.pathsSource.addFeature(possibleNextPath);

            var nextNode = getNextNodeEl(path);

            var olNodeGeometry = GEOJSON_FORMAT.readGeometry(nextNode.geometry);
            var possibleNextNodeFeature = new ol.Feature({
              name: '',
              geometry: olNodeGeometry,
            });

            possibleNextNodeFeature.set('node', nextNode);
            possibleNextNodeFeature.set('path', path);
            //possibleNextNodeFeature.setStyle(POSSIBLE_NEXT_NODE_STYLE);
            if (verifyIfEndNodeIsClosingNode(nextNode, lastNodes)) {
              possibleNextNodeFeature.setStyle(LAST_CLOSING_NODE_STYLE);
              scope.lastClosingNodesSource.addFeature(possibleNextNodeFeature);
            } else scope.lastNodesSource.addFeature(possibleNextNodeFeature);

            scope.resultIsNotReady = false;
            $timeout(scope.onfinish(), 100);
            //if (scope.lastClosingNodesSource.getFeatures().length > 0)
            //$timeout(activateExtentSelectInteraction, 1000);
            /* scope.networkEdgeSelectInteraction = new ol.interaction.Select({
                             condition: ol.events.condition.click,
                             layers: [lastNodesLayer]
                         });*/

            //map.on('pointermove', mapOnPointerMove);
          });
        }

        function getAmontAvalPartHandler() {
          if (scope.pathprocessconfig)
            pathProcessConfig = simplifyPathProcessConfig(
              scope.pathprocessconfig
            );

          var data = {
            noeudAmont: scope.noeudamont,
            barriers: scope.barriers,
            processConfig: pathProcessConfig,
          };

          gaDomUtils.showGlobalLoader();
          var nodesToParseCt =
            scope.nodesToParse != null ? scope.nodesToParse : 10;
          NetworkFactory.seekamontoravalnetworkpart(
            data,
            networkName,
            inSrid,
            nodesToParseCt,
            scope.isAmontPartSeek
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              /*if ((res.data.nextPaths == null || res.data.nextPaths.length == 0) && scope.nodesToParse.value < scope.maxNodesToParse)
                            showDialogToExtendPath();
                        else {*/
              var toRemoveFeatures = [];

              handlePossiblePaths(res.data, false, true);
              //}
            },
            function errorCallback(response) {
              gaDomUtils.hideGlobalLoader();
            }
          );
        }

        function activateExtentSelectInteraction() {
          removeExtendSelectInteraction();

          scope.networkExtendSelectInteraction = new ol.interaction.Select({
            layers: [scope.lastClosingNodesLayer],
            style: new ol.style.Style({
              fill: new ol.style.Fill({
                color: 'rgba(255, 100, 50, 0.3)',
              }),
              stroke: new ol.style.Stroke({
                width: 2,
                color: 'rgba(255, 100, 50, 0.8)',
              }),
              image: new ol.style.Icon({
                scale: 0.7,
                rotateWithView: false,
                anchor: [0.5, 1],
                anchorXUnits: 'fraction',
                anchorYUnits: 'fraction',
                opacity: 1,
                src: 'img/widget/network/marker.png',
              }),
            }),
            toggleCondition: ol.events.condition.never,
          });

          scope.networkExtendSelectInteraction.set('gctype', 'kis');
          scope.networkExtendSelectInteraction.set('interaction', 'Select');
          scope.networkExtendSelectInteraction.set(
            'widget',
            'networksubpathselect'
          );
          scope.networkExtendSelectInteraction.setActive(true);
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          map.addInteraction(scope.networkExtendSelectInteraction);
          var test = scope.networkExtendSelectInteraction.on(
            'select',
            handleExtendNodeEvent
          );
          console.log(test);
        }

        function removeExtendSelectInteraction() {
          if (scope.networkExtendSelectInteraction) {
            scope.networkExtendSelectInteraction.setActive(false);
            map.removeInteraction(scope.networkExtendSelectInteraction);
            //scope.networkExtendSelectInteraction.un('select', handleExtendNodeEvent);
            scope.networkExtendSelectInteraction = null;
          }
        }

        function getExtendNetworkPart(nodesValue) {
          if (!nodesValue) nodesValue = scope.nodesToParse.value;

          gaDomUtils.showGlobalLoader();
          var nodesToParseCt =
            scope.nodesToParse != null ? scope.nodesToParse : 10;
          NetworkFactory.seekamontoravalnetworkpart(
            scope.lastNetworkPartData,
            networkName,
            inSrid,
            20,
            scope.isAmontPartSeek
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (
                (res.data.nextPaths == null ||
                  res.data.nextPaths.length == 0) &&
                scope.nodesToParse.value < scope.maxNodesToParse
              )
                showDialogToExtendPath();
              else {
                var toRemoveFeatures = [];

                scope.lastClosingNodesSource.forEachFeature(function(feat) {
                  if (selectedFeature != feat) toRemoveFeatures.push(feat);
                });

                scope.lastClosingNodesSource.removeFeature(selectedFeature);

                handlePossiblePaths(res.data, false, false);
              }
            },
            function errorCallback(response) {
              gaDomUtils.hideGlobalLoader();
            }
          );
        }

        function handleExtendNodeEvent(evt) {
          if (evt.selected.length > 0) {
            selectedFeature = scope.networkExtendSelectInteraction
              .getFeatures()
              .item(0);

            if (selectedFeature) {
              var node = selectedFeature.get('node');

              if (scope.pathprocessconfig)
                pathProcessConfig = simplifyPathProcessConfig(
                  scope.pathprocessconfig
                );

              scope.lastNetworkPartData = {
                noeudAmont: node,
                barriers: scope.barriers,
                processConfig: pathProcessConfig,
              };

              getExtendNetworkPart();
            }
          }
        }

        function clearAll() {
          scope.pathsSource.clear();
          scope.originSource.clear();
          scope.validPathSource.clear();
          scope.lastNodesSource.clear();
          scope.lastClosingNodesSource.clear();
        }

        scope.getAmontAvalPart = function() {
          activate();
          clearAll();
          getAmontAvalPartHandler();
        };
      },
    };
  };

  gcelement.$inject = [
    'NetworkFactory',
    '$timeout',
    'gaDomUtils',
    'gcInteractions',
  ];
  return gcelement;
});
