'use strict';
define(function () {
  const gcelement = (extendedNgDialog, $filter, NetworkFactory,
    gclayers, SelectManager, ogcFactory, FeatureTypeFactory, gaJsUtils,
    GeometryFactory, $q, $timeout
  ) => {
    return {
      templateUrl: 'js/XG/widgets/utilities/network/views/gcpathroute.html',

      restrict: 'A',
      scope: {
        onfinish: '&',
        map: '=',
        fieldconfig: '=',
        dlgPopup: '=',
        res: '=',
        selectionRes: '=',
        geometryRes: '='
      },
      link: function (scope) {


        scope.fieldconfig.bufferTypes = [
          { value: 'round', label: 'Round'},
          { value: 'square', label: 'Square'},
          { value: 'flat', label: 'Flat'}
        ];
        if (scope.fieldconfig.buftype) {
          for (let ind = 0; ind < scope.fieldconfig.bufferTypes.length; ind++) {
            if (scope.fieldconfig.buftype.value == scope.fieldconfig.bufferTypes[ind].value) {
              scope.fieldconfig.buftype = scope.fieldconfig.bufferTypes[ind];
            }
          }
        }
        let geoJsonObj = new ol.format.GeoJSON();

        /**
         * Affichage d'une alerte avec l'intitulé de ce widget.
         *
         * @param {*} msg
         */
        let thisAlert = (msg) => {
          swal(
            {
              title: $filter('translate')('model.network.networkDirectedPathToolLabel'),
              text: $filter('translate')(msg),
              type: 'warning',
              showCancelButton: false,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: 'ok',
              closeOnConfirm: true,
            }
          );
        };


        let getMapResolution = () => {
          return scope.map.getView().getResolution();
        };


        let clearFeatures = () => {
          gclayers.clearhighLightFeatures();
          for (let featName in scope.features) {
            gclayers.getDrawLayer().getSource().removeFeature(
              scope.features[featName]);
            delete scope.features[featName];
          }
          delete gclayers.getDrawLayer().getSource().clear();
        };


        scope.selectPath = () => {
          scope.dlgPopup.features.hide();
          scope.parentPopup = scope.dlgPopup;
          scope.pathToolDlg = extendedNgDialog.open({
            template:
              'js/XG/widgets/utilities/network/views/gcPathRouteModal.html',
            className:
              'ngdialog-theme-default ' +
              'path_height550' +
              ' nopadding miniclose interventionRenderWrapper',
            closeByDocument: false,
            scope: scope,
            minimizeMaximize: true,
            scrollable: true,
            resizable: true,
            title: 'Cherchez le chemin',
            draggable: true,
            closeCallback: scope.cancel
          });
        };

        scope.nodeTypes = [];
        resolveNodeTypes();

        scope.route = {
          start: '',
          end: '',
          startShift: 0,
          endShift: 0
        };
        if (!scope.fieldconfig.max_nodes) {
          scope.fieldconfig.max_nodes = 200;
        }
        if (!scope.fieldconfig.max_paths) {
          scope.fieldconfig.max_paths = 5;
        }


        let deactivatePointDraw = () => {
          scope.pointerByPtUtil.setActive(false);
          scope.map.removeInteraction(scope.pointerByPtUtil);
          scope.addWayPointForStartStarted = false;
          scope.addWayPointForEndStarted = false;
        };


        let removeSelectionForWaypoints = () => {
          deactivatePointDraw();
          gclayers.clearhighLightFeatures();
          SelectManager.clear();
        };


        /**
         * Lancer la séelction d'un point sur la carte.
         *
         * @param {*} type
         */
        scope.addWaypoint = (type) => {
          removeSelectionForWaypoints();
          scope.dlgIsHidden = true;
          //-- SI la popup n'est pas minimisée, la minimiser.
          if (!scope.pathToolDlg.features.isTab) {
            scope.pathToolDlg.features.makeItTab();
          }
          if (type === 'start') {
            addWayPointForStart();
          }
          else if (type === 'end') {
            addWayPointForEnd();
          }
        };


        let getFtiUidFromNodeFtiName = (ftiName) => {
          //-- Recherche du node type du noeud sélectionné
          //-- d'aprés le nom du FTI.
          for (let iNt = 0; iNt < scope.nodeTypes.length; iNt++) {
            //-- Dans nodeTypes, il n'y a que l'UID du fti,
            //-- il faut donc récupérer le FTI pour connaître son  nom.
            let fti = FeatureTypeFactory.getFeatureByUid(scope.nodeTypes[iNt].ftiUID);
            if (fti.uid != '') {
              if (fti.name == ftiName) {
                return scope.nodeTypes[iNt].ftiUID;
              }
            }
          }
          if (scope.nodeType.length) {
            return scope.nodeTypes[0].ftiUID;
          }
        };


        let getInfoFromId = (strId) => {
          let arrId = strId.split('.');
          if (arrId.length != 1) {
            return {
              id: parseInt(arrId[1]),
              ftiUID: getFtiUidFromNodeFtiName(arrId[0])
            };
          }
          else {
            return { id: arrId[0], ftiUID: getFtiUidFromNodeFtiName(arrId[0]) };
          }
        };


        let getNodeForGettingPaths = (nodeName) => {
          let info = getInfoFromId(scope.route[nodeName]);
          return {
            id: info.id,
            featId: scope.route[nodeName],
            ftiUID: info.ftiUID,
            geometry: JSON.stringify(scope.route[nodeName + 'Point']),
            feature: '',
            modelFeature: ''
          };
        };


        let resetItineraryList = () => {
          if (scope.foundItineraries) {
            scope.foundItineraries.splice(0, scope.foundItineraries.length);
          }
          else {
            scope.foundItineraries = [];
          }
        };


        let feedItineraryList = (paths) => {
          scope.foundItineraries = scope.foundItineraries.concat(paths);
          if (paths.length == 0) {
            thisAlert('tools.builder.fields.network.path_route_from_nodes.no_path_found');
            scope.selectedItinerary = undefined;
          }
          else {
            $timeout(
              () => {
                scope.selectedItinerary = scope.foundItineraries[0];
              }, 0
            );
          }
        };


        let toastrError = (messId, moreMess) => {
          require('toastr').error(
            $filter('translate')('tools.builder.fields.network.path_route_from_nodes.' + messId)
            + moreMess
          );
        };


        /**
         * Récupérer la liste des tronçons connectés au noeud début/fin
         * et enregistrer cette liste pour l'utiliser avec le décalage
         * de construction du buffer pour connaître la direction
         * que le buffer doit prendre (gestion canalisations amont ou aval).
         * .
         * @param {*} inSrid
         * @param {*} startOrEnd
         * @param {*} def
         * @returns
         */
        let getConnectedEdges = (inSrid, startOrEnd, def) => {
          if (!def) {
            def = $q.defer();
          }
          NetworkFactory.getconnectededgesxy(
            '',
            scope.fieldconfig.network,
            inSrid,
            scope.route[startOrEnd].coordinates[0],
            scope.route[startOrEnd].coordinates[1],
            ''
          ).then(
            (res) => {
              if (startOrEnd == 'startPoint') {
                //-- On vient de récupérer les linéaires connecté
                //-- au noeud de départ, on enregistre  ces linéaires et
                //-- on fait la même recherche pour le noeud d'arrivé.
                scope.route.startEdges = res.data.nextEdges;
                getConnectedEdges(inSrid, 'endPoint', def);
              }
              else {
                scope.route.endEdges = res.data.nextEdges;
                def.resolve();
              }
            }
          );
          return def.promise;
        };


        scope.searchRoutes = () => {
          scope.searchingRoute = true;
          resetItineraryList();
          let srid = scope.map.getView().getProjection().getCode();
          let startNode = getNodeForGettingPaths('start');
          let endNode = getNodeForGettingPaths('end');
          getConnectedEdges(srid, 'startPoint').then(
            () => {
              NetworkFactory.getAllPaths(scope.fieldconfig.network, srid,
                startNode, endNode, scope.fieldconfig.max_nodes,
                scope.fieldconfig.max_paths).then(
                (res) => {
                  if (!res.data.errorList || res.data.errorList.length == 0) {
                    feedItineraryList(res.data);
                  }
                  else {
                    toastrError('get_all_paths_sce_error', res.data.errorMessage);
                  }
                }
              ).finally(
                () => {
                  scope.searchingRoute = false;
                }
              );
            },
            () => {
              scope.searchingRoute = false;
            }
          );
        };


        let setPointDraw = () => {
          scope.pointerByPtUtil = new ol.interaction.Draw({
            type: 'Point',
            style: new ol.style.Style({}),
          });

          scope.pointerByPtUtil.set('gctype', 'kis');
          scope.pointerByPtUtil.set('interaction', 'Draw');
          scope.pointerByPtUtil.set('widget', 'select');
          scope.pointerByPtUtil.setActive(false);
          scope.pointerByPtUtil.on('drawend', (evt) => {
            resolveFeaturesByPoint(evt);
          });
        };

        setPointDraw();


        const activatePointDraw = () => {
          scope.map.getViewport().style.cursor = 'pointer';
          scope.pointerByPtUtil.setActive(true);
          scope.map.addInteraction(scope.pointerByPtUtil);
        };


        function resolveNodeTypes () {
          NetworkFactory.get(false).then((res) => {
            if (!res || !Array.isArray(res.data)) {
              return;
            }
            scope.nodeTypes = (
              res.data.find((network) => network.name === scope.fieldconfig.network) ||
              {}
            ).nodesTypes;
            if (
              !Array.isArray(scope.nodeTypes) ||
              scope.nodeTypes.length === 0
            ) {
              return;
            }
          });
        }


        let addWayPointForStart = () => {
          scope.addWayPointForStartStarted = true;
          console.log('add waypoinrt start');
          activatePointDraw();
        };
        let addWayPointForEnd = () => {
          scope.addWayPointForEndStarted = true;
          activatePointDraw();
        };


        /**
         * Création du point de départ ou d'arrivé
         * dans la couche technique - edition.
         *
         * @param {*} feat : regard sélectionné
         * @param {*} featName : 'startFeature', ou 'endFeature'
         * @param {*} color : 'rgba(255,0,0,1)' par exemple
         */
        let drawPoint = (feat, featName, color) => {

          if (!scope.features) {
            scope.features = {};
          }
          if (scope.features[featName]) {
            //-- Le point de départ est déarrivé existe dans la couche,
            //-- on se contente de changer sa géoémtrie, donc
            //-- de le déplacer vers le nouvel objet sélectionné.
            scope.features[featName].setGeometry(
              new ol.geom.Point(feat.geometry.coordinates));
          }
          else {
            //-- Création de la feature open layers du point de départ
            //-- ou d'arrivée du parcours.
            scope.features[featName] = new ol.Feature({
              geometry: new ol.geom.Point(feat.geometry.coordinates)
            });
            let style = new ol.style.Style({
              image: new ol.style.Circle({
                radius: 10,
                fill: new ol.style.Fill({
                  color: color,
                }),
                stroke: new ol.style.Stroke({
                  color: 'rgba(125,125,125,1.0)',
                  width: 3,
                })
              })
            });
            scope.features[featName].setStyle(style);
            gclayers
              .getDrawLayer()
              .getSource()
              .addFeature(scope.features[featName]);
          }
        };


        let resolveFeaturesByPoint = (evt) => {
          if (!scope.nodeTypes) {
            thisAlert('tools.builder.fields.network.no_node_type_found');
            return;
          }
          let coordinates = getPointToPolygonCoordinates(evt)
            .map(point => point.join(' ')).join(',');
          const cqlFilter = `INTERSECTS(geom, POLYGON((${coordinates})))`;
          return ogcFactory.getfeatures(
            'GetFeature',
            'WFS',
            '1.0.0',
            (scope.nodeTypes || []).map(nodeType => nodeType.ftiUID).join(','),
            'json',
            scope.map
              .getView()
              .getProjection()
              .getCode(),
            cqlFilter,
            undefined,
            getMapResolution()
          ).then((res) => {
            if (res.data && res.data.features.length > 0) {
              scope.selectedCurrentFeature = res.data.features[0];
              gclayers.clearhighLightFeatures();
              SelectManager.clear();
              if (scope.addWayPointForStartStarted) {
                scope.route.start = scope.selectedCurrentFeature.id;
                scope.route.startPoint = scope.selectedCurrentFeature.geometry;
                drawPoint(scope.selectedCurrentFeature, 'startFeature',
                  'rgba(50,255,50,1.0)');
              }
              else if (scope.addWayPointForEndStarted) {
                scope.route.end = scope.selectedCurrentFeature.id;
                scope.route.endPoint = scope.selectedCurrentFeature.geometry;
                drawPoint(scope.selectedCurrentFeature, 'endFeature',
                  'rgba(255,50,50,1.0)');
              }
            }
            else {
              thisAlert('tools.builder.fields.network.no_node_found');
            }
          }).finally(
            () => {
              scope.map.getViewport().style.cursor = 'default';
              //-- Si la popup est minimisée, la remettre à sa taille normale.
              if (scope.pathToolDlg.features.isTab) {
                scope.pathToolDlg.features.makeItTab();
              }
              deactivatePointDraw();
            }
          );
        };


        function getPointToPolygonCoordinates(evt) {
          const format = new ol.format.GeoJSON();
          const feature = format.writeFeatureObject(evt.feature);
          let x = feature.geometry.coordinates[0];
          let y = feature.geometry.coordinates[1];
          const resolution = getMapResolution() || 1;
          return [
            [x - 7 * resolution, y - 7 * resolution],
            [x + 7 * resolution, y - 7 * resolution],
            [x + 7 * resolution, y + 7 * resolution],
            [x - 7 * resolution, y + 7 * resolution],
            [x - 7 * resolution, y - 7 * resolution],
          ];
        }



        let getGeomOfIti = (iti) => {
          if (!iti.geom) {
            iti.geom =
              new ol.geom.MultiLineString(JSON.parse(iti.geometry).coordinates);
          }
          return iti.geom;
        };


        scope.zoomToItinerary = (iti) => {
          gaJsUtils.localiseGeom(getGeomOfIti(iti), scope.map);
        };


        scope.showItinerary = (iti) => {
          scope.selectedItinerary = iti;
          let itiGeom = getGeomOfIti(iti);
          if (scope.features.itinerary) {
            //-- Le point de départ est déarrivé existe dans la couche,
            //-- on se contente de changer sa géométrie, donc
            //-- de le déplacer vers le nouvel objet sélectionné.
            scope.features.itinerary.setGeometry(itiGeom);
          }
          else {
            //-- Création de la feature open layers du point de départ
            //-- ou d'arrivée du parcours.
            scope.features.itinerary = new ol.Feature({
              geometry: itiGeom
            });
            let style = new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: 'rgba(255,182,43,0.85)',
                width: 8,
              })
            });
            scope.features.itinerary.setStyle(style);
          }
          gclayers.getDrawLayer().getSource().addFeature(
            scope.features.itinerary);
        };


        let sameCoords = (coords, feat, otherCoord) => {
          let pt;
          if (feat) {
            pt = feat.getGeometry().getCoordinates();
          }
          else {
            pt = otherCoord;
          }
          return Math.abs(coords[0] - pt[0]) < 0.01
            && Math.abs(coords[1] - pt[1]) < 0.01;
        };


        let getNewFirstPointFor = (geom, shift) => {
          let c = geom.getCoordinates();
          let dx = c[1][0] - c[0][0];
          let dy = c[1][1] - c[0][1];
          let newC = [];
          newC[0] = c[0][0] + shift * dx / geom.getLength();
          newC[1] = c[0][1] + shift * dy / geom.getLength();
          return newC;
        };


        /**
         * Inverser la ligne quand le décalage concerne le dernier point et
         * que le sens de la ligne est le même que celui allant
         * du point de départ au point d'arrivée.
         * Inverser aussi la ligne quand le décalage concerne
         * le premier point et quele sens de la ligne n'est pas le même
         * que allant du point de départ au point d'arrivée.
         *
         * @param {*} coords
         * @param {*} step
         * @returns
         */
        let haveToReverse = (coords, step) => {
          return (step == -1
            && sameCoords(coords[0], scope.features.startFeature))
            ||
            (step == 1 && !sameCoords(coords[0], scope.features.startFeature));
        };


        /**
         * Raccourcissement (ou extension quand décalage négatif) du tracé.
         *
         * @param {*} coords
         * @param {*} shift
         * @param {*} step
         * @param {*} oriCoords
         */
        let shortenLineCoords = (coords, shift, step, oriCoords) => {
          let ind, newCoord, reverse = haveToReverse(oriCoords, step);
          if (reverse) {
            coords.reverse();
          }
          for (ind = 1; ind < coords.length; ind++) {
            let geom = new ol.geom.LineString([coords[ind - 1], coords[ind]]);
            if (geom.getLength() > shift) {
              newCoord = getNewFirstPointFor(geom, shift);
              break;
            }
            else {
              shift -= geom.getLength();
            }
          }
          coords.splice(0, ind, newCoord);
          if (reverse) {
            coords.reverse();
          }
        };


        /**
         * Quand on veut chemin au delà du parcours (décalage négatif),
         * ajout du point du segment suivant ou précédent et
         * calcul du décalage positif à utiliser.
         *
         * @param {*} extLine
         * @param {*} coords
         * @param {*} shift
         * @param {*} step
         * @returns
         */
        let setCoordsAndShiftBeyongPath = (extLine, coords, shift, step) => {
          if (step == -1) {
            coords.reverse();
          }
          let geom = geoJsonObj.readGeometry(extLine.geometry);
          let extCoords = geom.getCoordinates()[0];
          if (sameCoords(coords[0], undefined, extCoords[0])) {
            for (let iCoord=1; iCoord < extCoords.length; iCoord++) {
              coords.splice(0, 0, extCoords[iCoord]);
            }
          }
          else {
            let iLastPt1 = coords.length - 1;
            let iLastPt2 = extCoords.length - 1;
            if (sameCoords(coords[iLastPt1], undefined, extCoords[iLastPt2])) {
              //-- Le dernier point de la ligne est
              //-- le dernier point de la ligne suivante
              for (let iCoord = extCoords.length - 2; iCoord >=0 ; iCoord--) {
                coords.push(extCoords[iCoord]);
              }
            }
            else {
              if (sameCoords(coords[iLastPt1], undefined, extCoords[0])) {
              //-- Le dernier point de la ligne est
              //-- le 1er point de la ligne suivante
                for (let iCoord = 1; iCoord < extCoords.length; iCoord++) {
                  coords.push(extCoords[iCoord]);
                }
              }
              else {
                //-- Le 1er point de la ligne est
                //-- le dernier point de la ligne suivante
                for (let iCoord = extCoords.length - 2; iCoord >=0 ; iCoord--) {
                  coords.splice(0,0,extCoords[iCoord]);
                }
              }
            }
          }
          if (step == -1) {
            coords.reverse();
          }
          geom = new ol.geom.LineString(extCoords);
          const newShift = geom.getLength() + shift;
          return newShift > 0 ? newShift : 0;
        };


        let getMlsFrom = (iti, coords, startShift, endShift) => {
          let geom = new ol.geom.LineString(coords);
          if (!endShift) endShift = 0;
          if (!startShift) startShift = 0;
          if (geom.getLength() < startShift + endShift) {
            toastrError('shift_sum_too_big', '');
          }
          else {
            //-- Il faut commencer par le décalage du dernier point.
            //-- Le décalage du premier point => que le test pour savoir
            //-- si on doit inverser la liste des coordonnées ne marche pas
            //-- puisque c'est celui-ci qui est testé.
            let oriCoords = angular.copy(coords);
            if (endShift != 0) {
              if (endShift > 0) {
                endShift = setCoordsAndShiftBeyongPath(scope.route.endExtLine,
                  coords, -endShift, -1);
              }
              shortenLineCoords(coords, Math.abs(endShift), -1, oriCoords);
            }
            if (startShift != 0) {
              if (startShift < 0) {
                startShift = setCoordsAndShiftBeyongPath(
                  scope.route.startExtLine, coords, startShift, 1);
              }
              shortenLineCoords(coords, startShift, 1, oriCoords);
            }
            return new ol.geom.LineString(coords);
          }
          return geom;
        };


        let getPosInNewCoordFor = (seg, newCoords) => {
          let iSegWithTolerance = -1;
          for (let iSeg = 0; iSeg < newCoords.length; iSeg++) {
            //-- Le dernier point du segment à ajouter
            //-- est le premier du segment iSeg, il faudra l'ajouter avant iSeg.
            if (newCoords[iSeg] == undefined
              || newCoords[iSeg][0] == undefined || seg[1] == undefined) {
              console.log('pb');
            }
            let iLastPt = seg.length-1;
            if (newCoords[iSeg][0][0] == seg[iLastPt][0]
              && newCoords[iSeg][0][1] == seg[iLastPt][1]) {
              return iSeg;
            }
            if (Math.abs(newCoords[iSeg][0][0] - seg[iLastPt][0]) < 0.1
              && Math.abs(newCoords[iSeg][0][1] - seg[iLastPt][1]) < 0.1) {
              iSegWithTolerance = iSeg;
            }
            //-- Le premier point du segment à ajouter
            //-- est le dernier du segment iSeg, il faudra l'ajouter aprés iSeg.
            iLastPt = newCoords[iSeg].length-1;
            if (newCoords[iSeg][iLastPt][0] == seg[0][0]
              && newCoords[iSeg][iLastPt][1] == seg[0][1]) {
              return iSeg + 1;
            }
            if (Math.abs(newCoords[iSeg][iLastPt][0] - seg[0][0]) < 0.1
              && Math.abs(newCoords[iSeg][iLastPt][1] - seg[0][1]) < 0.1) {
              iSegWithTolerance = iSeg + 1;
            }
          }
          return iSegWithTolerance;
        };


        /**
         * Impossible que le tracé ne soit pas continu,
         * il s'agit d'un parcours réseau.
         */
        let orderSegments = (coords, newCoords, nextCoords) => {
          let iTheCoord, rmCoord, doItLater;
          if (coords.length != 0) {
            iTheCoord = getPosInNewCoordFor(coords[0], newCoords);
            doItLater = newCoords.length != 0 && iTheCoord == -1;
            if (doItLater) {
              //-- Peut-être pas trouvé parceque le segment
              //-- a un sens inverse des précédents.
              coords[0].reverse();
              iTheCoord = getPosInNewCoordFor(coords[0], newCoords);
              doItLater = newCoords.length != 0 && iTheCoord == -1;
            }
            if (newCoords.length == 0 || iTheCoord != -1) {
              newCoords.splice(iTheCoord, 0, coords[0]);
            }
            rmCoord = coords.splice(0, 1);
            if (doItLater) {
              nextCoords.push(rmCoord[0]);
            }
            orderSegments(coords, newCoords, nextCoords);
          }
          else {
            return;
          }
        };


        /**
         * La liste de segment est transformée en une liste de coordonnées.
         *
         * @param {*} segments
         * @returns
         */
        let simplifySegmentsToSegment = (segments) => {
          let newSeg = [];
          newSeg.push(segments[0][0]);
          for (let iSeg = 0; iSeg < segments.length; iSeg++) {
            for (let iCoord = 0; iCoord < segments[iSeg].length; iCoord++) {
              newSeg.push(segments[iSeg][iCoord]);
            }
          }
          return newSeg;
        };


        let addBufferFeature = (geom) => {
          scope.features.itineraryBuffer = new ol.Feature({
            geometry: geom
          });
          let style = new ol.style.Style({
            fill: new ol.style.Fill({
              color: 'rgba(255,251,77,0.25)',
            }),
            stroke: new ol.style.Stroke({
              color: 'rgba(255,251,77,1.0)',
              width: 3,
            })
          });
          scope.features.itineraryBuffer.setStyle(style);
          gclayers
            .getDrawLayer()
            .getSource()
            .addFeature(scope.features.itineraryBuffer);
        };


        let setBufferFeature = (polygon, geoJsonObj) => {

          let geom = geoJsonObj.readGeometry(polygon);
          if (scope.features.itineraryBuffer == undefined) {
            addBufferFeature(geom);
          }
          else {
            scope.features.itineraryBuffer.setGeometry(geom);
          }
        };


        let getBufferGeom = () => {
          let lineGeom = scope.features.itinerary.getGeometry();
          let geoJson = geoJsonObj.writeGeometryObject(lineGeom);
          return GeometryFactory.buffer(geoJson,
            scope.fieldconfig.buftype.value, scope.fieldconfig.size);
        };


        let buildPathBuffer = () => {
          if (scope.route.showBuffer) {
            getBufferGeom().then(
              (res) => {
                setBufferFeature(res.data, geoJsonObj);
              }
            );
          }
          else {
            if (scope.features.itineraryBuffer) {
              gclayers.getDrawLayer().getSource().removeFeature(
                scope.features.itineraryBuffer);
              delete scope.features.itineraryBuffer;
            }
          }
        };


        let lineInLineList = (line, list) => {
          let iElt;
          for (iElt = 0; iElt < list.length; iElt++) {
            if (list[iElt].featId == line.featId &&
              list[iElt].ftiUID == line.ftiUID)
              return true;
          }
          return false;
        };


        let setExtremityLinesOfIti1 = (iti, startEnd, extLines) => {
          let edges = startEnd + 'Edges';
          let curLine;
          for (let iLine = 0; iLine < scope.route[edges].length; iLine++) {
            curLine = scope.route[edges][iLine];
            //-- Ne pas prendre le tronçon s'il fait parti du tracé, ou
            //-- lists'il est déjà dans la liste.
            if (!lineInLineList(curLine, iti.elements)
            && !lineInLineList(curLine,extLines)) {
              extLines.push(scope.route[edges][iLine]);
            }
          }
          if (extLines.length !== 0) {
            scope.route[startEnd+'ExtLine'] = extLines[0];
          }
        };


        let setExtremityLinesOfIti = (iti) => {
          if (!iti.extremityLinesUs) {
            iti.extremityLinesUs = [];
            iti.extremityLinesDs = [];
            setExtremityLinesOfIti1(iti, 'start', iti.extremityLinesUs);
            setExtremityLinesOfIti1(iti, 'end', iti.extremityLinesDs);
          }
        };


        let refreshPathDrawing = () => {
          let mls;
          let iti = scope.selectedItinerary;
          if (iti == undefined) return;
          setExtremityLinesOfIti(iti);
          let coords = JSON.parse(iti.geometry).coordinates;
          //-- rmCoords: rm pour removed: coordonnée enlevée de la liste
          //-- des coordonnées à traiter, pour traitement
          //-- dans itération suivante
          let newCoords = [], rmCoords = [];
          orderSegments(coords, newCoords, rmCoords);
          let iter = 0;
          while (rmCoords.length != 0 && ++iter < 50) {
            coords = rmCoords;
            rmCoords = [];
            orderSegments(coords, newCoords, rmCoords);
          }
          if (iter >= 50) {
            //-- Cas impossible en théorie , mais sait-on jamais.
            require('toastr').warning($filter('translate')('tools.builder.fields.network.path_route_from_nodes.ordering_problem'));
          }
          newCoords = simplifySegmentsToSegment(newCoords);
          if (sameCoords(newCoords[0], scope.features.startFeature)) {
            mls = getMlsFrom(iti, newCoords, scope.route.startShift,
              scope.route.endShift);
          }
          else {
            mls = getMlsFrom(iti, newCoords, scope.route.startShift,
              scope.route.endShift);
          }
          scope.selectedItinerary.geom = mls;
          if (!scope.features.itinerary) {
            scope.showItinerary(scope.selectedItinerary);
          }
          scope.features.itinerary.setGeometry(mls);
          buildPathBuffer();
        };


        scope.selectExtLine = (startOrEnd, line) => {
          scope.route[startOrEnd + 'ExtLine'] = line;
          refreshPathDrawing();
        };


        scope.$watch('route.startShift', refreshPathDrawing);
        scope.$watch('route.endShift', refreshPathDrawing);
        scope.$watch('selectedItinerary', refreshPathDrawing);
        scope.$watch('route.showBuffer', refreshPathDrawing);


        /**
         * Fermeture de la fenêtre de travail sans sauvegarde.
         * Activé depuis croix en haut àdroite ou bouton "Annuler".
         * Appelé également depuis validation, une fois
         * le traitement de validation effectué.
         */
        scope.cancel = () => {
          SelectManager.clear();
          clearFeatures();
          resetItineraryList();
          scope.pathToolDlg.close();
          scope.dlgPopup.features.show();
          scope.map.getViewport().style.cursor = 'default';
          scope.route.start = scope.route.end = '';
          scope.foundItineraries = undefined;
          scope.selectedItinerary = undefined;
        };


        scope.ok = () => {
          let featureCollection = {features: [],
            type:'FeatureCollection',
            totalFeatures:scope.selectedItinerary.elements.length
          };
          scope.selectedItinerary.elements.forEach((element)=>{
            featureCollection.features.push(JSON.parse(element.feature));
          });
          scope.res[scope.fieldconfig.update_selection]
            = featureCollection;
          scope.res[scope.fieldconfig.res]
            = scope.selectedItinerary.elements;
          getBufferGeom().then(
            (res) => {
              if (!scope.res[scope.fieldconfig.buffer_geometry]) {
                scope.res[scope.fieldconfig.buffer_geometry]
                  = res.data;
              }
              else {
                scope.res[scope.fieldconfig.buffer_geometry].geometry
                  = res.data;
              }
              scope.cancel();
              $timeout(scope.onfinish, 100);
            }
          );
        };

      }
    };
  };
  gcelement.$inject = ['extendedNgDialog', '$filter', 'NetworkFactory',
    'gclayers', 'SelectManager', 'ogcFactory', 'FeatureTypeFactory',
    'gaJsUtils', 'GeometryFactory', '$q', '$timeout'];

  return gcelement;
});
