/**
 * math.js
 * https://github.com/josdejong/mathjs
 *
 * Math.js is an extensive math library for JavaScript and Node.js,
 * It features real and complex numbers, units, matrices, a large set of
 * mathematical functions, and a flexible expression parser.
 *
 * @version 0.9.1
 * @date    2013-06-14
 *
 * @license
 * Copyright (C) 2013 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
!function(){function e(e){return e instanceof Boolean||"boolean"==typeof e}function n(e,t){if(!(this instanceof n))throw new SyntaxError("Complex constructor must be called with the new operator");switch(arguments.length){case 0:this.re=0,this.im=0;break;case 2:if(!p(e)||!p(t))throw new TypeError("Two numbers expected in Complex constructor");this.re=e,this.im=t;break;default:if(0!=arguments.length&&2!=arguments.length)throw new SyntaxError("Two or zero arguments expected in Complex constructor")}}function t(e){if(!(this instanceof t))throw new SyntaxError("Matrix constructor must be called with the new operator");if(e instanceof t||e instanceof g)this._data=e.toArray();else if(e instanceof Array)this._data=e;else{if(null!=e)throw new TypeError("Unsupported type of data ("+J["typeof"](e)+")");this._data=[]}this._size=en.size(this._data)}function r(e,n){return en.validateIndex(n,e.length),e[n-1]}function a(e,n){return n.forEach(function(n){e=r(e,n)}),J.clone(e)}function i(e,n){var t=n[0];return t.map?t.map(function(n){return r(e,n)}):[r(e,t)]}function o(e,n){var t=n[0],a=n[1];if(t.map)return a.map?t.map(function(n){var t=r(e,n);return a.map(function(e){return r(t,e)})}):t.map(function(n){return[r(r(e,n),a)]});if(a.map){var i=r(e,t);return[a.map(function(e){return r(i,e)})]}return[[r(r(e,t),a)]]}function f(e,n,t){var a=t==n.length-1,i=n[t],o=function(i){var o=r(e,i);return a?o:f(o,n,t+1)};return i.map?i.map(o):[o(i)]}function s(e,n,t){if(en.validateIndex(n),t instanceof Array)throw new TypeError("Dimension mismatch, value expected instead of array");e[n-1]=t}function u(e,n,t,r){var a=!1;t.length>n.length&&(a=!0);for(var i=0;i<t.length;i++){var o=t[i];en.validateIndex(o),(null==n[i]||o>n[i])&&(n[i]=o,a=!0)}a&&en.resize(e,n,0);var f=n.length;t.forEach(function(n,t){f-1>t?e=e[n-1]:e[n-1]=r})}function c(e,n,t,r){var a=t[0];en.validateIndex(a),a>n[0]&&(en.resize(e,[a],0),n[0]=a),e[a-1]=r}function l(e,n,t,r){var a=t[0],i=t[1];en.validateIndex(a),en.validateIndex(i);var o=!1;a>(n[0]||0)&&(n[0]=a,o=!0),i>(n[1]||0)&&(n[1]=i,o=!0),o&&en.resize(e,n,0),e[a-1][i-1]=r}function h(e,n,t,r,a){var i=r==t.length-1,o=t[r],f=function(o,f){if(i)s(e,o,a[f]),o>(n[r]||0)&&(n[r]=o);else{var u=e[o-1];u instanceof Array||(e[o-1]=u=[u]),o>(n[r]||0)&&(n[r]=o),h(u,n,t,r+1,a[f])}};if(o.map){var u=o.size&&o.size()||o.length;if(u!=a.length)throw new RangeError("Dimensions mismatch ("+u+" != "+a.length+")");o.map(f)}else f(o,0)}function m(e){for(var n=0,t=e.length;t>n;n++){var r=e[n];r instanceof Array?m(r):void 0==r&&(e[n]=0)}}function p(e){return e instanceof Number||"number"==typeof e}function v(e){return e==Math.round(e)}function g(e,n,t){if(!(this instanceof g))throw new SyntaxError("Range constructor must be called with the new operator");if(null!=e&&!p(e))throw new TypeError("Parameter start must be a number");if(null!=t&&!p(t))throw new TypeError("Parameter end must be a number");if(null!=n&&!p(n))throw new TypeError("Parameter step must be a number");this.start=null!=e?e:0,this.end=null!=t?t:0,this.step=null!=n?n:1}function w(e,n){var t=J.type.Selector,r=Array.prototype.slice;t.prototype[e]="function"==typeof n?function(){var e=[this.value].concat(r.call(arguments,0));return new t(n.apply(this,e))}:new t(n)}function d(e){return e instanceof String||"string"==typeof e}function y(e,n){if(!(this instanceof y))throw new Error("Unit constructor must be called with the new operator");if(null!=e&&!p(e))throw new TypeError("First parameter in Unit constructor must be a number");if(null!=n&&!d(n))throw new TypeError("Second parameter in Unit constructor must be a string");if(null!=n){var t=E(n);if(!t)throw new SyntaxError('String "'+n+'" is no unit');this.unit=t.unit,this.prefix=t.prefix}else this.unit=y.UNIT_NONE,this.prefix=y.PREFIX_NONE;null!=e?(this.value=this._normalize(e),this.fixPrefix=!1):(this.value=null,this.fixPrefix=!0)}function E(e){for(var n=y.UNITS,t=0,r=n.length;r>t;t++){var a=n[t];if(en.endsWith(e,a.name)){var i=e.length-a.name.length,o=e.substring(0,i),f=a.prefixes[o];if(void 0!==f)return{unit:a,prefix:f}}}return null}function O(e,n){var t=void 0;if(2==arguments.length){var r=J["typeof"](n);t="Function "+e+"("+r+") not supported"}else if(arguments.length>2){for(var a=[],i=1;i<arguments.length;i++)a.push(J["typeof"](arguments[i]));t="Function "+e+"("+a.join(", ")+") not supported"}else t="Unsupported parameter in function "+e;return new TypeError(t)}function b(e,n,t,r){var a="Wrong number of arguments in function "+e+" ("+n+" provided, "+t+(void 0!=r?"-"+r:"")+" expected)";return new SyntaxError(a)}function x(){}function N(e){this.value=e}function M(e,n,t){this.name=e,this.fn=n,this.params=t}function A(e,n){this.name=e,this.scope=n}function S(e,n,t){if(this.object=e,this.params=n,this.paramScopes=t,this.hasContextParams=!1,n)for(var r={type:J.type.SymbolNode,properties:{name:"end"}},a=0,i=n.length;i>a;a++)if(n[a].find(r).length>0){this.hasContextParams=!0;break}}function T(e){this.nodes=e||[]}function U(){this.params=[],this.visible=[]}function z(e,n,t){this.name=e,this.expr=n,this.scope=t}function R(e,n,t,r,a){this.name=e,this.params=n,this.paramScopes=t,this.expr=r,this.scope=a,this.hasContextParams=!1;for(var i={type:J.type.SymbolNode,properties:{name:"end"}},o=0,f=n.length;f>o;o++)if(n[o].find(i).length>0){this.hasContextParams=!0;break}}function L(e,n,t,r,a){this.name=e,this.variables=n,this.scope=a,this.fn=function(){var a=n?n.length:0;if(arguments.length!=a)throw b(e,arguments.length,a);for(var i=0;a>i;i++)r.set(n[i],arguments[i]);return t.eval()},this.fn.toString=function(){return e+"("+n.join(", ")+")"}}function I(e,t){var r=t.re*t.re+t.im*t.im;return 0!=r?new n((e.re*t.re+e.im*t.im)/r,(e.im*t.re-e.re*t.im)/r):new n(0!=e.re?e.re/0:0,0!=e.im?e.im/0:0)}function q(e,n){if(n>0)return e>0?e%n:0==e?0:e-n*Math.floor(e/n);if(0==n)return e;throw new Error("Cannot calculate mod for a negative divisor")}function _(e,t){return 0==e.im?new n(e.re*t.re,e.re*t.im):0==e.re?new n(-e.im*t.im,e.im*t.re):0==t.im?new n(e.re*t.re,e.im*t.re):0==t.re?new n(-e.im*t.im,e.re*t.im):new n(e.re*t.re-e.im*t.im,e.re*t.im+e.im*t.re)}function P(e,n){var t=J.log(e),r=J.multiply(t,n);return J.exp(r)}function C(e,n){if(n){var t=Math.pow(10,n);return Math.round(e*t)/t}return Math.round(e)}function B(e){if(e instanceof Array||e instanceof t||e instanceof g){for(var n=e.valueOf(),r="[",a=n.length,i=0;a>i;i++)0!=i&&(r+=", "),r+=B(n[i]);return r+="]"}return p(e)?en.formatNumber(e):e.toString()}function G(e,n,t,r){if(t>r){if(e.length!=n.length)throw new Error("Dimensions mismatch ("+e.length+" != "+n.length+")");for(var a=[],i=0;i<e.length;i++)a[i]=G(e[i],n[i],t,r+1);return a}return e.concat(n)}function F(e,n,t){var r=J.multiply,a=J.subtract;if(1==n)return e[0][0];if(2==n)return a(r(e[0][0],e[1][1]),r(e[1][0],e[0][1]));for(var i=1,o=0,f=0;n>f&&!(o>=t);f++){for(var s=f;0==e[s][o];)if(s++,s==n&&(s=f,o++,o==t))return en.deepEqual(e,J.eye(n).valueOf())?J.round(i,6):0;if(s!=f){for(var u=0;t>u;u++){var c=e[s][u];e[s][u]=e[f][u],e[f][u]=c}i*=-1}for(var l=e[f][o],u=0;t>u;u++)e[f][u]=e[f][u]/l;i*=l;for(var h=0;n>h;h++)if(h!=f)for(var m=e[h][o],u=0;t>u;u++)e[h][u]=e[h][u]-e[f][u]*m;o++}return en.deepEqual(e,J.eye(n).valueOf())?J.round(i,6):0}function j(e,n,t){var r,a,i,o,f,s=J.add,u=J.unaryminus,c=J.multiply,l=J.divide;if(1==n){if(o=e[0][0],0==o)throw Error("Cannot calculate inverse, determinant is zero");return[[l(1,o)]]}if(2==n){var h=J.det(e);if(0==h)throw Error("Cannot calculate inverse, determinant is zero");return[[l(e[1][1],h),l(u(e[0][1]),h)],[l(u(e[1][0]),h),l(e[0][0],h)]]}var m=e.concat();for(r=0;n>r;r++)m[r]=m[r].concat();for(var p=J.eye(n).valueOf(),v=0;t>v;v++){for(r=v;n>r&&0==m[r][v];)r++;if(r==n||0==m[r][v])throw Error("Cannot calculate inverse, determinant is zero");r!=v&&(f=m[v],m[v]=m[r],m[r]=f,f=p[v],p[v]=p[r],p[r]=f);var g=m[v],w=p[v];for(r=0;n>r;r++){var d=m[r],y=p[r];if(r!=v){if(0!=d[v]){for(i=l(u(d[v]),g[v]),a=v;t>a;a++)d[a]=s(d[a],c(i,g[a]));for(a=0;t>a;a++)y[a]=s(y[a],c(i,w[a]))}}else{for(i=g[v],a=v;t>a;a++)d[a]=l(d[a],i);for(a=0;t>a;a++)y[a]=l(y[a],i)}}}return p}function V(e){if(1==e.length)return V(e[0]);for(var n=0,t=e.length;t>n;n++){var r=e[n];r instanceof Array&&(e[n]=V(r))}return e}function H(e,n){var r,a;return e instanceof Array||e instanceof g?(r=J.matrix(e),a=r.get(n),a.valueOf()):e instanceof t?e.get(n):d(e)?D(e,n):(r=J.matrix([e]),a=r.get(n),a.valueOf())}function D(e,n){var t,r;if(n=n.valueOf(),1!=n.length)throw new RangeError("Dimension mismatch ("+n.length+" != 1)");n instanceof Array&&(n=n[0]),n=n.valueOf(),n instanceof Array||(n=[n]);var a="",i=e.length;for(t=0,r=n.length;r>t;t++){var o=n[t];en.validateIndex(o,i),a+=e.charAt(o-1)}return a}function k(e,n,r){if(e instanceof Array||e instanceof g){var a=J.matrix(J.clone(e));return a.set(n,r),a.valueOf()}return e instanceof t?e.clone().set(n,r):d(e)?Y(e,n,r):(a=J.matrix([e]),a.set(n,r),a.isScalar()?a.toScalar():a.valueOf())}function Y(e,n,t){var r,a;if(n=n.valueOf(),1!=n.length)throw new RangeError("Dimension mismatch ("+n.length+" != 1)");if(n instanceof Array&&(n=n[0]),n=n.valueOf(),n instanceof Array||(n=[n]),n.length!=t.length)throw new RangeError("Dimension mismatch ("+n.length+" != "+t.length+")");var i=e.length,o=[];for(r=0;i>r;r++)o[r]=e.charAt(r);for(r=0,a=n.length;a>r;r++){var f=n[r];en.validateIndex(f),o[f-1]=t.charAt(r)}if(o.length>i)for(r=i-1,a=o.length;a>r;r++)o[r]||(o[r]=" ");return o.join("")}function W(e){for(var n=J.larger,t=e[0],r=1,a=e.length;a>r;r++){var i=e[r];n(i,t)&&(t=i)}return t}function K(e,n,t){for(var r=J.larger,a=[],i=0;t>i;i++){for(var o=e[0][i],f=1;n>f;f++){var s=e[f][i];r(s,o)&&(o=s)}a[i]=o}return a}function Z(e){for(var n=J.smaller,t=e[0],r=1,a=e.length;a>r;r++){var i=e[r];n(i,t)&&(t=i)}return t}function X(e,n,t){for(var r=J.smaller,a=[],i=0;t>i;i++){for(var o=e[0][i],f=1;n>f;f++){var s=e[f][i];r(s,o)&&(o=s)}a[i]=o}return a}function Q(e,n,t){(t.override||void 0===J[e])&&(J[e]=t.wrap&&"function"==typeof n?function(){for(var e=[],t=0,r=arguments.length;r>t;t++)e[t]=arguments[t].valueOf();return n.apply(J,e)}:n,w(e,n))}function $(e){return"function"==typeof e||p(e)||d(e)||e instanceof n||e instanceof y}var J={type:{},expr:{node:{}},options:{precision:5}},en=function(){function e(n){if(n instanceof Array){var t=n.length;if(t){var r=e(n[0]);return 0==r[0]?[0].concat(r):[t].concat(r)}return[t]}return[]}function n(e,t,r){var a,i=e.length;if(i!=t[r])throw new RangeError("Dimension mismatch ("+i+" != "+t[r]+")");if(r<t.length-1){var o=r+1;for(a=0;i>a;a++){var f=e[a];if(!(f instanceof Array))throw new RangeError("Dimension mismatch ("+(t.length-1)+" < "+t.length+")");n(e[a],t,o)}}else for(a=0;i>a;a++)if(e[a]instanceof Array)throw new RangeError("Dimension mismatch ("+(t.length+1)+" > "+t.length+")")}function r(e,n,t){if(t<n.length-1){var a=e[0];if(1!=e.length||!(a instanceof Array))throw new RangeError("Dimension mismatch ("+e.length+" > 0)");r(a,n,t+1)}else if(e.length)throw new RangeError("Dimension mismatch ("+e.length+" > 0)")}function a(e,n,t,r){if(!(e instanceof Array))throw new TypeError("Array expected");var i=e.length,o=n[t];if(i!=o){if(o>e.length)for(var f=e.length;o>f;f++)e[f]=r?J.clone(r):0;else e.length=n[t];i=e.length}if(t<n.length-1){var s=t+1;for(f=0;i>f;f++)u=e[f],u instanceof Array||(u=[u],e[f]=u),a(u,n,s,r)}else for(f=0;i>f;f++){for(var u=e[f];u instanceof Array;)u=u[0];e[f]=u}}var i={};i.formatNumber=function(e,n){if(1/0===e)return"Infinity";if(e===-1/0)return"-Infinity";if(0/0===e)return"NaN";var t=Math.abs(e);if(t>.001&&1e5>t||0==t)return i.toPrecision(e,n);var r=Math.round(Math.log(t)/Math.LN10),a=e/Math.pow(10,r);return i.toPrecision(a,n)+"e"+r},i.toPrecision=function(e,n){return e.toPrecision(n).replace(o,function(e,n,t){return e.substring(0,e.length-(n.length?0:1)-t.length)})};var o=/\.(\d*?)(0+)$/g;return i.formatArray=function(e){if(e instanceof Array){for(var n="[",t=e.length,r=0;t>r;r++)0!=r&&(n+=", "),n+=i.formatArray(e[r]);return n+="]"}return J.format(e)},i.formatArray2d=function(e){var n="[",t=i.size(e);if(2!=t.length)throw new RangeError("Array must be two dimensional (size: "+i.formatArray(t)+")");for(var r=t[0],a=t[1],o=0;r>o;o++){0!=o&&(n+="; ");for(var f=e[o],s=0;a>s;s++){0!=s&&(n+=", ");var u=f[s];void 0!=u&&(n+=J.format(u))}}return n+="]"},i.argsToArray=function(e){var n;if(0==e.length)n=[];else if(1==e.length)n=e[0],n instanceof t&&(n=n.toVector()),n instanceof g&&(n=n.valueOf()),n instanceof Array||(n=[n]);else{n=[];for(var r=0;r<e.length;r++)n[r]=e[r]}return n},i.endsWith=function(e,n){var t=e.length-n.length,r=e.length;return e.substring(t,r)===n},i.extend=function(e,n){for(var t in n)n.hasOwnProperty(t)&&(e[t]=n[t]);return e},i.deepExtend=function f(e,n){for(var t in n)n.hasOwnProperty(t)&&(n[t]&&n[t].constructor===Object?(void 0===e[t]&&(e[t]={}),e[t].constructor===Object?f(e[t],n[t]):e[t]=n[t]):e[t]=n[t]);return e},i.randomUUID=function(){var e=function(){return Math.floor(65536*Math.random()).toString(16)};return e()+e()+"-"+e()+"-"+e()+"-"+e()+"-"+e()+e()+e()},i.map=function(e,n){if(e instanceof Array||e instanceof t||e instanceof g)return e.map(function(e){return n(e)});throw new TypeError("Array expected")},i.deepMap=function s(e,n){return e instanceof Array||e instanceof t||e instanceof g?e.map(function(e){return s(e,n)}):n(e)},i.map2=function(e,n,r){var a,o,f;if(e instanceof t||n instanceof t)return new t(i.map2(e.valueOf(),n.valueOf(),r));if(e instanceof g||n instanceof g)return i.map2(e.valueOf(),n.valueOf(),r);if(e instanceof Array)if(n instanceof Array){if(e.length!=n.length)throw new RangeError("Dimension mismatch ("+e.length+" != "+n.length+")");for(a=[],o=e.length,f=0;o>f;f++)a[f]=r(e[f],n[f])}else for(a=[],o=e.length,f=0;o>f;f++)a[f]=r(e[f],n);else if(n instanceof Array)for(a=[],o=n.length,f=0;o>f;f++)a[f]=r(e,n[f]);else a=r(e,n);return a},i.deepMap2=function u(e,n,r){var a,i,o;if(e instanceof t||n instanceof t)return new t(u(e.valueOf(),n.valueOf(),r));if(e instanceof g||n instanceof g)return u(e.valueOf(),n.valueOf(),r);if(e instanceof Array)if(n instanceof Array){if(e.length!=n.length)throw new RangeError("Dimension mismatch ("+e.length+" != "+n.length+")");for(a=[],i=e.length,o=0;i>o;o++)a[o]=u(e[o],n[o],r)}else for(a=[],i=e.length,o=0;i>o;o++)a[o]=u(e[o],n,r);else if(n instanceof Array)for(a=[],i=n.length,o=0;i>o;o++)a[o]=u(e,n[o],r);else a=r(e,n);return a},i.forEach=function(e,n){if(e instanceof Array)e.forEach(n);else for(var t in e)e.hasOwnProperty(t)&&n(e[t],t,e)},i.mapObject=function(e,n){var t={};for(var r in e)e.hasOwnProperty(r)&&(t[r]=n(e[r]));return t},i.deepEqual=function(e,n){var t,r,a;if(e instanceof Array){if(!(n instanceof Array))return!1;for(r=0,a=e.length;a>r;r++)if(!i.deepEqual(e[r],n[r]))return!1;return!0}if(e instanceof Object){if(n instanceof Array||!(n instanceof Object))return!1;for(t in e)if(e.hasOwnProperty(t)&&!i.deepEqual(e[t],n[t]))return!1;for(t in n)if(n.hasOwnProperty(t)&&!i.deepEqual(e[t],n[t]))return!1;return!0}return e.valueOf()==n.valueOf()},i.size=function(n){var t=e(n);return i.validate(n,t),t},i.validate=function(e,t){var a=0==t.length;if(a){if(e instanceof Array)throw new RangeError("Dimension mismatch ("+e.length+" != 0)")}else{var o=-1!=t.indexOf(0);o?(t.forEach(function(e){if(0!=e)throw new RangeError("Invalid size, all dimensions must be either zero or non-zero (size: "+i.formatArray(t)+")")}),r(e,t,0)):n(e,t,0)}},i.validateIndex=function(e,n){if(!p(e)||!v(e))throw new TypeError("Index must be an integer (value: "+e+")");if(1>e)throw new RangeError("Index out of range ("+e+" < 1)");if(n&&e>n)throw new RangeError("Index out of range ("+e+" > "+n+")")},i.resize=function(e,n,t){if(!(n instanceof Array))throw new TypeError("Size must be an array (size is "+J["typeof"](n)+")");n.forEach(function(e){if(!p(e)||!v(e)||0>e)throw new TypeError("Invalid size, must contain positive integers (size: "+i.formatArray(n)+")")});var r=-1!=n.indexOf(0);r&&n.forEach(function(e){if(0!=e)throw new RangeError("Invalid size, all dimensions must be either zero or non-zero (size: "+i.formatArray(n)+")")}),a(e,n,0,t)},i}();J.type.Complex=n,function(){function e(){for(;" "==c||"	"==c;)a()}function t(e){return e>="0"&&"9">=e||"."==e}function r(e){return e>="0"&&"9">=e}function a(){u++,c=s.charAt(u)}function i(e){u=e,c=s.charAt(u)}function o(){var e,n="";if(e=u,"+"==c?a():"-"==c&&(n+=c,a()),!t(c))return i(e),null;if("."==c){if(n+=c,a(),!r(c))return i(e),null}else{for(;r(c);)n+=c,a();"."==c&&(n+=c,a())}for(;r(c);)n+=c,a();if("E"==c||"e"==c){if(n+=c,a(),("+"==c||"-"==c)&&(n+=c,a()),!r(c))return i(e),null;for(;r(c);)n+=c,a()}return n}function f(){var e=s.charAt(u+1);if("I"==c||"i"==c)return a(),"1";if(!("+"!=c&&"-"!=c||"I"!=e&&"i"!=e)){var n="+"==c?"1":"-1";return a(),a(),n}return null}var s,u,c;n.parse=function(t){if(s=t,u=-1,c="",!d(s))return null;a(),e();var r=o();if(r){if("I"==c||"i"==c)return a(),e(),c?null:new n(0,Number(r));e();var i=c;if("+"!=i&&"-"!=i)return e(),c?null:new n(Number(r),0);a(),e();var l=o();if(l){if("I"!=c&&"i"!=c)return null;a()}else if(l=f(),!l)return null;return"-"==i&&(l="-"==l[0]?"+"+l.substring(1):"-"+l),a(),e(),c?null:new n(Number(r),Number(l))}return(r=f())?(e(),c?null:new n(0,Number(r))):null}}(),n.prototype.clone=function(){return new n(this.re,this.im)},n.prototype.toString=function(){var e="",n=en.formatNumber(this.re,J.options.precision),t=en.formatNumber(this.im,J.options.precision);return e=0==this.im?n:0==this.re?1==this.im?"i":-1==this.im?"-i":t+"i":this.im>0?1==this.im?n+" + i":n+" + "+t+"i":-1==this.im?n+" - i":n+" - "+en.formatNumber(Math.abs(this.im),J.options.precision)+"i"},J.type.Matrix=t,t.prototype.get=function(e){var n;if(e instanceof t)n=1==e.size().length||!e.size().some(function(e){return 1!=e}),e=e.valueOf();else{if(!(e instanceof Array))throw new TypeError("Invalid index");n=!e.some(function(e){var n=J.size(e);return 0!=n.length&&n!=[1]})}if(e.length!=this._size.length)throw new RangeError("Dimension mismatch ("+e.length+" != "+this._size.length+")");if(n)switch(e.length){case 1:return r(this._data,e[0]);case 2:return r(r(this._data,e[0]),e[1]);default:return a(this._data,e)}else switch(e.length){case 1:return new t(i(this._data,e));case 2:return new t(o(this._data,e));default:return new t(f(this._data,e,0))}},t.prototype.set=function(e,n){var r;if(e instanceof t)r=1==e.size().length||!e.size().some(function(e){return 1!=e}),e=e.valueOf();else{if(!(e instanceof Array))throw new TypeError("Invalid index");r=!e.some(function(e){var n=J.size(e);return 0!=n.length&&n!=[1]})}if((n instanceof t||n instanceof g)&&(n=n.valueOf()),e.length<this._size.length)throw new RangeError("Dimension mismatch ("+e.length+" != "+this._size.length+")");if(r){if(0!=J.size(n).length)throw new TypeError("Scalar value expected");switch(e.length){case 1:c(this._data,this._size,e,n);break;case 2:l(this._data,this._size,e,n);break;default:u(this._data,this._size,e,n)}}else{var a=this._size.concat();h(this._data,a,e,0,n),en.deepEqual(this._size,a)||(m(this._data),this.resize(a))}return this},t.prototype.resize=function(e,n){en.resize(this._data,e,n),this._size=J.clone(e)},t.prototype.clone=function(){var e=new t;return e._data=J.clone(this._data),e._size=J.clone(this._size),e},t.prototype.size=function(){return this._size},t.prototype.map=function(e){var n=this,r=new t,a=[],i=function(t,r){return t instanceof Array?t.map(function(e,n){return a[r]=n+1,i(e,r+1)}):e(t,a,n)};return r._data=i(this._data,0),r._size=J.clone(this._size),r},t.prototype.forEach=function(e){var n=this,t=[],r=function(a,i){a instanceof Array?a.forEach(function(e,n){t[i]=n+1,r(e,i+1)}):e(a,t,n)};r(this._data,0)},t.prototype.toScalar=function(){for(var e=this._data;e instanceof Array&&1==e.length;)e=e[0];return e instanceof Array?null:J.clone(e)},t.prototype.isScalar=function(){return this._size.every(function(e){return 1>=e})},t.prototype.toVector=function(){var e=0,n=void 0,t=[];if(this._size.forEach(function(r,a){r>1&&(e++,n=a),t[a]=0}),0==e){var r=this.toScalar();return r?[r]:[]}if(1==e){var a=[],i=function(e){e instanceof Array?e.forEach(i):a.push(e)};return i(this._data),a}return null},t.prototype.isVector=function(){var e=0;return this._size.forEach(function(n){n>1&&e++}),1>=e},t.prototype.toArray=function(){return J.clone(this._data)},t.prototype.valueOf=function(){return this._data},t.prototype.toString=function(){return J.format(this._data)},J.type.Range=g,g.parse=function(e){if(!d(e))return null;var n=e.split(":"),t=n.map(function(e){return Number(e)}),r=t.some(function(e){return isNaN(e)});if(r)return null;switch(t.length){case 2:return new g(t[0],1,t[1]);case 3:return new g(t[0],t[1],t[2]);default:return null}},g.prototype.clone=function(){return new g(this.start,this.step,this.end)},g.prototype.size=function(){var e=0,n=Number(this.start),t=Number(this.step),r=Number(this.end),a=r-n;return J.sign(t)==J.sign(a)?e=Math.floor(a/t)+1:0==a&&(e=1),isNaN(e)&&(e=0),[e]},g.prototype.forEach=function(e){var n=Number(this.start),t=Number(this.step),r=Number(this.end),a=0;if(t>0)for(;r>=n;)e(n,a,this),n+=t,a++;else if(0>t)for(;n>=r;)e(n,a,this),n+=t,a++},g.prototype.map=function(e){var n=[];return this.forEach(function(t,r,a){n[r]=e(t,r,a)}),n},g.prototype.toMatrix=function(){return new t(this.toArray())},g.prototype.toArray=function(){var e=[];return this.forEach(function(n,t){e[t]=n}),e},g.prototype.toVector=g.prototype.toArray,g.prototype.isVector=function(){return!0},g.prototype.toScalar=function(){var e=this.toArray();return 1==e.length?e[0]:null},g.prototype.isScalar=function(){return 1==this.size()[0]},g.prototype.valueOf=function(){return this.toArray()},g.prototype.toString=function(){var e=J.format(Number(this.start));return 1!=this.step&&(e+=":"+J.format(Number(this.step))),e+=":"+J.format(Number(this.end))},J.type.Selector=function(e){if(!(this instanceof J.type.Selector))throw new SyntaxError("Selector constructor must be called with the new operator");this.value=e instanceof J.type.Selector?e.value:e||void 0},J.type.Selector.prototype={done:function(){return this.value},get:function(e){var n=this.value;if(!n)throw Error("Selector value is undefined");return new J.type.Selector(J.subset(n,e))},set:function(e,n){var t=this.value;if(!t)throw Error("Selector value is undefined");return new J.type.Selector(J.subset(t,e,n))},valueOf:function(){return this.value},toString:function(){return J.format(this.value)}},J.type.Unit=y,function(){function e(){for(;" "==u||"	"==u;)r()}function n(e){return e>="0"&&"9">=e||"."==e}function t(e){return e>="0"&&"9">=e}function r(){s++,u=f.charAt(s)}function a(e){s=e,u=f.charAt(s)}function i(){var e,i="";if(e=s,"+"==u?r():"-"==u&&(i+=u,r()),!n(u))return a(e),null;if("."==u){if(i+=u,r(),!t(u))return a(e),null}else{for(;t(u);)i+=u,r();"."==u&&(i+=u,r())}for(;t(u);)i+=u,r();if("E"==u||"e"==u){if(i+=u,r(),("+"==u||"-"==u)&&(i+=u,r()),!t(u))return a(e),null;for(;t(u);)i+=u,r()}return i}function o(){var n="";for(e();u&&" "!=u&&"	"!=u;)n+=u,r();return n||null}var f,s,u;y.parse=function(n){if(f=n,s=-1,u="",!d(f))return null;r(),e();var t,a=i();return a?(t=o(),r(),e(),u?null:a&&t?new y(Number(a),t):null):(t=o(),r(),e(),u?null:new y(null,t))}}(),y.prototype.clone=function(){var e=new y;for(var n in this)this.hasOwnProperty(n)&&(e[n]=this[n]);return e},y.prototype._normalize=function(e){return(e+this.unit.offset)*this.unit.value*this.prefix.value},y.prototype._unnormalize=function(e,n){return void 0==n?e/this.unit.value/this.prefix.value-this.unit.offset:e/this.unit.value/n-this.unit.offset},y.isPlainUnit=function(e){return null!=E(e)},y.prototype.hasBase=function(e){return void 0===this.unit.base?void 0===e:this.unit.base===e},y.prototype.equalBase=function(e){return this.unit.base===e.unit.base},y.prototype.equals=function(e){return this.equalBase(e)&&this.value==e.value},y.prototype["in"]=function(e){var n;if(d(e)){if(n=new y(null,e),!this.equalBase(n))throw new Error("Units do not match");return n.value=this.value,n}if(e instanceof y){if(!this.equalBase(e))throw new Error("Units do not match");if(null!=e.value)throw new Error("Cannot convert to a unit with a value");if(null==e.unit)throw new Error("Unit expected on the right hand side of function in");return n=e.clone(),n.value=this.value,n.fixPrefix=!0,n}throw new Error("String or Unit expected as parameter")},y.prototype.toNumber=function(e){var n=this["in"](e),t=this.fixPrefix?n._bestPrefix():n.prefix;return n._unnormalize(n.value,t.value)},y.prototype.toString=function(){var e,n;if(this.fixPrefix)e=this._unnormalize(this.value),n=null!=this.value?en.formatNumber(e,J.options.precision)+" ":"",n+=this.prefix.name+this.unit.name;else{var t=this._bestPrefix();e=this._unnormalize(this.value,t.value),n=null!=this.value?en.formatNumber(e,J.options.precision)+" ":"",n+=t.name+this.unit.name}return n},y.prototype._bestPrefix=function(){var e=Math.abs(this.value/this.unit.value),n=y.PREFIX_NONE,t=Math.abs(Math.log(e/n.value)/Math.LN10-1.2),r=this.unit.prefixes;for(var a in r)if(r.hasOwnProperty(a)){var i=r[a];if(i.scientific){var o=Math.abs(Math.log(e/i.value)/Math.LN10-1.2);t>o&&(n=i,t=o)}}return n},y.PREFIXES={NONE:{"":{name:"",value:1,scientific:!0}},SHORT:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:10,scientific:!1},h:{name:"h",value:100,scientific:!1},k:{name:"k",value:1e3,scientific:!0},M:{name:"M",value:1e6,scientific:!0},G:{name:"G",value:1e9,scientific:!0},T:{name:"T",value:1e12,scientific:!0},P:{name:"P",value:1e15,scientific:!0},E:{name:"E",value:1e18,scientific:!0},Z:{name:"Z",value:1e21,scientific:!0},Y:{name:"Y",value:1e24,scientific:!0},d:{name:"d",value:.1,scientific:!1},c:{name:"c",value:.01,scientific:!1},m:{name:"m",value:.001,scientific:!0},u:{name:"u",value:1e-6,scientific:!0},n:{name:"n",value:1e-9,scientific:!0},p:{name:"p",value:1e-12,scientific:!0},f:{name:"f",value:1e-15,scientific:!0},a:{name:"a",value:1e-18,scientific:!0},z:{name:"z",value:1e-21,scientific:!0},y:{name:"y",value:1e-24,scientific:!0}},LONG:{"":{name:"",value:1,scientific:!0},deca:{name:"deca",value:10,scientific:!1},hecto:{name:"hecto",value:100,scientific:!1},kilo:{name:"kilo",value:1e3,scientific:!0},mega:{name:"mega",value:1e6,scientific:!0},giga:{name:"giga",value:1e9,scientific:!0},tera:{name:"tera",value:1e12,scientific:!0},peta:{name:"peta",value:1e15,scientific:!0},exa:{name:"exa",value:1e18,scientific:!0},zetta:{name:"zetta",value:1e21,scientific:!0},yotta:{name:"yotta",value:1e24,scientific:!0},deci:{name:"deci",value:.1,scientific:!1},centi:{name:"centi",value:.01,scientific:!1},milli:{name:"milli",value:.001,scientific:!0},micro:{name:"micro",value:1e-6,scientific:!0},nano:{name:"nano",value:1e-9,scientific:!0},pico:{name:"pico",value:1e-12,scientific:!0},femto:{name:"femto",value:1e-15,scientific:!0},atto:{name:"atto",value:1e-18,scientific:!0},zepto:{name:"zepto",value:1e-21,scientific:!0},yocto:{name:"yocto",value:1e-24,scientific:!0}},BINARY_SHORT:{"":{name:"",value:1,scientific:!0},k:{name:"k",value:1024,scientific:!0},M:{name:"M",value:Math.pow(1024,2),scientific:!0},G:{name:"G",value:Math.pow(1024,3),scientific:!0},T:{name:"T",value:Math.pow(1024,4),scientific:!0},P:{name:"P",value:Math.pow(1024,5),scientific:!0},E:{name:"E",value:Math.pow(1024,6),scientific:!0},Z:{name:"Z",value:Math.pow(1024,7),scientific:!0},Y:{name:"Y",value:Math.pow(1024,8),scientific:!0},Ki:{name:"Ki",value:1024,scientific:!0},Mi:{name:"Mi",value:Math.pow(1024,2),scientific:!0},Gi:{name:"Gi",value:Math.pow(1024,3),scientific:!0},Ti:{name:"Ti",value:Math.pow(1024,4),scientific:!0},Pi:{name:"Pi",value:Math.pow(1024,5),scientific:!0},Ei:{name:"Ei",value:Math.pow(1024,6),scientific:!0},Zi:{name:"Zi",value:Math.pow(1024,7),scientific:!0},Yi:{name:"Yi",value:Math.pow(1024,8),scientific:!0}},BINARY_LONG:{"":{name:"",value:1,scientific:!0},kilo:{name:"kilo",value:1024,scientific:!0},mega:{name:"mega",value:Math.pow(1024,2),scientific:!0},giga:{name:"giga",value:Math.pow(1024,3),scientific:!0},tera:{name:"tera",value:Math.pow(1024,4),scientific:!0},peta:{name:"peta",value:Math.pow(1024,5),scientific:!0},exa:{name:"exa",value:Math.pow(1024,6),scientific:!0},zetta:{name:"zetta",value:Math.pow(1024,7),scientific:!0},yotta:{name:"yotta",value:Math.pow(1024,8),scientific:!0},kibi:{name:"kibi",value:1024,scientific:!0},mebi:{name:"mebi",value:Math.pow(1024,2),scientific:!0},gibi:{name:"gibi",value:Math.pow(1024,3),scientific:!0},tebi:{name:"tebi",value:Math.pow(1024,4),scientific:!0},pebi:{name:"pebi",value:Math.pow(1024,5),scientific:!0},exi:{name:"exi",value:Math.pow(1024,6),scientific:!0},zebi:{name:"zebi",value:Math.pow(1024,7),scientific:!0},yobi:{name:"yobi",value:Math.pow(1024,8),scientific:!0}}},y.PREFIX_NONE={name:"",value:1,scientific:!0},y.BASE_UNITS={NONE:{},LENGTH:{},MASS:{},TIME:{},CURRENT:{},TEMPERATURE:{},LUMINOUS_INTENSITY:{},AMOUNT_OF_SUBSTANCE:{},FORCE:{},SURFACE:{},VOLUME:{},ANGLE:{},BIT:{}};var nn=y.BASE_UNITS,tn=y.PREFIXES;y.BASE_UNIT_NONE={},y.UNIT_NONE={name:"",base:y.BASE_UNIT_NONE,value:1,offset:0},y.UNITS=[{name:"meter",base:nn.LENGTH,prefixes:tn.LONG,value:1,offset:0},{name:"inch",base:nn.LENGTH,prefixes:tn.NONE,value:.0254,offset:0},{name:"foot",base:nn.LENGTH,prefixes:tn.NONE,value:.3048,offset:0},{name:"yard",base:nn.LENGTH,prefixes:tn.NONE,value:.9144,offset:0},{name:"mile",base:nn.LENGTH,prefixes:tn.NONE,value:1609.344,offset:0},{name:"link",base:nn.LENGTH,prefixes:tn.NONE,value:.201168,offset:0},{name:"rod",base:nn.LENGTH,prefixes:tn.NONE,value:5.02921,offset:0},{name:"chain",base:nn.LENGTH,prefixes:tn.NONE,value:20.1168,offset:0},{name:"angstrom",base:nn.LENGTH,prefixes:tn.NONE,value:1e-10,offset:0},{name:"m",base:nn.LENGTH,prefixes:tn.SHORT,value:1,offset:0},{name:"ft",base:nn.LENGTH,prefixes:tn.NONE,value:.3048,offset:0},{name:"yd",base:nn.LENGTH,prefixes:tn.NONE,value:.9144,offset:0},{name:"mi",base:nn.LENGTH,prefixes:tn.NONE,value:1609.344,offset:0},{name:"li",base:nn.LENGTH,prefixes:tn.NONE,value:.201168,offset:0},{name:"rd",base:nn.LENGTH,prefixes:tn.NONE,value:5.02921,offset:0},{name:"ch",base:nn.LENGTH,prefixes:tn.NONE,value:20.1168,offset:0},{name:"mil",base:nn.LENGTH,prefixes:tn.NONE,value:254e-7,offset:0},{name:"m2",base:nn.SURFACE,prefixes:tn.SHORT,value:1,offset:0},{name:"sqin",base:nn.SURFACE,prefixes:tn.NONE,value:64516e-8,offset:0},{name:"sqft",base:nn.SURFACE,prefixes:tn.NONE,value:.09290304,offset:0},{name:"sqyd",base:nn.SURFACE,prefixes:tn.NONE,value:.83612736,offset:0},{name:"sqmi",base:nn.SURFACE,prefixes:tn.NONE,value:2589988.110336,offset:0},{name:"sqrd",base:nn.SURFACE,prefixes:tn.NONE,value:25.29295,offset:0},{name:"sqch",base:nn.SURFACE,prefixes:tn.NONE,value:404.6873,offset:0},{name:"sqmil",base:nn.SURFACE,prefixes:tn.NONE,value:6.4516e-10,offset:0},{name:"m3",base:nn.VOLUME,prefixes:tn.SHORT,value:1,offset:0},{name:"L",base:nn.VOLUME,prefixes:tn.SHORT,value:.001,offset:0},{name:"litre",base:nn.VOLUME,prefixes:tn.LONG,value:.001,offset:0},{name:"cuin",base:nn.VOLUME,prefixes:tn.NONE,value:16387064e-12,offset:0},{name:"cuft",base:nn.VOLUME,prefixes:tn.NONE,value:.028316846592,offset:0},{name:"cuyd",base:nn.VOLUME,prefixes:tn.NONE,value:.764554857984,offset:0},{name:"teaspoon",base:nn.VOLUME,prefixes:tn.NONE,value:5e-6,offset:0},{name:"tablespoon",base:nn.VOLUME,prefixes:tn.NONE,value:15e-6,offset:0},{name:"minim",base:nn.VOLUME,prefixes:tn.NONE,value:6.161152e-8,offset:0},{name:"fluiddram",base:nn.VOLUME,prefixes:tn.NONE,value:36966911e-13,offset:0},{name:"fluidounce",base:nn.VOLUME,prefixes:tn.NONE,value:2957353e-11,offset:0},{name:"gill",base:nn.VOLUME,prefixes:tn.NONE,value:.0001182941,offset:0},{name:"cup",base:nn.VOLUME,prefixes:tn.NONE,value:.0002365882,offset:0},{name:"pint",base:nn.VOLUME,prefixes:tn.NONE,value:.0004731765,offset:0},{name:"quart",base:nn.VOLUME,prefixes:tn.NONE,value:.0009463529,offset:0},{name:"gallon",base:nn.VOLUME,prefixes:tn.NONE,value:.003785412,offset:0},{name:"beerbarrel",base:nn.VOLUME,prefixes:tn.NONE,value:.1173478,offset:0},{name:"oilbarrel",base:nn.VOLUME,prefixes:tn.NONE,value:.1589873,offset:0},{name:"hogshead",base:nn.VOLUME,prefixes:tn.NONE,value:.238481,offset:0},{name:"fldr",base:nn.VOLUME,prefixes:tn.NONE,value:36966911e-13,offset:0},{name:"floz",base:nn.VOLUME,prefixes:tn.NONE,value:2957353e-11,offset:0},{name:"gi",base:nn.VOLUME,prefixes:tn.NONE,value:.0001182941,offset:0},{name:"cp",base:nn.VOLUME,prefixes:tn.NONE,value:.0002365882,offset:0},{name:"pt",base:nn.VOLUME,prefixes:tn.NONE,value:.0004731765,offset:0},{name:"qt",base:nn.VOLUME,prefixes:tn.NONE,value:.0009463529,offset:0},{name:"gal",base:nn.VOLUME,prefixes:tn.NONE,value:.003785412,offset:0},{name:"bbl",base:nn.VOLUME,prefixes:tn.NONE,value:.1173478,offset:0},{name:"obl",base:nn.VOLUME,prefixes:tn.NONE,value:.1589873,offset:0},{name:"g",base:nn.MASS,prefixes:tn.SHORT,value:.001,offset:0},{name:"gram",base:nn.MASS,prefixes:tn.LONG,value:.001,offset:0},{name:"ton",base:nn.MASS,prefixes:tn.SHORT,value:907.18474,offset:0},{name:"tonne",base:nn.MASS,prefixes:tn.SHORT,value:1e3,offset:0},{name:"grain",base:nn.MASS,prefixes:tn.NONE,value:6479891e-11,offset:0},{name:"dram",base:nn.MASS,prefixes:tn.NONE,value:.0017718451953125,offset:0},{name:"ounce",base:nn.MASS,prefixes:tn.NONE,value:.028349523125,offset:0},{name:"poundmass",base:nn.MASS,prefixes:tn.NONE,value:.45359237,offset:0},{name:"hundredweight",base:nn.MASS,prefixes:tn.NONE,value:45.359237,offset:0},{name:"stick",base:nn.MASS,prefixes:tn.NONE,value:.115,offset:0},{name:"gr",base:nn.MASS,prefixes:tn.NONE,value:6479891e-11,offset:0},{name:"dr",base:nn.MASS,prefixes:tn.NONE,value:.0017718451953125,offset:0},{name:"oz",base:nn.MASS,prefixes:tn.NONE,value:.028349523125,offset:0},{name:"lbm",base:nn.MASS,prefixes:tn.NONE,value:.45359237,offset:0},{name:"cwt",base:nn.MASS,prefixes:tn.NONE,value:45.359237,offset:0},{name:"s",base:nn.TIME,prefixes:tn.SHORT,value:1,offset:0},{name:"min",base:nn.TIME,prefixes:tn.NONE,value:60,offset:0},{name:"h",base:nn.TIME,prefixes:tn.NONE,value:3600,offset:0},{name:"seconds",base:nn.TIME,prefixes:tn.LONG,value:1,offset:0},{name:"second",base:nn.TIME,prefixes:tn.LONG,value:1,offset:0},{name:"sec",base:nn.TIME,prefixes:tn.LONG,value:1,offset:0},{name:"minutes",base:nn.TIME,prefixes:tn.NONE,value:60,offset:0},{name:"minute",base:nn.TIME,prefixes:tn.NONE,value:60,offset:0},{name:"hours",base:nn.TIME,prefixes:tn.NONE,value:3600,offset:0},{name:"hour",base:nn.TIME,prefixes:tn.NONE,value:3600,offset:0},{name:"day",base:nn.TIME,prefixes:tn.NONE,value:86400,offset:0},{name:"days",base:nn.TIME,prefixes:tn.NONE,value:86400,offset:0},{name:"rad",base:nn.ANGLE,prefixes:tn.NONE,value:1,offset:0},{name:"deg",base:nn.ANGLE,prefixes:tn.NONE,value:.017453292519943295,offset:0},{name:"grad",base:nn.ANGLE,prefixes:tn.NONE,value:.015707963267948967,offset:0},{name:"cycle",base:nn.ANGLE,prefixes:tn.NONE,value:6.283185307179586,offset:0},{name:"A",base:nn.CURRENT,prefixes:tn.SHORT,value:1,offset:0},{name:"ampere",base:nn.CURRENT,prefixes:tn.LONG,value:1,offset:0},{name:"K",base:nn.TEMPERATURE,prefixes:tn.NONE,value:1,offset:0},{name:"degC",base:nn.TEMPERATURE,prefixes:tn.NONE,value:1,offset:273.15},{name:"degF",base:nn.TEMPERATURE,prefixes:tn.NONE,value:1/1.8,offset:459.67},{name:"degR",base:nn.TEMPERATURE,prefixes:tn.NONE,value:1/1.8,offset:0},{name:"kelvin",base:nn.TEMPERATURE,prefixes:tn.NONE,value:1,offset:0},{name:"celsius",base:nn.TEMPERATURE,prefixes:tn.NONE,value:1,offset:273.15},{name:"fahrenheit",base:nn.TEMPERATURE,prefixes:tn.NONE,value:1/1.8,offset:459.67},{name:"rankine",base:nn.TEMPERATURE,prefixes:tn.NONE,value:1/1.8,offset:0},{name:"mol",base:nn.AMOUNT_OF_SUBSTANCE,prefixes:tn.NONE,value:1,offset:0},{name:"mole",base:nn.AMOUNT_OF_SUBSTANCE,prefixes:tn.NONE,value:1,offset:0},{name:"cd",base:nn.LUMINOUS_INTENSITY,prefixes:tn.NONE,value:1,offset:0},{name:"candela",base:nn.LUMINOUS_INTENSITY,prefixes:tn.NONE,value:1,offset:0},{name:"N",base:nn.FORCE,prefixes:tn.SHORT,value:1,offset:0},{name:"newton",base:nn.FORCE,prefixes:tn.LONG,value:1,offset:0},{name:"lbf",base:nn.FORCE,prefixes:tn.NONE,value:4.4482216152605,offset:0},{name:"poundforce",base:nn.FORCE,prefixes:tn.NONE,value:4.4482216152605,offset:0},{name:"b",base:nn.BIT,prefixes:tn.BINARY_SHORT,value:1,offset:0},{name:"bits",base:nn.BIT,prefixes:tn.BINARY_LONG,value:1,offset:0},{name:"B",base:nn.BIT,prefixes:tn.BINARY_SHORT,value:8,offset:0},{name:"bytes",base:nn.BIT,prefixes:tn.BINARY_LONG,value:8,offset:0}],J.E=Math.E,J.LN2=Math.LN2,J.LN10=Math.LN10,J.LOG2E=Math.LOG2E,J.LOG10E=Math.LOG10E,J.PI=Math.PI,J.SQRT1_2=Math.SQRT1_2,J.SQRT2=Math.SQRT2,J.I=new n(0,1),J.Infinity=1/0,J.NaN=0/0,J.pi=J.PI,J.e=J.E,J.i=J.I,J.expr.node.Node=x,x.prototype.eval=function(){throw new Error("Cannot evaluate a Node interface")
},x.prototype.find=function(e){return this.match(e)?[this]:[]},x.prototype.match=function(e){var n=!0;if(e&&(!e.type||this instanceof e.type||(n=!1),n&&e.properties))for(var t in e.properties)if(e.properties.hasOwnProperty(t)&&this[t]!=e.properties[t]){n=!1;break}return n},x.prototype.toString=function(){return""},N.prototype=new x,J.expr.node.ConstantNode=N,N.prototype.eval=function(){return this.value},N.prototype.toString=function(){return J.format(this.value||null)},M.prototype=new x,J.expr.node.OperatorNode=M,M.prototype.eval=function(){return this.fn.apply(this,this.params.map(function(e){return e.eval()}))},M.prototype.find=function(e){var n=[];this.match(e)&&n.push(this);var t=this.params;if(t)for(var r=0,a=t.length;a>r;r++)n=n.concat(t[r].find(e));return n},M.prototype.toString=function(){var e=this.params;if(this.fn===J.unaryminus)return"-"+e[0].toString();switch(e.length){case 1:return e[0].toString()+this.name;case 2:var n=e[0].toString();e[0]instanceof M&&(n="("+n+")");var t=e[1].toString();return e[1]instanceof M&&(t="("+t+")"),n+" "+this.name+" "+t;default:return this.name+"("+this.params.join(", ")+")"}},A.prototype=new x,J.expr.node.SymbolNode=A,A.prototype.eval=function(){var e=this.scope.get(this.name);if(void 0===e)throw new Error("Undefined symbol "+this.name);return e},A.prototype.toString=function(){return this.name},S.prototype=new x,J.expr.node.ParamsNode=S,S.prototype.eval=function(){var e,n,t=this.object;if(void 0==t)throw new Error("Node undefined");var r=t.eval();if(this.hasContextParams){var a,i=this.paramScopes;if(a=r.size?r.size():void 0!==r.length?[r.length]:[],i&&a)for(e=0,n=this.params.length;n>e;e++){var o=i[e];o&&o.set("end",a[e])}}var f=this.params,s=[];for(e=0,n=this.params.length;n>e;e++)s[e]=f[e].eval();return"function"==typeof r?r.apply(this,s):J.subset(r,s)},S.prototype.find=function(e){var n=[];this.match(e)&&n.push(this),this.object&&(n=n.concat(this.object.find(e)));var t=this.params;if(t)for(var r=0,a=t.length;a>r;r++)n=n.concat(t[r].find(e));return n},S.prototype.toString=function(){var e=this.object?this.object.toString():"";return this.params&&(e+="("+this.params.join(", ")+")"),e},T.prototype=new x,J.expr.node.MatrixNode=T,function(){function e(e){for(var n=[],r=e.length,a=0;r>a;a++){for(var i=e[a],o=i.length,f=null,s=null,u=0;o>u;u++){var c,l=J.clone(i[u]);if(l instanceof t){if(c=l.size(),l=l.valueOf(),1==c.length)l=[l],c=[1,c[0]];else if(c.length>2)throw new Error("Cannot merge a multi dimensional matrix")}else l instanceof g?(l=[l.valueOf()],c=[1,l[0].length]):l instanceof Array?(c=[1,l.length],l=[l]):(c=[1,1],l=[[l]]);if(null==f)f=l,s=c[0];else{if(c[0]!=s)throw new Error("Dimension mismatch ("+c[0]+" != "+s+")");for(var h=0;s>h;h++)f[h]=f[h].concat(l[h])}}n=n.concat(f)}return n}T.prototype.eval=function(){for(var n=this.nodes,r=[],a=!1,i=0,o=n.length;o>i;i++){for(var f=n[i],s=[],u=0,c=f.length;c>u;u++){var l=f[u].eval();(l instanceof t||l instanceof g||l instanceof Array)&&(a=!0),s[u]=l}r[i]=s}return a&&(r=e(r)),new t(r)},T.prototype.find=function(e){var n=[];this.match(e)&&n.push(this);for(var t=this.nodes,r=0,a=t.length;a>r;r++)for(var i=t[r],o=0,f=i.length;f>o;o++)n=n.concat(i[o].find(e));return n},T.prototype.toString=function(){return en.formatArray(this.nodes)}}(),U.prototype=new x,J.expr.node.BlockNode=U,U.prototype.add=function(e,n){var t=this.params.length;this.params[t]=e,this.visible[t]=void 0!=n?n:!0},U.prototype.eval=function(){for(var e=[],n=0,t=this.params.length;t>n;n++){var r=this.params[n].eval();this.visible[n]&&e.push(r)}return e},U.prototype.find=function(e){var n=[];this.match(e)&&n.push(this);var t=this.params;if(t)for(var r=0,a=t.length;a>r;r++)n=n.concat(t[r].find(e));return n},U.prototype.toString=function(){for(var e=[],n=0,t=this.params.length;t>n;n++)this.visible[n]&&e.push("\n  "+this.params[n].toString());return"["+e.join(",")+"\n]"},z.prototype=new x,J.expr.node.AssignmentNode=z,z.prototype.eval=function(){if(void 0===this.expr)throw new Error("Undefined symbol "+this.name);var e=this.expr.eval();return this.scope.set(this.name,e),e},z.prototype.find=function(e){var n=[];return this.match(e)&&n.push(this),this.expr&&(n=n.concat(this.expr.find(e))),n},z.prototype.toString=function(){return this.name+" = "+this.expr.toString()},R.prototype=new x,J.expr.node.UpdateNode=R,R.prototype.eval=function(){if(void 0===this.expr)throw new Error("Undefined symbol "+this.name);var e;this.params;var n=this.scope.get(this.name);if(void 0==n)throw new Error("Undefined symbol "+this.name);if(this.hasContextParams){var t,r=this.paramScopes;if(t=n.size?n.size():void 0!==n.length?[n.length]:[],r&&t)for(var a=0,i=this.params.length;i>a;a++){var o=r[a];o&&o.set("end",t[a])}}var f=[];this.params.forEach(function(e){f.push(e.eval())});var s=this.expr.eval();return e=J.subset(n,f,s),this.scope.set(this.name,e),e},R.prototype.find=function(e){var n=[];this.match(e)&&n.push(this);var t=this.params;if(t)for(var r=0,a=t.length;a>r;r++)n=n.concat(t[r].find(e));return this.expr&&(n=n.concat(this.expr.find(e))),n},R.prototype.toString=function(){var e="";return e+=this.name,this.params&&this.params.length&&(e+="("+this.params.join(", ")+")"),e+=" = ",e+=this.expr.toString()},L.prototype=new x,J.expr.node.FunctionNode=L,L.prototype.eval=function(){return this.scope.set(this.name,this.fn),this.fn},L.prototype.find=function(e){var n=[];return this.match(e)&&n.push(this),this.expr&&(n=n.concat(this.expr.find(e))),n},L.prototype.toString=function(){return this.fn.toString()},J.expr.Scope=function(){if(this.parentScope=null,this.subScopes=null,this.symbols={},this.cache={},arguments.length>0){var e=arguments[0];e instanceof J.expr.Scope?this.parentScope=e:e instanceof Object&&(this.symbols=e)}if(arguments.length>1){var n=arguments[1];n instanceof Object&&(this.symbols=n)}},J.expr.Scope.prototype={createSubScope:function(){var e=new J.expr.Scope(this);return this.subScopes||(this.subScopes=[]),this.subScopes.push(e),e},get:function(e){var n;if(n=this.symbols[e],void 0!==n)return n;var t=this.cache[e];if(t)return t[e];for(var r=this.parentScope;r;){if(n=r.symbols[e],void 0!==n)return this.cache[e]=r.symbols,n;r=r.parentScope}return n=J[e],void 0!==n?(this.cache[e]=J,n):y.isPlainUnit(e)?(n=new y(null,e),this.cache[e]={},this.cache[e][e]=n,n):void 0},has:function(e){return void 0!==this.symbols[e]},set:function(e,n){return this.symbols[e]=n},remove:function(e){delete this.symbols[e]},clear:function(){var e=this.symbols;for(var n in e)e.hasOwnProperty(n)&&delete e[n];if(this.subScopes)for(var t=this.subScopes,r=0,a=t.length;a>r;r++)t[r].clear();this.clearCache()},clearCache:function(){this.cache={}}},J.expr.Parser=function(){if(!(this instanceof J.expr.Parser))throw new SyntaxError("Parser constructor must be called with the new operator");this.scope=new J.expr.Scope},J.expr.Parser.prototype.parse=function(e){return J.parse(e,this.scope)},J.expr.Parser.prototype.eval=function(e){var n=J.parse(e,this.scope);return n.eval()},J.expr.Parser.prototype.get=function(e){return this.scope.get(e)},J.expr.Parser.prototype.set=function(e,n){this.scope.set(e,n)},J.expr.Parser.prototype.remove=function(e){this.scope.remove(e)},J.expr.Parser.prototype.clear=function(){this.scope.clear()},J.abs=function(e){if(1!=arguments.length)throw b("abs",arguments.length,1);if(p(e))return Math.abs(e);if(e instanceof n)return Math.sqrt(e.re*e.re+e.im*e.im);if(e instanceof Array||e instanceof t)return en.map(e,J.abs);if(e.valueOf()!==e)return J.abs(e.valueOf());throw O("abs",e)},J.add=function(e,r){if(2!=arguments.length)throw b("add",arguments.length,2);if(p(e)){if(p(r))return e+r;if(r instanceof n)return new n(e+r.re,r.im)}else if(e instanceof n){if(p(r))return new n(e.re+r,e.im);if(r instanceof n)return new n(e.re+r.re,e.im+r.im)}else if(e instanceof y&&r instanceof y){if(!e.equalBase(r))throw new Error("Units do not match");if(null==e.value)throw new Error("Unit on left hand side of operator + has an undefined value");if(null==r.value)throw new Error("Unit on right hand side of operator + has an undefined value");var a=e.clone();return a.value+=r.value,a.fixPrefix=!1,a}if(d(e)||d(r))return e+r;if(e instanceof Array||e instanceof t||r instanceof Array||r instanceof t)return en.map2(e,r,J.add);if(e.valueOf()!==e||r.valueOf()!==r)return J.add(e.valueOf(),r.valueOf());throw O("add",e,r)},J.ceil=function(e){if(1!=arguments.length)throw b("ceil",arguments.length,1);if(p(e))return Math.ceil(e);if(e instanceof n)return new n(Math.ceil(e.re),Math.ceil(e.im));if(e instanceof Array||e instanceof t)return en.map(e,J.ceil);if(e.valueOf()!==e)return J.ceil(e.valueOf());throw O("ceil",e)},J.cube=function(e){if(1!=arguments.length)throw b("cube",arguments.length,1);if(p(e))return e*e*e;if(e instanceof n)return J.multiply(J.multiply(e,e),e);if(e instanceof Array||e instanceof t)return en.map(e,J.cube);if(e.valueOf()!==e)return J.cube(e.valueOf());throw O("cube",e)},J.divide=function(e,r){if(2!=arguments.length)throw b("divide",arguments.length,2);if(p(e)){if(p(r))return e/r;if(r instanceof n)return I(new n(e,0),r)}if(e instanceof n){if(p(r))return I(e,new n(r,0));if(r instanceof n)return I(e,r)}if(e instanceof y&&p(r)){var a=e.clone();return a.value/=r,a}if(e instanceof Array||e instanceof t)return r instanceof Array||r instanceof t?J.multiply(e,J.inv(r)):en.map2(e,r,J.divide);if(r instanceof Array||r instanceof t)return J.multiply(e,J.inv(r));if(e.valueOf()!==e||r.valueOf()!==r)return J.divide(e.valueOf(),r.valueOf());throw O("divide",e,r)},J.edivide=function(e,n){if(2!=arguments.length)throw b("edivide",arguments.length,2);return en.deepMap2(e,n,J.divide)},J.emultiply=function(e,n){if(2!=arguments.length)throw b("emultiply",arguments.length,2);return en.deepMap2(e,n,J.multiply)},J.epow=function(e,n){if(2!=arguments.length)throw b("epow",arguments.length,2);return en.deepMap2(e,n,J.pow)},J.equal=function an(e,r){if(2!=arguments.length)throw b("equal",arguments.length,2);if(p(e)){if(p(r))return e==r;if(r instanceof n)return e==r.re&&0==r.im}if(e instanceof n){if(p(r))return e.re==r&&0==e.im;if(r instanceof n)return e.re==r.re&&e.im==r.im}if(e instanceof y&&r instanceof y){if(!e.equalBase(r))throw new Error("Cannot compare units with different base");return e.value==r.value}if(d(e)||d(r))return e==r;if(e instanceof Array||e instanceof t||r instanceof Array||r instanceof t)return en.map2(e,r,J.equal);if(e.valueOf()!==e||r.valueOf()!==r)return an(e.valueOf(),r.valueOf());throw O("equal",e,r)},J.exp=function(e){if(1!=arguments.length)throw b("exp",arguments.length,1);if(p(e))return Math.exp(e);if(e instanceof n){var r=Math.exp(e.re);return new n(r*Math.cos(e.im),r*Math.sin(e.im))}if(e instanceof Array||e instanceof t)return en.map(e,J.exp);if(e.valueOf()!==e)return J.exp(e.valueOf());throw O("exp",e)},J.fix=function(e){if(1!=arguments.length)throw b("fix",arguments.length,1);if(p(e))return e>0?Math.floor(e):Math.ceil(e);if(e instanceof n)return new n(e.re>0?Math.floor(e.re):Math.ceil(e.re),e.im>0?Math.floor(e.im):Math.ceil(e.im));if(e instanceof Array||e instanceof t)return en.map(e,J.fix);if(e.valueOf()!==e)return J.fix(e.valueOf());throw O("fix",e)},J.floor=function(e){if(1!=arguments.length)throw b("floor",arguments.length,1);if(p(e))return Math.floor(e);if(e instanceof n)return new n(Math.floor(e.re),Math.floor(e.im));if(e instanceof Array||e instanceof t)return en.map(e,J.floor);if(e.valueOf()!==e)return J.floor(e.valueOf());throw O("floor",e)},J.gcd=function(){var e,n=arguments[0],r=arguments[1];if(2==arguments.length){if(p(n)&&p(r)){if(!v(n)||!v(r))throw new Error("Parameters in function gcd must be integer numbers");for(;0!=r;)e=r,r=n%e,n=e;return Math.abs(n)}if(n instanceof Array||n instanceof t||r instanceof Array||r instanceof t)return en.map2(n,r,J.gcd);if(n.valueOf()!==n||r.valueOf()!==r)return J.gcd(n.valueOf(),r.valueOf());throw O("gcd",n,r)}if(arguments.length>2){for(var a=1;a<arguments.length;a++)n=J.gcd(n,arguments[a]);return n}throw new SyntaxError("Function gcd expects two or more arguments")},J.larger=function(e,r){if(2!=arguments.length)throw b("larger",arguments.length,2);if(p(e)){if(p(r))return e>r;if(r instanceof n)return e>J.abs(r)}if(e instanceof n){if(p(r))return J.abs(e)>r;if(r instanceof n)return J.abs(e)>J.abs(r)}if(e instanceof y&&r instanceof y){if(!e.equalBase(r))throw new Error("Cannot compare units with different base");return e.value>r.value}if(d(e)||d(r))return e>r;if(e instanceof Array||e instanceof t||r instanceof Array||r instanceof t)return en.map2(e,r,J.larger);if(e.valueOf()!==e||r.valueOf()!==r)return J.larger(e.valueOf(),r.valueOf());throw O("larger",e,r)},J.largereq=function(e,r){if(2!=arguments.length)throw b("largereq",arguments.length,2);if(p(e)){if(p(r))return e>=r;if(r instanceof n)return e>=J.abs(r)}if(e instanceof n){if(p(r))return J.abs(e)>=r;if(r instanceof n)return J.abs(e)>=J.abs(r)}if(e instanceof y&&r instanceof y){if(!e.equalBase(r))throw new Error("Cannot compare units with different base");return e.value>=r.value}if(d(e)||d(r))return e>=r;if(e instanceof Array||e instanceof t||r instanceof Array||r instanceof t)return en.map2(e,r,J.largereq);if(e.valueOf()!==e||r.valueOf()!==r)return J.largereq(e.valueOf(),r.valueOf());throw O("largereq",e,r)},J.lcm=function(){var e,n=arguments[0],r=arguments[1];if(2==arguments.length){if(p(n)&&p(r)){if(!v(n)||!v(r))throw new Error("Parameters in function lcm must be integer numbers");for(var a=n*r;0!=r;)e=r,r=n%e,n=e;return Math.abs(a/n)}if(n instanceof Array||n instanceof t||r instanceof Array||r instanceof t)return en.map2(n,r,J.lcm);if(n.valueOf()!==n||r.valueOf()!==r)return J.lcm(n.valueOf(),r.valueOf());throw O("lcm",n,r)}if(arguments.length>2){for(var i=1;i<arguments.length;i++)n=J.lcm(n,arguments[i]);return n}throw new SyntaxError("Function lcm expects two or more arguments")},J.log=function(e,r){if(1==arguments.length){if(p(e))return e>=0?Math.log(e):J.log(new n(e,0));if(e instanceof n)return new n(Math.log(Math.sqrt(e.re*e.re+e.im*e.im)),Math.atan2(e.im,e.re));if(e instanceof Array||e instanceof t)return en.map(e,J.log);if(e.valueOf()!==e)return J.log(e.valueOf());throw O("log",e)}if(2==arguments.length)return J.divide(J.log(e),J.log(r));throw b("log",arguments.length,1,2)},J.log10=function(e){if(1!=arguments.length)throw b("log10",arguments.length,1);if(p(e))return e>=0?Math.log(e)/Math.LN10:J.log10(new n(e,0));if(e instanceof n)return new n(Math.log(Math.sqrt(e.re*e.re+e.im*e.im))/Math.LN10,Math.atan2(e.im,e.re)/Math.LN10);if(e instanceof Array||e instanceof t)return en.map(e,J.log10);if(e.valueOf()!==e)return J.log10(e.valueOf());throw O("log10",e)},J.mod=function(e,n){if(2!=arguments.length)throw b("mod",arguments.length,2);if(p(e)&&p(n))return q(e,n);if(e instanceof Array||e instanceof t||n instanceof Array||n instanceof t)return en.map2(e,n,J.mod);if(e.valueOf()!==e||n.valueOf()!==n)return J.mod(e.valueOf(),n.valueOf());throw O("mod",e,n)},J.multiply=function on(e,r){if(2!=arguments.length)throw b("multiply",arguments.length,2);if(p(e)){if(p(r))return e*r;if(r instanceof n)return _(new n(e,0),r);if(r instanceof y)return o=r.clone(),o.value*=e,o}else if(e instanceof n){if(p(r))return _(e,new n(r,0));if(r instanceof n)return _(e,r)}else if(e instanceof y){if(p(r))return o=e.clone(),o.value*=r,o}else{if(e instanceof Array){if(r instanceof Array){var a=en.size(e),i=en.size(r);if(2!=a.length)throw new Error("Can only multiply a 2 dimensional matrix (A has "+a.length+" dimensions)");if(2!=i.length)throw new Error("Can only multiply a 2 dimensional matrix (B has "+i.length+" dimensions)");if(a[1]!=i[0])throw new RangeError("Dimensions mismatch in multiplication. Columns of A must match rows of B (A is "+a[0]+"x"+a[1]+", B is "+i[0]+"x"+i[1]+", "+i[1]+" != "+i[0]+")");for(var o=[],f=a[0],s=i[1],u=a[1],on=J.multiply,c=J.add,l=0;f>l;l++){o[l]=[];for(var h=0;s>h;h++){for(var m=null,v=0;u>v;v++){var g=on(e[l][v],r[v][h]);m=null==m?g:c(m,g)}o[l][h]=m}}return o}return r instanceof t?new t(J.multiply(e.valueOf(),r.valueOf())):en.map2(e,r,J.multiply)}if(e instanceof t)return new t(J.multiply(e.valueOf(),r.valueOf()))}if(r instanceof Array)return en.map2(e,r,J.multiply);if(r instanceof t)return new t(J.multiply(e.valueOf(),r.valueOf()));if(e.valueOf()!==e||r.valueOf()!==r)return J.multiply(e.valueOf(),r.valueOf());throw O("multiply",e,r)},J.pow=function(e,r){if(2!=arguments.length)throw b("pow",arguments.length,2);if(p(e)){if(p(r))return v(r)||e>=0?Math.pow(e,r):P(new n(e,0),new n(r,0));if(r instanceof n)return P(new n(e,0),r)}else if(e instanceof n){if(p(r))return P(e,new n(r,0));if(r instanceof n)return P(e,r)}else{if(e instanceof Array){if(!p(r)||!v(r)||0>r)throw new TypeError("For A^b, b must be a positive integer (value is "+r+")");var a=en.size(e);if(2!=a.length)throw new Error("For A^b, A must be 2 dimensional (A has "+a.length+" dimensions)");if(a[0]!=a[1])throw new Error("For A^b, A must be square (size is "+a[0]+"x"+a[1]+")");if(0==r)return J.eye(a[0]);for(var i=e,o=1;r>o;o++)i=J.multiply(e,i);return i}if(e instanceof t)return new t(J.pow(e.valueOf(),r))}if(e.valueOf()!==e||r.valueOf()!==r)return J.pow(e.valueOf(),r.valueOf());throw O("pow",e,r)},J.round=function(e,r){if(1!=arguments.length&&2!=arguments.length)throw b("round",arguments.length,1,2);if(void 0==r){if(p(e))return Math.round(e);if(e instanceof n)return new n(Math.round(e.re),Math.round(e.im));if(e instanceof Array||e instanceof t)return en.map(e,J.round);if(e.valueOf()!==e)return J.round(e.valueOf());throw O("round",e)}if(!p(r))throw new TypeError("Number of decimals in function round must be an integer");if(r!==Math.round(r))throw new TypeError("Number of decimals in function round must be integer");if(0>r||r>9)throw new Error("Number of decimals in function round must be in te range of 0-9");if(p(e))return C(e,r);if(e instanceof n)return new n(C(e.re,r),C(e.im,r));if(e instanceof Array||e instanceof t||r instanceof Array||r instanceof t)return en.map2(e,r,J.round);if(e.valueOf()!==e||r.valueOf()!==r)return J.round(e.valueOf(),r.valueOf());throw O("round",e,r)},J.sign=function fn(e){if(1!=arguments.length)throw b("sign",arguments.length,1);if(p(e)){var fn;return fn=e>0?1:0>e?-1:0}if(e instanceof n){var r=Math.sqrt(e.re*e.re+e.im*e.im);return new n(e.re/r,e.im/r)}if(e instanceof Array||e instanceof t)return en.map(e,J.sign);if(e.valueOf()!==e)return J.sign(e.valueOf());throw O("sign",e)},J.smaller=function(e,r){if(2!=arguments.length)throw b("smaller",arguments.length,2);if(p(e)){if(p(r))return r>e;if(r instanceof n)return e<J.abs(r)}if(e instanceof n){if(p(r))return J.abs(e)<r;if(r instanceof n)return J.abs(e)<J.abs(r)}if(e instanceof y&&r instanceof y){if(!e.equalBase(r))throw new Error("Cannot compare units with different base");return e.value<r.value}if(d(e)||d(r))return r>e;if(e instanceof Array||e instanceof t||r instanceof Array||r instanceof t)return en.map2(e,r,J.smaller);if(e.valueOf()!==e||r.valueOf()!==r)return J.smaller(e.valueOf(),r.valueOf());throw O("smaller",e,r)},J.smallereq=function(e,r){if(2!=arguments.length)throw b("smallereq",arguments.length,2);if(p(e)){if(p(r))return r>=e;if(r instanceof n)return e<=J.abs(r)}if(e instanceof n){if(p(r))return J.abs(e)<=r;if(r instanceof n)return J.abs(e)<=J.abs(r)}if(e instanceof y&&r instanceof y){if(!e.equalBase(r))throw new Error("Cannot compare units with different base");return e.value<=r.value}if(d(e)||d(r))return r>=e;if(e instanceof Array||e instanceof t||r instanceof Array||r instanceof t)return en.map2(e,r,J.smallereq);if(e.valueOf()!==e||r.valueOf()!==r)return J.smallereq(e.valueOf(),r.valueOf());throw O("smallereq",e,r)},J.sqrt=function(e){if(1!=arguments.length)throw b("sqrt",arguments.length,1);if(p(e))return e>=0?Math.sqrt(e):J.sqrt(new n(e,0));if(e instanceof n){var r=Math.sqrt(e.re*e.re+e.im*e.im);return e.im>=0?new n(.5*Math.sqrt(2*(r+e.re)),.5*Math.sqrt(2*(r-e.re))):new n(.5*Math.sqrt(2*(r+e.re)),-.5*Math.sqrt(2*(r-e.re)))}if(e instanceof Array||e instanceof t)return en.map(e,J.sqrt);if(e.valueOf()!==e)return J.sqrt(e.valueOf());throw O("sqrt",e)},J.square=function(e){if(1!=arguments.length)throw b("square",arguments.length,1);if(p(e))return e*e;if(e instanceof n)return J.multiply(e,e);if(e instanceof Array||e instanceof t)return en.map(e,J.square);if(e.valueOf()!==e)return J.square(e.valueOf());throw O("square",e)},J.subtract=function(e,r){if(2!=arguments.length)throw b("subtract",arguments.length,2);if(p(e)){if(p(r))return e-r;if(r instanceof n)return new n(e-r.re,-r.im)}else if(e instanceof n){if(p(r))return new n(e.re-r,e.im);if(r instanceof n)return new n(e.re-r.re,e.im-r.im)}else if(e instanceof y&&r instanceof y){if(!e.equalBase(r))throw new Error("Units do not match");if(null==e.value)throw new Error("Unit on left hand side of operator - has an undefined value");if(null==r.value)throw new Error("Unit on right hand side of operator - has an undefined value");var a=e.clone();return a.value-=r.value,a.fixPrefix=!1,a}if(e instanceof Array||e instanceof t||r instanceof Array||r instanceof t)return en.map2(e,r,J.subtract);if(e.valueOf()!==e||r.valueOf()!==r)return J.subtract(e.valueOf(),r.valueOf());throw O("subtract",e,r)},J.unaryminus=function(e){if(1!=arguments.length)throw b("unaryminus",arguments.length,1);if(p(e))return-e;if(e instanceof n)return new n(-e.re,-e.im);if(e instanceof y){var r=e.clone();return r.value=-e.value,r}if(e instanceof Array||e instanceof t)return en.map(e,J.unaryminus);if(e.valueOf()!==e)return J.unaryminus(e.valueOf());throw O("unaryminus",e)},J.unequal=function(e,r){if(2!=arguments.length)throw b("unequal",arguments.length,2);if(p(e)){if(p(r))return e!=r;if(r instanceof n)return e!=r.re||0!=r.im}if(e instanceof n){if(p(r))return e.re!=r||0!=e.im;if(r instanceof n)return e.re!=r.re||e.im!=r.im}if(e instanceof y&&r instanceof y){if(!e.equalBase(r))throw new Error("Cannot compare units with different base");return e.value!=r.value}if(d(e)||d(r))return e!=r;if(e instanceof Array||e instanceof t||r instanceof Array||r instanceof t)return en.map2(e,r,J.unequal);if(e.valueOf()!==e||r.valueOf()!==r)return J.unequal(e.valueOf(),r.valueOf());throw O("unequal",e,r)},J.xgcd=function sn(e,n){if(2==arguments.length){if(p(e)&&p(n)){if(!v(e)||!v(n))throw new Error("Parameters in function xgcd must be integer numbers");if(0==n)return[e,1,0];var t=sn(n,e%n),r=t[0],a=t[1],i=t[2];return[r,i,a-i*Math.floor(e/n)]}throw O("xgcd",e,n)}throw new SyntaxError("Function xgcd expects two arguments")},J.arg=function(e){if(1!=arguments.length)throw b("arg",arguments.length,1);return p(e)?Math.atan2(0,e):e instanceof n?Math.atan2(e.im,e.re):e instanceof Array||e instanceof t?en.map(e,J.arg):e.valueOf()!==e?J.arg(e.valueOf()):J.atan2(0,e)},J.conj=function(e){if(1!=arguments.length)throw b("conj",arguments.length,1);return p(e)?e:e instanceof n?new n(e.re,-e.im):e instanceof Array||e instanceof t?en.map(e,J.conj):e.valueOf()!==e?J.conj(e.valueOf()):clone(e)},J.im=function(e){if(1!=arguments.length)throw b("im",arguments.length,1);return p(e)?0:e instanceof n?e.im:e instanceof Array||e instanceof t?en.map(e,J.im):e.valueOf()!==e?J.im(e.valueOf()):0},J.re=function(e){if(1!=arguments.length)throw b("re",arguments.length,1);return p(e)?e:e instanceof n?e.re:e instanceof Array||e instanceof t?en.map(e,J.re):e.valueOf()!==e?J.re(e.valueOf()):J.clone(e)},J.complex=function(){switch(arguments.length){case 0:return new n(0,0);case 1:var e=arguments[0];if(e instanceof n)return e.clone();if(d(e)){var t=n.parse(e);if(t)return t;throw new SyntaxError('String "'+e+'" is no valid complex number')}throw new TypeError("Two numbers or a single string expected in function complex");case 2:return new n(arguments[0],arguments[1]);default:throw b("complex",arguments.length,0,2)}},J.matrix=function(e){if(arguments.length>1)throw b("matrix",arguments.length,0,1);return new t(e)},J.number=function(e){switch(arguments.length){case 0:return 0;case 1:var n=Number(e);if(isNaN(n)&&(n=Number(e.valueOf())),isNaN(n))throw new SyntaxError(e.toString()+" is no valid number");return n;default:throw b("number",arguments.length,0,1)}},J.parser=function(){return new J.expr.Parser},J.range=function(e){switch(arguments.length){case 1:if(e instanceof g)return e.clone();if(d(e)){var n=g.parse(e);if(n)return n;throw new SyntaxError('String "'+n+'" is no valid range')}throw new TypeError("Two or three numbers or a single string expected in function range");case 2:return new g(arguments[0],null,arguments[1]);case 3:return new g(arguments[0],arguments[1],arguments[2]);default:throw b("range",arguments.length,2,3)}},J.string=function(e){switch(arguments.length){case 0:return"";case 1:return B(e);default:throw b("string",arguments.length,0,1)}},J.unit=function(){switch(arguments.length){case 1:var e=arguments[0];if(e instanceof y)return e.clone();if(d(e)){if(y.isPlainUnit(e))return new y(null,e);var n=y.parse(e);if(n)return n;throw new SyntaxError('String "'+e+'" is no valid unit')}throw new TypeError("A string or a number and string expected in function unit");case 2:return new y(arguments[0],arguments[1]);default:throw b("unit",arguments.length,1,2)}},J.workspace=function(){throw new Error("Workspace is no longer supported, sorry...")},J.concat=function(){var e,n,r=arguments.length,a=-1,i=!1,o=[];for(e=0;r>e;e++){var f=arguments[e];if(f instanceof t&&(i=!0),e==r-1&&p(f)){if(n=a,a=f,!v(a)||1>a)throw new TypeError("Dimension number must be a positive integer (dim = "+a+")");if(e>0&&a>n)throw new RangeError("Dimension out of range ("+a+" > "+n+")")}else{if(!(f instanceof Array||f instanceof t))throw O("concat",f);var s=J.clone(f.valueOf()),u=J.size(f);if(o[e]=s,n=a,a=u.length,e>0&&a!=n)throw new RangeError("Dimension mismatch ("+n+" != "+a+")")}}if(0==o.length)throw new SyntaxError("At least one matrix expected");for(var c=o.shift();o.length;)c=G(c,o.shift(),a-1,0);return i?new t(c):c},J.det=function(e){if(1!=arguments.length)throw b("det",arguments.length,1);var n=J.size(e);switch(n.length){case 0:return J.clone(e);case 1:if(1==n[0])return J.clone(e.valueOf()[0]);throw new RangeError("Matrix must be square (size: "+J.format(n)+")");case 2:var t=n[0],r=n[1];if(t==r)return F(e.valueOf(),t,r);throw new RangeError("Matrix must be square (size: "+J.format(n)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+J.format(n)+")")}},J.diag=function(e,n){var r,a,i,o;if(1!=arguments.length&&2!=arguments.length)throw b("diag",arguments.length,1,2);if(n){if(!p(n)||!v(n))throw new TypeError("Second parameter in function diag must be an integer")}else n=0;var f=n>0?n:0,s=0>n?-n:0;e instanceof t||e instanceof g||(e=new t(e));var u;switch(e.isVector()?(e=e.toVector(),u=[e.length]):u=e.size(),u.length){case 1:a=e.valueOf();var c=new t;for(c.resize([a.length+s,a.length+f]),r=c.valueOf(),o=a.length,i=0;o>i;i++)r[i+s][i+f]=J.clone(a[i]);return c;case 2:for(a=[],r=e.valueOf(),o=Math.min(u[0]-s,u[1]-f),i=0;o>i;i++)a[i]=J.clone(r[i+s][i+f]);return new t(a);default:throw new RangeError("Matrix for function diag must be 2 dimensional")}},J.eye=function(){var e=en.argsToArray(arguments);if(0==e.length)e=[1,1];else if(1==e.length)e[1]=e[0];else if(e.length>2)throw b("eye",e.length,0,2);var n=e[0],r=e[1];if(!p(n)||!v(n)||1>n)throw new Error("Parameters in function eye must be positive integers");if(r&&(!p(r)||!v(r)||1>r))throw new Error("Parameters in function eye must be positive integers");var a=new t;a.resize(e);for(var i=J.min(e),o=a.valueOf(),f=0;i>f;f++)o[f][f]=1;return a},J.inv=function(e){if(1!=arguments.length)throw b("inv",arguments.length,1);var n=J.size(e);switch(n.length){case 0:return J.divide(1,e);case 1:if(1==n[0])return e instanceof t?new t([J.divide(1,e.valueOf()[0])]):[J.divide(1,e[0])];throw new RangeError("Matrix must be square (size: "+J.format(n)+")");case 2:var r=n[0],a=n[1];if(r==a)return e instanceof t?new t(j(e.valueOf(),r,a)):j(e,r,a);throw new RangeError("Matrix must be square (size: "+J.format(n)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+J.format(n)+")")}},J.ones=function(){var e=en.argsToArray(arguments);0==e.length?e=[1,1]:1==e.length&&(e[1]=e[0]);var n=new t,r=1;return n.resize(e,r),n},J.size=function(e){if(1!=arguments.length)throw b("size",arguments.length,1);if(p(e)||e instanceof n||e instanceof y||null==e)return[];if(d(e))return[e.length];if(e instanceof Array)return en.size(e);if(e instanceof t)return e.size();if(e.valueOf()!==e)return J.size(e.valueOf());throw O("size",e)},J.squeeze=function(e){if(1!=arguments.length)throw b("squeeze",arguments.length,1);return e instanceof Array?V(J.clone(e)):e instanceof t?V(e.toArray()):e.valueOf()instanceof Array?V(J.clone(e.valueOf())):J.clone(e)},J.subset=function(){switch(arguments.length){case 2:return H(arguments[0],arguments[1]);case 3:return k(arguments[0],arguments[1],arguments[2]);default:throw b("subset",arguments.length,2,3)}},J.transpose=function(e){if(1!=arguments.length)throw b("transpose",arguments.length,1);var n=J.size(e);switch(n.length){case 0:return J.clone(e);case 1:return J.clone(e);case 2:for(var r,a=n[1],i=n[0],o=e instanceof t,f=e.valueOf(),s=[],u=J.clone,c=0;a>c;c++){r=s[c]=[];for(var l=0;i>l;l++)r[l]=u(f[l][c])}return 0==i&&(s[0]=[]),o?new t(s):s;default:throw new RangeError("Matrix must be two dimensional (size: "+J.format(n)+")")}},J.zeros=function(){var e=en.argsToArray(arguments);0==e.length?e=[1,1]:1==e.length&&(e[1]=e[0]);var n=new t;return n.resize(e),n},J.factorial=function(e){if(1!=arguments.length)throw b("factorial",arguments.length,1);if(p(e)){if(!v(e)||0>e)throw new TypeError("Positive integer value expected in function factorial");var n=e,r=n;for(n--;n>1;)r*=n,n--;return 0==r&&(r=1),r}if(e instanceof Array||e instanceof t)return en.map(e,J.factorial);if(e.valueOf()!==e)return J.factorial(e.valueOf());throw O("factorial",e)},J.random=function(){if(0!=arguments.length)throw b("random",arguments.length,0);return Math.random()},J.max=function(e){if(0==arguments.length)throw new Error("Function max requires one or more parameters (0 provided)");if(e instanceof Array||e instanceof t||e instanceof g){if(arguments.length>1)throw Error("Wrong number of parameters (1 matrix or multiple scalars expected)");var n=J.size(e);if(1==n.length){if(0==e.length)throw new Error("Cannot calculate max of an empty vector");return W(e.valueOf())}if(2==n.length){if(0==n[0]||0==n[1])throw new Error("Cannot calculate max of an empty matrix");if(e instanceof Array)return K(e,n[0],n[1]);if(e instanceof t||e instanceof g)return new t(K(e.valueOf(),n[0],n[1]));throw O("max",e)}throw new RangeError("Cannot calculate max for multi dimensional matrix")}return W(arguments)},J.min=function(e){if(0==arguments.length)throw new Error("Function min requires one or more parameters (0 provided)");if(e instanceof Array||e instanceof t||e instanceof g){if(arguments.length>1)throw Error("Wrong number of parameters (1 matrix or multiple scalars expected)");var n=J.size(e);if(1==n.length){if(0==e.length)throw new Error("Cannot calculate min of an empty vector");return Z(e.valueOf())}if(2==n.length){if(0==n[0]||0==n[1])throw new Error("Cannot calculate min of an empty matrix");if(e instanceof Array)return X(e,n[0],n[1]);if(e instanceof t||e instanceof g)return new t(X(e.valueOf(),n[0],n[1]));throw O("min",e)}throw new RangeError("Cannot calculate min for multi dimensional matrix")}return Z(arguments)},J.acos=function(e){if(1!=arguments.length)throw b("acos",arguments.length,1);if(p(e))return e>=-1&&1>=e?Math.acos(e):J.acos(new n(e,0));if(e instanceof n){var r=new n(e.im*e.im-e.re*e.re+1,-2*e.re*e.im),a=J.sqrt(r),i=new n(a.re-e.im,a.im+e.re),o=J.log(i);return new n(1.5707963267948966-o.im,o.re)}if(e instanceof Array||e instanceof t)return en.map(e,J.acos);if(e.valueOf()!==e)return J.acos(e.valueOf());throw O("acos",e)},J.asin=function(e){if(1!=arguments.length)throw b("asin",arguments.length,1);if(p(e))return e>=-1&&1>=e?Math.asin(e):J.asin(new n(e,0));if(e instanceof n){var r=e.re,a=e.im,i=new n(a*a-r*r+1,-2*r*a),o=J.sqrt(i),f=new n(o.re-a,o.im+r),s=J.log(f);
  return new n(s.im,-s.re)}if(e instanceof Array||e instanceof t)return en.map(e,J.asin);if(e.valueOf()!==e)return J.asin(e.valueOf());throw O("asin",e)},J.atan=function(e){if(1!=arguments.length)throw b("atan",arguments.length,1);if(p(e))return Math.atan(e);if(e instanceof n){var r=e.re,a=e.im,i=r*r+(1-a)*(1-a),o=new n((1-a*a-r*r)/i,-2*r/i),f=J.log(o);return new n(-.5*f.im,.5*f.re)}if(e instanceof Array||e instanceof t)return en.map(e,J.atan);if(e.valueOf()!==e)return J.atan(e.valueOf());throw O("atan",e)},J.atan2=function(e,r){if(2!=arguments.length)throw b("atan2",arguments.length,2);if(p(e)){if(p(r))return Math.atan2(e,r)}else if(e instanceof n&&p(r))return Math.atan2(e.re,r);if(e instanceof Array||e instanceof t||r instanceof Array||r instanceof t)return en.map2(e,r,J.atan2);if(r.valueOf()!==r||e.valueOf()!==e)return J.atan2(e.valueOf(),r.valueOf());throw O("atan2",e,r)},J.cos=function(e){if(1!=arguments.length)throw b("cos",arguments.length,1);if(p(e))return Math.cos(e);if(e instanceof n)return new n(.5*Math.cos(e.re)*(Math.exp(-e.im)+Math.exp(e.im)),.5*Math.sin(e.re)*(Math.exp(-e.im)-Math.exp(e.im)));if(e instanceof y){if(!e.hasBase(y.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cos is no angle");return Math.cos(e.value)}if(e instanceof Array||e instanceof t)return en.map(e,J.cos);if(e.valueOf()!==e)return J.cos(e.valueOf());throw O("cos",e)},J.cot=function(e){if(1!=arguments.length)throw b("cot",arguments.length,1);if(p(e))return 1/Math.tan(e);if(e instanceof n){var r=Math.exp(-4*e.im)-2*Math.exp(-2*e.im)*Math.cos(2*e.re)+1;return new n(2*Math.exp(-2*e.im)*Math.sin(2*e.re)/r,(Math.exp(-4*e.im)-1)/r)}if(e instanceof y){if(!e.hasBase(y.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cot is no angle");return 1/Math.tan(e.value)}if(e instanceof Array||e instanceof t)return en.map(e,J.cot);if(e.valueOf()!==e)return J.cot(e.valueOf());throw O("cot",e)},J.csc=function(e){if(1!=arguments.length)throw b("csc",arguments.length,1);if(p(e))return 1/Math.sin(e);if(e instanceof n){var r=.25*(Math.exp(-2*e.im)+Math.exp(2*e.im))-.5*Math.cos(2*e.re);return new n(.5*Math.sin(e.re)*(Math.exp(-e.im)+Math.exp(e.im))/r,.5*Math.cos(e.re)*(Math.exp(-e.im)-Math.exp(e.im))/r)}if(e instanceof y){if(!e.hasBase(y.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csc is no angle");return 1/Math.sin(e.value)}if(e instanceof Array||e instanceof t)return en.map(e,J.csc);if(e.valueOf()!==e)return J.csc(e.valueOf());throw O("csc",e)},J.sec=function(e){if(1!=arguments.length)throw b("sec",arguments.length,1);if(p(e))return 1/Math.cos(e);if(e instanceof n){var r=.25*(Math.exp(-2*e.im)+Math.exp(2*e.im))+.5*Math.cos(2*e.re);return new n(.5*Math.cos(e.re)*(Math.exp(-e.im)+Math.exp(e.im))/r,.5*Math.sin(e.re)*(Math.exp(e.im)-Math.exp(-e.im))/r)}if(e instanceof y){if(!e.hasBase(y.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sec is no angle");return 1/Math.cos(e.value)}if(e instanceof Array||e instanceof t)return en.map(e,J.sec);if(e.valueOf()!==e)return J.sec(e.valueOf());throw O("sec",e)},J.sin=function(e){if(1!=arguments.length)throw b("sin",arguments.length,1);if(p(e))return Math.sin(e);if(e instanceof n)return new n(.5*Math.sin(e.re)*(Math.exp(-e.im)+Math.exp(e.im)),.5*Math.cos(e.re)*(Math.exp(e.im)-Math.exp(-e.im)));if(e instanceof y){if(!e.hasBase(y.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cos is no angle");return Math.sin(e.value)}if(e instanceof Array||e instanceof t)return en.map(e,J.sin);if(e.valueOf()!==e)return J.sin(e.valueOf());throw O("sin",e)},J.tan=function(e){if(1!=arguments.length)throw b("tan",arguments.length,1);if(p(e))return Math.tan(e);if(e instanceof n){var r=Math.exp(-4*e.im)+2*Math.exp(-2*e.im)*Math.cos(2*e.re)+1;return new n(2*Math.exp(-2*e.im)*Math.sin(2*e.re)/r,(1-Math.exp(-4*e.im))/r)}if(e instanceof y){if(!e.hasBase(y.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tan is no angle");return Math.tan(e.value)}if(e instanceof Array||e instanceof t)return en.map(e,J.tan);if(e.valueOf()!==e)return J.tan(e.valueOf());throw O("tan",e)},J["in"]=function(e,n){if(2!=arguments.length)throw b("in",arguments.length,2);if(e instanceof y&&(n instanceof y||d(n)))return e["in"](n);if(e instanceof Array||e instanceof t||n instanceof Array||n instanceof t)return en.map2(e,n,J["in"]);if(e.valueOf()!==e||n.valueOf()!==n)return J["in"](e.valueOf(),n.valueOf());throw O("in",e,n)},J.clone=function(n){if(1!=arguments.length)throw b("clone",arguments.length,1);if(null==n)return n;if("function"==typeof n.clone)return n.clone();if(p(n)||d(n)||e(n))return n;if(n instanceof Array){var t=J.clone;return n.map(function(e){return t(e)})}if(n instanceof Object)return en.mapObject(n,J.clone);throw O("clone",n)},J.eval=function(e,n){if(1!=arguments.length&&2!=arguments.length)throw b("eval",arguments.length,1,2);var r;if(r=n?n instanceof J.expr.Scope?n:new J.expr.Scope(n):new J.expr.Scope,d(e)){var a=J.parse(e,r);return a.eval()}if(e instanceof Array||e instanceof t)return en.map(e,function(e){var n=J.parse(e,r);return n.eval()});throw new TypeError("String or matrix expected")},J.format=function(e,n){var t=arguments.length;if(1!=t&&2!=t)throw b("format",t,1,2);if(1==t){var r=arguments[0];return p(r)?en.formatNumber(r,J.options.precision):r instanceof Array?en.formatArray(r):d(r)?'"'+r+'"':r instanceof Object?r.toString():String(r)}if(!d(e))throw new TypeError("String expected as first parameter in function format");if(!(n instanceof Object))throw new TypeError("Object expected as first parameter in function format");return e.replace(/\$([\w\.]+)/g,function(e,t){for(var r=t.split("."),a=n[r.shift()];r.length&&void 0!=a;){var i=r.shift();a=i?a[i]:a+"."}return void 0!=a?a:e})},J["import"]=function(e,n){var t,r={override:!1,wrap:!0};if(n&&n instanceof Object&&en.extend(r,n),d(e)){if("undefined"==typeof require)throw new Error("Cannot load file: require not available.");var a=require(e);J["import"](a)}else if($(e)){if(t=e.name,!t)throw new Error("Cannot import an unnamed function or object");(r.override||void 0===J[t])&&Q(t,e,r)}else if(e instanceof Object)for(t in e)if(e.hasOwnProperty(t)){var i=e[t];$(i)?Q(t,i,r):J["import"](i)}},function(){function e(){nn=0,tn=$.charAt(0)}function r(){nn++,tn=$.charAt(nn)}function a(){return $.charAt(nn+1)}function i(){for(an=X.NULL,rn="";" "==tn||"	"==tn;)r();if("#"==tn)for(;"\n"!=tn&&""!=tn;)r();if(""==tn)return an=X.DELIMITER,void 0;var e=tn+a();if(Q[e])return an=X.DELIMITER,rn=e,r(),r(),void 0;if(Q[tn])return an=X.DELIMITER,rn=tn,r(),void 0;if(f(tn)){if(an=X.NUMBER,"."==tn)rn+=tn,r(),s(tn)||(an=X.UNKNOWN);else{for(;s(tn);)rn+=tn,r();"."==tn&&(rn+=tn,r())}for(;s(tn);)rn+=tn,r();if("E"==tn||"e"==tn)for(rn+=tn,r(),("+"==tn||"-"==tn)&&(rn+=tn,r()),s(tn)||(an=X.UNKNOWN);s(tn);)rn+=tn,r()}else{if(!o(tn)){for(an=X.UNKNOWN;""!=tn;)rn+=tn,r();throw W('Syntax error in part "'+rn+'"')}for(an=X.SYMBOL;o(tn)||s(tn);)rn+=tn,r()}}function o(e){return e>="a"&&"z">=e||e>="A"&&"Z">=e||"_"==e}function f(e){return e>="0"&&"9">=e||"."==e}function s(e){return e>="0"&&"9">=e}function u(n){e(),i();var t;if(t=""==rn?new N(void 0):c(n),""!=rn)throw an==X.DELIMITER?Z("Unknown operator "+rn):W('Unexpected part "'+rn+'"');return t}function c(e){var n,t,r;for("\n"!=rn&&";"!=rn&&""!=rn&&(n=l(e));"\n"==rn||";"==rn;)t||(t=new U,n&&(r=";"!=rn,t.add(n,r))),i(),"\n"!=rn&&";"!=rn&&""!=rn&&(n=l(e),r=";"!=rn,t.add(n,r));return t?t:(n||(n=l(e)),n)}function l(e){var n=h(e),t="ans";return new z(t,n,e)}function h(e){if(an==X.SYMBOL&&"function"==rn){if(i(),an!=X.SYMBOL)throw W("Function name expected");var n=rn;if(i(),"("!=rn)throw W("Opening parenthesis ( expected");for(var t=e.createSubScope(),r=[];;){if(i(),an!=X.SYMBOL)throw W("Variable name expected");if(r.push(rn),i(),","!=rn){if(")"==rn)break;throw W('Comma , or closing parenthesis ) expected"')}}if(i(),"="!=rn)throw W("Equal sign = expected");i();var a=m(t);return new L(n,r,a,t,e)}return m(e)}function m(e){var n,t,r,a,o=p(e);if("="==rn){if(o instanceof A)return i(),n=o.name,t=null,a=m(e),new z(n,a,e);if(o instanceof S&&o.object instanceof A)return i(),n=o.object.name,t=o.params,r=o.paramScopes,a=m(e),new R(n,t,r,a,e);throw W("Symbol expected at the left hand side of assignment operator =")}return o}function p(e){var n,t,r,a=[];if(n=":"==rn?new N(1):v(e),":"==rn){for(a.push(n);":"==rn;)i(),")"==rn||","==rn||""==rn?a.push(new A("end",e)):a.push(v(e));a.length&&(t="range",r=J.range,n=new M(t,r,a))}return n}function v(e){var n,t,r,a,o;for(n=g(e),t={"in":"in"};void 0!==t[rn];)r=rn,a=J[t[r]],i(),o=[n,g(e)],n=new M(r,a,o);return n}function g(e){var n=w(e);return n}function w(e){var n,t,r,a,o;for(n=E(e),t={"==":"equal","!=":"unequal","<":"smaller",">":"larger","<=":"smallereq",">=":"largereq"};void 0!==t[rn];)r=rn,a=J[t[r]],i(),o=[n,E(e)],n=new M(r,a,o);return n}function E(e){var n,t,r,a,o;for(n=O(e),t={"+":"add","-":"subtract"};void 0!==t[rn];)r=rn,a=J[t[r]],i(),o=[n,O(e)],n=new M(r,a,o);return n}function O(e){var n,t,r,a,o;for(n=x(e),t={"*":"multiply",".*":"emultiply","/":"divide","./":"edivide","%":"mod",mod:"mod"};void 0!==t[rn];)r=rn,a=J[t[r]],i(),o=[n,x(e)],n=new M(r,a,o);return n}function x(e){var n,t,r;return"-"==rn?(n=rn,t=J.unaryminus,i(),r=[I(e)],new M(n,t,r)):I(e)}function I(e){var n,t,r,a,o,f,s;for(r=[q(e)],a=[];"^"==rn||".^"==rn;)a.push(rn),i(),r.push(q(e));for(n=r.pop();r.length;)t=r.pop(),o=a.pop(),f="^"==o?J.pow:J.epow,s=[t,n],n=new M(o,f,s);return n}function q(e){var n,t,r,a;for(n=_(e);"!"==rn;)t=rn,r=J.factorial,i(),a=[n],n=new M(t,r,a);return n}function _(e){var n,t,r,a;for(n=P(e);"'"==rn;)t=rn,r=J.transpose,i(),a=[n],n=new M(t,r,a);return n}function P(e){return C(e)}function C(e){var n,t;return an==X.SYMBOL?(t=rn,i(),n=new A(t,e),B(e,n)):G(e)}function B(e,n){for(var t,r,a;"("==rn;){if(t=[],r=[],i(),")"!=rn)for(a=e.createSubScope(),r.push(a),t.push(p(a));","==rn;)i(),a=e.createSubScope(),r.push(a),t.push(p(a));if(")"!=rn)throw W("Parenthesis ) expected");i(),n=new S(n,t,r)}return n}function G(e){var n,t,a;if('"'==rn){for(t="",a="";""!=tn&&('"'!=tn||"\\"==a);)t+=tn,a=tn,r();if(i(),'"'!=rn)throw W('End of string " expected');return i(),n=new N(t),n=B(e,n)}return F(e)}function F(e){var n,t,r,a,o,f;if("["==rn){for(i();"\n"==rn;)i();if("]"!=rn){for(t=[],r=0,a=0,t[0]=[m(e)];","==rn||";"==rn;){for(","==rn?a++:(r++,a=0,t[r]=[]),i();"\n"==rn;)i();for(t[r][a]=m(e);"\n"==rn;)i()}for(o=t.length,f=t.length>0?t[0].length:0,r=1;o>r;r++)if(t[r].length!=f)throw Z("Number of columns must match ("+t[r].length+" != "+f+")");if("]"!=rn)throw W("End of matrix ] expected");i(),n=new T(t)}else i(),n=new T([[]]);return n=B(e,n)}return j(e)}function j(e){var t,r,a;if(an==X.NUMBER){if(a="."==rn?0:Number(rn),i(),an==X.SYMBOL){if("i"==rn||"I"==rn)return r=new n(0,a),i(),new N(r);if(y.isPlainUnit(rn))return r=new y(a,rn),i(),new N(r);throw K('Unknown unit "'+rn+'"')}return t=new N(a),t=B(e,t)}return V(e)}function V(e){var n;if("("==rn){if(i(),n=m(e),")"!=rn)throw W("Parenthesis ) expected");return i(),n=B(e,n)}return H(e)}function H(){throw""==rn?W("Unexpected end of expression"):W("Value expected")}function D(){return void 0}function k(){return nn-rn.length+1}function Y(e){var n=D(),t=k();return void 0===n?void 0===t?e:e+" (char "+t+")":e+" (line "+n+", char "+t+")"}function W(e){return new SyntaxError(Y(e))}function K(e){return new TypeError(Y(e))}function Z(e){return new Error(Y(e))}J.parse=function(e,n){if(1!=arguments.length&&2!=arguments.length)throw b("parse",arguments.length,1,2);var r;if(r=n?n instanceof J.expr.Scope?n:new J.expr.Scope(n):new J.expr.Scope,d(e))return $=e||"",u(r);if(e instanceof Array||e instanceof t)return en.map(e,function(e){return $=e||"",u(r)});throw new TypeError("String or matrix expected")};var X={NULL:0,DELIMITER:1,NUMBER:2,SYMBOL:3,UNKNOWN:4},Q={",":!0,"(":!0,")":!0,"[":!0,"]":!0,'"':!0,"\n":!0,";":!0,"+":!0,"-":!0,"*":!0,".*":!0,"/":!0,"./":!0,"%":!0,"^":!0,".^":!0,"!":!0,"'":!0,"=":!0,":":!0,"==":!0,"!=":!0,"<":!0,">":!0,"<=":!0,">=":!0},$="",nn=0,tn="",rn="",an=X.NULL}(),J.select=function(e){return new J.type.Selector(e)},J["typeof"]=function(e){if(1!=arguments.length)throw b("typeof",arguments.length,1);var n,t=typeof e;if("object"==t){if(null==e)return"null";if(e instanceof Boolean)return"boolean";if(e instanceof Number)return"number";if(e instanceof String)return"string";if(e instanceof Array)return"array";if(e instanceof Date)return"date";if(e.constructor){for(n in J)if(J.hasOwnProperty(n)&&e.constructor==J[n])return n.toLowerCase();for(n in J.type)if(J.type.hasOwnProperty(n)&&e.constructor==J.type[n])return n.toLowerCase();if(e.constructor.name)return e.constructor.name.toLowerCase()}}return t},Array.prototype.indexOf||(Array.prototype.indexOf=function(e){for(var n=0;n<this.length;n++)if(this[n]==e)return n;return-1}),Array.prototype.forEach||(Array.prototype.forEach=function(e,n){for(var t=0,r=this.length;r>t;++t)e.call(n||this,this[t],t,this)}),Array.prototype.map||(Array.prototype.map=function(e,n){var t,r,a;if(null==this)throw new TypeError(" this is null or not defined");var i=Object(this),o=i.length>>>0;if("function"!=typeof e)throw new TypeError(e+" is not a function");for(n&&(t=n),r=new Array(o),a=0;o>a;){var f,s;a in i&&(f=i[a],s=e.call(t,f,a,i),r[a]=s),a++}return r}),Array.prototype.every||(Array.prototype.every=function(e){"use strict";if(null==this)throw new TypeError;var n=Object(this),t=n.length>>>0;if("function"!=typeof e)throw new TypeError;for(var r=arguments[1],a=0;t>a;a++)if(a in n&&!e.call(r,n[a],a,n))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(e){"use strict";if(null==this)throw new TypeError;var n=Object(this),t=n.length>>>0;if("function"!=typeof e)throw new TypeError;for(var r=arguments[1],a=0;t>a;a++)if(a in n&&e.call(r,n[a],a,n))return!0;return!1}),Function.prototype.bind||(Function.prototype.bind=function(e){if("function"!=typeof this)throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable");var n=Array.prototype.slice.call(arguments,1),t=this,r=function(){},a=function(){return t.apply(this instanceof r&&e?this:e,n.concat(Array.prototype.slice.call(arguments)))};return r.prototype=this.prototype,a.prototype=new r,a});for(var rn in J)J.hasOwnProperty(rn)&&rn&&w(rn,J[rn]);"undefined"!=typeof module&&"undefined"!=typeof module.exports&&(module.exports=J),"undefined"!=typeof exports&&(exports=J),"undefined"!=typeof require&&"undefined"!=typeof define&&define(function(){return J}),"undefined"!=typeof window&&(window.math?en.deepExtend(window.math,J):window.math=J)}();