'use strict';
define(function() {
  var ffl2AttachmentFactory = function($http, gaUrlUtils) {
    var ffl2AttachmentFactory = {};
    /**
     * Class : ffl2AttachmentFactory
     * Factory WebServices
     */

    var resources = {};

    /**
     * Function: add
     */
    function add(senddata, fileName, partCountStr, layerName, featureId) {
      var urlFileName = gaUrlUtils.encodeUriQuery(fileName);
      var promise = $http.post(
        '/services/{portalid}/attachment/add?f=json' +
          '&fileName=' +
          urlFileName +
          '&partCountStr=' +
          partCountStr +
          '&layerName=' +
          layerName +
          '&featureId=' +
          featureId +
          '&fileToUnzipStr=&zipFileAssociation=&zipExtractUnusedEntriesStr=',
        senddata
      );
      promise.then(function(res) {
        // service level logic if any
      });
      return promise;
    }

    /**
     * Function: list
     */
    function list(layerName, featureId) {
      var promise = $http.get(
        '/services/{portalid}/attachment/list?f=json' +
          '&layerName=' +
          layerName +
          '&featureId=' +
          featureId
      );
      promise.then(function(res) {
        resources.fileList = res.data;
      });
      return promise;
    }

    /**
     * Function: remove
     */
    function removeFiles(fileNames, layerName, featureId) {
      var promise = $http.get(
        '/services/{portalid}/attachment/remove?f=json' +
          '&fileNames=' +
          fileNames +
          '&layerName=' +
          layerName +
          '&featureId=' +
          featureId
      );
      promise.then(function(res) {
        // service level logic if any
      });
      return promise;
    }

    /**
     * Function: getdownloadurl
     */
    function getdownloadurl(fileName, layerName, featureId) {
      var urlFileName = gaUrlUtils.encodeUriQuery(fileName);
      var promise = $http.get(
        '/services/{portalid}/attachment/getdownloadurl?f=json' +
          '&fileName=' +
          urlFileName +
          '&layerName=' +
          layerName +
          '&featureId=' +
          featureId +
          '&methode='
      );
      promise.then(function(res) {
        //				resources.downloadurl = gaUrlUtils.encodeUriQuery(res.data);
        resources.downloadurl = res.data;
      });
      return promise;
    }

    return {
      ffl2AttachmentFactory: ffl2AttachmentFactory,
      list: list,
      add: add,
      removeFiles: removeFiles,
      getdownloadurl: getdownloadurl,
      resources: resources,
    };
  };
  ffl2AttachmentFactory.$inject = ['$http', 'gaUrlUtils'];
  return ffl2AttachmentFactory;
});
