/**
 *
 */
'use strict';
define(function() {
  var ChoixProgrammeCtrl = function(
    $scope,
    ChoixProgrammeFactory,
    ConfigFactory,
    GlobalServices,
    QueryFactory,
    EditFactory,
    FeatureTypeFactory,
    $q,
    ngDialog,
    gaJsUtils
  ) {
    $scope.theProgram = null;
    $scope.programmes = [];
    $scope.displayProgram = false;
    $scope.addProgAvailable = false;
    $scope.firstYearOfProgToCreate = {};

    $scope.getFilterObjBuildWhere = function(queryObj) {
      var fn,
        part,
        newQuery = '',
        query = queryObj.where,
        valueList = [],
        val;
      var indStr1 = query.indexOf('!lastResult!'),
        indStrFieldEnd;
      var indOr;
      if (indStr1 == -1) newQuery = query;
      else {
        indOr = query.indexOf(' or ');
        indStrFieldEnd = query.indexOf('!', indStr1 + 14);
        if ($scope.gfowcObj.previousRes.length == 0) {
          if (indOr == -1 || indOr < indStrFieldEnd) return null;
          newQuery = query.substr(indOr + 4);
        } else {
          fn = query.substr(indStr1 + 14, indStrFieldEnd - indStr1 - 14);
          for (
            var indObj = 0;
            indObj < $scope.gfowcObj.previousRes.length;
            indObj++
          ) {
            val = $scope.gfowcObj.previousRes[indObj].properties[fn];
            if (val != null && valueList.indexOf(val) == -1)
              valueList.push(val);
          }
          newQuery =
            query.substr(0, indStr1) +
            valueList.valueOf() +
            query.substr(indStrFieldEnd + 1);
        }
      }
      return newQuery;
    };

    $scope.getFilterObjWhereClause = function(deferred) {
      var query =
        $scope.config.searchFilterObj[$scope.gfowcObj.indexOfSearchFilter];
      $scope.gfowcObj.indexOfSearchFilter++;
      var fti = FeatureTypeFactory.getFeatureTypeDesc(
        query.datastoreName,
        query.featureType
      );
      var where = $scope.getFilterObjBuildWhere(query);

      if ($scope.gfowcObj.deferred == undefined)
        $scope.gfowcObj.deferred = $q.defer();

      if (
        $scope.gfowcObj.indexOfSearchFilter ==
          $scope.config.searchFilterObj.length ||
        where == null
      ) {
        $scope.gfowcObj.deferred.resolve(where);
        $scope.gfowcObj = undefined;
      } else {
        QueryFactory.data(fti.uid, where).then(function(res) {
          $scope.gfowcObj.previousRes = res.data.features;
          $scope.getFilterObjWhereClause();
        });
      }
      if ($scope.gfowcObj != undefined) return $scope.gfowcObj.deferred.promise;
    };

    $scope.alert = function(message) {
      console.log(message);
      var errorMsg = '<h4>Erreur</h4> ';
      errorMsg += '<br/><h4>Details</h4>' + message;
      require('toastr').error(errorMsg);
    };

    $scope.getProcedureSteps = function(action, ids) {
      var deferred = $q.defer();
      //-- -2- Get "etapeProcedure". linked to etape standard
      var ftRel = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.config.progDatastorename,
        action.procedureTable.name
      );
      QueryFactory.data(ftRel.uid, 'in (' + ids + ')').then(function(res) {
        var id;
        var features = res.data.features;
        for (var ind = 0; ind < features.length; ind++) {
          id = features[ind].properties[action.procedureTable.projectId];
          if ($scope.projectIds.indexOf(id) == -1) $scope.projectIds.push(id);
        }
        deferred.resolve('gotProjectIds');
      });

      return deferred.promise;
    };

    $scope.ceateRelationGetWhereForProjectSteps = function(action) {
      return (
        action.standardStepTable.expectedStartDate +
        '>=' +
        (1 + gaJsUtils.getCurrentYear()) +
        '-01-01T12:00:00.000+00:00 and ' +
        action.standardStepTable.expectedStartDate +
        '<=' +
        (1 + gaJsUtils.getCurrentYear()) +
        '-12-31T12:00:00.000+00:00'
      );
    };

    $scope.getprojetcIdsOfSteps = function(action, specificSteptable) {
      //-- -1- Get "etapeStandard" ot "etapeFinale" where date_debut_prevue  is in the program year
      //-- -2- Get "etapeProcedure". linked to etape standard

      var deferred = $q.defer();

      //-- -1- Get "etapeStandard" where date_debut_prevue  is in the program year
      //-- Get id of previous program
      var ftRel = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.config.progDatastorename,
        specificSteptable.name
      );
      QueryFactory.data(
        ftRel.uid,
        $scope.ceateRelationGetWhereForProjectSteps(action)
      ).then(function(res) {
        var ids = '';
        var features = res.data.features;
        for (var ind = 0; ind < features.length; ind++) {
          if (ids != '') ids += ',';
          ids += features[ind].properties[specificSteptable.stepId];
        }
        if (ids == '') deferred.resolve('gotProjectIds');
        else
          $scope.getProcedureSteps(action, ids).then(function(res) {
            deferred.resolve('gotProjectIds');
          });
      });
      return deferred.promise;
    };

    /**
     *  -1- Get "etapeStandard" where date_debut_prevue  is in the program year
     *  -2- Get distinct project id of "etapeProcedure". linked to etape standard
     *  -3- Get "etapeFinale" where date_debut_prevue  is in the program year
     *  -4- Get distinct project id of "etapeProcedure". linked to etape finale
     *  -6- Build relations between program and projects.
     *
     */
    $scope.createRelationForProjectsOfProgram = function(action, programId) {
      //-- Array of project IDs will be stored in thid scope property.
      $scope.projectIds = [];
      //-- Get id of projects where at leat one standard step has to be executed the first year of the program.
      $scope
        .getprojetcIdsOfSteps(action, action.standardStepTable)
        .then(function(res) {
          //-- Get id of projects where at leat one final step has to be executed the first year of the program.
          $scope
            .getprojetcIdsOfSteps(action, action.finalStepTable)
            .then(function(res) {
              if ($scope.projectIds.length != 0) {
                //-- Build relations between program and projects.
                var ft = FeatureTypeFactory.getFeatureTypeDesc(
                  $scope.config.progDatastorename,
                  action.relationTable.name
                );
                var senddata = GlobalServices.initEditFeatures(
                  $scope.projectIds.length
                );

                for (var ind = 0; ind < $scope.projectIds.length; ind++) {
                  senddata.features[ind].properties[
                    action.relationTable.fieldProgramId
                  ] = programId;
                  senddata.features[ind].properties[
                    action.relationTable.fieldProjectId
                  ] = $scope.projectIds[ind];
                }
                EditFactory.add(ft.uid, senddata);
              }
            });
        });
    };

    $scope.doTheAction = function(action, programId) {
      if (action.action == 'createRelationFromPrevious') {
        $scope.createRelationForProjectsOfProgram(action, programId);
      }
    };

    $scope.manageActions = function(event, programId) {
      var ind;

      if ($scope.config.actions != undefined) {
        for (ind = 0; ind < $scope.config.actions.length; ind++) {
          if ($scope.config.actions[ind].when == event)
            $scope.doTheAction($scope.config.actions[ind], programId);
        }
      }
    };

    $scope.progConfigGotten = function(config) {
      var mess = '';

      //-- Configuration has been gotten, so get the descriptor of each table we need.
      $scope.config = config;
      if ($scope.config.addProgAvailable != undefined)
        $scope.addProgAvailable = $scope.config.addProgAvailable;
      FeatureTypeFactory.getFeatureTypeDescAsPromise(
        $scope.config.progDatastorename,
        $scope.config.progTablename
      ).then(function(res) {
        $scope.programmeTable = res;
        $scope.etapesPredefTable = FeatureTypeFactory.getFeatureTypeDesc(
          $scope.config.progEtapesPredefDatastorename,
          $scope.config.progEtapesPredefTablename
        );
        $scope.etapesTable = FeatureTypeFactory.getFeatureTypeDesc(
          $scope.config.progEtapesDatastorename,
          $scope.config.progEtapesTablename
        );
        //-- Check if the tables are accessible.
        $scope.isProcedureWithSteps = true;
        if ($scope.config.isProcedureWithSteps === 'false')
          $scope.isProcedureWithSteps = false;
        if ($scope.programmeTable == null)
          mess +=
            '* ' +
            $scope.config.progDatastorename +
            ': ' +
            $scope.config.progTablename +
            '\n';
        if ($scope.etapesPredefTable == null && $scope.isProcedureWithSteps)
          mess +=
            '* ' +
            $scope.config.progDatastorename +
            ': ' +
            $scope.config.progEtapesPredefTablename +
            '\n';
        if ($scope.etapesTable == null && $scope.isProcedureWithSteps)
          mess +=
            '* ' +
            $scope.config.progDatastorename +
            ': ' +
            $scope.config.progEtapesTablename +
            '\n';
        if (mess == '')
          //-- We got the description of each table, so we can continue.
          $scope.getProgrammes();
        //--- Inform the user table descriptions are missing.
        else
          $scope.alert(
            "La description des tables suivantes n'a pas été trouvée:\n" + mess
          );
      });
    };

    //-- Ask for configuration.
    ConfigFactory.get('Programmation', $scope.ConfigName).then(function(res) {
      var mess = '';
      if (res.data == '')
        ConfigFactory.get('programmation', $scope.ConfigName).then(function(
          res
        ) {
          $scope.progConfigGotten(res.data);
        });
      else $scope.progConfigGotten(res.data);
    });

    /**
     *       Extract id value from id string which looks like
     *    "featuretypename.X" where X is the identifier value.
     */
    $scope.getFeatureId = function(feature) {
      var indPt;

      indPt = feature.id.indexOf('.');
      if (indPt == -1) return feature.id;
      else return feature.id.substr(indPt + 1);
    };

    /**
     *       Get id of most recent program.
     */
    $scope.getMostRecentProgramId = function() {
      var anneeMax = 0,
        indLast = -1;

      for (var ind = 0; ind < $scope.programmes.length; ind++) {
        if ($scope.programmes[ind].anneeAsNumber > anneeMax) indLast = ind;
      }
      if (indLast != -1) return $scope.programmes[indLast].id;
      else return 0;
    };

    $scope.getWhereClause = function() {
      var w;
      var deferred = $q.defer();

      if ($scope.config.where == undefined) w = '';
      else {
        var reg = new RegExp('!PARENT_ID!', 'g');
        w = $scope.config.where.replace(reg, $scope.objectId);
        w = GlobalServices.getObjUsingQueriesBuildWhere(w);
      }

      if ($scope.config.searchFilterObj == undefined) {
        deferred.resolve(w);
      } else {
        $scope.gfowcObj = {};
        $scope.gfowcObj.indexOfSearchFilter = 0;
        $scope.getFilterObjWhereClause().then(function(res) {
          if (res == null) {
            gaJsUtils.errorMessage(
              "Aucun objet satisfaisant les critéres n'a été trouvé",
              ''
            );
            deferred.resolve('!!nok!!');
          } else {
            if (w != '') w += ' AND ';
            w += res;
            $scope.gfowcObj = undefined;
            deferred.resolve(w);
          }
        });
      }

      return deferred.promise;
    };

    $scope.progTableHasFieldAnnee = function() {
      var att = $scope.programmeTable.attributes;
      for (var iAtt = 0; iAtt < att.length; iAtt++) {
        if (att[iAtt].name == 'annee') return true;
      }
      return false;
    };

    $scope.sortFeatures = function() {
      var sortProp;
      if (ChoixProgrammeFactory.resources.programmes.features.length != 0) {
        if (
          ChoixProgrammeFactory.resources.programmes.features[0].properties
            .annee != undefined
        )
          sortProp = 'anneeAsNumber';
        else sortProp = 'annee';
        //-- IF A SORT FIELD IS GIVEN
        //-- Sort objects on ordering field.
        $scope.maxOrder = 0;
        $scope.programmes.sort(function(a, b) {
          var v1, v2;
          v1 = a;
          v2 = b;
          /*
                    if (cfg.orderingAsc!=false)
                       {  v1 = a;  v2 = b;  }
                    else
                       {  v1 = b;  v2 = a;  }
                     */
          if (v1[sortProp] == null) return -1;
          if (v2[sortProp] == null) return 1;
          if (v1[sortProp] > v2[sortProp]) return 1;
          if (v1[sortProp] < v2[sortProp]) return -1;
          // a doit etre egale a b
          return 0;
        });
      }
    };

    /**
     *      Get the list of "programmes triennaux" from the DataBase..
     */
    $scope.getProgrammes = function() {
      $scope.getWhereClause().then(function(where) {
        if (where == '!!nok!!') return;
        //-- Insert the object into the database.
        ChoixProgrammeFactory.getProgrammes(
          $scope.programmeTable.uid,
          where
        ).then(function() {
          var ind1,
            anneeDuJour,
            anneeTrouvee = false,
            nomProg;

          anneeDuJour = gaJsUtils.getCurrentYear();
          $scope.programmes = [];
          for (
            ind1 = 0;
            ind1 < ChoixProgrammeFactory.resources.programmes.features.length;
            ind1++
          ) {
            nomProg =
              ChoixProgrammeFactory.resources.programmes.features[ind1]
                .properties.nom;
            $scope.programmes.push({
              annee: nomProg,
              id: $scope.getFeatureId(
                ChoixProgrammeFactory.resources.programmes.features[ind1]
              ),
              anneeAsNumber:
                ChoixProgrammeFactory.resources.programmes.features[ind1]
                  .properties.annee,
            });
            if (
              anneeDuJour ==
              ChoixProgrammeFactory.resources.programmes.features[ind1]
                .properties.annee
            )
              anneeTrouvee = true;
          }
          //-- TODO sort $scope.programmes on year
          if ($scope.programmes.length != 0) {
            if ($scope.isProcedureWithSteps)
              $scope.theProgram = $scope.getMostRecentProgramId();
            else $scope.theProgram = $scope.programmes[0].id;
          }
          if (!anneeTrouvee && $scope.progTableHasFieldAnnee())
            $scope.creerProgrammation(anneeDuJour);
          if (
            $scope.config.whenOneOpenFormDirectly == 'true' &&
            ChoixProgrammeFactory.resources.programmes.features.length == 1
          )
            $scope.showProgram();
          $scope.sortFeatures();
        });
      });
    };

    $scope.creerProgrammation = function(anneeDuJour) {
      var nomDuProgramme =
        'Programme triennal ' +
        (anneeDuJour + 1) +
        ' - ' +
        (anneeDuJour + 2) +
        ' - ' +
        (anneeDuJour + 3);
      ChoixProgrammeFactory.addObject(
        $scope.programmeTable.uid,
        [{ annee: anneeDuJour, nom: nomDuProgramme }],
        $scope.config.progTablename
      ).then(function() {
        $scope.programmeId = ChoixProgrammeFactory.resources.objectId;
        //-- Cas oùutiliser juste pour lister des objets tels que des projets par exemple.
        if ($scope.etapesPredefTable == null) return;
        //-- Get predefined steps from DataBase
        ChoixProgrammeFactory.getProgrammes($scope.etapesPredefTable.uid).then(
          function() {
            var ind1,
              senddata = [],
              ind2,
              ind3,
              prop,
              att;

            for (
              ind1 = 0;
              ind1 < ChoixProgrammeFactory.resources.programmes.features.length;
              ind1++
            ) {
              //-- Add a step record in the list of the steps to add.
              senddata[ind1] = {};
              prop =
                ChoixProgrammeFactory.resources.programmes.features[ind1]
                  .properties;
              //-- Standard (normal) attributes
              for (
                ind2 = 0;
                ind2 < $scope.etapesTable.attributes.length;
                ind2++
              ) {
                att = $scope.etapesTable.attributes[ind2].name;
                if (prop.hasOwnProperty(att)) senddata[ind1][att] = prop[att];
              }
              //-- Relation attribute
              for (
                ind3 = 0;
                ind3 < $scope.programmeTable.relations.length;
                ind3++
              )
                if (
                  $scope.programmeTable.relations[ind3].componentEnd ==
                  $scope.etapesTable.name
                ) {
                  att = $scope.programmeTable.relations[ind3].fieldEnd;
                  senddata[ind1][att] = $scope.programmeId;
                }
            }
            //-- Create all the copied steps.
            ChoixProgrammeFactory.addObject(
              $scope.etapesTable.uid,
              senddata,
              $scope.config.progEtapesTablename
            ).then(function(res) {
              var created = res.data.create[0];
              if (created.id != undefined) {
                var indPt = created.id.indexOf('.');
                var objectId = created.id.substr(indPt + 1);
                $scope.manageActions('programCreated', objectId);
              }
            });

            // Refresh list content after creation
            $scope.getProgrammes();
          }
        );
      });
    };

    /**
     * TODO commenter
     */
    $scope.backToChoixProg = function() {
      $scope.displayProgram = false;
      $scope.childScope.$destroy();
      var elt = document.getElementById('typeprojetdirective_' + $scope.$id);
      var eltParent = document.getElementById('choixprogram_' + $scope.$id);
      if (elt != null) eltParent.removeChild(elt);

      elt = document.getElementById('backtochoixbtn_' + $scope.$id);
      eltParent.removeChild(elt);

      $scope.getProgrammes();
    };

    /**
     *
     */
    $scope.showProgram = function() {
      $scope.displayProgram = true;
      var elt = document.getElementById('choixprogram_' + $scope.$id);
      var str =
        '<div TypeProjetDirective ng-show="displayProgram" id="typeprojetdirective_' +
        $scope.$id +
        '" >';
      str += '</div>';
      str +=
        '<button ng-click="backToChoixProg()"  ng-show="displayProgram" id="backtochoixbtn_' +
        $scope.$id +
        '"><img src="img/common/24px-Go-previous.png" ></img></button>';
      $scope.childScope = $scope.$new();
      $scope.childScope.objectId = $scope.theProgram;
      $scope.childScope.ConfigName = $scope.config.programmationConfigname;
      var cmp = $scope.compile(str)($scope.childScope);
      angular.element(elt).append(cmp);
      $scope.childScope.configName = $scope.childScope.ConfigName;
      $scope.$broadcast('openTools_typeprojetdirective', $scope.childScope);
    };

    $scope.checkYearValue = function() {
      var val = parseInt($scope.firstYearOfProgToCreate.value);
      if (val != undefined && val > 1900 && val < 3000) return val;
      return -1;
    };

    $scope.createPreviousProg = function() {
      //yyyyyy enlever            var val = $scope.checkYearValue();
      //yyyyyy enlever            if (val!=-1)
      $scope.creerProgrammation($scope.firstYearOfProgToCreate.value - 1);
      //yyyyyy enlever            else
      //yyyyyy enlever                gaJsUtils.errorMessage("Valeur d'année incorrecte: "+$scope.firstYearOfProgToCreate.value+" !");
      ngDialog.closeAll('');
    };

    $scope.cancelProgCreation = function() {
      ngDialog.closeAll('');
    };

    $scope.getSelectYearInputAsHtml = function() {
      var html = '',
        valDesc;

      $scope.intervalList = [];
      for (var iYear = 1980; iYear < 2019; iYear++) {
        for (var iProg = 0; iProg < $scope.programmes.length; iProg++) {
          if (iYear - 1 == $scope.programmes[iProg].anneeAsNumber) break;
        }
        if (iProg == $scope.programmes.length) {
          valDesc = {};
          valDesc.code = valDesc.value = iYear;
          $scope.intervalList.push(valDesc);
        }
      }
      html += '<select ng-model="firstYearOfProgToCreate.value"';
      html += 'ng-options="desc.value as desc.code for desc in intervalList">';

      return html;
    };

    $scope.addProg = function() {
      var dialogContent;

      //            dialogContent  = "<div>Première année du programme triennal: <input ng-model='firstYearOfProgToCreate.value' ></div>";
      dialogContent =
        '<div>Première année du programme triennal: ' +
        $scope.getSelectYearInputAsHtml() +
        '</div>';
      dialogContent += '<div>';
      dialogContent +=
        "  <button ng-disabled='checkYearValue()==-1' ng-click='createPreviousProg()'>Créer</button>";
      dialogContent +=
        "  <button ng-click='cancelProgCreation()'>Abandonner</button>";
      dialogContent += '</div>';

      dialogContent = '<table>';
      dialogContent += '  <tr>';
      dialogContent += '    <td>';
      dialogContent += '      Première année du programme triennal:&nbsp;';
      dialogContent += '    </td>';
      dialogContent += '    <td>';
      dialogContent += $scope.getSelectYearInputAsHtml();
      dialogContent += '    </td>';
      dialogContent += '  </tr>';
      dialogContent += '  <tr>';
      dialogContent += "    <td colspan='2'>";
      dialogContent += '    </td>';
      dialogContent += '  </tr>';
      dialogContent += "  <tr halign='center'>";
      dialogContent += "    <td halign='center'>";
      dialogContent +=
        "      <button ng-click='createPreviousProg()'>Créer</button>";
      dialogContent += '    </td>';
      dialogContent += "    <td halign='center'>";
      dialogContent +=
        "      <button ng-click='cancelProgCreation()'>Abandonner</button>";
      dialogContent += '    </td>';
      dialogContent += '</table>';

      ngDialog.open({ template: dialogContent, plain: true, scope: $scope });
    };
  };

  ChoixProgrammeCtrl.$inject = [
    '$scope',
    'ChoixProgrammeFactory',
    'ConfigFactory',
    'GlobalServices',
    'QueryFactory',
    'EditFactory',
    'FeatureTypeFactory',
    '$q',
    'ngDialog',
    'gaJsUtils',
  ];
  return ChoixProgrammeCtrl;
});
