'use strict';
define(() => {
  const kisCalendar = (
    $rootScope,
    $timeout,
    gaDomUtils,
    $filter,
    kisCalendarFactory,
    CalendarFactory,
    ConfigFactory,
    uiCalendarConfig,
    $q,
    AncAppFactory,
    gaBrowserSniffer,
    ngDialog,
    FeatureTypeFactory,
    $compile
  ) => {
    const kisCalendarLink = (scope) => {

      onInit();

      const agentsPlaceholder = 'Tous les Agents';
      const creatorPlaceholder = 'Tous les Créateurs';
      const eventTypesPlaceholder = 'Tous les types d\'événements';

      scope.viewType = 'calendar';
      scope.eventsTaken = {};
      scope.startWhenViewList;
      scope.endWhenViewList;

      scope.refreshEvents = () => {
        removeEvents();
        getCalendarEvents(scope.eventsFilters)
          .then(events => {
            changeEvents(events);
          })
          .finally(() => {
            gaDomUtils.hideGlobalLoader();
          });
      }

      scope.addNewEvent = () => {
        openCalendarEvent();
      }

      scope.onChangeViewType = (viewType) => {
        scope.viewType = viewType;
        if (viewType === 'list') {
          resolveListEvents();
        } else {
          scope.calendar_list_data = [];
          removeEvents();
        }
      }

      scope.onChangeViewDetails = (details) => {
        if (details) {
          scope.showDescription = details.showDescription;
          scope.showNumber = details.showNumber;
        }
        changeEvents(angular.copy(scope.eventSources[0].events));
      }

      scope.onChangedFilters = (eventsFilters) => {
        scope.eventsFilters = eventsFilters;
        if (scope.viewType === 'list') {
          resolveListEvents();
        } else {
          removeEvents();
          getCalendarEvents(eventsFilters)
            .then(events => {
              changeEvents(events);
            })
            .finally(() => {
              gaDomUtils.hideGlobalLoader();
            });
        }
      }

      scope.goToMonth = function () {
        const date = new Date();
        const numMonth = getNumberMonth(scope.selectedMonth);
        date.setMonth(numMonth);
        uiCalendarConfig.calendars['kisCalendar'].fullCalendar('gotoDate', date);
      };

      scope.goToYear = function () {
        const calendarCurrYear = uiCalendarConfig.calendars['kisCalendar'].fullCalendar('getDate');
        const yearDiff = scope.selectedYear - calendarCurrYear.year();

        uiCalendarConfig.calendars['kisCalendar'].fullCalendar(
          'gotoDate',
          calendarCurrYear.add(yearDiff, 'year')
        );
      };

      scope.openPopupAddAvent = function () {
        scope.addCtrl = {
          value: scope.ajouterctrl,
        };
        scope.showCalendarEvent = false;
        var title;
        if (scope.currentEvent && scope.currentEvent.id) {
          title = scope.currentEvent.id;
        } else {
          title = 'Ajouter un nouvel événement';
        }
        if (scope.agentCalendar && scope.agentCalendar.value) {
          scope.currentagent = scope.agentCalendar.value.login;
        }
        scope.agendaControle = ngDialog.open({
          template: 'js/XG/containers/views/popupAddEvent.html',
          className:
            'ngdialog-theme-plain width600 height400 miniclose nopadding',
          closeByDocument: false,
          scope: scope,
        });
      };

      scope.$on('closeNgDialogAgendaCtrl', function (event) {
        if (scope.agendaControle) scope.agendaControle.close();
      });

      scope.getEventLabelFromType = (id) => {
        var idx = scope.eventTypes
          .map(et => et.properties.type_id)
          .indexOf(id);
        if (scope.eventTypes[idx]) {
          return scope.eventTypes[idx].properties.alias;
        }
      };

      scope.openInvitePage = function () {
        scope.invitedevents = [];
        var url = $location.absUrl().split('#')[0] + '#/calendar_invite';
        window.open(url);
      };

      scope.setEventSize = function (size) {
        scope.eventDisplay.size = size;
      };

      scope.editEvent = function (event) {
        scope.currentEvent = angular.copy(event);
        scope.showCalendarEvent = true;
      };

      scope.$watch('plagehoraire', (newVal) => {
        if (newVal && newVal.jours) {
          scope.businessHours = getBusinessHours();
          if (scope.uiConfig && scope.uiConfig.calendar) {
            scope.uiConfig.calendar.defaultView = scope.calendarView
              && scope.calendarView.type || scope.defaultView;
            scope.uiConfig.calendar.defaultDate = scope.start_datetime
              || scope.defaultDate;
            scope.uiConfig.calendar.businessHours
              = scope.businessHours.businessIntervals;
            scope.uiConfig.calendar.minTime = scope.businessHours.minHour;
            scope.uiConfig.calendar.maxTime = scope.businessHours.maxHour;
            //-- Ne pas faire apparaître dans le calendrier
            //-- les jours configurés comme étant à ne pas utiliser
            //-- pour les rendez-vous.
            scope.uiConfig.calendar.hiddenDays = scope.businessHours.hiddenDays;
          }
        }
      }, true);

      scope.getWeekNumber = () => {
        if (!scope.weekNumberToShow) { 
          return '0'; 
        } else {
          return  scope.weekNumberToShow
        }
       
      }

      $rootScope.$on('$translateChangeEnd', function () {
        setCalendarLanguage();
      });

      $rootScope.$on('kis_calendar_event_refresh', function () {
        scope.eventDisplay.size = 'm';
        if (scope.viewType === 'list') {
          return resolveListEvents();
        } else {
          scope.refreshEvents();
          scope.currentEvent = {};
          scope.showCalendarEvent = false;
        }
      });
      $rootScope.$on('kis_calendar_eventAgent_refresh', function () {
        scope.eventDisplay.size = 'm';
        scope.refreshEvents();
        scope.currentEvent = {};
        scope.showCalendarEvent = false;
      });

      function getNumberMonth(monthName) {
        return scope.monthsList.findIndex((month) => month === monthName);
      }

      function setCalendarLanguage() {
        scope.calendarButtonTexts = {
          today: $filter('translate')('tools.calendar.ui.buttons.today'),
          month: $filter('translate')('tools.calendar.ui.buttons.month'),
          week: $filter('translate')('tools.calendar.ui.buttons.week'),
          day: $filter('translate')('tools.calendar.ui.buttons.day'),
        };
        scope.calendarAllDayText = $filter('translate')(
          'tools.calendar.ui.buttons.allday'
        );
        if (scope.rdvAuto) {
          scope.defaultDate = scope.dateRdvs;
        }
        const currLanguage = localStorage.getItem('current_language') || 'fr';
        if (currLanguage == 'fr') {
          scope.timeFormat = 'H:mm';
          scope.axisFormat = 'H:mm';
          scope.allDayText = 'Journée';
        } else {
          scope.timeFormat = 'H[h]';
          scope.axisFormat = 'h(:mm)a';
          scope.allDayText = 'all-day';
        }
      }

      function onInit() {

        scope.$on('$destroy', function () {
          $rootScope.$broadcast('kis_calendar_destroy');
        });

        watchChangedAgent();
        resolveFiltersOptions();
        setCalendarLanguage();

        setMonthsList();
        setYearsList();

        scope.eventSources = [{ events: [] }];

        if (scope.currentEvent || scope.rdvAuto) {
          scope.defaultView = 'agendaDay';
        } else {
          scope.defaultView = 'month';
        }

        scope.eventDisplay = {
          size: scope.currentEvent && scope.rdvAuto ? 'xl' : 'm',
        };

        if (scope.currentEvent) {
          scope.showCalendarEvent = true;
        }

        resolveEventTypes().then(() => {
          initUiCalendarConfig();
        });
      }

      function setMonthsList() {
        scope.monthsList = [
          'janvier',
          'février',
          'mars',
          'avril',
          'mai',
          'juin',
          'juillet',
          'août',
          'septembre',
          'octobre',
          'novembre',
          'décembre'
        ];
        const date = new Date();
        const monthNumber = date.getMonth();
        scope.selectedMonth = scope.monthsList[monthNumber];
      }

      function setYearsList() {
        scope.selectedYear = moment().year();
        scope.yearsList = [];
        for (
          var i = scope.selectedYear - 25;
          i < scope.selectedYear + 10;
          i++
        ) {
          scope.yearsList.push(i);
        }
      }

      function watchChangedAgent() {
        scope.$watch('selectedAgent', (agent) => {
          if (agent && agent.login) {
            const eventsFilters = Object.assign(scope.eventsFilters || {}, { agent: agent.login });
            scope.onChangedFilters(eventsFilters);
          }
        });
      }

      function resolveListEvents() {
        gaDomUtils.showGlobalLoader();

        scope.calendar_list_data = [];
        getEvents(scope.eventsFilters).then(data => {
          scope.calendar_list_data = data.features.sort(function (a, b) {
            return (
              gaBrowserSniffer.parseDateSpecIE(a.properties.start) -
              gaBrowserSniffer.parseDateSpecIE(b.properties.start)
            );
          });
        }).finally(() => gaDomUtils.hideGlobalLoader());
      }


      const initUiCalendarConfig = () => {
        scope.businessHours = getBusinessHours();

        scope.uiConfig = {
          calendar: {
            firstDay: 1,
            //-- Jour à ne pas faire apparaître dans le calendrier.
            hiddenDays: scope.businessHours.hiddenDays,
            slotEventOverlap: false,
            height: scope.heightCalendar || 650,
            slotDuration: '00:15:00',
            editable: true,
            buttonText: scope.calendarButtonTexts,
            handleWindowResize: false,
            header: {
              left: 'month agendaWeek agendaDay',
              center: 'title',
              right: 'today prev,next',
            },
            // dddd : c'est le jour 
            columnFormat: {
              agendaWeek: 'dddd D/MM',
              month: 'dddd',
            },
            titleFormat: 'D MMMM YYYY',
            eventClick: eventClick,
            eventDrop: eventDrop,
            eventResize: eventResize,
            defaultView: scope.defaultView,
            defaultDate: scope.defaultDate,
            allDayText: scope.calendarAllDayText,
            selectable: true,
            selectHelper: true,
            timezone: 'local',
            businessHours: scope.businessHours.businessIntervals,
            axisFormat: scope.axisFormat,
            timeFormat: scope.timeFormat,
            minTime: scope.businessHours.minHour,
            maxTime: scope.businessHours.maxHour,
            select: select,
            eventRender: eventRender,
            viewRender: (view) => {
              let refreshEvents = !scope.calendarView || scope.calendarView.type !== view.type || scope.calendarView.start.toISOString() !== view.start.toISOString();

              scope.calendarView = Object.assign({}, view);
              scope.disableDescription = false;

              if (view.name === 'agendaWeek') {
                scope.disableDescription = false;
              }

              scope.typeViewCal = view.name;
              scope.titleCal = view.title;
              let currentStartViewDate = new Date(view.start.toISOString());
              let startDate = new Date(currentStartViewDate.getFullYear(), 0, 1);
              let  days = Math.floor((currentStartViewDate - startDate) /
              (24 * 60 * 60 * 1000));
              scope.weekNumberToShow = Math.ceil(days / 7);
              // Correction de la date en cas de changement de l'année avant le mois
              // En effet quand on change l année avant le mois , les années augmentent deux ans et un an (à comprendre)  
              scope.start_datetime = new Date(view.start).toISOString().split('T')[0];

              if (scope.typeViewCal === 'month') {
                scope.end_datetime =  new Date(new Date(scope.start_datetime).getTime() + (1000 * 3600 * 24 * 30)).toISOString().split('T')[0]
              } else if (scope.typeViewCal === 'week') {
                scope.end_datetime =  new Date(new Date(scope.start_datetime).getTime() + (1000 * 3600 * 24 * 7)).toISOString().split('T')[0]
              } else {
                scope.end_datetime = view.end.toISOString();
              }

              switch (view.type) {
                case 'month':
                  const tmp = view.title.replace(/[0-9]/g, '').trim();
                  scope.selectedMonth = tmp.substring(tmp.lastIndexOf(' ') + 1);
                  break;
              }
              if (refreshEvents) {
                removeEvents();
                getCalendarEvents(scope.eventsFilters)
                  .then(events => {
                    changeEvents(events);
                  })
                  .finally(() => {
                    gaDomUtils.hideGlobalLoader();
                  });
              }
            },
          }
        };
        // pas d'affichage des weekends et subdivision en 4 de la plage horaire en consultation du calendrier
        if ($rootScope.calendar.visible) {
          scope.uiConfig.calendar.weekends = false;
          scope.uiConfig.calendar.slotDuration = '00:15:00';
        }
      };


      const getBusinessHours = () => {
        const days = ['MONDAY', 'TUESDAY', 'WEDNESDAY', 'THURSDAY', 'FRIDAY',
          'SATURDAY'];
        let daysOfWeek = [1, 2, 3, 4, 5];
        const defaultBusinessHours = {
          dow: daysOfWeek,
          start: '07:00',
          end: '19:00',
        };

        if (!scope.plagehoraire || !scope.plagehoraire.jours) {
          return {
            businessIntervals: [defaultBusinessHours],
            minHour: defaultBusinessHours.start,
            maxHour: defaultBusinessHours.end,
          };
        }

        daysOfWeek = [];
        let businessIntervals = [];
        const hiddenDays = [];

        Object.keys(scope.plagehoraire.jours).forEach((day) => {
          const dayNum = days.indexOf(day) + 1;
          const dayValues = scope.plagehoraire.jours[day];
          if (!dayValues.active) {
            //-- Alimentation de la liste des jours
            //-- à ne pas mettre dans le calendrier.
            hiddenDays.push(dayNum);
          }
          if (!dayValues.matinee && !dayValues.apresmidi) { return; }
          const minHour1 = dayValues.matinee && dayValues.dateDebut1
            ? moment(dayValues.dateDebut1).format('HH:mm')
            : null;
          const maxHour1 = dayValues.matinee && dayValues.dateFin1
            ? moment(dayValues.dateFin1).format('HH:mm')
            : null;
          const minHour2 = dayValues.apresmidi && dayValues.dateDebut2
            ? moment(dayValues.dateDebut2).format('HH:mm')
            : null;
          const maxHour2 = dayValues.apresmidi && dayValues.dateFin2
            ? moment(dayValues.dateFin2).format('HH:mm')
            : null;

          if (minHour1 && maxHour1) {
            businessIntervals.push({
              dow: [dayNum],
              start: minHour1,
              end: maxHour1,
            });
          }

          if (minHour2 && maxHour2) {
            businessIntervals.push({
              dow: [dayNum],
              start: minHour2,
              end: maxHour2,
            });
          }
        });


        if (businessIntervals.length === 0) {
          businessIntervals = [defaultBusinessHours];
        }

        const calendarMinMax = getCalendarMinMax(businessIntervals);

        const minHour = moment(calendarMinMax.min).add(getHoursToAddToMin(calendarMinMax.min), 'hours').add(1, 'seconds').format('HH:mm');
        const maxHour = moment(calendarMinMax.max).add(getHoursToAddToMax(calendarMinMax.max), 'hours').add(-1, 'seconds').format('HH:mm');

        return { businessIntervals, minHour, maxHour, hiddenDays };
      }


      function getHoursToAddToMin(date) {
        return moment(date).format('HH') > 0
          ? -1
          : 0;
      }

      function getHoursToAddToMax(date) {
        return moment(date).diff(moment('23:00', 'HH:mm')) > 0
          ? 0
          : moment(date).diff(moment('22:00', 'HH:mm')) > 0
            ? 1
            : 2;
      }

      function eventResize(event, delta, revertFunc) {
        eventResizeDrop(event.kis_event, 'resize', delta, revertFunc);
      };

      function eventDrop(event, delta, revertFunc) {
        eventResizeDrop(event.kis_event, 'drop', delta, revertFunc);
      };

      function eventResizeDrop(event, type, delta, revertFunc) {
        let canModifyEvent;
        const isUserManagerOrRoot = $rootScope.xgos.user.login == 'root' || $rootScope.xgos.user.roles.filter(role => role.name === 'kis_calendar_manager').length;
        if ($rootScope.xgos.user.name == event.properties.created_by || isUserManagerOrRoot) {
          canModifyEvent = true;
        }

        if (!canModifyEvent) {
          return revertFunc();
        }

        const confirmed = confirm($filter('translate')('tools.calendar.ui.event_actions.' + type + '.confirm'));
        if (!confirmed) {
          return revertFunc();
        }

        if (type == 'drop') {
          event.properties.start = moment(event.properties.start)
            .add(delta)
            .format();
        }
        event.properties.end = moment(event.properties.end)
          .add(delta)
          .format();

        event.properties.start = formatDate(event.properties.start);
        event.properties.end = formatDate(event.properties.end);
        CalendarFactory.updateeventtime({
          type: 'FeatureCollection',
          features: [event],
        }).then(() => {
          kisCalendarFactory.refreshListeDossier()
          refreshCtrlsPriseRdv();
          require('toastr').success(
            $filter('translate')('tools.calendar.ui.event_actions.' + type + '.done'),
            { positionClass: 'toast-bottom-left' }
          );
        });
      }

      function formatDate(dateSource) {
        let date = moment(dateSource);
        date = date.toISOString();
        date = $filter('date')(date, 'yyyy-MM-ddTHH:mm:ss.sssZ');
        return date;
      }

      function getCalendarMinMax(businessIntervals) {
        const hours = {};
        businessIntervals.forEach(interval => {
          hours.min = getMinDate(hours.min, moment(interval.start, 'HH:mm'));
          hours.max = getMaxDate(hours.max, moment(interval.end, 'HH:mm'));
        });
        return {
          min: moment(hours.min),
          max: moment(hours.max).add(-1, 'hours'),
        };
      }

      function getMinDate(date1, date2) {
        return !date1 || moment(date1).diff(moment(date2)) > 0
          ? date2
          : date1;
      }

      function getMaxDate(date1, date2) {
        return !date1 || moment(date1).diff(moment(date2)) < 0
          ? date2
          : date1;
      }

      function eventClick(event) {
        // l id du contrôle auquel le rdv est associé
        const idDossier = event.kis_event.relations.dossierId.split('.')[1];
        // l id du dossier auquel le rdv est associé
        const idControle = event.kis_event.relations.controleId.split('.')[1];
        if (scope.deleteButtonActivated) {
          kisCalendarFactory.annulerEvent(event.kis_event.id, scope.refreshEvents,event.kis_event.relations.dossierId)
            .then(refreshCtrlsPriseRdv);
          scope.deleteButtonActivated = false;
        } else if (scope.openFolderButtonActivated) {
          ouvreDossier(event);
          scope.openFolderButtonActivated = false;
        } else {
          scope.showCalendarEvent = true;
          scope.currentEvent = {
            id: event.kis_event.id,
            properties: event.kis_event.properties,
            type: event.kis_event.type
          };
        }
      }

      function eventRender(event, element) {
        setEventActionsButtons(element, event);
        if (scope.showDescription && !scope.disableDescription && event.kis_event) {
          renderDescription(event, element);
        }
      }

      function renderDescription(event, element) {
        element
          .find('.fc-content')
          .addClass('showtitledetail')
          .wrapInner('<div class=\'fc-content-wrapper\' />');
        if (event.kis_event.properties.description) {
          if (event.kis_event.properties.description) {
            // si da description n'est pas parsable en json, cela signifie que l'event a été enregistré avec l'ancienne methode'
            // c'est le cas ici, donc on affiche comme avant
            if (!IsJsonString(event.kis_event.properties.description)) {
              const desc = event.kis_event.properties.description.trim();
              element
                .find('.fc-content-wrapper')
                .after(
                  '<span class="calendar_event_description" title="' + desc + '">' +
                desc +
                '</span>'
                );
            }
            else {
              // si da description est parsable en json, cela signifie que l'event a été enregistrer avec la nouvelle méthode
              // if faut l'afficher avec cette nouvelle méthode : 
              var jsonDescription = JSON.parse(event.kis_event.properties.description);
              // on créé un nouveau json avec l ordre demandé, adresse-propro-occupant
              var descriptionEventFinalVersion = {
                'Adresse': jsonDescription.adresse,
                'Propriétaire': jsonDescription.proprietaire,
                'Occupant': jsonDescription.occupant
              };
              // la description qui apparaît au survol de l'evenement
              var stringToSeeOnHover
                = 'Adresse: ' + descriptionEventFinalVersion.Adresse + '\n'
                + 'Propriétaire: ' + descriptionEventFinalVersion.Propriétaire
                + '\n' + 'Occupant: ' + descriptionEventFinalVersion.Occupant;
              //  la description à l interieur de la div de description de l'evenement
              var eventDescriptionContent = Object.entries(descriptionEventFinalVersion).map(x=>x.join(':')).join('\n');

              element
                .find('.fc-content-wrapper')
                .after(
                  '<span class="calendar_event_description" title="' + stringToSeeOnHover + '">' +
                eventDescriptionContent +
                '</span>'
                );
            }
          }
        }

        element
          .find('.fc-title')
          .addClass('calendar_title_content');
        element[0].setAttribute('id', event.kis_event.id);
        element[0].setAttribute('idEvent', event.kis_event.id);
      }

      function ouvreDossier(event) {
        if (event && event.kis_event && event.kis_event.relations && event.kis_event.relations.dossierId) {
          loadListeDossier().then(() => {
            $timeout(() => {
              $rootScope.$broadcast('anc_open_controle', [{
                dossier_id: event.kis_event.relations.dossierId,
                controle_id: event.kis_event.relations.controleId,
              }]);
            });
          });
        } else {
          swal({
            title: 'Pas de dossier ANC associé à cet événement !',
            type: 'warning',
            confirmButtonColor: '#DD6B55',
            closeOnConfirm: true,
          });
        }
      }

      function loadListeDossier() {
        scope.loadListeDossierDefer = $q.defer();
        if (
          AncAppFactory.appCfg.main == undefined ||
          FeatureTypeFactory.resources.featuretypes.length == 0
        ) {
          $timeout(loadListeDossier, 500);
        } else {
          const loadedEltListeDossier = document.getElementsByClassName(
            'ancBacMainList'
          );
          const calEltListeDossier = document.getElementById(
            'kisCalendarListeDossier'
          );
          if (
            loadedEltListeDossier.length > 1 &&
            scope.childScope != undefined
          ) {
            scope.childScope.$destroy();
            scope.childScope = undefined;
            while (calEltListeDossier.firstChild) {
              calEltListeDossier.removeChild(calEltListeDossier.firstChild);
            }
          } else if (loadedEltListeDossier.length == 0) {
            var str = '<liste-dossiers ng-show="false"></liste-dossiers>';
            scope.childScope = scope.$new();
            var cmp = $compile(str)(scope.childScope);
            angular.element(calEltListeDossier).append(cmp);
          }
          scope.loadListeDossierDefer.resolve();
        }
        return scope.loadListeDossierDefer.promise;
      }


      /**
       * Vérifie que le créneau cliqué et défini
       * par les paramétres "start" et "end" correspond bien
       * à un créneau autorisé.
       *
       * @param {*} start : début du créneau cliqué
       * @param {*} end  : fin du créneau cliqué
       * @returns : VRAI si le créneau est autorisé, FAUX sinon
       */
      const businessHourSelected = (start, end) => {
        //-- Obtenir le jour depuis l'heure de début
        const startDay = start.day();
        const startHour = start.hour();
        const startMinute = start.minute();
        const endHour = end.hour();
        const endMinute = end.minute();
        //-- Liste des intervales
        const intervals = scope.businessHours.businessIntervals;
        for (let iInterv = 0; iInterv < intervals.length; iInterv++) {
          const interval = intervals[iInterv];
          let intervStartHour = interval.start.split(':');
          const intervStartMinute = parseInt(intervStartHour[1]);
          intervStartHour = parseInt(intervStartHour[0]);
          let intervEndHour = interval.end.split(':');
          const intervEndMinute = parseInt(intervEndHour[1]);
          intervEndHour = parseInt(intervEndHour[0]);

          if (interval.dow[0] == startDay
            && startHour >= intervStartHour && startMinute >= intervStartMinute
            && (startHour < intervEndHour
              || (startHour === intervEndHour && startMinute <= intervEndMinute))
            && (endHour < intervEndHour
              || (endHour === intervEndHour && endMinute <= intervEndMinute))
          ) {
            //-- On a cliqué dans une zone horaire qui correspond
            //-- à une plage autorisée.
            return true;
          }
        }
        //-- Le clic n'a pas été fait dans  une plage horaire autorisée.
        return false;
      };


      function select(start, end) {
        if (!businessHourSelected(start, end)) {
          //-- Le créneau cliqué n'est pas autorisé: on ne fait rien.
          return;
        }
        var startDate;
        if (!scope.rdvAuto) {
          if (!angular.copy(scope.currentEvent)) {
            scope.currentEvent = {
              properties: {},
            };
            startDate = $filter('date')(
              start.toDate(),
              'yyyy-MM-ddTHH:mm:ss.sssZ'
            );
            scope.currentEvent.properties.start = startDate;
          } else {
            var event;
            scope.currentEvent = event;
            startDate = $filter('date')(
              start.toDate(),
              'yyyy-MM-ddTHH:mm:ss.sssZ'
            );
            var endDate = $filter('date')(
              end.toDate(),
              'yyyy-MM-ddTHH:mm:ss.sssZ'
            );
            scope.currentEvent.collection.features[0].properties.start = startDate;
            scope.currentEvent.collection.features[0].properties.end = endDate;
          }
          scope.showCalendarEvent = true;
        }
        else {
          if (scope.disableClickEvent) {
            $timeout(() => {
              swal({ // This does something that remove the event created
                title: 'Le délai de rendez-vous est invalide !',
                type: 'warning',
                confirmButtonColor: '#DD6B55',
                closeOnConfirm: true,
              });
            });
            return;
          }
          const startTime = $filter('date')(start.toDate(), 'HH:mm');
          swal(
            {
              title:
                scope.listeCtrl.length > 1
                  ? 'Voulez vous lancer la planification des rendez vous à partir de ' +
                  startTime +
                  ' ?'
                  : 'Voulez vous valider cette prise de rendez-vous ?',
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
            },
            isConfirm => {
              if (isConfirm) {
                $rootScope.$broadcast('getHeureDebut', {
                  debut: start,
                  heureDebut: startTime,
                  fixedSlot: true,
                });
              }
            }
          );
        }
      }

      function resolveFiltersOptions() {
        resolveAgentsAndOwners();
      }

      function resolveEventTypes() {
        return CalendarFactory.geteventtypes().then(() => {
          scope.eventTypes = CalendarFactory.resources.event_types.filter(eventType => {
            return eventType && eventType.properties.type && (
              (!isAnc() && !isBac()) ||
              (isAnc() && eventType.properties.type.toLowerCase().indexOf('kis_bac') === -1) ||
              (isBac() && eventType.properties.type.toLowerCase().indexOf('kis_anc') === -1)
            )
          });
          if (isAnc()) {
            return resolveAncEventTypesConfig().then(eventTypesConfig => {
              scope.rdvAllowedEventTypes = getFilteredRdvPossibleEventTypes(eventTypesConfig);
              return scope.eventTypes;
            });
          }
          scope.rdvAllowedEventTypes = angular.copy(scope.eventTypes);
          return scope.eventTypes;
        });
      }

      function resolveAgentsAndOwners() {
        scope.agents = [];
        scope.creators = [];
        return getEvents().then(data => {
          scope.agents = [agentsPlaceholder].concat(data.agents || []);
          scope.creators = [creatorPlaceholder].concat(getUniqueCreators(data.features));
        });
      }

      function getUniqueCreators(events) {
        const uniqueCreatedBy = [];
        return events.filter(event => {
          if (event.properties && event.properties.created_by && uniqueCreatedBy.indexOf(event.properties.created_by) === -1) {
            uniqueCreatedBy.push(event.properties.created_by);
            return true;
          }
          return false;
        }).map(event => event.properties.created_by);
      }

      function resolveAncEventTypesConfig() {
        return ConfigFactory.get('ANC', 'calendar').then(res => {
          scope.showNumber = res.data.showNumDossierDef;
          return res.data && res.data.eventTypes || [];
        }).catch(() => {
          require('toastr').error('Couldn\'t load event types configuration for ANC. Refresh page or contact an admin!');
          return []; // We don't have the data available to establish which event types can be used, so none.
        });
      }

      function getFilteredRdvPossibleEventTypes(eventTypesConfig = []) {
        return angular.copy(scope.eventTypes.filter(eventType =>
          (eventTypesConfig.find(eventTypeFromConfig => eventTypeFromConfig.type_id === eventType.properties.type_id) || {}).rdvIsPossible
        ));
      }

      function openCalendarEvent(event = { properties: {} }) {
        scope.currentEvent = event;
        scope.showCalendarEvent = true;
      }

      function setEventActionsButtons(element, event) {
        let btn = '';
        if (event && event.kis_event && event.kis_event.ref_dossier) {
          btn += '<span>&nbsp;</span><span class="openfolder btn btn-default calendareventbtn calendareventopen fa fa-folder-open-o" title="Ouvrir le contrôle"></span>';
        }
        btn += '<span class="closeon btn btn-default calendareventbtn calendardelete" title="Supprimer">X</span>';

        if (scope.typeViewCal == 'agendaWeek') {
          element.find('.fc-time').append(btn);
        } else {
          element.find('.fc-content').append(btn);
        }
        element.find('.calendardelete').click(function () {
          scope.deleteButtonActivated = true;
        });
        element.find('.calendareventopen').click(function () {
          scope.openFolderButtonActivated = true;
        });
      }

      function onCloseCalendarEvent() {
        scope.currentEvent = null;
        scope.showCalendarEvent = false;
      }

      function isAnc() {
        return $rootScope.xgos.sector === 'anc';
      }
      function isBac() {
        return $rootScope.xgos.sector === 'bac';
      }

      // format the eventArrays
      function formatEventObject(eventList) {
        eventList.features.forEach((f) =>{
          // si le dossier a été enregistré avec la nouvelle méthode
            if (f.properties.description && IsJsonString(f.properties.description)) {
              f.properties.adresse2 = JSON.parse(f.properties.description).adresse;
              f.properties.proprietaire2 = JSON.parse(f.properties.description).proprietaire;
              f.properties.occupant2 = JSON.parse(f.properties.description).occupant
            }
        });
        return eventList
      }
      
      function getEvents(filters = {}) {
        return CalendarFactory.getevents(
          getWhereQuery(filters),
          scope.start_datetime,
          scope.end_datetime
        ).then(response => {
          if (!response || !response.data) {
            return [];
          }
          scope.eventsTaken = response.data;
          scope.currentEvent = false;
          formatEventObject(scope.eventsTaken);
          return response.data;
        }).finally(() => gaDomUtils.hideGlobalLoader());
      }
      // function to test if a string is parsable into json
      function IsJsonString(str) {
        try {
            JSON.parse(str);
        } catch (e) {
            return false;
        }
        return true;
      }

      function geteventsCalendarMode(filters = {}) {
        return CalendarFactory.geteventsCalendarMode(
          getWhereQuery(filters),
          scope.start_datetime,
          scope.end_datetime
        ).then(response => {
          if (!response || !response.data) {
            return [];
          }
          scope.eventsTaken = response.data;
          scope.currentEvent = false;
          formatEventObject(scope.eventsTaken)
          return response.data;
        }).finally(() => gaDomUtils.hideGlobalLoader());
      }

      /**
       * Va cherche la liste des rendez vous sur une période de temps,
       * pour chaque rendez-vous, met à jour les données de l'evenement pour l'affichage
       * @param filters
       * @returns {*}
       */
      const getCalendarEvents = (filters = {}) => {
        gaDomUtils.showGlobalLoader();

        return geteventsCalendarMode(filters)
        .then(data => {
          let resolveEventsPromises = [];
          resolveEventsPromises = data.features.map((event) => {
            return resolveEventData(event);
          });
          return $q.all(resolveEventsPromises);
        });
      }


      function resolveEventData(event) {
        return CalendarFactory.geteventrelations(event.id).then((res) => {
          if (!res || !res.data || !res.data.features) { return event; }
          const dossierId = (
            (
              res.data.features.find(feature => feature.properties && feature.properties.feature_uid === 'kis_anc_dossier') || { properties: {} }
            ).properties.feature_id || '.'
          ).split('.')[1];
          event.relations = {
            dossierId: (res.data.features.find(feature => feature && feature.properties.feature_uid === 'kis_anc_dossier') || { properties: {} }).properties.feature_id,
            controleId: (res.data.features.find(feature => feature && feature.properties.feature_uid === 'kis_anc_dossier_controle') || { properties: {} }).properties.feature_id,
          };
          if (!dossierId) { return event; }
          return AncAppFactory.getdossier(dossierId).then((res) => {
            if (res.data.features && res.data.features.length != 0 && res.data.features[0].properties.ref_dossier) {
              event.ref_dossier = res.data.features[0].properties.ref_dossier;
            }
            return event;
          }).catch(() => event);
        }).catch(() => event);
      }

      function changeEvents(events = []) {
        events = events.map(event => event.kis_event || event);
        scope.eventSources[0] = { events: getUniqueEvents(events).map(transformFeatureToCalendarEvent) };
      }

      function removeEvents() {
        scope.eventSources[0] = { events: [] };
      }

      function getUniqueEvents(events) {
        const uniqueEventsIds = [];
        return events.filter(event => {
          if (uniqueEventsIds.indexOf(event.id) === -1) {
            uniqueEventsIds.push(event.id);
            return true;
          }
          return false;
        });
      }

      function transformFeatureToCalendarEvent(feature) {
        const color = '#' + feature.properties.color;
        return {
          title: getEventTypeTitleForCalendar(feature, feature.ref_dossier),
          start: moment(feature.properties.start),
          end: moment(feature.properties.end),
          color: color,
          allDay: feature.properties.allday,
          kis_event: feature,
        };
      }

      function getEventTypeTitleForCalendar(event, refDoss) {
        let title = '';
        if (
          scope.typeViewCal == 'agendaDay' ||
          kisCalendarFactory.resources.config.showEventType === true
        ) {
          title = event.properties.title;
        }
        if (scope.showNumber && refDoss) {
          if (title != '') {
            title += ' - ';
          }
          title += refDoss;
        }
        return title;
      }

      function getWhereQuery(filters) {
        const where = ['1=1'];
        if (filters.title) { where.push(`title ILIKE '%${filters.title}%'`); }
        if (filters.place) { where.push(`place ILIKE '%${filters.place}%'`); }
        if (filters.color) { where.push(`color='${filters.color}'`); }
        if (filters.created_by && filters.created_by !== creatorPlaceholder) { where.push(`created_by='${filters.created_by}'`); }
        if (filters.type_evenement && filters.type_evenement !== eventTypesPlaceholder) { where.push(`type_evenement='${filters.type_evenement}'`); }
        return where.join(' AND ') + (filters.agent && filters.agent !== agentsPlaceholder ? `&agent=${filters.agent}` : '');
      }

      function refreshCtrlsPriseRdv() {
        if (typeof scope.refreshCtrlsPriseRdv === 'function') {
          scope.refreshCtrlsPriseRdv();
        }
      }

    };

    return {
      templateUrl: 'js/XG/containers/views/kis_calendar.html',
      restrict: 'E',
      scope: {
        calendarCfg: '=?',
        currentEvent: '=?',
        currentdossier: '=?',
        agentcontrol: '=?',
        selectedAgent: '=?',
        dateRdvs: '=?',
        rdvAuto: '=',
        showAddEventButton: '=?',
        displayFilters: '=?',
        showDescription: '=?',
        plagehoraire: '=?',
        listeCtrl: '=?',
        disableClickEvent: '=?',
        refreshCtrlsPriseRdv: '=?'
      },
      link: kisCalendarLink
    };
  };

  kisCalendar.$inject = [
    '$rootScope',
    '$timeout',
    'gaDomUtils',
    '$filter',
    'kisCalendarFactory',
    'CalendarFactory',
    'ConfigFactory',
    'uiCalendarConfig',
    '$q',
    'AncAppFactory',
    'gaBrowserSniffer',
    'ngDialog',
    'FeatureTypeFactory',
    '$compile',
  ];
  return kisCalendar;
});